Ext.ns("Starit.Alarm", "Starit.Alarm.AlarmPresent");

var PROVINCE_URL_ALARM_CONFIG = "getProvince_L.action";
var CITY_URL_ALARM_CONFIG = "getCityByProvinceId_L.action";
var TYPE_URL_ALARM_CONFIG = "getAllObjectType_L.action";
var padBlank = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
/**
 * 资源面板的实现
 * @class Starit.Alarm.AlarmPresent.resourcesConfigForm
 * @extends Ext.Panel
 */
Starit.Alarm.AlarmPresent.resourcesConfigForm = Ext.extend(Ext.Panel, {

			province : null,
			city : null,
			type : null,
			tree : null,
			buttonForm : null,
			grid : null,
			constructor : function(cfg) {
				var cfg = cfg || {};
				Ext.apply(this, cfg);

				this.grid = new Starit.Alarm.AlarmPresent.resourcesGrid({
							parent : this
						});
				this.tree = new Starit.Alarm.AlarmPresent.resourcesTree({
							parent : this
						});
				//this.initCombo();		//上面的下拉框暂时去掉
				/*var comboPanel = new Ext.Panel({
							layout : 'column',
							width : 800,
							items : [{
										columnWidth : .20,
										layout : 'form',
										labelWidth:30,
										items : [this.province]
									}, {
										columnWidth : .20,
										layout : 'form',
										labelWidth:30,
										items : [this.city]
									}, {
										columnWidth : .35,
										layout : 'form',
										labelWidth:80,
										items : [this.type]
									}]
						});*/
				this.initButtonForm();

				var underPanel = new Ext.Panel({
							layout : 'column',
							width : 800,
							items : [{
										columnWidth : .30,
										layout : 'form',
										border : true,
										items : [this.tree]
									}, {
										columnWidth : .07,
										layout : 'form',
										items : [this.buttonForm]
									}, {
										columnWidth : .33,
										layout : 'form',
										items : [this.grid]
									}]
						});

				Starit.Alarm.AlarmPresent.resourcesConfigForm.superclass.constructor
						.call(this, {
									// renderTo: 'UserForm',
									anchor : '85%',
									height : 300,
									border : false,
									frame : true,
									bodyStyle: 'padding: 10px 0 0 10px',
								    autoScroll : true,
									title : '服务配置',
									//iconCls : "tab-config",
									items : [/*comboPanel, */underPanel]
								});
				//this.initListener();

			},
			initCombo : function() {
				this.province = this.createCombo("省",
						PROVINCE_URL_ALARM_CONFIG, 120, false, null, "geoid",
						"geoname");

				this.city = this.createCombo("市", CITY_URL_ALARM_CONFIG,
						120, true, null, "geoid", "geoname");

				this.type = this.createCombo("设备类型",
						TYPE_URL_ALARM_CONFIG,120, false, null,
						"objecttypeid", "objectcname");
				this.province.store.load();
				this.type.store.load();

			},
			initListener : function() {
				this.province.on('select', function(combo, record, index) {
							var provinceId = record.data.geoid;
							this.tree.provinceId = provinceId;
							this.tree.cityId=null;
							// 对树的加载。
							this.tree.doRefresh();
							this.city.clearValue();
							this.city.store.load({
										params : {
											provinceId : provinceId
										}
									});
							

						}, this);
				this.city.on('select', function(combo, record, index) {
							var cityId = record.data.geoid;
							this.tree.cityId = cityId;
							// 对树的加载。
							this.tree.doRefresh();
						}, this);
				this.type.on('select', function(combo, record, index) {
							var typeId = record.data.objecttypeid;
							this.tree.objectTypeId = typeId;
							// 对树的加载。
							this.tree.doRefresh();
						}, this);
			},
			initButtonForm : function() {
				var that = this;
				this.buttonForm = new Ext.Panel({
							// frame : false,
							// layout : 'form',
							// anchor:'99%',
							width : 90,
							buttonAligh : 'center',
							layout : 'column',
							items : [{
										columnWidth : .60,
										layout : 'form',
										items : [{
													xtype : 'panel',
													height : 40
												}, {
													xtype : "button",
													//width : 60,
													handler : this.devAdd,
													scope : that,
													iconCls : 'right'
												}/*, {
													xtype : "panel",
													//width : 60,
													handler : this.devAdd,
													html: '<img src="../resources/sysImages/add.gif">',
													scope : that
													//iconCls : 'right'
												}*/, {
													xtype : 'panel',
													height : 10
												}, {
													xtype : "button",
													width : 60,
													handler : this.devAllAdd,
													scope : that,
													iconCls : 'rightAll'
												}, {
													xtype : 'panel',
													height : 10
												}, {
													xtype : "button",
													width : 60,
													handler : this.devMove,
													scope : that,
													iconCls : 'left'
												}, {
													xtype : 'panel',
													height : 10
												}, {
													xtype : "button",
													width : 60,
													handler : this.devAllMove,
													scope : that,
													iconCls : 'leftAll'
												}]
									},{
										columnWidth : .30}]
						});
			},
			devAdd : function() {
				var node = this.tree.getSelectionModel().getSelectedNode();
				if(!node){
					Ext.Msg.alert("系统提示",padBlank+"请选择相应的设备结点." );
					return ;
				}
				var pNode = node.parentNode;
				
				if(node.id.indexOf("serv")==0){
					var count = node.id.lastIndexOf("_");
					//服务ID
					var instanceId = node.id.substring(count+1);
					//资源类型（这里是服务前缀serv）
					var restypes = "serv";
					
					if(this.grid.doExist(instanceId)){
						Ext.Msg.alert("系统提示",padBlank+"该设备已经选择！"+padBlank+padBlank);
					}else{
						var dev ={
							instanceid:instanceId,
						    instancecname:node.text,
						    restypes: restypes
						    //restypesName: pNode.text
						};
						var record = new Ext.data.Record(dev);
						this.grid.getStore().add([record]);
					}
				}else{
					Ext.Msg.alert("系统提示",padBlank+"单节点添加的时候，只能够是设备."+padBlank+padBlank+"<br>若想要一次性添加一种类型的设备，请点击批添加.");
					return ;
				}
			},
			devAllAdd : function() {
				var node = this.tree.getSelectionModel().getSelectedNode();
				if(!node){
					Ext.Msg.alert("系统提示",padBlank+"请选择相应的设备类型结点." );
					return ;
				}
				if(node.id.indexOf("serv_man")==0){
				    var that = this; 
					node.expand(false, true, function() {
						        //得到孩子结点，把不存在的结点加进去
								var childNodes = node.childNodes;
								var records = new Array();
								for (var i = 0; i < childNodes.length; i++) {
									var nodeC = childNodes[i];
									var count = nodeC.id.lastIndexOf("_");
				                	var instanceId = nodeC.id.substring(count+1);//设备的Id
									if (!that.grid.doExist(instanceId)) {
										var dev = {
											instanceid : instanceId,
											instancecname : nodeC.text 
										};
										records.push(new Ext.data.Record(dev));
									}
								}
								that.grid.getStore().add(records);
								 
							});
				}else{
					Ext.Msg.alert("系统提示",padBlank+"批设备添加.请选择设备类型！"+padBlank+padBlank);
					return ;
				}
			},
			devMove : function() {
				var record = this.grid.getSelectionModel().getSelections();
				if(record.length > 1 || record.length<0){
				     Ext.Msg.alert("系统提示",padBlank+"这是单设备移除操作，请选择一条记录！"+padBlank);
				     return ;
				}
				record = this.grid.getSelectionModel().getSelected();
				this.grid.getStore().remove(record);
			},
			devAllMove : function() {
		         var records = this.grid.getSelectionModel().getSelections();
				if (records.length < 0) {
					Ext.Msg.alert("系统提示", padBlank + "这是批设备移除操作，请至少选择一条记录！" + padBlank);
					return;
				}
				for(var i =0;i<records.length;i++){
				    this.grid.getStore().remove(records[i]);
				}
	       },
			doClearAll : function() {
				 this.grid.doClearAll();
			
			},
			createCombo : function(fieldLabel,url,width,allowBlank,helpText,id,name,extra1,extra2) {   
				    var itemCls=(allowBlank?'':'required-field');
			        var combo = new Ext.form.ComboBox({
			            autoLoad: true,
			            fieldLabel: fieldLabel,
			            emptyText: '请选择...',
			            isFormField: true,
			            width:width,
			            mode: 'local',
			            name:id,
			            itemCls:itemCls,
			            helpText:helpText,
			            allowBlank: allowBlank,
			            blankText:'请选择...',
			            lastQuery: '',
			            triggerAction: 'all',
			            displayField:name,
			            valueField:id,
			            store: new Ext.data.Store({
			                proxy: new Ext.data.HttpProxy({url: url, method: 'POST'}),
			                reader: new Ext.data.JsonReader({},new Ext.data.Record.create([{name:id},{name:name},{name:extra1},{name:extra2}]))
			            }),
			            readOnly: true
			        });
			        return combo;
			}
		});

Starit.Alarm.AlarmPresent.resourcesGrid = Ext.extend(Ext.grid.GridPanel, {
	selectDevice : null,
	store : null,
	data : null,
	constructor : function(cfg) {
		var cfg = cfg || {};
		Ext.apply(this, cfg);
		this.initStore();
		this.sm = new Ext.grid.CheckboxSelectionModel();
		Starit.Alarm.AlarmPresent.resourcesGrid.superclass.constructor.call(this, {
			height : 200,
			store : this.store,
			autoScroll : true,
			//title : "已选设备",
			stripeRows : true,
			//border : true,
			style: 'border: 1px solid #99BBE8',
			width : 210,
			//frame : true,
			columns : [this.sm,{
						header : '<font style="font-weight:bold; color:#59A6D6;">已选服务</font>',
						sortable : true,
						dataIndex : 'instancecname'
					}],
			viewConfig : {
				forceFit : true
			}
		});
	},
	initStore : function() {
		this.selectDevice = [];
		this.store = new Ext.data.Store({
			proxy : new Ext.data.MemoryProxy(this.selectDevice),
			reader : new Ext.data.JsonReader({}, [
				{name : 'instanceid'},
				{name : 'instancecname'},
				{name: 'restypes'}	//服务商id
			])
		});
		this.store.load();
	},
	doClearAll : function() {
		this.getStore().removeAll();
		this.selectDevice=[];
	},
	doLoadData:function(){
		 
	},
	doExist:function(instanceId){
		 if(this.getStore().find("instanceid",instanceId)!=-1){
		   	return true;
		 }
    },
	doGetMsg:function(){
		var devIds = [];
		var count = this.getStore().getCount();
		var record;
		for(var i=0;i<count;i++){
		  record =this.getStore().getAt(i);
		  devIds.push(record.data.instanceid + "," + record.data.restypes);
		}
		this.selectDevice = devIds;
	}
}); 

