Ext.ns("Starit.Alarm", "Starit.Alarm.AlarmPresent");

var LevelGrid_URL = "getAlarmLevel_L.action";
var CategoryGrid_URL = "getAlarmCategory_L.action";
var TypeGrid_URL = "getAlarmType_L.action";

Starit.Alarm.AlarmPresent.PropertyConfigForm = Ext.extend(Ext.Panel, {
			levelGrid : null,// 级别
			categoryGrid : null,// 类别
			typeGrid : null,// 类型
			selLevelArr : null,// 已选择的级别数组 (id)
			selCategoryArr : null,// 已选择的类别的数组(id)
			selTypeArr : null,// 已选择的类型的数组(id)
			constructor : function(cfg) {
				var cfg = cfg || {};
				Ext.apply(this, cfg);
				this.initGrid();
				Starit.Alarm.AlarmPresent.PropertyConfigForm.superclass.constructor
						.call(this, {
									// renderTo: 'UserForm',
									anchor : '90%',
									height : 260,
									autoScroll : true,
									frame:true,
									title : '告警属性配置',
									layout : 'column',
									bodyStyle : 'padding: 10px 0 0 10px',
									items : [{
												xtype : 'panel',
												border : true,
												columnWidth : .22,
												layout : 'form',
												items : [this.levelGrid]
											}, {
												columnWidth : .22,
												layout : 'form',
												items : [this.categoryGrid]
											}, {
												columnWidth : .22,
												layout : 'form',
												items : [this.typeGrid]
											}]
								});
				this.initListener();

			},
			initGrid : function() {
				this.levelGrid = new Starit.Alarm.AlarmPresent.LevelGrid();
				this.categoryGrid = new Starit.Alarm.AlarmPresent.CategoryGrid();
				this.typeGrid = new Starit.Alarm.AlarmPresent.TypeGrid();
			},
			initListener : function() {
				this.levelGrid.addListener('render', function() {
							this.levelGrid.getStore().load();
						}, this);
				this.categoryGrid.addListener('render', function() {
							this.categoryGrid.getStore().load();
						}, this);
				this.typeGrid.addListener('render', function() {
							this.typeGrid.getStore().load();
						}, this);

				this.levelGrid.getStore().addListener("load", function() {
					   this.levelGrid.doLoadData("almLevel");
				}, this);
				this.categoryGrid.getStore().addListener("load", function() {
					 this.categoryGrid.doLoadData("almCat");
				}, this);
				this.typeGrid.getStore().addListener("load", function() {
						this.typeGrid.doLoadData("almType");
				}, this);
			},
			initCfgParams : function() {
				// name 必须有 ，自己配置
				this.initConfig({
							layout : 'column',
							columnNum : 5,
							fields : [this.levelGrid, {
										xtype : "panel"
									}, this.categoryGrid, {
										xtype : "panel"
									}, this.typeGrid]
						});

			},
			doClearAll : function() {
				this.selCategoryArr = null;
				this.selLevelArr = null;
				this.selTypeArr = null;

				this.levelGrid.doClearAll();
				this.categoryGrid.doClearAll();
				this.typeGrid.doClearAll();
			},
			/**
			 * 得到所有选择的属性的信息
			 */
			doGetSelMsg : function() {
				  this.categoryGrid.doGetSelMsg();
				  this.levelGrid.doGetSelMsg();
				  this.typeGrid.doGetSelMsg();
			},
			doLoadGridData : function(grid, listRecord, storeIdField,
					listIdField) {
				/*
				 * 测试代码var list
				 * =[{id:1,name:'过滤器1',catalogId:1,catalogName:'目录2',remark:'this
				 * filter is created for testing !'}];
				 * 
				 * var str="id"; var index =
				 * this.getStore().find("id",list[0][str]); alert(index);
				 */
				if (listRecord) {
					for (var i = 0; i < listRecord.length; i++) {
						var value = listRecord[i][listIdField];
						var index = grid.getStore().find(storeIdField,
								listRecord[i][listIdField]);
						grid.getSelectionModel().selectRow(index, true);
					}
				}
			}
		});

		
		

			
		
Starit.Alarm.AlarmPresent.LevelGrid = Ext.extend(Ext.grid.GridPanel, {
	        selLevelArr : null,// 已选择的级别数组 (id)
			constructor : function(cfg) {
				var cfg = cfg || {};
				Ext.apply(this, cfg);

				this.sm = new Ext.grid.CheckboxSelectionModel();

				Starit.Alarm.AlarmPresent.LevelGrid.superclass.constructor
						.call(this, {
							height : 200,
							width : 200,
							//frame : true,
							//border : true,
							style:'border: 1px solid #99BBE8; margin-left: 8px;',
							loadMask : new Ext.LoadMask(Ext.getBody(), {
										Msg : "正在载入数据，请稍后..."
									}),
							autoScroll : true,
							store : new Ext.data.Store({
										proxy : new Ext.data.HttpProxy({
													url : LevelGrid_URL,
													method : 'POST'
												}),
										reader : new Ext.data.JsonReader({},
												Ext.data.Record.create([{
															name : "almLevel"
														}, {
															name : "almLevelName"
														}]))
									}),
							columns : [this.sm, {
										header : '<font style="font-weight:bold; color:#59A6D6;">告警级别</font>',
										dataIndex : 'almLevelName',
										width : 90
									}],
							viewConfig : {
								forceFit : true
							}
						});
			},
			/**
			 * 清理所有选择的记录
			 */
			doClearAll : function() {
				if (this.getSelectionModel().grid) {
					this.getSelectionModel().clearSelections();
				}
			},
			/**
			 * 得到选择的记录
			 * 
			 * @return {} 一个记录的数组
			 */
			doGetSelMsg : function() {
				var selections = this.getSelectionModel().getSelections();
				var levelArr = new Array();
				for (var i = 0, len = selections.length; i < len; i++) {
					levelArr.push(selections[i].get("almLevel"));
				}
				this.selLevelArr=levelArr;
			},
			doLoadData:function(listIdField){
				if (this.selLevelArr) {
					listRecord=this.selLevelArr;
					for (var i = 0; i < listRecord.length; i++) {
						var index = this.getStore().find("almLevel",
								listRecord[i]);
						this.getSelectionModel().selectRow(index, true);
					}
				}
			}
		});

Starit.Alarm.AlarmPresent.CategoryGrid = Ext.extend(Ext.grid.GridPanel, {
	        selCategoryArr : null,// 已选择的类别的数组(id)
			constructor : function(cfg) {
				var cfg = cfg || {};
				Ext.apply(this, cfg);
				this.sm = new Ext.grid.CheckboxSelectionModel();
				Starit.Alarm.AlarmPresent.CategoryGrid.superclass.constructor
						.call(this, {
									height : 200,
									width : 200,
									//frame : true,
									//border : true,
									style:'border: 1px solid #99BBE8; margin-left: 8px;',
									autoScroll : true,
									loadMask : new Ext.LoadMask(Ext.getBody(),
											{
												Msg : "正在载入数据，请稍后..."
											}),
									store : new Ext.data.Store({
												proxy : new Ext.data.HttpProxy(
														{
															url : CategoryGrid_URL,
															method : 'POST'
														}),
												reader : new Ext.data.JsonReader(
														{}, Ext.data.Record
																.create([{
																	name : "almCat"
																}, {
																	name : "almCatName"
																}]))
											}),
									columns : [this.sm, {
												header : '<font style="font-weight:bold; color:#59A6D6;">告警类别</font>',
												dataIndex : 'almCatName',
												width : 90
											}],
									viewConfig : {
										forceFit : true
									}
								});
			},
			doClearAll : function() {
				if (this.getSelectionModel().grid) {
					this.getSelectionModel().clearSelections();
				}
			},
			/**
			 * 得到选择的记录
			 * 
			 * @return {} 一个记录的数组
			 */
			doGetSelMsg : function() {
				var selections = this.getSelectionModel().getSelections();
				var CategoryArr = new Array();
				for (var i = 0, len = selections.length; i < len; i++) {
					CategoryArr.push(selections[i].get("almCat"));
				}
				this.selCategoryArr= CategoryArr;
			},
			doLoadData:function(listIdField){
				if (this.selCategoryArr) {
					listRecord=this.selCategoryArr;
					for (var i = 0; i < listRecord.length; i++) {
						var index = this.getStore().find("almCat",
								listRecord[i]);
						this.getSelectionModel().selectRow(index, true);
					}
				}
			}
		});

Starit.Alarm.AlarmPresent.TypeGrid = Ext.extend(Ext.grid.GridPanel, {
		    selTypeArr : null,// 已选择的类型的数组(id)
			constructor : function(cfg) {
				var cfg = cfg || {};
				Ext.apply(this, cfg);
				this.sm = new Ext.grid.CheckboxSelectionModel();
				Starit.Alarm.AlarmPresent.TypeGrid.superclass.constructor.call(
						this, {
							height : 200,
							width : 200,
							//frame : true,
							//border : true,
							style:'border: 1px solid #99BBE8; margin-left: 8px;',
							autoScroll : true,
							loadMask : new Ext.LoadMask(Ext.getBody(), {
										Msg : "正在载入数据，请稍后..."
									}),
							store : new Ext.data.Store({
										proxy : new Ext.data.HttpProxy({
													url : TypeGrid_URL,
													method : 'POST'
												}),
										reader : new Ext.data.JsonReader({},
												Ext.data.Record.create([{
															name : "almType"
														}, {
															name : "almTypeName"
														}]))
									}),
							columns : [this.sm, {
										header : '<font style="font-weight:bold; color:#59A6D6;">告警类型</font>',
										dataIndex : 'almTypeName',
										width : 90
									}],
							viewConfig : {
								forceFit : true
							}
						});
			},
			doClearAll : function() {
				if (this.getSelectionModel().grid) {
					this.getSelectionModel().clearSelections();
				}
			},
			/**
			 * 得到选择的记录
			 * 
			 * @return {} 一个记录的数组
			 */
			doGetSelMsg : function() {
				var selections = this.getSelectionModel().getSelections();
				var TypeArr = new Array();
				for (var i = 0, len = selections.length; i < len; i++) {
					TypeArr.push(selections[i].get("almType"));
				}
				this.selTypeArr=TypeArr;
			},
			doLoadData:function(listIdField){
				if (this.selTypeArr) {
					listRecord=this.selTypeArr;
					for (var i = 0; i < listRecord.length; i++) {
						var index = this.getStore().find("almType",
								listRecord[i]);
						this.getSelectionModel().selectRow(index, true);
					}
				}
			}
		});