Ext.ns("Starit.Alarm", "Starit.Alarm.AlarmPresent");
var ALARM_FILTER_GRID_URL = "getAlarmFilterByCatalogId_L.action";
var padBlank = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
// 时间的处理
function formatDate(val) {
	if (null == val) {
		return '';
	} else {
		return new Date(val['time']).format('Y-m-d H:i:s ');
	}
}
Starit.Alarm.AlarmPresent.FilterGrid = Ext.extend(Starit.CommonGrid, {
	saveflag : true,
	catalogId : null,
	filterName : null,
	rightMenu : null,
	RealTimeMonitor : null,
	ToPersonalTemplate : null,
	ToGlobalTemplate : null,
	personalTemplateWin : null,
	personalTemplateForm : null,
	globalTemplateForm : null,
	globalTemplateWin : null,
	constructor : function(cfg) {
		var cfg = cfg || {};
		Ext.apply(this, cfg);
		this.initRightMenu();
		this.RWinImpl();

		Starit.Alarm.AlarmPresent.FilterGrid.superclass.constructor.call(this,
				{
					width : 800,
					height : 300,
					region : 'center',
					autoScroll : true
				});
		this.initListener();

	},
	initRightMenu : function() {
		this.RealTimeMonitor = new Ext.menu.Item({
			text : '告警实时监控',
			handler : this.doTurnToRealTimeMonitor,
			scope : this
		});
		this.ToPersonalTemplate = new Ext.menu.Item({
			text : '转换为个人模板',
			handler : this.doTurnToPersonalTemplate,
			scope : this
		});
		this.ToGlobalTemplate = new Ext.menu.Item({
			text : '转换为全局模板',
			handler : this.doTurnToGlobalTemplate,
			scope : this
		});

		this.rightMenu = new Ext.menu.Menu({
			items : [this.RealTimeMonitor, this.ToPersonalTemplate,
					this.ToGlobalTemplate]
		});
	},
	RWinImpl : function() {
		this.personalTemplateForm = new PersonalTemplateForm();
		this.personalTemplateWin = new Ext.Window({
			bodyStyle : 'padding 30px ,5px',
			width : 310,
			modal : true,
			closeAction : 'hide',
			items : [this.personalTemplateForm]
		});
		this.globalTemplateForm = new GlobalTemplateForm();
		this.globalTemplateWin = new Ext.Window({
			bodyStyle : 'padding 30px ,5px',
			width : 310,
			modal : true,
			closeAction : 'hide',
			items : [this.globalTemplateForm]
		});
	},
	initListener : function() {

		this.addListener('render', function() {
			this.getStore().load({
				params : {
					start : 0,
					limit : 10
				}
			})
		}, this);
		this.addListener('rowcontextmenu', function(grid, rowIndex, e) {
			grid.getSelectionModel().selectRow(rowIndex);
			e.preventDefault();
			this.rightMenu.showAt(e.getXY());

		}, this);
		this.store.addListener('beforeload', function() {
			Ext.apply(this.store, {
				baseParams : {
					catalogId : this.catalogId,
					filterName : this.filterName
				}
			});
		}, this);

	},
	initCfgParams : function() {

		this.isExport = false;// 不支持导入导出
		this.isCharts = false;// 不显示图标操作
		this.isAdvancedQuery = false;// 不支持高级查询

		this.showDataIndex = "name";// 标志dataIndex
		this.initConfig({
			url : ALARM_FILTER_GRID_URL,
			dataField : ["templateId", "templateName", "templateClassId",
					"templateClassName", "templateType", "userId", "userName",
					"createTime"],
			columnParams : [{
				header : '过滤器名称',
				dataIndex : 'templateName',
				width : 90
			}, {
				header : '目录',
				dataIndex : 'templateClassName',
				width : 90
			}, {
				header : '创建人',
				dataIndex : 'userName',
				width : 90
			}, {
				header : '创建日期',
				dataIndex : 'createTime',
				renderer : formatDate,
				width : 150
			}]
		});
	},
	onRowClick : function() {
		this.doModify();
	},
	/**
	 * 添加
	 */
	doAdd : function() {
		this.saveflag = true;
		var viewport = this.viewport;
		this.doClearAll();
		viewport.saveForm.show();
	},
	doModify : function() {
		this.saveflag = false;
		this.doClearAll();

		var selections = this.getSelectionModel().getSelections();
		if (!selections || selections.length != 1) {
			Ext.Msg.alert('系统提示', padBlank + "只能选择一条记录！" + padBlank + padBlank);
			return;
		}
		var record = this.getSelectionModel().getSelected();
		var viewport = this.viewport;
		viewport.saveForm.show();
		var filterId = record.data.templateId;
		Ext.MessageBox.show({
			msg : '操作正在进行,请稍候!',
			progressText : '操作中...',
			width : 300,
			wait : true,
			icon : 'loading',
			waitConfig : {
				interval : 400
			}
		});

		AlarmWebFilterManager.getFilterInfo(filterId, function(data) {

			var jsonData = Ext.decode(data);

			var filterList = jsonData.filterList;
			var catList = jsonData.catList;
			var typeList = jsonData.typeList;
			var levelList = jsonData.levelList;
			var devList = jsonData.devList;
			/**
			 * 这部分的处理根据数据库而定
			 */
			var catIds = new Array();
			if (catList) {
				for (var i = 0; i < catList.length; i++) {
					catIds.push(catList[i].id)
				}
			}

			var typeIds = new Array();
			if (typeList) {
				for (var j = 0; j < typeList.length; j++) {
					typeIds.push(typeList[j].id);
				}
			}

			var levelIds = new Array();
			if (levelList) {
				for (var k = 0; k < levelList.length; k++) {
					levelIds.push(levelList[k].id)
				}
			}

			/**
			 * 这部分的处理根据数据库而定
			 */

			// 过滤器名称，备注，是否仅限本人的加载
			viewport.saveForm.doLoadData(filterList);

			// 设备的加载
			var devs = [];
			if (devList) {
				for (var i = 0; i < devList.length; i++) {
					var obj = devList[i];
					var devObj = {
						instanceid:obj.seqid,
						instancecname:obj.signame,
						restypes:obj.restype
					};
					devs.push(new Ext.data.Record(devObj));
				}
			}
			viewport.resourcesConfigForm.grid.getStore().add(devs);

			// 告警类型，类别，级别信息的加载
			viewport.propertyConfigForm.levelGrid.selLevelArr = levelIds;
			viewport.propertyConfigForm.categoryGrid.selCategoryArr = catIds;
			viewport.propertyConfigForm.typeGrid.selTypeArr = typeIds;
			viewport.propertyConfigForm.levelGrid.doLoadData();
			viewport.propertyConfigForm.categoryGrid.doLoadData();
			viewport.propertyConfigForm.typeGrid.doLoadData();
			Ext.MessageBox.hide();

		});
	},
	doDelete : function() {
		var selections = this.getSelectionModel().getSelections();
		if (!selections || selections.length != 1) {
			Ext.Msg.alert('系统提示', padBlank + "只能删除一条记录！" + padBlank + padBlank);
			return;
		}
		var that = this;
		var record = this.getSelectionModel().getSelected();
		var filterId = record.data.templateId;
		Ext.MessageBox.confirm("提示", "是否要删除指定的内容?" + padBlank + padBlank,
				function(button, text) {
					if (button == "yes") {
						AlarmWebFilterManager.deleteFilter(filterId, function(
								data) {
							if (data) {
								Ext.MessageBox.alert("系统提示", padBlank
										+ "删除过滤器成功!" + padBlank + padBlank);
								that.getStore().reload();
							} else {
								Ext.MessageBox.alert("系统提示", padBlank
										+ "删除过滤器失败！" + padBlank + padBlank);
							}
						});

					}
					that.doAdd();
				}, this);

	},
	/**
	 * 清理Grid。这里边应该好好考虑一下。是否应该load进来一个为空的数据
	 */
	doClearAll : function() {
		var viewport = this.viewport;
		// 下面各种组件的清空
		// 过滤器名称，备注，是否仅限本人
		viewport.saveForm.doClearAll();
		// 设备
		viewport.resourcesConfigForm.doClearAll();
		// 属性
		viewport.propertyConfigForm.doClearAll();

	},
	/**
	 * 载入Grid的数据
	 * 
	 * @param {}
	 *            data
	 */
	doLoadData : function(data) {

	},
	doQuery : function(v) {
		this.filterName = v;
		this.getStore().reload();
		this.doClearAll();
	},
	doTurnToRealTimeMonitor : function() {
		var filterId = this.getSelectionModel().getSelected().data.templateId;
		window.open("alarmMonitor.jsp?newfilterID=" + filterId, "_blank",
				"fullscreen=1,resizable=yes,status=yes,toolbar=yes, menubar=yes,scrollbars=yes");
	},
	doTurnToGlobalTemplate : function() {

		var filterId = this.getSelectionModel().getSelected().data.templateId;
		var filterCatId = null;
		var that = this;
		var flag = null;
		this.personalTemplateForm.doClearAll();
		this.personalTemplateWin.show();
		this.personalTemplateForm.copyOrShear.store.load();
		this.personalTemplateForm.changeStartBiz = function() {

			filterCatId = that.personalTemplateForm.gId;
			if (that.personalTemplateForm.cId == 1) {
				flag = true;
			}
			if (that.personalTemplateForm.cId == 2) {
				flag = false;
			}
			if (filterCatId == null || flag == null) {
				Ext.MessageBox.alert("系统提示", "请选择转到的新目录和是否保留原模板！");
				return;
			} else {
				AlarmWebFilterManager.copyAlarmWebFilter(filterId, filterCatId,
						flag, function(data) {
							if (data) {
								Ext.MessageBox.alert("系统提示", "该模板成功转换成为全局模板！");

								that.personalTemplateWin.hide();
								that.viewport.catalogTree.doRefresh();
								that.viewport.grid.getStore().reload();
								that.viewport.grid.doClearAll();
							} else {

								Ext.MessageBox.alert("系统提示", "该模板转换成为全局模板失败！");
								that.personalTemplateWin.hide();
								return;
							}
						});

			};
		}

	},
	doTurnToPersonalTemplate : function() {

		var filterId = this.getSelectionModel().getSelected().data.templateId;
		var filterCatId = null;
		var that = this;
		var flag = true;
		this.globalTemplateForm.doClearAll();
		this.globalTemplateWin.show();
		this.globalTemplateForm.personalCatalog.store.load();
		this.globalTemplateForm.changeStartBiz = function() {
			filterCatId = that.globalTemplateForm.pId;
			if (filterCatId == null || filterCatId == '') {
				Ext.MessageBox.alert("系统提示", "请选择转到的新目录！");
				return;
			} else {
				AlarmWebFilterManager.copyAlarmWebFilter(filterId, filterCatId,
						flag, function(data) {
							if (data) {
								Ext.MessageBox.alert("系统提示", "该模板成功转换成为个人模板！");
								that.globalTemplateWin.hide();
								that.viewport.catalogTree.doRefresh();
								that.viewport.grid.getStore().reload();
								that.viewport.grid.doClearAll();
							} else {
								Ext.MessageBox.alert("系统提示", "该模板转换成为个人模板失败！");
								that.globalTemplateWin.hide();
								return;
							}
						});

			};
		}

	}
});

/**
 * 当目录是个人的目录的时候，表格的右键面板
 * 
 * @class PersonalTemplateForm
 * @extends Ext.form.FormPanel
 */
PersonalTemplateForm = Ext.extend(Ext.form.FormPanel, {
	globalCatalog : null,
	copyOrShear : null,
	gId : null,// 全局目录的Id
	cId : null,// 保留还是删除目录的Id
	constructor : function() {
		this.init();
		PersonalTemplateForm.superclass.constructor.call(this, {
			frame : true,
			width : 300,
			height : 150,
			layout : 'form',
			buttonsAlgin : 'center',
			items : [this.globalCatalog, this.copyOrShear],
			buttons : [{
				text : '转换',
				handler : this.changeStart,
				scope : this
			}]
		});

	},
	init : function() {
		this.globalCatalog = Starit.createCombo("转换到全体目录",
				"getGlobalAlarmCatalog_L.action", "classid", "classname",
				'90%', false, null);
		this.globalCatalog.store.load();
		this.copyOrShear = Starit.createMemoryCombo("保留原模板", [{
			id : 1,
			name : '删除'
		}, {
			id : 2,
			name : '复制'
		}], "90%", false);
		this.copyOrShear.store.load();
	},
	changeStart : function() {
		this.gId = this.globalCatalog.getValue();
		this.cId = this.copyOrShear.getValue();
		this.changeStartBiz();
	},
	changeStartBiz : function() {
	},
	doClearAll : function() {
		this.globalCatalog.reset();
		this.copyOrShear.reset();
		this.gId = null;
		this.cId = null;
	}
});

GlobalTemplateForm = Ext.extend(Ext.form.FormPanel, {
	personalCatalog : null,
	pId : null,// 个人目录的Id
	constructor : function() {
		this.init();
		GlobalTemplateForm.superclass.constructor.call(this, {
			frame : true,
			width : 300,
			height : 100,
			layout : 'form',
			buttonAlign : 'center',
			items : [this.personalCatalog],
			buttons : [{
				text : '转换',
				handler : this.changeStart,
				scope : this
			}]
		});
	},
	init : function() {
		this.personalCatalog = Starit.createCombo("转换到个人目录",
				"getAlarmCatalogByUserId_L.action", "classid", "classname",
				'90%', false, null);
		this.personalCatalog.store.load();
	},
	changeStart : function() {
		this.pId = this.personalCatalog.getValue();
		this.changeStartBiz();
	},
	changeStartBiz : function() {
	},
	doClearAll : function() {
		this.personalCatalog.reset();
		this.pId = null;
	}
});
