Ext.ns("Starit.Alarm", "Starit.Alarm.AlarmPresent");
var padBlank = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
var FILTER_TREE_URL = "getAlarmCatalogTree_L.action";
var WHOLE='sys';//当是全局的模板的时候的UserId; 

/**
 * 告警过滤树
 * 
 * @class Starit.Alarm.AlarmPresent.filterTree
 * @extends Starit.CommonTree
 * 
 * 说明： 1.viewport 属性代表的是外界的布局; 2.对树的结点的json有一定的要求 根节点： 目录结点：catalog:true 过滤器结点：
 */
Starit.Alarm.AlarmPresent.catalogTree = Ext.extend(Starit.CommonTree, {

			
			rootRightMenu : null,
		    catalogRrightMenu : null,
		    isPersonal:null,
			constructor : function(cfg) {
				var cfg = cfg || {};
				Ext.apply(this, cfg);
				this.initRightMenu();
				Starit.Alarm.AlarmPresent.catalogTree.superclass.constructor
						.call(this, {
									// region:'west',
									width : 230,
									height : 700,
									title : '过滤器分类',
									autoScroll : true,
									rootVisible:false,
									//hideCollapseTool:true,
									url : FILTER_TREE_URL,
									rootId : "root_alarm_filter",
									rootText : "过滤器"
								});
				this.addListener('contextmenu', this.onContextmenu, this);
			},
			doQuery : function(v) {
                   
                    /*
                     * 该接口还没有实现
                     * */
			},
			/**
			 * 初始化右键菜单
			 */
			initRightMenu : function() {
				// 根右键菜单
				this.rootRightMenu = new Ext.menu.Menu({
							items : [{
										iconCls : 'new',
										text : '增加分类',
										handler : this.addCatalog,
										scope : this
									}]
						});
				this.catalogRrightMenu = new Ext.menu.Menu({
							items : [{
										iconCls : 'update',
										text : '修改分类',
										handler : this.updateCatalog,
										scope : this
									}, {
										iconCls : 'delete',
										text : '删除分类',
										handler : this.deleteCatalog,
										scope : this
									}]
						});
			},
			/**
			 * 右键处理
			 * 
			 * @param {}
			 *            node
			 * @param {}
			 *            e
			 */
			onContextmenu : function(node, e) {
				node.select();
				// 实际上这里应该判断一下，是根还是非根结点
				e.preventDefault();

				if (node != this.getRootNode() && (node.text=='全局' || node.text=='个人')) {

					this.rootRightMenu.showAt(e.getXY());

				} else if(node != this.getRootNode()) {

					this.catalogRrightMenu.showAt(e.getXY());

				} 
			},
			/**
			 * 点击树的结点
			 * 
			 * @param {}
			 *            node
			 * @param {}
			 *            e
			 */
			doTreeClickCascading : function(node) {
				  node.select();
				// 对树的右边的grid的处理。
				// grid 加载的初始化的条件。(例如说：省市，过滤器名称等)
				if(node != this.getRootNode() && node.text!='全局' && node.text!='个人'){
					if(node.parentNode.attributes.text == '个人'){
						this.viewport.grid.ToPersonalTemplate.hide();
						this.viewport.grid.ToGlobalTemplate.show();
					    this.isPersonal=true;
					}else{
						this.viewport.grid.ToPersonalTemplate.show();
						this.viewport.grid.ToGlobalTemplate.hide();
						this.isPersonal=false;
						
					}
					this.viewport.grid.doClearAll();
					this.viewport.grid.catalogId = node.id;
					this.viewport.grid.getStore().reload();
					
				}
			},
			/**
			 * 增加分类
			 */
			addCatalog : function() {
               
                var node = this.getSelectedNode();
                var templateType=2 ; 
                if(node != this.getRootNode() && node.text=='全局'){ 
                    templateType=1;
                }
                var that =this;
				Ext.Msg.prompt("增加分类", padBlank + padBlank + "请输入分类的名称"
								+ padBlank + padBlank, function(btn, txt) {
							if (btn == 'ok' && txt) {
								AlaramWebFilterCatalogManager.addCatalog(txt,templateType,
										function(data) {
											if (data) {
												Ext.MessageBox.alert("系统提示:",
														padBlank + padBlank
																+ "添加分类成功"
																+ padBlank
																+ padBlank);
												that.doRefresh();
											} else {
												Ext.MessageBox.alert("系统提示:",
														padBlank + padBlank
																+ "添加分类失败！"
																+ padBlank
																+ padBlank);
											}
										});
							}
						}, this);
			},
			/**
			 * 修改分类
			 */
			updateCatalog : function() {
				var that = this; // 获得过滤器树的引用
				var selectedNode = this.getSelectedNode();
				if (!selectedNode)
					return;

				Ext.Msg.prompt('修改分类', padBlank + '请输入新的分类名称' + padBlank,
						function(btn, text) {
							if (btn == 'ok' && text) {

								if (text == selectedNode.text) {
									Ext.MessageBox.alert("系统提示:", padBlank
													+ "分类没有改变！" + padBlank);
									return;
								}
								AlaramWebFilterCatalogManager.updateCatalog(selectedNode.id,
										text, function(data) {
											if (data) {
												Ext.MessageBox.alert("系统提示:",
														padBlank + padBlank
																+ "修改分类成功"
																+ padBlank
																+ padBlank);
												that.doRefresh();
											} else {
												Ext.MessageBox.alert("系统提示:",
														padBlank + padBlank
																+ "修改分类失败！ "
																+ padBlank
																+ padBlank);
											}
										});
							}
						}, null, false, selectedNode.text);
			},
			/**
			 * 删除分类
			 */
			deleteCatalog : function() {
				var node = this.getSelectedNode();
				//同时应该判断这个分类下有没有过滤器
				var that = this;
				Ext.MessageBox.confirm('系统提示:', '你确定要删除所选分类吗？', function(btn) {
							if (btn == 'yes') {
								
								AlaramWebFilterCatalogManager.haveFilters(node.id,function(data1){
								        if(data1){
								        	 Ext.MessageBox.alert("系统提示:",
														padBlank + padBlank
																+ "该目录下有过滤器，不可删除！"
																+ padBlank
																+ padBlank);
												return; 
								        }else{
												AlaramWebFilterCatalogManager.deleteCatalog(node.id,
														function(data) {
															if (data) {
																Ext.MessageBox.alert("系统提示:",
																		padBlank + padBlank
																				+ "删除 成功"
																				+ padBlank
																				+ padBlank);
																that.doRefresh();
				
															} else {
																Ext.MessageBox.alert("系统提示:",
																		padBlank + padBlank
																				+ "删除分类失败！"
																				+ padBlank
																				+ padBlank);
															}
														});
										       }
								});
							}
						});
			} 
			 ,
			/**
			 * 获得被选择的结点
			 * 
			 * @return {}
			 */
			getSelectedNode : function() {
				return this.getSelectionModel().getSelectedNode();
			}

		});
