Ext.ns("Starit.Alarm", "Starit.Alarm.Monitor");
/**
 * 布局
 * 
 * @class Starit.Alarm.Monitor.viewport
 * @extends Starit.CommonViewport
 */
Starit.Alarm.Monitor.viewport = Ext.extend(Starit.CommonViewport, {

	constructor : function() {
		Starit.Alarm.Monitor.viewport.superclass.constructor.call(this, {});
	},

	initCfgParams : function() {
		this.filterTree = new Starit.Alarm.Monitor.CountPanel({
			viewport : this
		});
		this.grid = new Starit.Alarm.Monitor.Grid({
			viewport : this
		});
		this.initConfig({
			leftCmp : this.filterTree,
			rightCmp : [{
				title : '告警实时监控',
				upper : this.grid
			}]
		});
	},
	initConfig : function(o) {
		// 含有this.leftCmp ,this.rightCmp , this.upper ,this.under
		this.items = [];
		if (o && o.leftCmp) {
			this.leftCmp = o.leftCmp;
			this.leftCmp.region = 'west';
			this.items.push(this.leftCmp);
		}

		var rItems = [];
		var title;
		if (o && o.rightCmp && o.rightCmp.length) {

			this.rightCmp = o.rightCmp[0];

			if (this.rightCmp.upper) {
				this.upper = this.rightCmp.upper;
				this.upper.region = 'center';
				title = this.rightCmp.title;
				rItems.push(this.upper);
			}
		}
		var p = new Ext.Panel({
			autoScroll : true,
			region : 'center',
			layout : 'border',
			title : title,
			items : rItems
		});
		this.items.push(p);
	}

});

Ext.BLANK_IMAGE_URL = "../resources/images/default/s.gif";
var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'; // 需要补充的空格
var testView;

function loadAlarmData() {
	testView.grid.getStore().load({
		callback : function() {
			var s = testView.grid.getStore();
			for (var i = 0, len = s.getCount(); i < len; i++) {
				var r = s.getAt(i);
				countHandler(true, r.get('alarmlevelkey'), r.get('treatstate'));
			}
			getCacheData();
			pauseFlag = false;
			changeAllPanel();
		}
	});
}

Ext.BLANK_IMAGE_URL = "../resources/images/default/s.gif";

function changeStyle(style) {
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/" + style + ".css");
}

function keepSession() {
	SessionKeeperManager.keepSession(function(data) {
	});
}

Ext.onReady(function() {
	Ext.QuickTips.init();// 这句 必须有，用于初始化提示。
	Ext.util.CSS.swapStyleSheet("theme", "../resources/css/"
			+ window.parent.styleCssValue);
	Ext.lib.Ajax.defaultPostHeader += ";charset=utf-8";

	setInterval(keepSession, 1000 * 60 * 5);
	alarmShowConfigStore.on('load', function(store, records, options) {
		if (records && records.length) {
			for (var k = 0, len = records.length; k < len; k++) {
				if (records[k].get("soundkey") === 3) {
					soundObj[4] = records[k].get("fileinfo");
				} else if (records[k].get("soundkey") === 4) {
					soundObj[8] = records[k].get("fileinfo");
				} else {
					soundObj[records[k].get("soundkey")] = records[k]
							.get("fileinfo");
				}
				colorObj[records[k].get("soundkey")] = records[k].get("color");
			}
		}

		testView = new Starit.Alarm.Monitor.viewport();
		commonGrid = testView.grid;

		testView.grid.getStore().addListener('beforeload', function() {
			Ext.apply(this, {
				baseParams : {
					filterId : newfilterID,
					maxCount : RECORDCOUNT
				}
			});
		});

		testView.filterTree.alarmMonitorTree.expandAll();
	});

	AlarmViewConfigManager.createColumn(function(data) {
		if (data) {
			columns = Ext.decode(data);
			alarmShowConfigStore.load();
		}
	});

		// window.setInterval(timeTaskRefresh, 1000);
	});