
Ext.namespace("Ext.ux");

Ext.ux.Form = Ext.extend(Ext.form.FormPanel, {
    frame: true,
    bodyStyle:"padding: 5px 5px 0",
    initComponent: function() {
    	Ext.ux.Form.superclass.initComponent.call(this);
    },
    initEvents : function(){
        Ext.ux.Form.superclass.initEvents.call(this);
    },
    createButton: function(text,handler) {
    	var btn = new Ext.Button({
    	    text: text,
    	    handler: handler
    	});
    	return btn;
    },
    createTextFiled: function(fieldLabel, name, anchor, blankText, vtype, maxLength, maxLengthText) {    //生成一个通用的TextField
        var tf = new Ext.form.TextField({
            fieldLabel: fieldLabel,
            name: name,
            xtype: 'textfield',
            readOnly: false,
            allowBlank: false,
            anchor: anchor,
            blankText: '该选项为必填项,请输入内容...',
            vtype: vtype,
            maxLength: maxLength,
            maxLengthText: maxLengthText
        });
        return tf;
    },
    createRadio: function(boxLabel,name,checked,inputValue) {    //生成一个通用的Radio
        var radio = new Ext.form.Radio({
            boxLabel:boxLabel,
            checked:checked,
            name:name,
            labelSeparator:"",
            inputValue:inputValue,
            anchor:"90%"
        });
        return radio;
    },
    createCombo: function(fieldLabel,id,name,anchor,url,extra1,extra2) {    //生成一个通用的ComboBox
        var combo = new Ext.form.ComboBox({
        	autoLoad: true,
            fieldLabel: fieldLabel,
            emptyText: '请选择...',
            isFormField: true,
            anchor: anchor,
            mode: 'local',
            name:id,
            //hiddenName: name,
            allowBlank: false,
            blankText:'请选择...',
            //forceSelection: true,
            lastQuery: '',
            triggerAction: 'all',
            displayField:name,
            valueField:id,
            store: new Ext.data.Store({
                proxy: new Ext.data.HttpProxy({url: url, method: 'POST'}),
                reader: new Ext.data.JsonReader({},new Ext.data.Record.create([{name:id},{name:name},{name:extra1},{name:extra2}]))
            }),
            readOnly: true
        });
        return combo;
    },
     createCombo1: function(fieldLabel,id,name,anchor,url,extra1,extra2) {    //生成一个通用的ComboBox
        var combo = new Ext.form.ComboBox({
        	autoLoad: true,
            fieldLabel: fieldLabel,
            emptyText: '所有',
            isFormField: true,
            anchor: anchor,
            mode: 'local',
            name:id,
            allowBlank: true,
            lastQuery: '',
            triggerAction: 'all',
            displayField:name,
            valueField:id,
            store: new Ext.data.Store({
                proxy: new Ext.data.HttpProxy({url: url, method: 'POST'}),
                reader: new Ext.data.JsonReader({},new Ext.data.Record.create([{name:id},{name:name},{name:extra1},{name:extra2}]))
            }),
            readOnly: true
        });
        return combo;
    },
    createMemoryCombo: function(fieldLabel,id,name,anchor,jsonData) {
    	 var combo = new Ext.form.ComboBox({
            fieldLabel: fieldLabel,
            emptyText: '请选择...',
            isFormField: true,
            anchor: anchor,
            mode: 'local',
            name: id,
            allowBlank: false,
            blankText:'请选择...',
            forceSelection: true,
            triggerAction: 'all',
            displayField:name,
            valueField:id,
            store: new Ext.data.Store({
                proxy: new Ext.data.MemoryProxy(jsonData),
                reader: new Ext.data.JsonReader({},new Ext.data.Record.create([{name:id},{name:name}]))
            }),
            readOnly: true
        });
        return combo;
    },
    createTextArea: function(fieldLabel,name,height,anchor) {
    	var ta = new Ext.form.TextArea({
    	    fieldLabel:fieldLabel,
            name:name,
            height:height,
            anchor:anchor,
            allowBlank: false,
            blankText: '该选项为必填项,请输入内容...'
    	});
    	return ta;
    },
    createHidden: function(fieldLabel,name) {
    	var hidden = new Ext.form.Hidden({
    	    fieldLabel:fieldLabel,
    	    name:name
    	});
    	return hidden;
    },
    createHtmlEditor: function(fieldLabel, anchor) {      //生成一个通用的HtmlEditor
        var he = new Ext.form.HtmlEditor({
            fieldLabel: fieldLabel,
            height: 270,
            anchor: anchor,
            enableLinks: false,
            enableSourceEdit: false,
            fontFamilies:['宋体','隶书','黑体']
        });
        return he;
    },
    createButton: function(text,fn,scope, iconCls) {
    	var btn = new Ext.Button({
    		align: 'left',
    		text: text,
    		handler: fn,
    		scope: scope,
    		iconCls: iconCls
    	});
    	return btn;
    },
    createDateField: function(fieldLabel, name, format, anchor, minText, value) {
    	var df =  new Ext.form.DateField({
			fieldLabel: fieldLabel,
			name: name,
			value : value,
			anchor: anchor,
			minText: minText,
			format: format
		});
		return df;
    },
    createLabel: function(fieldLabel,text) {
    	var label = new Ext.form.Label({
            width: 90,
            height: 40,
            fieldLabel: fieldLabel,
            text: text
        });
        return label;
    }
});

Ext.reg("uxForm", Ext.ux.Form);

