Ext.ns("Starit.Alarm", "Starit.Alarm.Monitor");

var AlMCFG_SHOW_URL = 'getAlarmSoundColor.action';
var PAGESIZE = 30;
var RECORDCOUNT = 2000;
var cacheStore;
var alarmStore;
var instanceIdArr = [];
var objectTypeIdArr = [];
var pauseFlag = true;
var columns; // 定义动态列
var soundObj = {}; // 定义声音对象
var soundFlag = true;// 声音标记
var commonGrid;

var colorObj = {}; // 定义颜色对象

// 全局变量:告警配置数据库数据
var alarmShowConfigStore = new Ext.data.Store({
	proxy : new Ext.data.HttpProxy({
		url : AlMCFG_SHOW_URL,
		method : 'POST'
	}),
	reader : new Ext.data.JsonReader({}, [{
		name : 'soundkey'// 级别数字
	}, {
		name : 'soundname'// 级别 汉语
	}, {
		name : 'color'
	}, {
		name : 'fileinfo'// sound
	}])
});

// 告警数量统计变量
var alarmFilterCount = {

	// 确认数量
	confirm_count1 : 0,
	confirm_count2 : 0,
	confirm_count3 : 0,
	confirm_count4 : 0,
	// 未确认数量
	unconfirm_count1 : 0,
	unconfirm_count2 : 0,
	unconfirm_count3 : 0,
	unconfirm_count4 : 0
};

/**
 * 确认/未确认告警统计计数
 * 
 * @param {}
 *            flag 为增加或者减少标识位
 */
var countHandler = function(falg, level, state) {
	var almLevel = level;
	if (state === ALMTREATSTATE_COMFIRM) {
		// 统计确认告警
		switch (almLevel) {
			case '1' :
				falg
						? alarmFilterCount.confirm_count1++
						: (alarmFilterCount.confirm_count1 == 0
								? alarmFilterCount.confirm_count1
								: alarmFilterCount.confirm_count1--);
				break;
			case '2' :
				falg
						? alarmFilterCount.confirm_count2++
						: (alarmFilterCount.confirm_count2 == 0
								? alarmFilterCount.confirm_count2
								: alarmFilterCount.confirm_count2--);
				break;
			case '4' :
				falg
						? alarmFilterCount.confirm_count3++
						: (alarmFilterCount.confirm_count3 == 0
								? alarmFilterCount.confirm_count3
								: alarmFilterCount.confirm_count3--);
				break;
			case '8' :
				falg
						? alarmFilterCount.confirm_count4++
						: (alarmFilterCount.confirm_count4 == 0
								? alarmFilterCount.confirm_count4
								: alarmFilterCount.confirm_count4--);
				break;
		}
	} else {
		// 统计未确认告警
		switch (almLevel) {
			case '1' :
				falg
						? alarmFilterCount.unconfirm_count1++
						: (alarmFilterCount.unconfirm_count1 == 0
								? alarmFilterCount.unconfirm_count1
								: alarmFilterCount.unconfirm_count1--);
				break;
			case '2' :
				falg
						? alarmFilterCount.unconfirm_count2++
						: (alarmFilterCount.unconfirm_count2 == 0
								? alarmFilterCount.unconfirm_count2
								: alarmFilterCount.unconfirm_count2--);
				break;
			case '4' :
				falg
						? alarmFilterCount.unconfirm_count3++
						: (alarmFilterCount.unconfirm_count3 == 0
								? alarmFilterCount.unconfirm_count3
								: alarmFilterCount.unconfirm_count3--);
				break;
			case '8' :
				falg
						? alarmFilterCount.unconfirm_count4++
						: (alarmFilterCount.unconfirm_count4 == 0
								? alarmFilterCount.unconfirm_count4
								: alarmFilterCount.unconfirm_count4--);
				break;
		}
	}
}

/**
 * 更新统计数量
 * 
 * @author chen.bo
 * @param cmpId ->
 *            组件的id
 * @param value ->
 *            要更新的值
 */
function changePanelCount(cmpId, value) {
//暂时屏蔽掉，如果要使用确认/未确认的统计面板的时候再打开
//	var bd = Ext.getCmp(cmpId).body;
//	bd.update(value);
}

function changeAllPanel() {
	changePanelCount('unconfirm_level1', '<font>'
			+ alarmFilterCount.unconfirm_count1 + '</font>');
	changePanelCount('unconfirm_level2', '<font>'
			+ alarmFilterCount.unconfirm_count2 + '</font>');
	changePanelCount('unconfirm_level3', '<font>'
			+ alarmFilterCount.unconfirm_count3 + '</font>');
	changePanelCount('unconfirm_level4', '<font>'
			+ alarmFilterCount.unconfirm_count4 + '</font>');
	changePanelCount('confirm_level1', '<font>'
			+ alarmFilterCount.confirm_count1 + '</font>');
	changePanelCount('confirm_level2', '<font>'
			+ alarmFilterCount.confirm_count2 + '</font>');
	changePanelCount('confirm_level3', '<font>'
			+ alarmFilterCount.confirm_count3 + '</font>');
	changePanelCount('confirm_level4', '<font>'
			+ alarmFilterCount.confirm_count4 + '</font>');
}

/**
 * 插入多条告警
 */
var insertOnes = function(records) {
	var josnObjs = Ext.decode(records);

	for (var i = 0, len = josnObjs.length; i < len; i++) {
		var newRecord = new Ext.data.Record(josnObjs[i]);
		insertAlm(newRecord);
	}
	changeAllPanel();
	if (testView.grid) {
		keepSelectRecord();
	}
}

/**
 * 插入一条告警
 * 
 * @author chen.bo
 * @param newRecord
 *            一条告警的json数据
 */

var insertOne = function(record) {
	var newRecord = new Ext.data.Record(Ext.decode(record));
	insertAlm(newRecord);
	changeAllPanel();
	if (testView.grid) {
		keepSelectRecord();
	}
}

var insertAlm = function(newRecord) {
	var maxSoundLevel = 1;
	// 如果是异常告警
	if (newRecord.get('gategorykey') === 3
			&& newRecord.get('alarmtypekey') === -2) {
		return;
	}
	// 获得告警级别对应声音标识
	var almLevel = newRecord.get("alarmlevelkey");
	var state = newRecord.get('treatstate');
	if (almLevel === '4') {
		maxSoundLevel = 3;
	} else if (almLevel === '8') {
		maxSoundLevel = 4;
	} else {
		maxSoundLevel = almLevel;
	}

	var length = instanceIdArr.length;
	var almId = newRecord.get('alarmid');

	var num = alarmStore.findBy(function(record) {
		return record.get('alarmid') == almId;
	});

	var countFlag = true;
	if (pauseFlag) {
		cacheStore.addRecord(newRecord);
	} else {
		if (num > -1) {
			countFlag = false;
			var oldRecord = alarmStore.getAt(num);
			alarmStore.remove(oldRecord);
		}
		alarmStore.addRecord(newRecord);
		if (countFlag)
			countHandler(true, almLevel, state);
	}
	if (soundFlag && !pauseFlag) {
		var snd = document.getElementById("soundPlay");
		if (snd) {
			snd.src = "../resources/sound/" + soundObj[maxSoundLevel] + ".wav";
		}
	}
}

/**
 * 确认告警信息
 * 
 * @param ids
 *            ->告警id数组
 * @param userName
 *            ->确认人
 * @param dt
 *            ->时间
 */
var confirmAIs = function(ids, userid, dt) {
	var flag = false;
	var number = alarmStore.findBy(function(record) {
		return record.get('alarmid') == ids;
	});
	if (number === -1) {
		return;
	} else
		flag = true;
	var r = alarmStore.getAt(number);

	if (r.data.treatstate == ALMTREATSTATE_COMFIRM) {
		flag = false;
	}
	r.data.treatstate = ALMTREATSTATE_COMFIRM;
	r.data.treatstatename = '已确认';
	r.data.cfmuser = userid;
	r.data.cfmtime = dt;
	if (flag) {
		countHandler(true, r.data.alarmlevelkey, ALMTREATSTATE_COMFIRM);
		countHandler(false, r.data.alarmlevelkey, ALMTREATSTATE_UNCOMFIRM);
	}
	if (testView.grid) {
		keepSelectRecord();
	}

	changeAllPanel();
}
/**
 * 取消确认告警信息
 */
var undoComfirmAIs = function(ids) {
	var flag = false;
	var number = alarmStore.findBy(function(record) {
		return record.get('alarmid') == ids;
	});
	if (number === -1) {
		return;
	} else
		flag = true;
	var r = alarmStore.getAt(number);
	if (r.data.treatstate == ALMTREATSTATE_UNCOMFIRM) {
		flag = false;
	}
	r.data.treatstate = ALMTREATSTATE_UNCOMFIRM;
	r.data.treatstatename = '未确认';
	r.data.cfmuser = '';
	r.data.cfmtime = '';

	if (flag) {
		countHandler(false, r.data.alarmlevelkey, ALMTREATSTATE_COMFIRM);
		countHandler(true, r.data.alarmlevelkey, ALMTREATSTATE_UNCOMFIRM);
	}
	if (testView.grid) {
		keepSelectRecord();
	}
	changeAllPanel();
}

/**
 * 清除告警信息
 * 
 * @param ids ->
 *            ids告警id数组
 */
function removeAIs(ids) {
	var flag = false;
	var number = alarmStore.findBy(function(record) {
		return record.get('alarmid') == ids;
	});
	if (number === -1)
		return;
	else
		flag = true;
	var r = alarmStore.getAt(number);
	// 统计数
	if (flag) {
		countHandler(false, r.data.alarmlevelkey, r.data.treatstate);
	}
	changeAllPanel();
	alarmStore.remove(r);
	if (testView.grid) {
		keepSelectRecord();
	}
}

/**
 * 告警cacheStore
 * 
 */
cacheStore = new AlarmDataContainer({
	proxy : new Ext.data.MemoryProxy(),
	reader : new Ext.data.JsonReader({}, [{
		name : 'alarmid'
	}, {
		name : 'alarmlevelkey'
	}, {
		name : 'alarmlevelkeyname'
	}, {
		name : 'gategorykey'
	}, {
		name : 'gategorykeyname'
	}, {
		name : 'alarmtypekey'
	}, {
		name : 'alarmtypekeyname'
	}, {
		name : 'causeid'
	}, {
		name : 'factoryid'
	}, {
		name : 'title'
	}, {
		name : 'detail'
	}, {
		name : 'localinfo'
	}, {
		name : 'causedesc'
	}, {
		name : 'alarmvalue'
	}, {
		name : 'orgintime'
	}, {
		name : 'neworgintime'
	}, {
		name : 'cfmtime'
	}, {
		name : 'cleartime'
	}, {
		name : 'cfmuser'
	}, {
		name : 'clearuser'
	}, {
		name : 'state'
	}, {
		name : 'treatstate'
	}, {
		name : 'treatstatename'
	}, {
		name : 'repeattimes'
	}, {
		name : 'collecttime'
	}, {
		name : 'oldalarmid'
	}, {
		name : 'oldleave'
	}, {
		name : 'oldtype'
	}, {
		name : 'worksheetid'
	}, {
		name : 'nettypeid'
	}, {
		name : 'restypeid'
	}, {
		name : 'restypename'
	}, {
		name : 'instanceid'
	}, {
		name : 'fatherinstanceid'
	}, {
		name : 'instanceCName'
	}, {
		name : 'fatherInstanceCName'
	}, {
		name : 'offinum'
	}, {
		name : 'offiCName'
	}, {
		name : 'lscId'
	}, {
		name : 'lscCName'
	}])
}, RECORDCOUNT / 2);

/**
 * 告警Store
 */
alarmStore = new AlarmDataContainer({
	proxy : new Ext.data.HttpProxy({
		url : 'getAlarms.action',
		method : 'POST'
	}),
	reader : new Ext.data.JsonReader({
		root : 'root'
	}, [{
		name : 'alarmid'
	}, {
		name : 'alarmlevelkey'
	}, {
		name : 'alarmlevelkeyname'
	}, {
		name : 'gategorykey'
	}, {
		name : 'gategorykeyname'
	}, {
		name : 'alarmtypekey'
	}, {
		name : 'alarmtypekeyname'
	}, {
		name : 'causeid'
	}, {
		name : 'factoryid'
	}, {
		name : 'title'
	}, {
		name : 'detail'
	}, {
		name : 'localinfo'
	}, {
		name : 'causedesc'
	}, {
		name : 'alarmvalue'
	}, {
		name : 'orgintime'
	}, {
		name : 'neworgintime'
	}, {
		name : 'cfmtime'
	}, {
		name : 'cleartime'
	}, {
		name : 'cfmuser'
	}, {
		name : 'clearuser'
	}, {
		name : 'state'
	}, {
		name : 'treatstate'
	}, {
		name : 'treatstatename'
	}, {
		name : 'repeattimes'
	}, {
		name : 'collecttime'
	}, {
		name : 'oldalarmid'
	}, {
		name : 'oldleave'
	}, {
		name : 'oldtype'
	}, {
		name : 'worksheetid'
	}, {
		name : 'nettypeid'
	}, {
		name : 'restypeid'
	}, {
		name : 'restypename'
	}, {
		name : 'instanceid'
	}, {
		name : 'fatherinstanceid'
	}, {
		name : 'instanceCName'
	}, {
		name : 'fatherInstanceCName'
	}, {
		name : 'offinum'
	}, {
		name : 'offiCName'
	}, {
		name : 'lscId'
	}, {
		name : 'lscCName'
	}])
}, RECORDCOUNT);

/**
 * @author chen.bo
 * @class Starit.Alarm.Monitor.Grid
 * @extends Starit.Alarm.MonitorGrid
 */
Starit.Alarm.Monitor.Grid = Ext.extend(Starit.Alarm.MonitorGrid, {
	constructor : function(cfg) {
		var cfg = cfg || {};
		Ext.apply(this, cfg);
		Starit.Alarm.Monitor.Grid.superclass.constructor.call(this, {
			// width : 800,
			width : Ext.getBody().getViewSize().width - 270,
			// height : 300,
			height : Ext.getBody().getViewSize().height,
			region : 'center',
			autoScroll : true
		});
	},
	initCfgParams : function() {
		this.initConfig({
			size : 30,
			store : alarmStore,
			columnParams : columns
		});
	}
});

/**
 * 刷新时保持选中的记录
 */
function keepSelectRecord() {
	var r = testView.grid.getSelectionModel().getSelections();
	var page = testView.grid.getBottomToolbar().cursor;
	var rs = [];
	if (r.length > 0) {
		rs = r;
	}
	if (rs.length > 0) {
		selectIndex = rs;
	}
	testView.grid.getBottomToolbar()
			.doLoad(testView.grid.getBottomToolbar().cursor);

	if (selectIndex.length > 0 && option) {
		var arr = [];
		for (var i = 0, len = selectIndex.length; i < len; i++) {
			var index = testView.grid.store.find('alarmid',
					selectIndex[i].data.alarmid);
			if (index > -1)
				arr.push(index);
		}
		if (arr && arr.length > 0)
			testView.grid.getSelectionModel().selectRows(arr, true);
	}
	selectIndex.length = 0;
	// 恢复默认值
	option = true;
}