Ext.ns("Starit.Alarm", "Starit.Alarm.Monitor");

var FILTER_TREE_URL = "getAlarmCatalogTree_L.action";
// var FILTER_TREE_URL = "c.json";

/**
 * 过滤树 chen.bo
 * 
 * @class Starit.Alarm.Monitor.filterTree
 * @extends Starit.CommonTree
 */
Starit.Alarm.Monitor.filterTree = Ext.extend(Starit.CommonTree, {
	templateClassName : null,
	constructor : function(cfg) {
		var cfg = cfg || {};
		Ext.apply(this, cfg);
		Starit.Alarm.Monitor.filterTree.superclass.constructor.call(this, {
			// width : Ext.getBody().getViewSize().width / 5,
			width : 230,
			// height : 380,
			height : Ext.getBody().getViewSize().height, //-150 原本有150的统计区域
			autoScroll : true,
			url : FILTER_TREE_URL,
			rootId : "root_filter",
			rootText : "个性化展示",
			listener : {
			// 'expand' : {
			// fn : pageload,
			// scope : this
			// }
			}
		});

	},
	doQuery : function(v) {
		(v == null)
				? this.templateClassName = null
				: this.templateClassName = v.trim();
		var that = this;
		this.loader = new Ext.tree.TreeLoader({
			dataUrl : FILTER_TREE_URL,
			baseParams : {
				templateClassName : this.templateClassName
			}
		});
		this.getLoader().load(this.getRootNode(), function() {
			// that.getRootNode().expand();
			that.expandAll()
		});
	},
	doRefresh : function() {
		this.templateClassName = this.trigger.getValue();
		var that = this;
		this.loader = new Ext.tree.TreeLoader({
			dataUrl : FILTER_TREE_URL,
			baseParams : {
				templateClassName : this.templateClassName
			}
		});
		this.getLoader().load(this.getRootNode(), function() {
			// that.getRootNode().expand();
			that.expandAll();
		});
	},
	onTreeClick : function(node, e) {
		if (node.isLeaf()) {
			pauseFlag = true;
			changerFilter(node.id);
		}
	}
});

Starit.Alarm.Monitor.From = Ext.extend(Ext.form.FormPanel, {
	constructor : function() {
		Starit.Alarm.Monitor.From.superclass.constructor.call(this, {
			// width : Ext.getBody().getViewSize().width / 5,
			width : 230,
			// height : Ext.getBody().getViewSize().height / 3,
			height : 150,
			title : '确认/未确认告警统计',
			frame : true,
			layout : 'form',
			items : [{
				layout : 'form',
				items : [{
					layout : 'column',
					items : [{
						columnWidth : .24,
						layout : 'form',
						items : [{
							xtype : 'panel',
							height : 30,
							width : 45,
							html : '<H3>未确认:</H3>'
						}]
					}, {
						columnWidth : .19,
						layout : 'form',
						items : [{
							xtype : 'panel',
							height : 25,
							width : 42,
							bodyStyle : 'background-color:' + colorObj[1]
									+ ';font-size:12pt',
							id : 'unconfirm_level1'
						}]
					}, {
						columnWidth : .19,
						layout : 'form',
						items : [{
							xtype : 'panel',
							id : 'unconfirm_level2',
							height : 25,
							width : 42,
							bodyStyle : 'background-color:' + colorObj[2]
									+ ';font-size:12pt'
						}]
					}, {
						columnWidth : .19,
						layout : 'form',
						items : [{
							xtype : 'panel',
							id : 'unconfirm_level3',
							height : 25,
							width : 42,
							bodyStyle : 'background-color:' + colorObj[3]
									+ ';font-size:12pt'
						}]
					}, {
						columnWidth : .19,
						layout : 'form',
						items : [{
							xtype : 'panel',
							id : 'unconfirm_level4',
							height : 25,
							width : 42,
							bodyStyle : 'background-color:' + colorObj[4]
									+ ';font-size:12pt'
						}]
					}]
				}, {
					xtype : 'panel',
					height : 10
				}, {
					layout : 'column',
					items : [{
						columnWidth : .24,
						layout : 'form',
						items : [{
							xtype : 'panel',
							height : 40,
							width : 45,
							html : '<h3>确  认:</h3>'
						}]
					}, {
						columnWidth : .19,
						layout : 'form',
						items : [{
							xtype : 'panel',
							id : 'confirm_level1',
							height : 25,
							width : 42,
							bodyStyle : 'background-color:' + colorObj[1]
									+ ';font-size:12pt'
						}]
					}, {
						columnWidth : .19,
						layout : 'form',
						items : [{
							xtype : 'panel',
							id : 'confirm_level2',
							height : 25,
							width : 42,
							bodyStyle : 'background-color:' + colorObj[2]
									+ ';font-size:12pt'
						}]
					}, {
						columnWidth : .19,
						layout : 'form',
						items : [{
							xtype : 'panel',
							id : 'confirm_level3',
							height : 25,
							width : 42,
							bodyStyle : 'background-color:' + colorObj[3]
									+ ';font-size:12pt'
						}]
					}, {
						columnWidth : .19,
						layout : 'form',
						items : [{
							xtype : 'panel',
							id : 'confirm_level4',
							height : 25,
							width : 42,
							bodyStyle : 'background-color:' + colorObj[4]
									+ ';font-size:12pt'
						}]
					}]
				}]
			}]
		})
	}
})

Starit.Alarm.Monitor.CountPanel = Ext.extend(Ext.Panel, {
	alarmMonitorTree : null,
	alarmMonitorForm : null,
	constructor : function() {

		this.alarmMonitorTree = new Starit.Alarm.Monitor.filterTree();
		//确认/未确认告警统计
		//this.alarmMonitorForm = new Starit.Alarm.Monitor.From();
		Starit.Alarm.Monitor.CountPanel.superclass.constructor.call(this, {
			// width : Ext.getBody().getViewSize().width / 5,
			width : 230,
			height : Ext.getBody().getViewSize().height,
			title : '实时监控过滤树',
			collapsible : true,
			layout : 'form',
			items : [this.alarmMonitorTree]
		})
	}
});
