/**
 * 显示告警详细信息
 * 
 * @class CompleteAlarmForm
 * @extends Ext.form.FormPanel
 */

/** **************************CompleteAlarmForm组件****************************************** */
CompleteAlarmForm = Ext.extend(Ext.form.FormPanel, {

	almLevelHd : null,
	almCatHd : null,
	almTypeHd : null,
	oldAlmTypeHd : null,
	oldAlmLevelHd : null,
	fatherNeHd : null,

	netWorkTypeHd : null, // 网络类型
	devManufactureHd : null, // 设备厂家
	omcHd : null, // omc
	almStateHd : null, // 告警状态
	almTreatStateHd : null, // 告警处理状态
	almCauseHd : null, // 告警吗

	localInfoTf : null, // 定位信息
	almTitleTf : null, // 告警标题
	clearTimeTf : null, // 告警清除时间
	almCausePosibleTf : null, // 告警可能原因
	collectTimeTf : null, // 告警时长
	workSheetIdTf : null, // 关联工单号

	almNetWorkTypeTf : null,
	devManufactureNameTf : null,
	omcNameTf : null,
	almStateNameTf : null,
	almTreatStateNameTf : null,
	oldAlmTypeNameTf : null,
	oldAlmLevelNameTf : null,
	fatherNeNameTf : null, // 父网元

	almSeqField : null,
	almCatNameField : null,
	alamLevelNameField : null,
	almTypeNameField : null,
	orginTimeField : null,
	cfmTimeField : null,
	cfmUserField : null,
	almPosField : null,
	almDescArea : null,
	almCauseArea : null,
	objectCnameField : null,
	instanceCNameField : null,
	oldAlmTypeField : null,
	oldAlmLevelField : null,
	repeatTimesField : null,
	expGrid : null,// 告警经验

	constructor : function() {

		this.fatherNeHd = this.createHidden('fatherinstanceid');
		this.almLevelHd = this.createHidden('alarmlevelkey');
		this.almCatHd = this.createHidden('gategorykey');
		this.almTypeHd = this.createHidden('alarmtypekey');
		this.netWorkTypeHd = this.createHidden('offinum');
		this.devManufactureHd = this.createHidden('instanceid');
		this.almTreatStateHd = this.createHidden('treatstate');
		this.omcHd = this.createHidden('omc');
		this.almStateHd = this.createHidden('treatstate');
		this.oldAlmTypeHd = this.createHidden('oldAlmType');
		this.oldAlmLevelHd = this.createHidden('oldAlmLevel');
		this.almCauseHd = this.createHidden('almCause');
		// 以下是需要显示的
		this.almIdField = this.createTextFiled("告警标识", 'alarmid');
		this.almSeqField = this.createTextFiled("告警序号", 'oldalarmid');
		this.localInfoTf = this.createTextFiled("LSC名", 'lscCName');
		this.almNetWorkTypeTf = this.createTextFiled("局站名", 'offiCName');
		this.fatherNeNameTf = this
				.createTextFiled("设备名", 'fatherInstanceCName');
		this.devManufactureNameTf = this.createTextFiled("设备厂家", 'factoryid');
		this.instanceIdField = this.createTextFiled("信号名", 'instanceCName');
		this.collectTimeTf = this.createTextFiled("信号类型", 'restypename');
		this.almCatNameField = this.createTextFiled("告警类别", 'gategorykeyname');
		this.alamLevelNameField = this.createTextFiled("告警级别",
				'alarmlevelkeyname');
		this.almTypeNameField = this
				.createTextFiled("告警类型", 'alarmtypekeyname');// add
		this.almPosField = this.createTextFiled("告警数值", 'alarmvalue');
		this.almStateNameTf = this.createTextFiled("告警状态", 'state');
		this.almTreatStateNameTf = this.createTextFiled("告警处理状态",
				'treatstatename');
		this.repeatTimesField = this.createTextFiled("重复次数", 'repeattimes');
		this.almTitleTf = this.createTextFiled("告警标题", 'title');// 隐藏
		this.orginTimeField = this.createTextFiled("发生时间", 'orgintime');
		this.almCausePosibleTf = this.createTextFiled("最新发生时间", 'neworgintime');
		this.oldAlmTypeNameTf = this.createTextFiled("原告警类型", 'oldtype');
		this.oldAlmLevelNameTf = this.createTextFiled("原告警级别", 'oldleave');
		this.cfmTimeField = this.createTextFiled("确认时间", 'cfmtime');
		this.cfmUserField = this.createTextFiled("确认人", 'cfmuser');
		this.undoCfmTimeTf = this.createTextFiled("清除时间", 'cleartime');// 隐藏
		this.undoCfmUserTf = this.createTextFiled("清除人", 'clearuser');// 隐藏
		this.almDescArea = this.createTextArea("告警详细信息", 'detail', true);
		// 以下是不需要显示的
		this.objectTypeIdField = this.createTextFiled("资源类型", 'restypeid');
		this.workSheetIdTf = this.createTextFiled("关联工单号", 'worksheetid');
		this.almCauseArea = this.createTextArea("告警可能原因", 'causedesc', true);
		this.expGrid = new ExpGrid({
			form : this
		});

		CompleteAlarmForm.superclass.constructor.call(this, {
			width : 700,
			height : 400,
			autoScroll : true,
			frame : true,
			bodyStyle : "padding: 3px 3px 0",
			items : [{
				layout : 'column',
				items : [{
					columnWidth : 0.5,
					layout : 'form',
					items : [this.almIdField, this.localInfoTf,
							this.fatherNeNameTf, this.instanceIdField,
							this.almCatNameField, this.almTypeNameField,
							this.almStateNameTf, this.repeatTimesField,
							this.almCausePosibleTf, this.oldAlmLevelNameTf,
							this.cfmUserField]
				}, {
					columnWidth : 0.5,
					layout : 'form',
					items : [this.almSeqField, this.almNetWorkTypeTf,
							this.devManufactureNameTf, this.collectTimeTf,
							this.alamLevelNameField, this.almPosField,
							this.almTreatStateNameTf, this.orginTimeField,
							this.oldAlmTypeNameTf, this.cfmTimeField]
				}, {
					columnWidth : 1.0,
					layout : 'form',
					items : [this.almDescArea]
				}]
			}]
		})
	},
	createTextFiled : function(fieldLabel, name) { // 生成一个通用的TextField
		var tf = new Ext.form.TextField({
			fieldLabel : fieldLabel,
			xtype : 'textfield',
			readOnly : true,
			anchor : "78%",
			name : name,
			allowBlank : true
		});
		return tf;
	},
	createTextArea : function(fieldLabel, name, readOnly) {
		var ta = new Ext.form.TextArea({
			fieldLabel : fieldLabel,
			xtype : 'textarea',
			readOnly : readOnly,
			anchor : "78%",
			labelAlign : 'center',
			name : name,
			allowBlank : true
		});
		return ta;
	},
	createHidden : function(name) {
		var hd = new Ext.form.Hidden({
			name : name
		});
		return hd;
	}
})
/**
 * 
 * @class CompleteAlarmWnd
 * @extends Ext.Window
 * @author:jsfang
 */
/** **************************CompleteAlarmWnd组件********************************************* */
CompleteAlarmWnd = Ext.extend(Ext.Window, {

	CompleteAlarmForm : null,

	constructor : function() {

		this.CompleteAlarmForm = new CompleteAlarmForm();
		CompleteAlarmWnd.superclass.constructor.call(this, {
			title : "告警详细信息",
			width : 720,
			height : 470,
			resizable : true,
			modal : true,
			buttonAlign : 'center',
			autoScroll : true,
			closeAction : 'hide',// 如果没有这个参数，窗口只显示一次
			items : [this.CompleteAlarmForm],
			buttons : [{
				text : '确认',
				width : 45,
				iconCls : 'submit',
				handler : this.confirm,
				scope : this
			}, {
				text : '清除',
				width : 45,
				iconCls : 'delete',
				handler : this.alarmClear,
				scope : this
			}, {
				text : '关闭',
				width : 45,
				iconCls : 'close',
				handler : this.winClose,
				scope : this
			}, {
				text : '上一条',
				width : 45,
				iconCls : 'left',
				handler : this.getPreRecord,
				scope : this
			}, {
				text : '下一条',
				width : 45,
				iconCls : 'right',
				handler : this.getNextRecord,
				scope : this
			}]
		});
	},
	winClose : function() {
		this.CompleteAlarmForm.getForm().reset();
		this.hide();
	},
	confirm : function() {
		var r = commonGrid.getSelectionModel().getSelected();
		if (!r)
			return;
		var index = commonGrid.store.find('alarmid', r.data.alarmid);
		var newR = commonGrid.store.getAt(index
				+ commonGrid.getBottomToolbar().cursor);
		if (!newR)
			return;
		if (newR.get('treatstate') == ALMTREATSTATE_COMFIRM) {
			Ext.MessageBox.alert("系统提示：", blankStr + "该告警记录已确认！" + blankStr);
			return;
		}

		var thisWin = this;
		var almid = newR.data.alarmid;
		var level = newR.data.alarmlevelkey;
		var state = newR.data.treatstate;
		var ids = [almid];

		Ext.MessageBox.confirm('系统提示:', '你确定要确认所选记录吗？', function(btn) {
			if (btn == 'yes') {
				AlarmInfoManager.confirmAlarm(ids, newfilterID, function(data) {
					if (data) {
						Ext.MessageBox.alert("系统提示:", blankStr + "确认成功"
								+ blankStr, function() {
							thisWin.loadCurrentRecord(index);
							commonGrid.getSelectionModel().selectRow(index);

							countHandler(true, level, ALMTREATSTATE_COMFIRM);
							countHandler(false, level, ALMTREATSTATE_UNCOMFIRM);
						});
					}
				});
			}
		});
	},
	alarmClear : function() {
		var r = commonGrid.getSelectionModel().getSelected();
		if (!r)
			return;
		var index = commonGrid.store.find('alarmid', r.data.alarmid);
		var newR = commonGrid.store.getAt(index
				+ commonGrid.getBottomToolbar().cursor);
		if (!newR)
			return;
		var thisWin = this;
		var almid = newR.data.alarmid;
		var almLevel = newR.data.alarmlevelkey;
		var state = newR.data.treatstate;

		var ids = [almid];
		Ext.MessageBox.confirm('系统提示:', '您确定要清除所选告警吗？', function(btn) {
			if (btn == 'yes') {
				AlarmInfoManager.deleteOneAlarm(ids, newfilterID,
						function(data) {
							if (data) {
								countHandler(false, almLevel, state);
								Ext.MessageBox.alert("系统提示:", blankStr + "清除成功"
										+ blankStr, function() {
									thisWin.loadCurrentRecord(index);
									commonGrid.getSelectionModel()
											.selectRow(index);
								});
							}
						});
			}
		});
	},
	loadCurrentRecord : function(index) { // 载入当前记录
		var xg = commonGrid;
		var f = this.CompleteAlarmForm;
		var s = xg.getStore();
		var x = s.getAt(index + xg.getBottomToolbar().cursor);

		if (!x) {
			Ext.MessageBox.show({
				title : "系统提示:",
				msg : blankStr + "已经到最后一条记录!" + blankStr,
				icon : Ext.MessageBox.INFO,
				buttons : {
					ok : '确定'
				}
			});
			RecentrowIndex -= 1;
			return;
		}

		this.CompleteAlarmForm.getForm().loadRecord(x);
		xg.getSelectionModel().selectRow(RecentrowIndex);
		var row = xg.getView().getRow(RecentrowIndex);
		// Ext.get(row).focus();
	},
	getNextRecord : function() {
		var next = RecentrowIndex + 1;
		// var count = commonGrid.store.getCount();
		// var pageRecord = (count % PAGESIZE === 0 ? count : count % PAGESIZE);
		RecentrowIndex = next;
		this.loadCurrentRecord(next);
	},

	getPreRecord : function() {
		var pre = RecentrowIndex - 1;
		if (pre < 0) {
			Ext.MessageBox.show({
				title : "系统提示:",
				msg : blankStr + "已经到第一条记录!" + blankStr,
				icon : Ext.MessageBox.INFO,
				buttons : {
					ok : '确定'
				}
			});
			return;
		}
		RecentrowIndex = pre;
		this.loadCurrentRecord(pre);
	}
});
