AlarmDataContainer = Ext.extend(Ext.data.Store, {

	RecordCount : 800,
	constructor : function(config, size) {
		Ext.apply(this, config);
		AlarmDataContainer.superclass.constructor.call(this);
		this.RecordCount = size;
	},
	setRecordCount : function(size) {
		this.RecordCount = size;
	},
	/**
	 * 新增记录
	 * 
	 * @param {}
	 *            records
	 */
	addRecord : function(records) {
		this.insert(0, records);
		// var count = this.getCount();
		// alert(this.getCount() + "," + this.RecordCount);
		// if (count > this.RecordCount) {
		// for (var i = this.RecordCount; i < count; i++) {
		// this.remove(this.getAt(i));
		// }
		// }
		this.removeSurplus();
	},
	removeSurplus : function() { // 移除store中大于2000条的数据
		var count = this.getCount();
		if (count > this.RecordCount) {
			for (var i = this.RecordCount; i < count; i++) {
				var r = this.getAt(i);
				countHandler(false, r.get('alarmlevelkey'), r.get('treatstate'));
				this.remove(r);
			}
		}
		// 更新统计面板
		changeAllPanel();
	},
	queryWithPage : function(currPage, perPageSize) {
		var startIndex = currPage === 1 ? 0 : currPage * perPageSize - 1;
		var endIndex = (startIndex + perPageSize) > this.RecordCount
				? this.RecordCount
				: startIndex + perPageSize - 1;
		return this.getRange(startIndex, endIndex);
	}
});
