/**
 * 增加告警窗体
 * 
 * @author:chen.bo
 */

/** **************************CompleteAlarmForm组件****************************************** */
AddAlarmForm = Ext.extend(Ext.form.FormPanel, {

	almLevelHd : null,
	almCatHd : null,
	almTypeHd : null,
	oldAlmTypeHd : null,
	oldAlmLevelHd : null,
	fatherNeHd : null,

	netWorkTypeHd : null, // 网络类型
	devManufactureHd : null, // 设备厂家
	omcHd : null, // omc
	almStateHd : null, // 告警状态
	almTreatStateHd : null, // 告警处理状态
	almCauseHd : null, // 告警吗

	localInfoTf : null, // 定位信息
	almTitleTf : null, // 告警标题
	clearTimeTf : null, // 告警清除时间
	almCausePosibleTf : null, // 告警可能原因
	collectTimeTf : null, // 告警接收时间
	workSheetIdTf : null, // 关联工单号

	almNetWorkTypeTf : null,
	devManufactureNameTf : null,
	omcNameTf : null,
	almStateNameTf : null,
	almTreatStateNameTf : null,
	oldAlmTypeNameTf : null,
	oldAlmLevelNameTf : null,
	fatherNeNameTf : null, // 父网元

	almSeqField : null,
	almCatNameField : null,
	alamLevelNameField : null,
	almTypeNameField : null,
	orginTimeField : null,
	cfmTimeField : null,
	cfmUserField : null,
	almPosField : null,
	almDescArea : null,
	almCauseArea : null,
	objectCnameField : null,
	instanceCNameField : null,
	oldAlmTypeField : null,
	oldAlmLevelField : null,
	repeatTimesField : null,

	constructor : function() {

		this.almCauseHd = this.createTextFiled('原因码', 'almCause');

		// this.almIdField = this.createTextFiled("告警内部标识", 'alarmid');

		this.almSeqField = this.createTextFiled("原告警编号", 'oldalarmid');
		this.almCatNameField = this.createTextFiled("告警类别", 'gategorykey');// modified
		this.alamLevelNameField = this.createTextFiled("告警级别", 'alarmlevelkey');// modified
		this.almTypeNameField = this.createTextFiled("告警类型", 'alarmtypekey');// add
		this.objectTypeIdField = this.createTextFiled("设备类型", 'restypeid');
		this.instanceIdField = this.createTextFiled("设备名", 'instanceid');
		this.orginTimeField = this.createTextFiled("发生时间", 'orgintime');
		this.almCausePosibleTf = this.createTextFiled("最新发生时间", 'neworgintime');
		this.cfmTimeField = this.createTextFiled("确认时间", 'cfmtime');
		this.cfmUserField = this.createTextFiled("确认人", 'cfmuser');
		this.undoCfmTimeTf = this.createTextFiled("清除时间", 'cleartime');
		this.undoCfmUserTf = this.createTextFiled("清除人", 'clearuser');

		this.collectTimeTf = this.createTextFiled("告警时长", 'collecttime');
		this.almPosField = this.createTextFiled("告警数值", 'alarmvalue');
		this.almTitleTf = this.createTextFiled("告警标题", 'title');
		this.localInfoTf = this.createTextFiled("告警位置", 'localinfo');
		this.oldAlmTypeNameTf = this.createTextFiled("原告警类型", 'oldtype');
		this.oldAlmLevelNameTf = this.createTextFiled("原告警级别", 'oldleave');
		this.repeatTimesField = this.createTextFiled("告警重复次数", 'repeattimes');
		this.workSheetIdTf = this.createTextFiled("关联工单号", 'worksheetid');
		this.fatherNeNameTf = this.createTextFiled("父网元", 'fatherinstanceid');
		this.almNetWorkTypeTf = this.createTextFiled("网络类型", 'nettypeid');
		this.devManufactureNameTf = this.createTextFiled("设备厂家", 'factoryid');
		this.almStateNameTf = this.createTextFiled("告警状态", 'state');
		this.almTreatStateNameTf = this.createTextFiled("告警处理状态", 'treatstate');

		this.almDescArea = this.createTextArea("告警详细信息", 'detail', true);
		this.almCauseArea = this.createTextArea("告警可能原因", 'causedesc', true);

		AddAlarmForm.superclass.constructor.call(this, {
			width : 690,
			height : 390,
			autoScroll : true,
			frame : true,
			bodyStyle : "padding: 3px 3px 0",
			items : [{
				layout : 'column',
				items : [{
					columnWidth : 0.5,
					layout : 'form',
					items : [this.almSeqField, this.almCatNameField,
							this.almTypeNameField, this.instanceIdField,
							this.almCausePosibleTf, this.cfmUserField,
							this.undoCfmUserTf, this.almPosField,
							this.oldAlmLevelNameTf, this.almStateNameTf,
							this.devManufactureNameTf]
				}, {
					columnWidth : 0.5,
					layout : 'form',
					items : [this.alamLevelNameField, this.objectTypeIdField,
							this.orginTimeField, this.cfmTimeField,
							this.undoCfmTimeTf, this.almTitleTf,
							this.oldAlmTypeNameTf, this.repeatTimesField,
							this.almTreatStateNameTf, this.fatherNeNameTf,
							this.almCauseHd]
				}, {
					columnWidth : 1.0,
					layout : 'form',
					items : [this.almDescArea]
				}]
			}]
		})
	},
	createTextFiled : function(fieldLabel, name) { // 生成一个通用的TextField
		var tf = new Ext.form.TextField({
			fieldLabel : fieldLabel,
			xtype : 'textfield',
			readOnly : false,
			anchor : "78%",
			name : name,
			allowBlank : true
		});
		return tf;
	},
	createTextArea : function(fieldLabel, name) {
		var ta = new Ext.form.TextArea({
			fieldLabel : fieldLabel,
			xtype : 'textarea',
			readOnly : false,
			anchor : "78%",
			labelAlign : 'center',
			name : name,
			allowBlank : true
		});
		return ta;
	},
	createHidden : function(name) {
		var hd = new Ext.form.Hidden({
			name : name
		});
		return hd;
	},
	createCombo : function(fieldLabel, id, name, anchor, url, extra1, extra2) { // 生成一个通用的ComboBox
		var combo = new Ext.form.ComboBox({
			autoLoad : true,
			fieldLabel : fieldLabel,
			emptyText : '请选择...',
			isFormField : true,
			anchor : anchor,
			mode : 'local',
			name : id,
			allowBlank : false,
			blankText : '请选择...',
			// forceSelection: true,
			lastQuery : '',
			triggerAction : 'all',
			displayField : name,
			valueField : id,
			store : new Ext.data.Store({
				proxy : new Ext.data.HttpProxy({
					url : url,
					method : 'POST'
				}),
				reader : new Ext.data.JsonReader({},
						new Ext.data.Record.create([{
							name : id
						}, {
							name : name
						}, {
							name : extra1
						}, {
							name : extra2
						}]))
			}),
			readOnly : true
		});
		return combo;
	},
	createCombo : function(fieldLabel, width, url, displayField, valueField,
			name, allowBlank) {
		var combo = new Ext.form.ComboBox({
			fieldLabel : fieldLabel,
			emptyText : '请选择。。。',
			width : width,
			name : name,
			allowBlank : allowBlank,
			mode : 'local',
			forceSelection : true,
			isFormField : true,
			triggerAction : 'all',
			displayField : displayField,// 显示在下拉框的值
			valueField : valueField,// 实际传出的值
			selectOnFocus : true,
			store : new Ext.data.Store({
				proxy : new Ext.data.HttpProxy({
					url : url,
					method : 'POST'
				}),
				reader : new Ext.data.JsonReader({},
						new Ext.data.Record.create([{
							name : valueField
						}, {
							name : displayField
						}]))
			}),
			readOnly : true
		});

		return combo;
	}
})
/**
 * 
 * @class CompleteAlarmWnd
 * @extends Ext.Window
 * @author:chen.bo
 */
/** **************************CompleteAlarmWnd组件********************************************* */
AddAlarmWnd = Ext.extend(Ext.Window, {
	AddAlarmForm : null,
	constructor : function() {
		this.AddAlarmForm = new AddAlarmForm();
		AddAlarmWnd.superclass.constructor.call(this, {
			title : "增加告警",
			width : 710,
			height : 460,
			resizable : true,
			modal : true,
			buttonAlign : 'center',
			autoScroll : true,
			closeAction : 'hide',// 如果没有这个参数，窗口只显示一次
			items : [this.AddAlarmForm],
			buttons : [{
				text : '保存',
				width : 45,
				iconCls : 'save',
				handler : this.addAlarm,
				scope : this
			}, {
				text : '重置',
				width : 45,
				iconCls : 'resume',
				handler : this.alarmClear,
				scope : this
			}, {
				text : '关闭',
				width : 45,
				iconCls : 'close',
				handler : this.winClose,
				scope : this
			}]
		});
	},
	winClose : function() {
		this.AddAlarmForm.getForm().reset();
		this.hide();
	},
	addAlarm : function() {
		var thisWin = this;
		var alarmlevelkey = this.AddAlarmForm.alamLevelNameField.getRawValue();
		var gategorykey = this.AddAlarmForm.almCatNameField.getRawValue();
		var alarmtypekey = this.AddAlarmForm.almTypeNameField.getRawValue();
		var causeid = this.AddAlarmForm.almCauseHd.getRawValue();
		var factoryid = this.AddAlarmForm.devManufactureNameTf.getRawValue();
		var title = this.AddAlarmForm.almTitleTf.getRawValue();
		var detail = this.AddAlarmForm.almDescArea.getRawValue();
		var localinfo = this.AddAlarmForm.localInfoTf.getRawValue();
		var causedesc = this.AddAlarmForm.almCauseArea.getRawValue();
		var alarmvalue = this.AddAlarmForm.almPosField.getRawValue();
		var orgintime = this.AddAlarmForm.orginTimeField.getRawValue();
		var neworgintime = this.AddAlarmForm.almCausePosibleTf.getRawValue();
		var cfmtime = this.AddAlarmForm.cfmTimeField.getRawValue();
		var cleartime = this.AddAlarmForm.undoCfmTimeTf.getRawValue();
		var cfmuser = this.AddAlarmForm.cfmUserField.getRawValue();
		var clearuser = this.AddAlarmForm.undoCfmUserTf.getRawValue();
		var state = this.AddAlarmForm.almStateNameTf.getRawValue();
		var treatstat = this.AddAlarmForm.almTreatStateNameTf.getRawValue();
		var repeattimes = this.AddAlarmForm.repeatTimesField.getRawValue();
		var collecttime = this.AddAlarmForm.collectTimeTf.getRawValue();
		var oldalarmid = this.AddAlarmForm.almSeqField.getRawValue();
		var oldleave = this.AddAlarmForm.oldAlmLevelNameTf.getRawValue();
		var oldtype = this.AddAlarmForm.oldAlmTypeNameTf.getRawValue();
		var worksheetid = this.AddAlarmForm.workSheetIdTf.getRawValue();
		var nettypeid = this.AddAlarmForm.almNetWorkTypeTf.getRawValue();
		var restypeid = this.AddAlarmForm.objectTypeIdField.getRawValue();
		var instanceid = this.AddAlarmForm.instanceIdField.getRawValue();
		var fatherinstanceid = this.AddAlarmForm.fatherNeNameTf.getRawValue();

		if (alarmlevelkey == '' || gategorykey == '' || alarmtypekey == '') {
			Ext.MessageBox.alert("系统提示:", blankStr + "信息不完整,请重新填写!" + blankStr);
			return;
		}
		AlarmInfoManager.saveAlarm(alarmlevelkey, gategorykey, alarmtypekey,
				causeid, factoryid, title, detail, localinfo, causedesc,
				alarmvalue, orgintime, neworgintime, cfmtime, cleartime,
				cfmuser, clearuser, state, treatstate, repeattimes,
				collecttime, oldalarmid, oldleave, oldtype, worksheetid,
				nettypeid, restypeid, instanceid, fatherinstanceid, function(
						data) {
					if (data) {
						Ext.MessageBox.alert("系统提示:", blankStr + "新增告警成功"
								+ blankStr);
					} else {
						Ext.MessageBox.alert("系统提示:",
								"新增告警失败,操作可能出现了某些错误, 请重试！");
					}
				});
	},
	alarmClear : function() {
		this.AddAlarmForm.getForm().reset();
	}
});
