/**
 * @description: 实时监控Grid
 * @author: chen.bo
 */
Ext.ns("Starit.Alarm");

var ALMTREATSTATE_COMFIRM = 2;
var ALMTREATSTATE_UNCOMFIRM = 1;
var selectIndex = [];
var ischeck = false;
var option = true;
var allSelect = [];// 保存当前页的全选
var that ;
/**
 * 从cacheStore中得到数据 --> alarmStore中
 */
function getCacheData() {
	if (cacheStore && cacheStore.getCount()) {

		for (var len = cacheStore.getCount(), i = len - 1; i >= 0; i--) {
			var countFlag = true;
			var r = cacheStore.getAt(i);
			var num = alarmStore.findBy(function(record) {
				return record.get('alarmid') == r.get('alarmid');
			});
			if (num > -1) {
				countFlag = false;
				var oldRecord = alarmStore.getAt(num);
				alarmStore.remove(oldRecord);
			}
			alarmStore.addRecord(r);
			// 统计数
			if (countFlag)
				countHandler(true, r.get('alarmlevelkey'), r.get('treatstate'));
		}
		cacheStore.removeAll();
		// 刷新显示
		if (testView.grid) {
			testView.grid.getBottomToolbar().doLoad(testView.grid
					.getBottomToolbar().cursor);
		}
	}
}

/**
 * 告警实时监控grid
 * 
 * @author chen.bo
 * @class Starit.Alarm.MonitorGrid
 * @extends Ext.grid.GridPanel
 */
Starit.Alarm.MonitorGrid = Ext.extend(Ext.grid.GridPanel, {
	iconCls : null,
	viewport : null,// 外界的布局。
	isPaging : true, // 是否分页,默认为 true.
	isRowNumberer : true, // 是否有行号,默认为true.
	isCheckBoxSelectionModel : true,// 选择模式是否为checkBox默认为false
	isSingleSelect : false, // 选择模式是否为单选
	CompleteAlarmWnd : null, // 详细信息窗口
	AddAlarmWnd : null,// 增加告警窗口

	constructor : function(cfg) {
		that = this ;
		// 把一个对象中的属性拷贝到当前对象中
		cfg = cfg || {};
		Ext.apply(this, cfg);

		//this.CompleteAlarmWnd = new CompleteAlarmWnd();
		//this.AddAlarmWnd = new AddAlarmWnd();
		this.createDyCSS();
		this.initCfgParams(); // 初始化需要配置的参数

		Starit.Alarm.MonitorGrid.superclass.constructor.call(this, {
			frame : true,
			border : true,
			autoScroll : true,
			loadMask : {
				msg : '正在载入数据,请稍候...'
			},
			listeners : {
				'dblclick' : {
					fn : this.CompleteInfo,
					scope : this
				},

				'render' : function() {
					Ext.getCmp('tipPanel1').body
							.update('<table width=10px height=10px class=x-grid-record-lev-1><tr><td></td></tr></table>');
					Ext.getCmp('tipPanel2').body
							.update('<table width=10px height=10px class=x-grid-record-lev-2><tr><td></td></tr></table>');
					Ext.getCmp('tipPanel3').body
							.update('<table width=10px height=10px class=x-grid-record-lev-3><tr><td></td></tr></table>');
					Ext.getCmp('tipPanel4').body
							.update('<table width=10px height=10px class=x-grid-record-lev-4><tr><td></td></tr></table>');
				}
			}
		});

		this.addListener("rowcontextmenu", this.onRowContextmenu, this);
		// this.addListener("rowselect", this.onRowClick, this);
		// rowclick
	},

	/**
	 * 声音的开始与关闭
	 */
	doBell : function() {
		var almBell = Ext.getCmp('almBell');
		if (soundFlag) {
			almBell.setIconClass('bellDelete');
			soundFlag = false;
		} else {
			almBell.setIconClass('bell');
			soundFlag = true;
		}
	},
	// 取消确认功能
	doUndoComfirm : function() {
		var r = this.getSelectionModel().getSelections();
		var thisGrid = this;
		if (r.length == 0 && selectIndex.length == 0) {
			Ext.Msg.alert('系统提示', blankStr + '请选择一条告警记录' + blankStr);
			return;
		}
		var almIds = [];
		var almLevels = [];
		var newR;
		if (r.length > 0) {
			for (var i = 0, len = r.length; i < len; i++) {
				var index = this.store.find('alarmid', r[i].data.alarmid);
				if (index > PAGESIZE) {
					// newR = this.store.getAt(index);
				} else {
					newR = this.store.getAt(index
							+ this.getBottomToolbar().cursor);
					if (newR.get('treatstate') == ALMTREATSTATE_UNCOMFIRM) {
						Ext.MessageBox.alert("系统提示：", blankStr + "该告警记录已取消确认！"
								+ blankStr);
						continue;
					}
					almIds.push(newR.data.alarmid);
					almLevels.push(newR.data.alarmlevelkey);
				}
				// newR = this.store.getAt(index +
				// this.getBottomToolbar().cursor);
			}
		} else {
			for (var i = 0, len = selectIndex.length; i < len; i++) {
				newR = selectIndex[i];
				if (newR.get('treatstate') == ALMTREATSTATE_UNCOMFIRM) {
					Ext.MessageBox.alert("系统提示：", blankStr + "该告警记录已取消确认！"
							+ blankStr);
					return;
				}
				almIds.push(newR.data.alarmid);
				almLevels.push(newR.data.alarmlevelkey);
			}
		}
		selectIndex.length = 0;
		if (almIds && almIds.length) {
			Ext.MessageBox.confirm('系统提示:', '你确定要取消确认所选记录吗？', function(btn) {
				if (btn == 'yes') {
					AlarmInfoManager.undoConfirmAlarm(almIds, newfilterID,
							function(data) {
								if (data) {
									option = false;
									Ext.MessageBox.alert("系统提示:", blankStr
											+ "取消确认成功" + blankStr);
								}
							});
				}
			});
		}
	},
	// 告警确认
	ConfirmAlarm : function() {
		var r = this.getSelectionModel().getSelections();
		// alert(r.length);
		var thisGrid = this;
		var almIds = [];
		var almLevels = [];

		if (r.length == 0 && selectIndex.length == 0) {
			Ext.Msg.alert('系统提示', blankStr + '请选择一条告警记录' + blankStr);
			return;
		}
		var newR;
		if (r.length > 0) {
			for (var i = 0, len = r.length; i < len; i++) {
				var index = this.store.find('alarmid', r[i].data.alarmid);
				// alert(index + this.getBottomToolbar().cursor);
				if (index > PAGESIZE) {
					// newR = this.store.getAt(index);
				} else {
					newR = this.store.getAt(index
							+ this.getBottomToolbar().cursor);
					if (newR.get('treatstate') == ALMTREATSTATE_COMFIRM) {
						Ext.MessageBox.alert("系统提示：", blankStr + "该告警记录已确认！"
								+ blankStr);
						continue;
					}
					almIds.push(newR.data.alarmid);
					almLevels.push(newR.data.alarmlevelkey);
				}
			}
		} else {
			for (var i = 0, len = selectIndex.length; i < len; i++) {
				// newR = this.store.getAt(selectIndex[i]);
				newR = selectIndex[i];
				if (newR.get('treatstate') == ALMTREATSTATE_COMFIRM) {
					Ext.MessageBox.alert("系统提示：", blankStr + "该告警记录已确认！"
							+ blankStr);
					return;
				}
				almIds.push(newR.data.alarmid);
				almLevels.push(newR.data.alarmlevelkey);
			}
		}
		selectIndex.length = 0;
		if (almIds && almIds.length) {
			Ext.MessageBox.confirm('系统提示:', '你确定要确认所选记录吗？', function(btn) {
				if (btn == 'yes') {
					AlarmInfoManager.confirmAlarm(almIds, newfilterID,
							function(data) {
								if (data) {
									option = false;
									Ext.MessageBox.alert("系统提示:", blankStr
											+ "确认成功" + blankStr);
								}
							});
				}
			});
		}
	},
	// 告警清除
	deleteGridClick : function() {
		var r = [];
		r = this.getSelectionModel().getSelections();
		if (r.length == 0 && selectIndex.length == 0) {
			Ext.Msg.alert('系统提示', blankStr + '请选择一条告警记录' + blankStr);
			return;
		}
		var almIds = [];
		var almLevels = [];
		var copyRs = [];
		var newR;
		if (r.length > 0) {
			for (var i = 0, len = r.length; i < len; i++) {
				var index = this.store.find('alarmid', r[i].data.alarmid);
				if (index > PAGESIZE) {
					// newR = this.store.getAt(index);
				} else {
					newR = this.store.getAt(index
							+ this.getBottomToolbar().cursor);
					almIds[i] = newR.get('alarmid');
					almLevels.push(newR.get('alarmlevelkey'));
					copyRs.push(newR.get('treatstate'));
				}
				// newR = this.store.getAt(index +
				// this.getBottomToolbar().cursor);
			}
		} else {
			for (var i = 0, len = selectIndex.length; i < len; i++) {
				newR = selectIndex[i];
				almIds.push(newR.get('alarmid'));
				almLevels.push(newR.get('alarmlevelkey'));
				copyRs.push(newR.get('treatstate'));
			}
		}
		selectIndex.length = 0;
		Ext.MessageBox.confirm('系统提示:', '您确定要清除所选告警吗？', function(btn) {
			if (btn == 'yes') {
				AlarmInfoManager.deleteOneAlarm(almIds, newfilterID, function(
						data) {
					if (data) {
						option = false;
						Ext.MessageBox.alert("系统提示:", blankStr + "清除成功"
								+ blankStr);
						that.doRefresh() ;
					} else {
						Ext.MessageBox.alert("系统提示:", "操作可能出现了某些错误, 请重试！！");
					}
				});
			}
		});
	},
	// 显示告警详细信息
	CompleteInfo : function() {
		var f = this.CompleteAlarmWnd.CompleteAlarmForm;
		var origR = this.getSelectionModel().getSelected();
		if (!origR || origR.length == 0) {
			Ext.Msg.alert('系统提示', blankStr + '请选择一条告警记录' + blankStr);
			return;
		}
		var index = this.store.find('alarmid', origR.data.alarmid);
		var r = this.store.getAt(index + this.getBottomToolbar().cursor);
		if (r) {
			//this.CompleteAlarmWnd.show(); //弹出窗口
			RecentrowIndex = index;
			//f.getForm().loadRecord(r); //弹出窗口
		} else {
			Ext.Msg.alert('系统提示', blankStr + '请选择一条告警记录' + blankStr);
			return;
		}
	},
	onPauseClick : function() {
		var pBtn = Ext.getCmp('pause_btn');
		if (pBtn.text == '暂停') {
			Ext.MessageBox.confirm('系统提示：',
					'你确定要暂停告警实时监控?(请不要暂停过长时间,否则可能导致告警数据的丢失！)', function(btn) {
						if (btn == 'yes') {
							pBtn.setText('恢复');
							pBtn.setIconClass('play');
							pauseFlag = true;
						}
					});
		} else if (pBtn.text == '恢复') {
			pBtn.setText('暂停');
			pBtn.setIconClass('pause');
			getCacheData();
			changeAllPanel();
			pauseFlag = false;
		}
	},

	/**
	 * 增加告警
	 */
	doAdd : function() {
		this.AddAlarmWnd.AddAlarmForm.getForm().reset();
		this.AddAlarmWnd.show();
	},

	/**
	 * 设置各种告警的行颜色
	 * 
	 * @author chen.bo
	 * @type {}
	 */
	viewConfig : {
		enableRoBody : true,
		getRowClass : function(record, rowIndex, p, ds) {
			var cls;
			switch (record.data.alarmlevelkey) {
				case '1' :
					cls = 'x-grid-record-lev-1';
					break;
				case '2' :
					cls = 'x-grid-record-lev-2';
					break;
				case '4' :
					cls = 'x-grid-record-lev-3';
					break;
				case '8' :
					cls = 'x-grid-record-lev-4';
					break;
			}
			return cls;
		}
	},

	createDyCSS : function() {
		// 针对两种浏览器的实现
		// IE模式
		var almLevId = [];
		var almColor = [];
		var RecordSize = alarmShowConfigStore.getCount();
		for (var i = 0; i < RecordSize; i++) {
			almLevId[i] = alarmShowConfigStore.getAt(i).get('soundkey');
		}
		for (var j = 0; j < RecordSize; j++) {
			almColor[j] = alarmShowConfigStore.getAt(j).get('color');
		}
		var tempstr = [];
		var CSSStr = "";
		for (var k = 0; k < RecordSize; k++) {
			tempstr[k] = ".x-grid-record-lev-" + almLevId[k] + "{ background:"
					+ almColor[k] + ";} ";
		}
		for (var m = 0; m < RecordSize; m++) {
			CSSStr = CSSStr + tempstr[m];
		}
		var st = document.createElement('style');
		st.setAttribute('type', 'text/css');
		document.getElementsByTagName('head')[0].appendChild(st);
		// 针对两种不对的浏览器(IE和firefox)
		if (st.styleSheet) {
			st.styleSheet.cssText = CSSStr;
		} else {
			st.appendChild(document.createTextNode(CSSStr));
		}
	},

	/**
	 * 右键菜单
	 */
	onRowContextmenu : function(grid, rowIndex, e) {
		this.getSelectionModel().selectRow(rowIndex);
		e.preventDefault();
		this.rightMenu.showAt(e.getXY());
	},

	/**
	 * 刷新，需要在store.load时传递参数传到可以覆盖此方法
	 */
	doRefresh : function() {
		var r = this.getSelectionModel().getSelections();
		var rs = [];
		var page = this.getBottomToolbar().cursor;
		var len = r.length;
		if (len > 0) {
			rs = r;
		}
		if (rs.length > 0) {
			selectIndex = rs;
		}

		var that = this;
		this.store.load({
			callback : function() {
				that.getBottomToolbar().doLoad(page);
				var s = that.getStore();
				countReset(alarmFilterCount);
				for (var i = 0, len = s.getCount(); i < len; i++) {
					var r = s.getAt(i);
					countHandler(true, r.get('alarmlevelkey'), r
							.get('treatstate'));
				}
				changeAllPanel();

				if (selectIndex.length > 0) {
					var arr = [];
					for (var i = 0, len = selectIndex.length; i < len; i++) {
						var index = that.store.find('alarmid',
								selectIndex[i].data.alarmid);
						arr.push(index + page);
					}
					that.getSelectionModel().selectRows(arr, true);
					// that.getSelectionModel().selectRecords(selectIndex,
					// true);
				}
			}
		});

	},

	/**
	 * 实现 excel导出
	 */
	doExcel : function() {
		var cm = this.getColumnModel();
		var count = cm.getColumnCount();
		var cmHeadStr = '';
		var dataStr = '';

		for (var i = 2; i < count; i++) {
			if (!cm.isHidden(i)) {
				cmHeadStr += cm.getColumnHeader(i);
				dataStr += cm.getDataIndex(i);
			}
			if (i != count - 1) {
				cmHeadStr += ';';
				dataStr += ';';
			}
		}
		if (!Ext.fly('frmDummy')) {
			var frm = document.createElement('form');
			frm.id = 'frmDummy';
			frm.name = id;
			frm.className = 'x-hidden';
			document.body.appendChild(frm);
		};
		Ext.Ajax.request({
			url : 'exportExcel.action',
			method : 'POST',
			form : Ext.fly('frmDummy'),
			isUpload : true,
			params : {
				excelHeader : cmHeadStr,
				excelDate : dataStr,
				filterId : newfilterID,
				maxCount : RECORDCOUNT
			}
		});
	},

	/**
	 * 初始化配置信息
	 */
	initCfgParams : function() {
	},

	/**
	 * public 初始化grid中需要配置的参数
	 */
	initConfig : function(o) {
		this.initSm();
		// this.store = this.initStore(o.url, o.dataField);
		this.store = o.store;
		this.initColumn();
		this.initPagingBar(o.size);
		this.initTbar();
		this.initRightMenu();
	},
	/**
	 * 初始化右键菜单的操作，主要根据tbar上操作来确定，右键菜单的操作
	 */
	initRightMenu : function() {
		var menuItems = [];
		menuItems.push({
			text : '刷新',
			iconCls : 'refresh',
			handler : this.doRefresh,
			scope : this
		}
//		, '-', {
//			text : '确认',
//			iconCls : 'submit',
//			handler : this.ConfirmAlarm,
//			scope : this
//		}, '-', {
//			text : '取消确认',
//			iconCls : 'cancel',
//			handler : this.doUndoComfirm,
//			scope : this
//		}
		, '-', {
			text : '清除',
			iconCls : 'delete',
			handler : this.deleteGridClick,
			scope : this
		}
//		, '-', {
//			text : '告警详情',
//			iconCls : 'find',
//			handler : this.CompleteInfo,
//			scope : this
//		}, '-', {
//			text : '暂停',
//			iconCls : 'pause',
//			handler : this.onPauseClick,
//			scope : this
//		}, '-', {
//			text : '导出',
//			iconCls : 'excel',
//			handler : this.doExcel,
//			scope : this
//		}
		);

		this.rightMenu = new Ext.menu.Menu({
			items : menuItems
		});
	},
	/**
	 * 初始化tbar
	 */
	initTbar : function() {
		var tbarItems = ["-"];
		tbarItems.push({
			text : '',
			iconCls : 'refresh',
			handler : this.doRefresh,
			scope : this
		}, '->'
//		, '-', {
//			text : '确认',
//			iconCls : 'submit',
//			handler : this.ConfirmAlarm,
//			scope : this
//		}, '-', {
//			text : '取消确认',
//			iconCls : 'cancel',
//			handler : this.doUndoComfirm,
//			scope : this
//		}
		, '-', {
			text : '清除',
			iconCls : 'delete',
			handler : this.deleteGridClick,
			scope : this
		}
//			, '-', {
//			text : '告警详情',
//			iconCls : 'find',
//			handler : this.CompleteInfo,
//			scope : this
//		}, '-', {
//			text : '暂停',
//			iconCls : 'pause',
//			id : 'pause_btn',
//			handler : this.onPauseClick,
//			scope : this
//		}, '-', {
//			text : '导出',
//			iconCls : 'excel',
//			handler : this.doExcel,
//			scope : this
//		}, '->', '-', {
//			text : '',
//			id : 'almBell',
//			iconCls : 'bell',
//			handler : this.doBell,
//			scope : this
//		}
		, '-', '【提示】', {
			xtype : 'panel',
			id : 'tipPanel1'
		}, '-', '【一般】', {
			xtype : 'panel',
			id : 'tipPanel2'
		}, '-', '【重要】', {
			xtype : 'panel',
			id : 'tipPanel3'
		}, '-', '【紧急】', {
			xtype : 'panel',
			id : 'tipPanel4'
		});

		this.tbar = new Ext.Toolbar({
			items : tbarItems
		});
	},
	/**
	 * private 配置Grid中的数据源store
	 */
	initStore : function(url, dataField) {
		var s = new Ext.data.Store({
			proxy : new Ext.data.HttpProxy({
				url : url,
				method : 'POST'
			}),
			reader : this.initReader(dataField)
		});
		return s;
	},
	/**
	 * private 配置grid中的列
	 * 
	 * @params:columnParams {Array}列的参数数组
	 * 
	 */
	initColumn : function() {
		if (this.isCheckBoxSelectionModel) {
			columns.unshift(this.sm);
		}
		if (this.isRowNumberer) {
			columns.unshift(new Ext.grid.RowNumberer({
				sortable : true
					// width : 40
					}));
		}
		this.cm = new Ext.grid.ColumnModel(columns);
		// this.cm.addListener("rowselect", this.onRowClick, this);
	},
	/**
	 * private 如果配置isPaging为true时，增加分页工具条
	 * 
	 * @params pageSize{Number} 分页的个数 默认为10
	 */
	initPagingBar : function(pageSize) {
		if (this.isPaging) {
			this.bbar = new Ext.PagingToolbar({
				pageSize : (pageSize || 24),
				store : this.store,
				displayInfo : true,
				dsiplayMsg : '本页显示 {0} - {1},共{2}条记录',
				emptyMsg : "没有可显示的记录"
			});
		}
	},
	/**
	 * private 配置选择模式 配置选择模式是否为checkbox,是否为单选模式
	 */
	initSm : function() {
		if (!this.isCheckBoxSelectionModel) {
			this.sm = new Ext.grid.RowSelectionModel({
				singleSelect : this.isSingleSelect,
				header : ''
			});
		}
		this.sm = new Ext.grid.CheckboxSelectionModel({
			singleSelect : this.isSingleSelect,
			header : ''
				// handleMouseDown : Ext.emptyFn
		});
		// this.sm.addListener('rowselect', this.onRowSelect, this);
		// this.sm.addListener('rowdeselect', this.rowDeselect, this);
	},

	/**
	 * 维护选中的行,用户选中时触发
	 */
	onRowSelect : function(sm, rowIndex, r) {
		// option = true;
		// var view = this.getView();
		// var hd = Ext.fly(view.innerHd).child('div.x-grid3-hd-checker');
		// var isChecked = hd.hasClass('x-grid3-hd-checker-on');
		// if (isChecked) {
		// / ischeck = true;
		// } else {
		// ischeck = false;
		// }
	},

	/**
	 * 护选中的行,用户取消选择行时触发
	 */
	rowDeselect : function(sm, rowIndex, record) {
		var view = this.getView();
		var hd = Ext.fly(view.innerHd).child('div.x-grid3-hd-checker');
		var isChecked = hd.hasClass('x-grid3-hd-checker-on');
		if (isChecked) {
			ischeck = true;
		} else {
			ischeck = false;
		}
	},

	/**
	 * private 配置store中的reader,分为分页和不分页两种实现方式
	 * 
	 * @params:dataField {Array} 如：["userID","userName"]
	 * @retrun{Ext.data.JsonReader}
	 */
	initReader : function(dataField) {
		return new Ext.data.JsonReader(this.isPaging ? {
			totalProperty : 'totalProperty',
			root : 'root'
		} : {}, this.initDataField(dataField));
	},
	/**
	 * private 配置store中的对应的属性字段
	 * 
	 * @params:dataField{Array} 如：["userID","userName"]
	 * @return{Array}返回属性字段组成后的对象数组如：[{name:'userID'},{name:'userName'}]
	 */
	initDataField : function(dataField) {
		if (!Ext.isArray(dataField)) {
			throw new Error("dataField is not a Array, is required a Array.");
			return;
		}
		var dfs = [];
		for (var i = 0, len = dataField.length; i < len; i++) {
			var o = {};
			o.name = dataField[i];
			dfs[dfs.length] = o;
		}
		
		return dfs;
	},
	/**
	 * private 打印当前grid的当前页
	 * 
	 * @params{Ext.grid.GridPanel} grid
	 */
	printPage : function(grid) {
		var tableStr = '<table width="100%" border=1>';
		var cm = grid.getColumnModel();
		var colCount = cm.getColumnCount();
		var temp_obj = new Array();

		// 只下载没有隐藏的列(isHidden()为true表示隐藏,其他都为显示)
		// 临时数组,存放所有当前显示列的下标
		for (var i = 1; i < colCount; i++) {
			if (cm.isHidden(i) == true) {
			} else {
				temp_obj.push(i);
			}
		}
		tableStr = tableStr + '<tr><td>序号</td>';
		for (var i = 0; i < temp_obj.length; i++) {
			// 显示列的列标题
			// xlSheet.Cells(1, i).Value =
			// cm.getColumnHeader(temp_obj[i
			// - 1]);
			tableStr = tableStr + '<td>' + cm.getColumnHeader(temp_obj[i])
					+ '</td>';
		}
		tableStr = tableStr + '</tr>';
		var store = grid.getStore();
		var recordCount = store.getCount();
		for (var i = 0; i < recordCount; i++) {
			var r = store.getAt(i);
			tableStr = tableStr + '<tr><td>' + (i + 1) + '</td>';
			for (var j = 0; j < temp_obj.length; j++) {
				var dataIndex = cm.getDataIndex(temp_obj[j]);
				var tdValue = r.get(dataIndex);
				var rendererFunc = cm.getRenderer(temp_obj[j]);
				if (rendererFunc != null) {
					tdValue = rendererFunc(tdValue);
				}
				if (tdValue == null) {
					tdValue = '';
				}
				tableStr = tableStr + '<td>' + tdValue + '</td>';
			}
			tableStr = tableStr + '</tr>';
		}
		tableStr = tableStr + '</table>';
		var titleHTML = tableStr;
		var newwin = window.open('printer.jsp', '', '');

		newwin.document.write(titleHTML);
		newwin.document.location.reload();
		newwin.print();
		newwin.close();
	}
});
