
/**
 * 告警处理意见
 */
ExpGrid = Ext.extend(Ext.grid.GridPanel, {

			alarmExpWindow : null, // 告警自定义处理意见

			constructor : function(cfg) {

				var cfg = cfg || {};
				Ext.apply(this, cfg);

				this.alarmExpWindow = new AlarmExpWindow({
							grid : this
						});

				ExpGrid.superclass.constructor.call(this, {
							title : '告警处理意见',
							frame : true,
							width : 672,
							height : 200,
							viewConfig : {
								forceFit : true
							},
							loadMask : {
								msg : '正在载入数据,请稍候...'
							},
							cm : new Ext.grid.ColumnModel([
									new Ext.grid.RowNumberer(), {
										header : 'id',
										dataIndex : 'experienceid',
										width : 100,
										hidden : true
									}, {
										header : '经验描述',
										dataIndex : 'experiencedesc',
										width : 180,
										hidden : false
									}, {
										header : '创建人',
										dataIndex : 'userid',
										width : 120
									}]),
							ds : new Ext.data.Store({
										proxy : new Ext.data.HttpProxy({
													url : "getAlarmExp.action",
													method : 'POST'
												}),
										reader : new Ext.data.JsonReader({}, [{
															name : 'experienceid'
														}, {
															name : 'experiencedesc'
														}, {
															name : 'userid'
														}])
									}),
							tbar : [
									// {text : '增加',handler :
									// this.addExp,iconCls : 'new',scope :
									// this}, '-',
									{
								text : '刷新',
								handler : this.doRefresh,
								iconCls : 'refreshxp',
								scope : this
							}]
						});
			},
			/**
			 * 增加默认经验
			 */
			addExp : function() {
				// this.alarmExpWindow.alarmExpForm.getForm().reset();
				// this.alarmExpWindow.show();
			},

			/**
			 * 刷新
			 */
			doRefresh : function() {
				var f = this.form; // 通过引用关系找到对应的告警详细信息表单
				var causeid = f.almCauseHd.getValue();

				this.store.load({
							params : {
								causeid : causeid
							}
						});
			}
		});
