/*
 * tab      [
 *          {id:'sz',title:'ZZZZ1',isActive:'true'} ,
 *          {id:'sz1',title:'ZZZZ2',isActive:'true'},
 *          {id:'sz2',title:'ZZZZ3',isActive:'true'},
 *          {id:'sz3',title:'ZZZZ4',isActive:'true'}
 *          ]
 *          
 *          tabID: tabTree_id
 *          root:  id
 *          action: 'tree.action'
 */

var tabs_data1 =  [
                    {id:'100',title:'资源类型',isActive:'true'} ,
                    {id:'200',title:'区域设置',isActive:'false'},
                    {id:'300',title:'应用系统',isActive:'false'}
                 ];
var tabs_data = null;

var rightMenuData = null;  //右键菜单数据

function createTreePanel(rootText,rootId) {
    var tree= new Ext.tree.TreePanel({
        autoScroll:true, 
        enableDD:false,//是否支持拖拽效果
        containerScroll: true,//是否支持滚动条
        split:true,
        width: 160,
        border: false,
        height:Ext.getBody().getViewSize().height - 120,
        //minSize: 175,
        //maxSize: 300,
        rootVisible:true,//是否显示跟节点
        collapsible: true,
        margins:'0 0 0 0',
        loader:new Ext.tree.TreeLoader({  
            dataUrl: 'getChildNodesWithMain.action'
        }),
        root: new Ext.tree.AsyncTreeNode({
        	id: rootId,
            text:rootText,
            draggable:false
        })
    });
    return tree;
}


/**
 * tab设备导航
 * @class TabTreePanel
 * @extends Ext.TabPanel
 */
TabsPanel = Ext.extend(Ext.TabPanel, {
    
    constructor: function() {
        
        TabsPanel.superclass.constructor.call(this, {
            title: "dfdf",
            margins:'0 0 0 0',
            resizeTabs: true,
            minTabWidth: 80,
            tabWidth: 80,
            enableTabScroll: true,
            border: false,
            width:188,
            height:Ext.getBody().getViewSize().height - 100,
            autoTabs: true,
            autoWidth: true,
            activeTab: 0,
            defaults:{autoHeight: true}
        });
    }
});

/**
 * 外层的Panel
 * @class TabsPanel
 * @extends Ext.Panel
 */
LeftPanel = Ext.extend(Ext.Panel, {
    tabsPanel: null,
    
     constructor: function(data) {
        tabs_data = eval(data);
        this.tabsPanel = new TabsPanel();        
        LeftPanel.superclass.constructor.call(this, {
            id:'api-tree',
            region:'west',
            title:'设备导航树',
            split:true,
            width: 190,
            minSize: 190,
            maxSize: 200,
            height: Ext.getBody().getViewSize().height - 80,
            collapsible: true,
            margins:'0 0 5 5',
            cmargins:'0 0 0 0',
            rootVisible:false,
            //border: false,
            lines:false,
            autoScroll:true,
            animCollapse:false,
            animate: false,
            collapseMode:'mini',
            collapseFirst:false,
            items:[this.tabsPanel],
            listeners: {
                'render': {fn:this.renderToPanel, scope: this}
            }
        });
    },
    initTabs: function() {
    	for(var i=0,len=tabs_data.length; i<len; i++) {
    		var rootId = tabs_data[i].id;
    		var tabsId = 'tabTree_' + tabs_data[i].id;
    		var title = tabs_data[i].title;
    		//var isActive = tabs_data[i].isActive;
    		var p = new Ext.Panel({id:tabsId,title:title,autoScroll:true,layout: 'fit',border:false,autoWidth:true});
    		var tree = createTreePanel(title,rootId);
    		p.add(tree);
    		tree.on('click', this.treeClick, this);
    		tree.on('contextmenu', this.treeRightMenu, this);
    		this.tabsPanel.add(p);
    	    
    	}
    },
    renderToPanel: function() {
    	this.initTabs();
    },
    treeClick: function(node, e) {
	    var tabId = mainPanel.getActiveTab().id;
        if(tabId && tabId !== 'start-panel') {
            var tabIdStr = tabId.substring(9);
            alert('frame_' + tabIdStr);
            if(typeof(document.getElementById('frame_' + tabIdStr).contentWindow.invoke) !== 'undefined') {
                
            	//invoke 统一为子页面统一接口 传节点 ： invoke(Ext.tree.node node);
            	document.getElementById('frame_' + tabIdStr).contentWindow.invoke(node);
            }
       }
    },
    treeRightMenu: function(node, e) {
    	  var nodemenu = createRightMenu(node,rightMenuData);
          nodemenu.showAt(e.getPoint());
    }
});

/**
 * 创建右键菜单
 * @param {} menuData
 * @return {}
 */
function createRightMenu(node,rightMenuData){
    
    var menu = new Ext.menu.Menu();
    
    for(var i=0; i<rightMenuData.length; i++){
        var menuItem = null;
        
        if(rightMenuData[i].isDisplay){
            menuItem = new Ext.menu.Item({
                id: rightMenuData[i].id,
                text: rightMenuData[i].menuBiz,
                treeNode: node,
                capaId: rightMenuData[i].capaId,
                handler: onRightMenuClick
            });
        }
        menu.addItem(menuItem);
    }
    return menu;
}

/**
 * 右键菜单处理函数
 * @param {} menuItem
 */
function onRightMenuClick(rightMenuItem) {
	var capaId = rightMenuItem.capaId;     //功能菜单id
	var treeNode = rightMenuItem.treeNode;
	var menuItem = Ext.getCmp("menu_" + capaId);   //根据功能菜单id查找功能菜单
	mainPanel.loadMenu(menuItem);
	var win = document.getElementById("frame_menu_" + capaId).contentWindow;
	if(win && win.invoke) {
	   win.invoke(treeNode,treeNode.parentNode);
	}
}

/*function setVisibility(frameName,treeNode) {
	var win = document.getElementById(frameName).contentWindow;
    if(win.document.readyState=="complete") {
    	win.invoke(treeNode, treeNode.parentNode);
     } else {
        setTimeout("setVisibility()",1000);
     }
} 
*/