/******************************************************************************
 * 	Portal (我的工作室)
 * 	@author Qinaldo
 * 	@created on 2009年3月6日10:06:48 
 * 	@Company 苏州科大恒星
 * 
 *****************************************************************************/

var jsonData;

if(typeof console == 'undefined'){
    console = {
    log: Ext.debug?Ext.log:alert,
    dir: Ext.debug?Ext.dump:alert
    };
  }

Ext.apply(window,{
    $ : Ext.get
   ,$A: Ext.value
   ,$C : Ext.getCmp
   ,$D : Ext.getDom
   ,$$ : Ext.select
   ,$Q : Ext.query
   ,$on: Ext.EventManager.on
   ,$ready : Ext.onReady
   ,$l : console.log
   ,$cd: console.dir
   ,$for : typeof forEach != 'undefined'? forEach : Ext.each

});

Ext.lib.Ajax.forceActiveX = true;

Ext.BLANK_IMAGE_URL = 'resources/images/default/s.gif';  //本地图形化

/******************起始页面StartPortal组件*******************************************************/
StartPortal = Ext.extend(Ext.ux.Portal, {
	
	leftColumn   : null,
	centerColumn : null,
	rightColumn  : null,
	
	noticeGrid : null,
	alarmChartPanel  : null,
	objDevChartPanel : null,
	autoReportGrid : null,
	
	constructor: function() {
		
		this.leftColumn = this.createColumn('left', .33);
		this.centerColumn = this.createColumn('center', .33);
		this.rightColumn = this.createColumn('right', .33);
		
		StartPortal.superclass.constructor.call(this, {
			region:'center',
		    autoScroll:true,
		    border:false
		});
	},
	restore: function() {	//恢复默认
		
    	this.initAllComponent();
    	
        this.leftColumn.add(this.createPortlet('noticeGrid','最新公告', this.noticeGrid));
        this.leftColumn.add(this.createPortlet('autoReportGrid','定时报表',this.autoReportGrid));
        this.centerColumn.add(this.createPortlet('alarmChartPanel','告警柱状图显示',this.alarmChartPanel));
        this.rightColumn.add(this.createPortlet('objDevChartPanel','资源变更柱状图显示',this.objDevChartPanel));
        
        this.reDoLayout();
    },
    init: function(){	//初始化
    	
    	if(!jsonData || jsonData.length == 0) {
    		this.restore();
    		return;
    	}
    	this.initAllComponent();
    	
    	for(var i=0, len=jsonData.length; i<len; i++) {
    		var id = jsonData[i].portletId;
            var colNum = jsonData[i].column;   
            var rowNum = jsonData[i].row;
            var title, panel;
            for(var props in this.portletObj) {
            	if(this.portletObj.hasOwnProperty(props)) {
            		var propValue = (this.portletObj)[props];
            		if(propValue['idx'] === id) {
            			title = propValue['title'];
            			panel = propValue['panel'];
            			break;
            		}
            	}
            }
            if(colNum == 0) {
            	this.leftColumn.add(this.createPortlet(id,title,panel));
            } else if(colNum == 1) {
            	this.centerColumn.add(this.createPortlet(id,title,panel));
            } else if(colNum == 2) {
            	this.rightColumn.add(this.createPortlet(id,title,panel));
            }
    	}
    	
    	this.reDoLayout();
    },
    removeAllportlet: function () {	//移除所有的portlet
    	if(this.items && this.items.length > 0) {
	    	for (var i = 0; i < this.items.length; i++) {
	            var c = this.items.itemAt(i);
	            if (c.items){
	                for (var j = c.items.length - 1; j >= 0; j--) {
	                    c.remove(c.items.itemAt(j), true);
	                }
	           }
	        }
    	}
    },
    initAllComponent: function() {
    	
    	var that = this;
    	this.portletObj = {};	//所有的portlet
    	
    	this.noticeGrid = new NoticeGrid();
    	this.noticeGrid.store.load();
    	
    	this.autoReportGrid = new AutoReportGrid();
    	this.autoReportGrid.store.load();
    	
    	this.alarmChartPanel = new AlarmChartPanel();
    	this.alarmChartPanel.load();
    	this.alarmChartPanel.show();
    	/*AlarmStatisticsManager.statisticsAlarm(function(data) {
			if(data !== 'error') {
				that.alarmForm.getForm().setValues(Ext.decode(data));
			}
		});*/
    	
    	this.objDevChartPanel = new ObjDevChartPanel();
    	this.objDevChartPanel.load();
    	this.objDevChartPanel.show();
    	
    	//组成组件id, title, 组件名称的对应关系
    	this.portletObj.noticeGrid = {idx: 'noticeGrid', title: '最新公告', panel: this.noticeGrid};
    	this.portletObj.alarmChartPanel = {idx: 'alarmChartPanel', title: '告警柱状图显示', panel: this.alarmChartPanel};
    	this.portletObj.autoReportGrid = {idx: 'autoReportGrid', title: '定时报表', panel: this.autoReportGrid};
    	this.portletObj.objDevChartPanel = {idx: 'objDevChartPanel', title: '资源变更柱状图显示', panel: this.objDevChartPanel};
    },
	reDoLayout:function() {	//重新布局
		this.add(this.leftColumn);
        this.add(this.centerColumn);
        this.add(this.rightColumn);
        
        var fullPanel = Ext.getCmp('fullPanel');
        fullPanel.add(this);
        fullPanel.doLayout();
	},
    createPortlet: function(id,title,items) {
    	return new Ext.ux.Portlet({
	        id:id,
	        title:title,
	        tools: [
	        	{ id:'close', handler: function(e, target, panel){panel.ownerCt.remove(panel, true);}}
	        ],
	        style:'padding:0px 0 5px 0px',
	        items:items
	    });
    },
    createColumn : function (id, columnWidth) {
	    return new Ext.ux.PortalColumn({
	        id:id,
	        columnWidth:columnWidth,
	        style:'padding:5px 0 5px 5px'
	    });
	}
});

/*****************最外层的FullPanel面板********************************************************/
FullPanel = Ext.extend(Ext.Panel, {
	
	portal : null,		//portal
	
	constructor: function() {
		
		this.portal = new StartPortal();
		
		FullPanel.superclass.constructor.call(this, {
			renderTo: 'FullPanel',
			id: 'fullPanel',
			height: Ext.getBody().getHeight(),
	    	width: Ext.getBody().getWidth(),
	        layout:'fit',
	        bodyStyle:'padding:5px 5px 5px 5px;',
			tbar: [
				{ xtype: 'label', id: 'onLineMsg', title: ''},'->', '-', 
				{ text: '恢复默认', iconCls: 'resume',handler: this.onResumeClick, scope: this}, '-',
				{ text: '保存我的设置',iconCls: 'save',handler: this.onSaveClick, scope: this}, '-'
			],
			listeners: {
				'render': {fn : this.onRenderEvent, scope: this}
			}
		});
	},
	onRenderEvent: function(panel) {
		var that = this;
		LogInManager.logIn(function(data) {
			if(data) {
				var jData = Ext.decode(data);
				Ext.get('onLineMsg').dom.innerHTML = '&nbsp;&nbsp;&nbsp;&nbsp;欢迎你,【<font color=blue>' + jData.userId +
						'</font>】进入新网管系统!&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;当前在线人数：<font color=blue>' + jData.count + '</font>';
			}
		});
	},
	onResumeClick: function() {
		this.portal.removeAllportlet();
	    this.portal.restore();
	},
	onSaveClick: function() {
		var arr = [];
		if(!this.portal.items || this.portal.items.length == 0)
			return;
    	for (var i = 0; i < this.portal.items.length; i++) {
            var col = this.portal.items.items[i];
            for (var j = 0; j < col.items.length; j++) {
            	var portlet = col.items.items[j];
                var portletId = col.items.items[j].id;
                var rowNum = col.items.indexOf(portlet);
                var colNum = i;
                var str = portletId + ',' + colNum + ',' + rowNum;
                arr.push(str);
            }
        }
        PortalManager.savePortal(arr, function(data) {
            if(data) {
            	
            } else {
            	
            }
        });
	}
});

/***风格转换****************/
function changeStyle(style) {
    Ext.util.CSS.swapStyleSheet("theme", "resources/css/" + style + ".css");
}


/****************onReady**********************/
Ext.onReady(function() {
	
	Ext.QuickTips.init();								//开启快速提示功能
    Ext.form.Field.prototype.msgTarget = 'side';		//提示方式为'side'
	
    Ext.util.CSS.swapStyleSheet("theme", "resources/css/" + window.parent.styleCssValue);
    
    PortalManager.getPortal(function(data) {
        if(data) {
            jsonData = Ext.decode(data);
            var fullPanel = new FullPanel();
            fullPanel.portal.init();
        } else {
            Ext.MessageBox.alert('系统提示：', '操作可能出现了某些错误, 请重试！');
        }
    });
    
});

