/**
*  起始页各个portlet的配置
*  @author Qinaldo
*  @created on 2009年6月10日10:38:03
*/

var blankStr = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';//需要补充的空格

/**公告Grid*******************/
NoticeGrid = Ext.extend(Ext.grid.GridPanel, {
	constructor: function() {
		NoticeGrid.superclass.constructor.call(this, {
			frame: true,
            width: (Ext.getBody().getViewSize().width) * 0.315,
            height: (Ext.getBody().getViewSize().height) * 0.39,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            autoScroll: true,
            sm: new Ext.grid.RowSelectionModel({singleSelect: true}),
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                {header: "标题", width: 140, sortable: false, dataIndex: 'title',renderer: this.toHref, scope: this},
                {header: "时间", width: 50, sortable: false, dataIndex: 'issueTime',renderer: this.changeTime, scope: this}
            ]),
            bbar: [
            	'-',{ text: '刷新', tooltip:'刷新查看最新的十条公告', iconCls: 'refreshxp', handler: function() {this.store.load();} ,scope: this},
            	'->',{text: '更多...', tooltip: '查看更多的公告信息', iconCls: 'more', handler: this.onMoreClick, scope:this}
            ],
            ds: new Ext.data.Store({		
		        proxy: new Ext.data.HttpProxy({url:"maintenance/notice/getNoticeTopTen.action", method:'POST'}),
		        reader: new Ext.data.JsonReader({},[{name: 'id'},{name: 'name'},{name: 'title'},{name: 'content'},{name: 'userName'},{name: 'author'},{name: 'issueTime'}])
		    })
		});
	},
	onMoreClick: function(){
		parent.mainPanel.loadMenu(parent.noticeMenu);
	},
	changeType: function(val) {
		return '【<font color=green>' + val + '</font>】';
	},
	toHref: function(val,metadata,record) {
		return '<a href="maintenance/notice/getNoticeInfoById.action?id= ' + record.data.id+ '">' + val+ '</a>'; 
	},
	changeTime: function(val) {
    	return formatDate(new Date(val["time"]),"y-M-d HH:mm:ss");
    }
});


/***告警AlarmForm*****************//*
AlarmForm = Ext.extend(Ext.form.FormPanel,{
	
	allLabel : null,	//全部告警
	commonLabel : null, //一般告警
	tipLabel: null,		//提示告警
	importLabel: null,	//重要告警
	urgentLabel: null,  //紧急告警
	
    constructor: function() {
        
    	this.allLabel = this.createTextField("全部告警","allCount");
    	this.commonLabel = this.createTextField("一般告警","tipCount");
		this.tipLabel = this.createTextField("提示告警","commonCount");
		this.importLabel = this.createTextField("重要告警","importCount");
		this.urgentLabel = this.createTextField("紧急告警","urgentCount");
    	
        AlarmForm.superclass.constructor.call(this, {
            width: (Ext.getBody().getViewSize().width) * 0.315,
            height: (Ext.getBody().getViewSize().height) * 0.48,
            labelWidth: 70,
            border: true,
            bodyStyle:"padding: 30px 5px 0 50px",
            //baseCls: 'x-plain',
            frame: true,
            items: [this.allLabel,this.commonLabel,this.tipLabel,this.importLabel,this.urgentLabel],
            bbar: ['-',{ text: '刷新', tooltip:'刷新查看最新的告警条数', iconCls: 'refreshxp', handler: this.onRefreshClick ,scope: this},
            	'->',{text: '更多...', tooltip: '查看更多的告警信息', iconCls: 'more', handler: this.onMoreClick, scope:this}
            ],
            listeners: {
            	'beforerender': {fn: this.onBeforRender, scope: this}
            }
        });
    },
    onBeforRender: function() {
    	
    },
    onRefreshClick: function() {	//刷新
    	var that = this;
    	AlarmStatisticsManager.statisticsAlarm(function(data) {
			if(data !== 'error') {
				that.getForm().setValues(Ext.decode(data));
			}
		});
    },
	onMoreClick: function(){
		parent.mainPanel.loadMenu(parent.alarmView);
	},
    createTextField: function(fieldLabel, name) {
        var tf = new Ext.form.TextField({
        	width: 150,
            height: 20,
            fieldLabel: fieldLabel,
            name: name,
            labelSeparator: ':',
            //frame: false,
            readOnly: true,
            //border: false,
            labelStyle: '{font-weight:bold;color:#3AB1F5;}',
            style: '.x-form-text{background:#dfe8f6;color:#3AB1F5;font-weight:bold;border:0;}'
        });
        return tf;
    }
});*/

/***************************************资源变更objDevGrid组件***************************************************//*
ObjDevGrid=Ext.extend(Ext.grid.GridPanel, {
	
    constructor: function() {
        ObjDevGrid.superclass.constructor.call(this, {
            frame: true,
            width: (Ext.getBody().getViewSize().width) * 0.315,
            height: (Ext.getBody().getViewSize().height) * 0.48,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            sm: new Ext.grid.RowSelectionModel({singleSelect:true}),
            cm: new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
                {header:'对象标识',dataIndex:'objId',width:1,hidden:true},
                {header:'设备类型',dataIndex:'objName',width:80},
                {header:'记录数',dataIndex:'cnt',width:50}  
            ]),
            ds: new Ext.data.Store({
		        proxy: new Ext.data.HttpProxy({url: "getAllGreyListObjx.action", method: 'POST'}),
		        reader: new Ext.data.JsonReader({},[{name:'objId'},{name:'objName'},{name:'cnt'}])
		    }),
            bbar: [
            	'-',{ text: '刷新', tooltip:'刷新查看最新的资源变更', iconCls: 'refreshxp', handler: function() {this.store.load();} ,scope: this},
            	'->',{text: '更多...', tooltip: '查看更多的资源变更', iconCls: 'more', handler: this.onMoreClick, scope:this}
            ]
        });
    },
    onMoreClick: function(){
		parent.mainPanel.loadMenu(parent.ashListManageMenu);
	}
});
*/
ObjDevChartPanel = Ext.extend(Ext.ux.OFCPanel, {
	constructor: function() {
		ObjDevChartPanel.superclass.constructor.call(this, {
			collapsible : true,
		    floating:false,
	       	autoScroll : true,
		    chartURL : 'open-flash-chart.swf',
		    dataURL  : 'getGreyListCount.action',
		    mediaMask  : {msg:'Loading Chart Object'},
	        autoMask  : true,
	        width: (Ext.getBody().getViewSize().width) * 0.315,
	        height: (Ext.getBody().getViewSize().height) * 0.39,
	        listeners :{
	           show  : function(p){
	               if(p.floating)p.setPosition(p.x||10,p.y||10);
	               }
	        },
	        bbar: ['-',{ text: '刷新', tooltip:'刷新查看最新的资源变更', iconCls: 'refreshxp', handler: this.onRefreshClick ,scope: this},
	            	'->',{text: '更多...', tooltip: '查看更多的资源变更', iconCls: 'more', handler: this.onMoreClick, scope:this}
	        ]
		});
	},
    onRefreshClick: function() {	//刷新
   		this.load();
    	this.show();
    },
	onMoreClick: function(){
		parent.mainPanel.loadMenu(parent.ashListManageMenu);
	}
});

/**告警统计柱状图显示*************************/
AlarmChartPanel = Ext.extend(Ext.ux.OFCPanel, {
	constructor: function() {
		AlarmChartPanel.superclass.constructor.call(this, {
			collapsible : true,
		    floating:false,
	       	autoScroll : true,
		    chartURL : 'open-flash-chart.swf',
		    dataURL  : 'getAlarmCount.action',
		    mediaMask  : {msg:'Loading Chart Object'},
	        autoMask  : true,
	        width: (Ext.getBody().getViewSize().width) * 0.315,
	        height: (Ext.getBody().getViewSize().height) * 0.39,
	        listeners :{
	           show  : function(p){
	               if(p.floating)p.setPosition(p.x||10,p.y||10);
	               }
	        },
	        bbar: ['-',{ text: '刷新', tooltip:'刷新查看最新的告警条数', iconCls: 'refreshxp', handler: this.onRefreshClick ,scope: this},
	        	   '-',{ text: '配置颜色', tooltip:'配置告警颜色', iconCls: 'config', handler: this.onConfigClick ,scope: this},
	               '->',{text: '更多...', tooltip: '查看更多的告警信息', iconCls: 'more', handler: this.onMoreClick, scope:this}
	        ]
		});
	},
    onRefreshClick: function() {	//刷新
   		this.load();
    	this.show();
    },
    onConfigClick: function() {
    	parent.mainPanel.loadMenu(parent.alarmShowCinfgMenu);
    },
	onMoreClick: function(){
		parent.mainPanel.loadMenu(parent.alarmView);
	}
});

/*******************************自动报表AutoReportGrid************************/
AutoReportGrid=Ext.extend(Ext.grid.GridPanel,{
	
	rightClick : null,
	
	constructor: function() {
		
		this.rightClick =  new Ext.menu.Menu({
	        items : [
	        	{ text : '查看', 	handler: this.OnOpenFile, 		scope: this },
	        	{ text : '删除', 	handler: this.deleteRecords, 	scope: this },
	            { text: 'Excel导出',	handler: this.exportByExcel, 	scope: this },
	            { text: '条形图',   	handler: this.displayBarChart, 	scope: this },
	            { text: '折线图',  	handler: this.displayLineChart,	scope: this },
	        	{ text: '饼图',  	handler: this.displayPieChart, 	scope: this }, '-',
	        	{ text:'重新生成', 	handler: this.reExecute, 		scope: this }
	        ]
	     }); 
		
	 	AutoReportGrid.superclass.constructor.call(this,{
    		frame: true,
    		width: (Ext.getBody().getViewSize().width) * 0.315,
			height: (Ext.getBody().getViewSize().height) * 0.39,
    		viewConfig: {
        		forceFit: true
    		},
    		 loadMask: {
       			 msg : '正在载入数据,请稍候...'
    		},
    		cm:new Ext.grid.ColumnModel([new Ext.grid.RowNumberer(),
    		{header : '执行时间',dataIndex : 'finishTime',align: 'center',hidden:false,renderer:this.formatTime,scope:this},
			{header : '报表名称',dataIndex : 'rptName',align: 'center',hidden:false},
			{header : '执行状态',dataIndex : 'execStatus',align: 'center',hidden:false,renderer:this.formatStyle,scope:this}]         		            		
    		),
    		ds:  new Ext.data.Store({
				proxy: new Ext.data.HttpProxy({url: 'getAutoRptHisTopTen.action', method: 'POST'}),
				reader: new Ext.data.JsonReader({},[ 
					{name: 'hisId'},{name: 'finishTime'},{name: 'autoRptId'},{name: 'rptName'},
					{name: 'execStatus'},{name: 'fileName'},{name: 'dispMode'},{name: 'userId'}
				])	
			}),
			bbar: [
            	'-', { text: '刷新', tooltip:'刷新查看最新', iconCls: 'refreshxp', handler: function() {this.store.load();} ,scope: this},
            	'->',{ text: '更多...', tooltip: '查看更多定时报表信息', iconCls: 'more', handler: this.onMoreClick, scope:this}
            ],
            listeners: {
            	'rowcontextmenu': { fn: this. onRightMenuClick, scope: this},
            	'rowdblclick': {fn: this.OnOpenFile, scope: this}
            }
 		})
	 },
	 OnOpenFile: function() {	//右键查看或者双击查看
	 	var r = this.getSelectionModel().getSelected();
	 	var g_fileName;
	 	if(r) {
	 		 g_fileName=r.data.fileName;
		} else {
    		Ext.Msg.alert('系统提示', blankStr + '请选择一条记录' + blankStr);
    	    return;
    	}  	
		Ext.Ajax.request({    
          	url: 'getQueryResultByFileName.action',    
	        params:{ fileName:g_fileName },
       		success: function(response, options) { 
       	     	if(response.responseText.trim().length !=0) {
       	     		parent.hide();                      	
       	     	} else {
      	     		Ext.Msg.alert('系统提示', blankStr+'执行结果为空'+blankStr);
       	     	}
           		resultData = response.responseText;
            	window.open("showResult.jsp","结果展现界面");
    		},
         	failure: function(){
         		Ext.Msg.alert('系统提示', blankStr+'打开报表文件失败'+blankStr);
         	}
        });
	 },
	 deleteRecords: function() {		//删除
	 	var that = this;
	 	var r = [];
		r = this.getSelectionModel().getSelections();
		if (r.length == 0) {
			Ext.Msg.alert('系统提示', blankStr + '请选择记录' + blankStr);
			return;
		}
		var hisIds=[];
		var fileNames=[];
		for (var i = 0; i < r.length; i++) {
			hisIds[i]=r[i].data.hisId;
			fileNames[i]=r[i].data.fileName;
		}
		Ext.MessageBox.confirm('系统提示:', '你确定要删除所选记录吗？', function(btn) {
			if (btn == 'yes') {
				QueryAutoRptHisManager.deleteQueryAutoRptHiss(hisIds,fileNames,function(data) {
					if (data) {
						Ext.MessageBox.alert("系统提示:",blankStr + "删除成功" + blankStr);
						that.store.reload();
					}
					else{	
						Ext.MessageBox.alert("系统提示:",blankStr + "删除失败" + blankStr);
					}
				});
			}
		});
	 },
	 exportByExcel: function(){		//excel导出
		var r = this.getSelectionModel().getSelected();
		var g_fileName;
	 	if(r) {
	 		 g_fileName = r.data.fileName;
		}  	
		if (!Ext.fly('frmDummy')) {
	        var frm = document.createElement('form');
	        frm.id = 'frmDummy';
	        frm.name = id;
	        frm.className = 'x-hidden';
	        document.body.appendChild(frm);
	    }
        Ext.Ajax.request({
            url: 'exportAutoRptByExl.action',
            method : 'POST',
            form: Ext.fly('frmDummy'),
            failure: function(){
				Ext.Msg.alert('系统提示', '操作失败');
			},
            isUpload: true,
            params: { 
            	fileName:g_fileName 
			}
        });
	},
	displayBarChart: function() {	//柱状图
		var r = this.getSelectionModel().getSelected();
	 	if(r) {
	 		 g_fileName=r.data.fileName;
		}	
		Ext.Ajax.request({    
			url: 'getReportBarChart.action',    
			params: {fileName:g_fileName},
			success: function(response, options) {
				resultData = response.responseText;
				var pageWidth = window.screen.availWidth;
				var pageHeight = window.screen.availHeight - 20;
				window.open("query/BarChart.jsp","_blank","top=0,left=0,menubar=0,toolbar=0,width=" + pageWidth + ",height=" + pageHeight);
			},
			failure: function() {
				Ext.Msg.alert('系统提示', '操作失败');
         	}
        });			
	},
	displayLineChart: function() {	//线图
		var r = this.getSelectionModel().getSelected();
	 	if(r) {
	 		 g_fileName=r.data.fileName;
		}	
	
		Ext.Ajax.request({    
			url: 'getReportLineChart.action',    
			params: {fileName:g_fileName},
			success: function(response, options) {
				resultData = response.responseText;
				var pageWidth = window.screen.availWidth;
				var pageHeight = window.screen.availHeight - 20;
				window.open("query/LineChart.jsp","_blank","top=0,left=0,menubar=0,toolbar=0,width=" + pageWidth + ",height=" + pageHeight);
			},
			failure: function() {
				Ext.Msg.alert('系统提示', '操作失败');
         	}
        });			
	},
	displayPieChart: function() {	//饼图
		var r = this.getSelectionModel().getSelected();
	 	if(r) {
	 		 g_fileName=r.data.fileName;
		}	
	
		Ext.Ajax.request({    
			url: 'getReportPieChart.action',    
			params: {fileName:g_fileName},
			success: function(response, options) {
				resultData = response.responseText;
				charts = resultData.split('+');
				var pageWidth = window.screen.availWidth;
				var pageHeight = window.screen.availHeight - 20;
				for (var i=0; i<charts.length - 1; i++) {
					window.open("query/PieChart.jsp?chartIndex=" + i,"_blank","top=0,left=0,menubar=0,toolbar=0,width=" + pageWidth + ",height=" + pageHeight);					
				}				},
			failure: function() {
				Ext.Msg.alert('系统提示', '操作失败');
         	}
        });			
	},
	reExecute:function(){
		var that = this;
		var r = [];
		r = this.getSelectionModel().getSelections();
		if (r.length == 0) {
			Ext.Msg.alert('系统提示', blankStr + '请选择记录!' + blankStr);
			return;
		}
		var hisIds=[];
		for (var i = 0; i < r.length; i++) {
			if(r[i].data.execStatus==0) {
				hisIds[i]=r[i].data.hisId;
			}
		}
		if (hisIds.length == 0) {
			Ext.Msg.alert('系统提示', blankStr + '没有符合需要重新生成的记录!' + blankStr);
			return;
		}
		Ext.MessageBox.confirm('系统提示:', '你确定要重新生成吗？', function(btn) {
			if (btn == 'yes') {
				QueryAutoRptHisManager.reEexecute(hisIds, function(data) {
					if (data) {
						Ext.MessageBox.alert("系统提示:",blankStr + "重新生成成功!" + blankStr);																					
						that.store.reload();
					}
					else{	
						Ext.MessageBox.alert("系统提示:",blankStr + "重新生成失败!" + blankStr);
					}
				});
			}
		});
	 },
	 onRightMenuClick: function(grid, index, event) {	//右键点击弹出菜单
	 	event.preventDefault();
		this.getSelectionModel().selectRow(index); 
		this.rightClick.showAt(event.getXY());
	 },
	 onMoreClick: function() {
	 	parent.mainPanel.loadMenu(parent.queryMainMenu);
	 },
	 formatStyle: function(val){
	 	if(val==1)
	 		return "执行成功";
	 	else
	 		return '<span style="color:red;">' + '执行失败' + '</span>';
	 },
	formatTime : function(val) {
		if(val!= null)
			return formatDate(new Date(val["time"]),"yyyy年MM月dd日HH:mm");
	}
});

/*panel = new Ext.ux.OFCPanel({
       collapsible : true,
       floating:false,
       autoScroll : true,
       id       : 'chartpanel',
       chartURL : 'open-flash-chart.swf',
       dataURL  : 'data-3.txt',
       mediaMask  : {msg:'Loading Chart Object'},
       autoMask  : true,
       width: 450,
       height: 300,
       listeners :{
           show  : function(p){
               if(p.floating)p.setPosition(p.x||10,p.y||10);
               }
       },
       bbar: ['-',{ text: '刷新', tooltip:'刷新查看最新的告警条数', iconCls: 'refreshxp', handler: this.onRefreshClick ,scope: this},
            	'->',{text: '更多...', tooltip: '查看更多的告警信息', iconCls: 'more', handler: this.onMoreClick, scope:this}
       ]
  });
  panel.show();
  Ext.EventManager.on(window,   "beforeunload",  function(){
       Ext.destroy( view, panel);
       } ,window ,{single:true});*/

