/*
 * 在这里，规定菜单基本数据格式： id: 表示标识 text: 显现名字
 * 
 * isHead: 是否为头（即在菜单条上） "true" isParent: 是否是父菜单 "true" childs: 子菜单集 url: 对应页面
 * 注意：在菜单条上菜单项定义，需用isHead、childs，无需isParent
 * 具体菜单，如还包括子菜单需isParent和childs，无子菜单只使用url 所有菜单项都可以包括URL
 */
var menu_data = null;

/*
 * 定义菜单条-菜单集变量
 */
var tbar = new Array();
var STYLE_STORE_DATA = [{
			'id' : 'default',
			'name' : '默认'
		}, {
			'id' : 'midnight',
			'name' : '蓝黑色'
		}, {
			'id' : 'slate',
			'name' : '灰色'
		}, {
			'id' : 'olive',
			'name' : '草绿色'
		}, {
			'id' : 'purple',
			'name' : '粉色'
		}, {
			'id' : 'indigo',
			'name' : '深蓝色'
		}, {
			'id' : 'darkgray',
			'name' : '浅黑色'
		}, {
			'id' : '2brave',
			'name' : '蓝黄色'
		}, {
			'id' : 'calista',
			'name' : '绿黄色'
		}];
var styleStore = new Ext.data.Store({
			proxy : new Ext.data.MemoryProxy(STYLE_STORE_DATA),
			reader : new Ext.data.JsonReader({}, [{
								name : 'id'
							}, {
								name : 'name'
							}])
		});
styleStore.load();

var styleCssValue;

var styleCombo = new Ext.form.ComboBox({
			emptyText : '默认',
			isFormField : true,
			width : 80,
			mode : 'local',
			// allowBlank: false,
			// blankText:'请选择...',
			forceSelection : true,
			triggerAction : 'all',
			displayField : "name",
			valueField : "id",
			store : styleStore,
			readOnly : true,
			listeners : {
				'select' : {
					fn : styleSelect
				}
			},
			value : 'default'
		});
var count = 0;
var selfMenu = new Ext.menu.Menu({
			items : [{
				text : '修改资料',
				iconCls : 'userInfo',
				handler : function() {
					LogInManager.getLogInUserInfo(function(data) {
								if (data) {
									updateUserWindow.show();
									var jData = Ext.decode(data);
									if(count == 0){
									   updateUserWindow.userForm.getForm().setValues(jData);
									   count ++;
									}
								} else {
									Ext.MessageBox.alert('系统提示',
											"获得用户资料时出错，请重试！");
								}
							});
				}
			}, {
				text : '修改密码',
				iconCls : 'password',
				handler : function() {
					changePswdDlg.show();
				}
			}]

		});

/*
 * 初始化菜单
 */
function initMenu() {

	// 我的工作室菜单项
	var startMenuItem = {
		id : "start_panel",
		text : "我的工作室",
		url : "start.jsp"
	};
	var menuData = menu_data;
	for (var i = 0; i < menuData.length; i++) {
		if (menuData[i].isHead === 'true') {
			var m = menuData[i];
			var menu = null;
			
			if (typeof(menuData[i].childs) != 'undefined')
				menu = createChildMenu(m.childs);
			if(menu==null) continue ;//如果用户对此菜单没有权限，就不显示
			var iconCls = getIconCls(m);
			//在安全管理菜单下增加个人信息子菜单
			if(m.id == 'menu_2001' || m.text=='系统管理'){
				var menuItem = new Ext.menu.Item({
						text : "个人信息",
						menu : selfMenu
					});
				menu.add(menuItem);
			}
			
			tbar.push({
				id : m.id,
				text : m.text,
				menu : menu,
				iconCls: iconCls
					// assign menu by instance
				}, '-'); // 分隔符
		}
	}

	//tbar.push('->', '&nbsp;&nbsp;', '风格：', styleCombo);
	tbar.push('->', '&nbsp;&nbsp;');//代替前一行，屏蔽 风格切换09/11/16yhzhang
	tbar.push('-', {
				text : '我的工作室',
				disabled : false,
				id : 'start_btn',
				iconCls : 'homepage',
				enableToggle : true,
				toggleHandler : function(item, pressed) {
					mainPanel.loadMenu(startMenuItem);
				}
			});

/*	tbar.push('-', {
		iconCls : 'update',
		text : "个人信息",
		menu : selfMenu
			// assign menu by instance
		}); // 分隔符
	
	 * tbar.push('-',{ text: '修改资料', iconCls: 'password', enableToggle: true,
	 * toggleHandler : function(item, pressed){
	 * LogInManager.getLogInUserInfo(function(data) { if(data) {
	 * updateUserWindow.show(); var jData = Ext.decode(data);
	 * updateUserWindow.userForm.getForm().setValues(jData); } else {
	 * Ext.MessageBox.alert('系统提示',"获得用户资料时出错，请重试！"); } }); } });
	 * tbar.push('-',{ text: '修改密码', iconCls: 'password', enableToggle: true,
	 * toggleHandler : function(item, pressed){ changePswdDlg.show(); } });
	 */
	tbar.push('-', {
				text : '注销',
				iconCls : 'logout',
				enableToggle : true,
				toggleHandler : function(item, pressed) {
					Ext.MessageBox.confirm('退出', '您是否确定退出系统?', function(btn) {
								if (btn == 'yes') {
									LogoutManager.logout(logoutCallback);
								}
							});
				}
			}, '-');
}

/*
 * 建立子菜单 ymiao
 */
function createChildMenu(menuData) {

	var menu = new Ext.menu.Menu();
	for (var i = 0; i < menuData.length; i++) {
		var menuItem = null;
		
		if (typeof(menuData[i].isParent) === 'undefined') {
			var disabled = false;
			dwr.engine.setAsync(false);
			UserInfoManager.findCapaByMenuId(menuData[i].id, function(data) {
				if(data == 0) {disabled = false;}//判断如果没有权限的话，直接不显示
				else if(data == 1) disabled = true;
				else if(data == 2) window.location.href = 'login.jsp';
			});
			dwr.engine.setAsync(true);
			
			menuItem = new Ext.menu.Item({
						id : menuData[i].id,
						text : menuData[i].text,
						url : menuData[i].url,
						handler : onMenuItemClick,
						disabled:disabled
					});
			// menuItem.on('click', onMenuItemClick);
		} else if (menuData[i].isParent === 'true') {
			menuItem = new Ext.menu.Item({
						id : menuData[i].id,
						text : menuData[i].text
					});
			var sMenu = createChildMenu(menuData[i].childs);
			menuItem.menu = sMenu;
		}
		if(menuItem.disabled==true) continue ;
		menu.addItem(menuItem);
	}
	//LS增加两个事件来处理生成的shim的大小和位置，以及移除shim
		menu.on("hide",function(menu){
            closeShim();
        });
		menu.on("show",function(menu){
           closeShim();
            var winEl = menu.getEl();
		   // var position =new Array();
		   // position = winEl.getPosition(true);
		             createShim({   
		                 top:winEl.getY(),   
		                 left:winEl.getX(), 
		                 width:winEl.getWidth(),   
		                 height:winEl.getHeight()  
		            });
        });
        
	return menu;
}

//LS创建垫片效果iframe遮罩层
  function createShim(coordinate) { 
       closeShim();
          var shimmer = document.createElement('iframe');   
          shimmer.id='shimmer';   
          shimmer.style.position='absolute';   
          shimmer.style.top=coordinate.top;   
          shimmer.style.left=coordinate.left;   
          shimmer.style.width=coordinate.width;   
          shimmer.style.height=coordinate.height;   
          shimmer.style.zIndex='999';   
          shimmer.setAttribute('frameborder','0');   
         // shimmer.setAttribute('src','javascript:false;');  
          document.body.appendChild(shimmer);   
  } 
       //LS移除iframe遮罩层   
      function closeShim(){
        var shimmer = document.getElementById('shimmer')   
         if(shimmer){
         document.body.removeChild(shimmer);
         }
      }

function onMenuItemClick(menuItem) {
	var menuId = menuItem.id;
	var style = styleCombo.getValue();
	UserInfoManager.findCapaByMenuId(menuId, function(data) {
		if (data == 0) {
			mainPanel.loadMenu(menuItem);
		} else if (data == 1) {
			Ext.MessageBox
					.alert('系统提示：',
							'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;你没有此页面的权限,请联系管理员配置！');
		} else if (data == 2) {
			Ext.MessageBox
					.alert('系统提示：',
							'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;登录超时，请您重新登录，谢谢！');
			window.location.href = 'login.jsp';
		}
	});
}

/**
 * 风格选择
 */
function styleSelect(combo) {
	var optionValue = combo.getValue();
	if (optionValue == "default") {
		changeStyleFunc("ext-all.css");
		changeChildStyle("ext-all");
		styleCssValue = "ext-all.css";
	} else {
		changeStyleFunc("xtheme-" + optionValue + ".css");
		changeChildStyle("xtheme-" + optionValue);
		styleCssValue = "xtheme-" + optionValue + ".css";
	}
}

/**
 * 修改子窗口(iframe)下的样式
 * 
 * @param {}
 *            style
 */
function changeChildStyle(style) {
	//window.frames['frame_start_panel'].changeStyle(style);
	window.frames['frame_start_panel'].frames['MyWorkFrame'].changeStyle(style);
	//规则配置页面样式
	if(window.frames['frame_menu_1301']!= undefined){
		window.frames['frame_menu_1301'].frames['treeFrame'].changeStyle(style);
		window.frames['frame_menu_1301'].frames['queryFrame'].changeStyle(style);
	}
	
	for (var i = 0; i < window.frames.length; i++) {
		if (window.frames[i] && window.frames[i].changeStyle) {
			window.frames[i].changeStyle(style);
			if (window.frames[i].frames && window.frames[i].frames.length) {
				/*for (var j = 0; j < window.frames[i].frames.length; j++) {
					window.frames[i].frames[j].changeStyle(style);					
				}*/
			}
		}
	}
	
}

/**
 * 修改主框架的样式并且进行cookie保存
 * 
 * @param {}
 *            style
 */
function changeStyleFunc(style) {
	Ext.util.CSS.swapStyleSheet("theme", "resources/css/" + style);
	Ext.state.Manager.set("extCss", style);
	var expDate = new Date();
	expDate.setTime(expDate.getTime() + 60 * 60 * 1000 * 30);
	setCookie("extCss", style, expDate, "/");
}

/**
 * 设置cookie
 * 
 * @param {}
 *            name -> cookie名称
 * @param {}
 *            value -> cookie值
 * @param {}
 *            expires ->有效期
 * @param {}
 *            path
 * @param {}
 *            domain
 * @param {}
 *            secure
 */
function setCookie(name, value, expires, path, domain, secure) {
	document.cookie = name + "=" + escape(value)
			+ ((expires) ? "; expires=" + expires.toGMTString() : "")
			+ ((path) ? "; path=" + path : "")
			+ ((domain) ? "; domain=" + domain : "")
			+ ((secure) ? "; secure" : "");
}

function getIconCls(menu) {
	//系统上线后一般菜单的ID很少变动暂时做成静态配置,如有需要再行改动
	/*
	 * 菜单图标动态配置方案
	 * 1.在menu_info增加样式字段IconCls varchar2(20)
	 * 2.菜单管理页面增加填写菜单样式字符串，如：gggl 或者直接系统数据库初始化时候一次导入
	 * 3.改下下面的方法根据菜单ID（menu.id）取menu_info.IconCls字段的值返回
	 */
	if(menu.id == 'menu_2010' || menu.text == '公告管理') return 'gggl';
	if(menu.id == 'menu_2001' || menu.text == '系统管理') return 'aqgl';
	if(menu.id == 'menu_1004' || menu.text == '服务监控') return 'ssjk';
	if(menu.id == 'menu_1002' || menu.text == '服务注册') return 'gdgl';
//	if(menu.id == 'menu_1006' || menu.text == '系统维护') return 'xtgl';
	if(menu.id == 'menu_1005' || menu.text == '综合查询') return 'gzpz';
	if(menu.id == 'menu_1003' || menu.text == '服务消息管理') return 'pzgl';
	if(menu.id == 'menu_11111331' || menu.text == '告警管理') return 'xtgl';
	if(menu.id == 'menu_11111491' || menu.text == '拓扑管理') return 'tjfx';
	if(menu.id == 'menu_11111731' || menu.text == '互联模块') return 'hlmk';
	if(menu.id == 'menu_11111851' || menu.text == '互联控制中心')return 'kzzx';
}