function handleMaximize(event, toolEl, panel) {
    panel.originalOwnerCt = panel.ownerCt;
    panel.originalPosition = panel.ownerCt.items.indexOf(panel);
    panel.originalSize = panel.getSize();

    if (!toolEl.window) {
        var defaultConfig = {
            id : (panel.getId() + '-MAX'),
            width : (Ext.getBody().getSize().width - 400),
            height : (Ext.getBody().getSize().height - 200),
            resizable : true,
            draggable : true,
            closable : true,
            closeAction : 'hide',
            hideBorders : true,
            modal: true,
            plain : true,
            layout : 'fit',
            autoScroll : false,
            border : false,
            bodyBorder : false,
            frame : true,
            pinned : true,
            bodyStyle : 'background-color: #ffffff;'
        };
        toolEl.window = new Ext.Window(defaultConfig);
        toolEl.window.on('hide', handleMinimize, panel);
    }
    if (!panel.dummyComponent) {
        var dummyCompConfig = {
            title : panel.title,
            width : panel.getSize().width,
            height : panel.getSize().height,
            html : '&nbsp;'
        };
        panel.dummyComponent = new Ext.Panel(dummyCompConfig);
    }

    toolEl.window.add(panel);
    if (panel.tools['toggle'])
        panel.tools['toggle'].setVisible(false);
    if (panel.tools['close'])
        panel.tools['close'].setVisible(false);
    panel.tools['maximize'].setVisible(false);

    panel.originalOwnerCt.insert(panel.originalPosition,
            panel.dummyComponent);
    panel.originalOwnerCt.doLayout();
    panel.dummyComponent.setSize(panel.originalSize);
    panel.dummyComponent.setVisible(true);
    panel.dummyComponent.getEl().mask('已被最大化');
    toolEl.window.show(this);
}

function handleMinimize(window) {
    this.dummyComponent.getEl().unmask();
    this.dummyComponent.setVisible(false);
    this.originalOwnerCt.insert(this.originalPosition, this);
    this.originalOwnerCt.doLayout();
    this.setSize(this.originalSize);
    this.tools['maximize'].setVisible(true);
    if (this.tools['toggle'])
        this.tools['toggle'].setVisible(true);
    if (this.tools['close'])
        this.tools['close'].setVisible(true);
}
