/**
 * @description 这里定义整个系统中通用功能
 * @author pbqi
 * @created on 2009年12月23日11:10:53
 */
 
/**
 * 这里定义整个系统及系统各个模板的命名空间
 * 需要时，可以在这里对新增加模块增加新的命名空间
 * 这样做的好处是：1.为了对各个模块更好的管理
 *               2.避免相同变量之间的冲突
 */
Ext.ns("Starit", "Starit.security", "Starit.officfg");

/**
 * 对Starit整个全局变量添加对整个系统都需要用到的属性和方法
 */
(function() {
    var padBlank = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    
    Ext.apply(Starit, {
        /**
         * 补充的空白字符串,在弹出提示框的时候会用到。
         */
        padBlank: padBlank,
        /**
         * 载入标识
         */
        LOAD_FLAG: 0,
        /**
         * 查询载入标识
         */
        QUERY_FLAG: 1,
        /**
         * 增加标识
         */
        ADD_FLAG: 'add',
        /**
         * 修改标识
         */
        UPDATE_FLAG: 'update',
        /**
		 * @description: 生成图形报表(线图、条形图)需要的XML数据(json数据转换为xml数据)
		 * @params caption 标题
		 * @params seriesNames{Array} 系列
		 * @params dataArray{Array} 数值\
         * @return
		 */
        getChartsXmlData: function(caption, seriesNames, dataArray) {
            var xmlData = "<graph caption='" + caption + "'>";
		    var len = dataArray.length;
		    // 种类(查询结果记录数)
		    xmlData += "<categories>";
		    for (var i = 0; i < len; i++) {
		        xmlData += "<category name='" + dataArray[i][0] + "' />";
		    }
		    xmlData += "</categories>";
		
		    // 为各个系列的每个种类设值(各个参数每条记录对应的值)
		    var seriesNamesLen = seriesNames.length;
		    if (seriesNamesLen === 0 || seriesNamesLen === 1) {
		        var seriesName = '';
		        xmlData += "<dataset seriesName='" + seriesName + "'>";
		        for (var j = 0; j < len; j++) {
		            xmlData += "<set value='" + dataArray[j][1] + "' color='"
		                    + this.getRandomColor() + "'/>";
		        }
		        xmlData += "</dataset>";
		    } else {
		        for (var i = 0; i < seriesNamesLen; i++) {
		            xmlData += "<dataset seriesName='" + seriesNames[i] + "' color='"
		                    + this.getRandomColor() + "'>";
		            for (var j = 0; j < len; j++) {
		                xmlData += "<set value='" + dataArray[j][i + 1] + "'/>";
		            }
		            xmlData += "</dataset>";
		        }
		    }
		    xmlData += "</graph>";
		    return xmlData;
        },
        
        /**
         * @description: 生成图形报表(饼图)需要的XML数据(json数据转换为xml数据)
         * @params caption 标题
         * @params seriesNames{Array} 系列
         * @params dataArray{Array} 数值
         */
        getPieChartXmlData: function(caption, seriesNames, dataArray) {
            var seriesNamesLen = seriesNames.length;
		    var len = dataArray.length
		    var xmlData = "";
		    if (seriesNamesLen === 0 || seriesNamesLen === 1) {
		        var seriesName = '';
		        xmlData += "<graph caption='" + caption
		                + "' showNames='1' showPercentageValues='0' showPercentageInLabel='1' decimalPrecision='2'>";
		        for (var i = 0; i < len; i++) {
		            xmlData += "<set name='" + dataArray[i][0] + "' value='" + dataArray[i][1] + "' color='" + this.getRandomColor() + "'/>"
		        }
		        xmlData += "</graph>+";
		    } else {
		        for (var i = 0; i < seriesNamesLen; i++) {
		            xmlData += "<graph caption='" + caption + "-" + seriesNames[i]
		                    + "' showNames='1' showPercentageValues='0' showPercentageInLabel='1' decimalPrecision='2'>";
		            for (var j = 0; j < len; j++) {
		                xmlData += "<set name='" + dataArray[j][0] + "' value='" + dataArray[j][i + 1] + "' color='" + this.getRandomColor()
		                        + "'/>"
		            }
		
		            xmlData += "</graph>+";
		        }
		    }
		    return xmlData;
        },
        
        /**
         * 随机生成颜色
         * @return {String}
         */
        getRandomColor: function() {
            return '#' + (Math.random() * 0xffffff << 0).toString(16);
        }
    });
})();