/**
 * @description 这里定义整个系统中通用功能
 * @author pbqi
 * @created on 2009年12月23日11:10:53
 */
 
/**
 * 这里定义整个系统及系统各个模板的命名空间
 * 需要时，可以在这里对新增加模块增加新的命名空间
 * 这样做的好处是：1.为了对各个模块更好的管理
 *               2.避免相同变量之间的冲突
 */
Ext.ns("Starit", "Starit.security");

/**
 * 对Starit整个全局变量添加对整个系统都需要用到的属性和方法
 */
(function() {
    var padBlank = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    
    Ext.apply(Starit, {
        /**
         * 补充的空白字符串,在弹出提示框的时候会用到。
         */
        padBlank: padBlank
    });
    
    
})();

/**
 * 提供一些通用的field的配置
 */
 //生成一个通用的TextField
Starit.createTextField = function(fieldLabel, name, anchor, blankText, vtype, maxLength, maxLengthText) {   
    var tf = new Ext.form.TextField({
        fieldLabel: fieldLabel,
        name: name,
        xtype: 'textfield',
        readOnly: false,
        allowBlank: false,
        anchor: anchor,
        blankText: '该选项为必填项,请输入内容...',
        vtype: vtype,
        maxLength: maxLength,
        maxLengthText: maxLengthText
    });
    return tf;
};

//生成一个通用的ComboBox
Starit.createCombo = function(fieldLabel,id,name,anchor,url,extra1,extra2) {   
        var combo = new Ext.form.ComboBox({
            autoLoad: true,
            fieldLabel: fieldLabel,
            emptyText: '请选择...',
            isFormField: true,
            anchor: anchor,
            mode: 'local',
            name:id,
            allowBlank: false,
            blankText:'请选择...',
            lastQuery: '',
            triggerAction: 'all',
            displayField:name,
            valueField:id,
            store: new Ext.data.Store({
                proxy: new Ext.data.HttpProxy({url: url, method: 'POST'}),
                reader: new Ext.data.JsonReader({},new Ext.data.Record.create([{name:id},{name:name},{name:extra1},{name:extra2}]))
            }),
            readOnly: true
        });
        return combo;
};

Starit.createMemoryCombo = function(jsonData) {
         var combo = new Ext.form.ComboBox({
            emptyText: '请选择...',
            isFormField: true,
            mode: 'local',
            name: "id",
            blankText:'请选择...',
            width: 100,
            triggerAction: 'all',
            displayField:"name",
            valueField:"id",
            store: new Ext.data.Store({
                proxy: new Ext.data.MemoryProxy(jsonData),
                reader: new Ext.data.JsonReader({},new Ext.data.Record.create([{name:"id"},{name:"name"}]))
            }),
            readOnly: true
        });
        return combo;
    }
Starit.createSelector = function(valueField, displayField, fromStore, toStore) {
    var selector = new Ext.ux.ItemSelector({ 
           isFormField: false,
           hideLabel: true,
           msWidth: 265,
           autoScroll:true,
           msHeight: 300,
           valueField: 'instanceId',
           displayField: 'userLabel',
           imagePath: '../resources/images/query',
           fromStore: fromStore,
           toStore: toStore
       });
       return selector;
};

Starit.createButton = function(text,fn,scope,iconCls) {
    var btn = new Ext.Button({
        text: text,
        handler: fn,
        scope: scope,
        iconCls: iconCls
    });
    return btn;
};

Starit.createDateField = function(fieldLabel, name, format, anchor, value) {
        var df =  new Ext.form.DateField({
            fieldLabel: fieldLabel,
            name: name,
            value : value,
            anchor: anchor,
            format: format
        });
        return df;
    }

Starit.createHidden = function(name) {
    var hn = new Ext.form.Hidden({
        name: name
    });
    return hn;
};

Starit.createTextArea = function(fieldLabel,name,height,anchor) {
    var ta = new Ext.form.TextArea({
        fieldLabel:fieldLabel,
        name:name,
        height:height,
        anchor:anchor,
        allowBlank: false,
        blankText: '该选项为必填项,请输入内容...'
    });
    return ta;
};


/**
 * @description: 用户信息管理
 * @author: pbqi
 * @created on 2009年12月23日10:34:02
 * @modified on 2009年12月24日10:34:46
 */

Starit.CommonForm = Ext.extend(Ext.form.FormPanel, {

    constructor : function(cfg) {

        // 把一个对象中的属性拷贝到当前对象中
        cfg = cfg || {};
        Ext.apply(this, cfg);
        
        this.initCfgParams();
        
        Starit.CommonForm.superclass.constructor.call(this, {
            frame: true,
            border: false,
            bodyStyle:"padding: 20px 5px 0 20px",
            labelWidth : this.labelWidth || 60,     //默认为60
            labelAlign: 'right',
            layout: 'form',                         //"form"布局
            tbar: new Ext.Toolbar({
                items:[
                    {text: "刷新", iconCls: 'refresh', handler: this.doSave, scope:this},
                    {text: "关闭", iconCls: 'close', handler: this.doClose, scope:this}
                ]
            })
        });
    },
    /**
     * 可以看做一个抽象方法需要实现
     * 初始化配置参数
     */
    initCfgParams: function() {},
    
    /**
     * private
     * @param {String} html 要输入的用户提示信息
     * @param {Object} o 
     * 初始化参数配置 默认布局为'form'
     * 若是'column' 布局, 需要配置 
     * 配置项 fields: [fields, field2, .........],
     * 列号  columnNum : 2 表明为2列
     */
    initConfig: function(html, o) {
        this.items = [];
        
        var layoutx = o.layout || "form";
        var itemLen = o.fields.length;
        
        if(layoutx == "form") {         //form布局
            this.items = o.fields;
        }
        if(layoutx == "column") {       //column布局
            var columnItems = [];
            
            var columnNum = o.columnNum || 2;
            if(columnNum > itemLen) {
                throw new Error("列的配置列数columnNum>fields的长度,应该小于或者等于.");
            }
            
            var columnW = 0.66 / columnNum;
            var avg = Math.floor(itemLen / columnNum);
            var remainder = itemLen % columnNum;
            
            var j = 0;
            
            var bakAvg = avg;
            for(var i = 0; i < columnNum; i++) {
                var fs = [];
                for(; j < avg; j++) {
                    fs.push(o.fields[j]);
                }
                if(remainder > 0) {
                    fs.push(o.fields[j++]);
                    remainder--;
                }
                columnItems.push({
                    xtype: 'panel',
                    columnWidth: columnW,
                    layout: 'form',
                    items: fs
                });
                
                avg = bakAvg + j;
            }
            this.items = [{
                xtype: 'panel',
                layout: 'column',
                items: columnItems
            }];
        }
        this.items.unshift({
            xtype:'panel',
            html:html,
            width:358,
            border:false,
            style:'border-bottom:1px solid #3674A7;margin:5px 0px 20px 17px;font-size:12px;font-weight:bold;'
        });
    }
});


/**
 * @description: 通用的Grid
 * @author: pbqi
 * @created on 2009年12月23日10:34:02
 * @modified on 2009年12月24日10:34:46
 */

Starit.CommonGrid = Ext.extend(Ext.grid.GridPanel, {
    
    isPaging: true,         //是否分页,默认为 true.
    isRowNumberer:true,     //是否有行号,默认为true. 
    isCheckBoxSelectionModel: false,//选择模式是否为checkBox默认为false
    isSingleSelect: false,          //选择模式是否为单选
    
    constructor: function(cfg) {
        
        //把一个对象中的属性拷贝到当前对象中
        cfg = cfg || {};
        Ext.apply(this, cfg);
        
        this.initCfgParams();    //初始化需要配置的参数
        this.initQueryField();   //初始化查询条件组件
        this.rightMenu = new Ext.menu.Menu({
            items: [
                {text: '添加',iconCls: 'new', handler: this.doRigthSave,scope: this},
                {text: '修改',iconCls: 'update',handler: this.onResumeClick,scope: this},
                {text: '删除',iconCls: 'delete',handler: this.onDeleteClick,scope: this},'-',
                {text: '刷新',iconCls: 'refresh',handler: this.doMoveUser,scope: this},'-',
                {text: '高级查询',iconCls: 'find',handler: this.onRePswClick,scope: this},'-',
                {text:'导入',iconCls: 'import',handler:this.doQuery,scope:this},
                {text:'打印',iconCls: 'print',handler:this.doPrint,scope:this},
                {text:'excel导出',iconCls: 'excel',handler:this.doExcel,scope:this},
                {text:'条形图',iconCls: 'bar',handler:this.doBarChart,scope:this},
                {text:'线图',iconCls: 'line',handler:this.doLineChart,scope:this},
                {text:'饼图',iconCls: 'pie',handler:this.doPieChart,scope:this}
            ]
        });
        
        Starit.CommonGrid.superclass.constructor.call(this, {
            frame: true,
            height: 300,
            width: 800,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            tbar: new Ext.Toolbar({
                items:['-',
                    {text:'添加',iconCls: 'new', handler:this.doAdd,scope:this},'-',
                    {text:'修改',iconCls: 'update',handler:this.doModify,scope:this},'-',
                    {text:'删除',iconCls: 'delete',handler:this.doDelete,scope:this},'-',
                    '名称：',this.trigger,'-',
                    {text:'',iconCls: 'refresh',handler:this.doRefresh,scope:this},'-',
                    {text:'高级查询',iconCls: 'find',handler:this.doQuery,scope:this},'->',
                    {text:'',iconCls: 'import',handler:this.doQuery,scope:this},'-',
                    {text:'',iconCls: 'print',handler:this.doPrint,scope:this},'-',
                    {text:'',iconCls: 'excel',handler:this.doExcel,scope:this},'-',
                    {text:'',iconCls: 'bar',handler:this.doBarChart,scope:this},'-',
                    {text:'',iconCls: 'line',handler:this.doLineChart,scope:this},'-',
                    {text:'',iconCls: 'pie',handler:this.doPieChart,scope:this}
                ]
            }),
            listeners: {
                'rowcontextmenu': {fn: this.onRowContextmenu, scope: this}
            }
        });
    },
    doRigthSave: function() {
        this.doAdd();
    },
    /**
     * 右键菜单
     */
    onRowContextmenu: function(grid, rowIndex, e)  {
        this.getSelectionModel().selectRow(rowIndex);
        e.preventDefault();
        this.rightMenu.showAt(e.getXY());
    },
    /**
     * 这里可以看做一个抽象方法，需要实现
     * 增加
     */
    doAdd: function() {},
    /**
     * 这里可以看做一个抽象方法，需要实现
     * 修改
     */
    doModify: function() {},
    /**
     * 这里可以看做一个抽象方法，需要实现
     * 删除
     */
    doDelete: function() {},
    /**
     * 刷新，需要在store.load时传递参数传到可以覆盖此方法
     */
    doRefresh: function() {
        this.store.load();
    },
    /**
     * 这里可以看做一个抽象方法，需要实现
     * 查询
     */
    doQuery: function() {},
     /**
     * 这里可以看做一个抽象方法，需要实现
     * excel导出
     */
    doExcel: function(){},
     /**
     * 这里可以看做一个抽象方法，需要实现
     * 柱状图查看
     */
    doBarChart: function(){},
     /**
     * 这里可以看做一个抽象方法，需要实现
     * 线图查看
     */
    doLineChart: function(){},
    /**
     * 这里可以看做一个抽象方法，需要实现
     * 饼图查看
     */
    doPieChart: function(){},
    /**
     * private 已实现，一般情况下，子类grid不要再次实现此方法
     * 打印当前grid的当前页
     */
    doPrint: function() {
        var that = this;
        this.printPage(that);
    },
    /**
     * 初始化配置信息
     * 这里可以看做一个抽象方法，需要实现
     * 例如:
     *  this.isCheckBoxSelectionModel = true;
     *  this.isPaging = false;
     *  this.initConfig({
     *      url: 'test.json',
     *      dataField: ["name", "age"],
     *      columnParams:[
     *           {header: '用户名称', dataIndex: 'name', width: 90},
     *           {header: '年龄', dataIndex: 'age', width: 90}
     *       ]
     *   });
     */
    initCfgParams: function() {},
    /**
     * 初始化查询一般条件组件
     */
    initQueryField: function() {
        var that = this;
        this.trigger = new Ext.form.TriggerField({
            width:150,
            triggerClass:'x-form-search-trigger',
            listeners:{
                'render': function() {
                    Ext.select(".x-form-search-trigger").on('click',that.doQuery);
                }
            }
        });
    },
    /**
     * public 初始化grid中需要配置的参数
     */
    initConfig: function(o) {
        this.initSm();
        this.store = this.initStore(o.url, o.dataField);
        this.initColumn(o.columnParams);
        this.initPagingBar();
    },
    /**
     * private
     * 配置Grid中的数据源store
     */
    initStore: function(url, dataField) {
        var s = new Ext.data.Store({          
            proxy: new Ext.data.HttpProxy({url: url, method: 'POST'}),
            reader: this.initReader(dataField)
        });
        return s;
    },
    /**
     * private
     * 配置grid中的列
     * @params:columnParams {Array}列的参数数组
     * 
     */
    initColumn: function(columnParams) {
        if(this.isCheckBoxSelectionModel) {
            columnParams.unshift(this.sm);
        }
        if(this.isRowNumberer) {
            columnParams.unshift(new Ext.grid.RowNumberer());
        }
        this.cm = new Ext.grid.ColumnModel(columnParams);
    },
    /**
     * private
     * 如果配置isPaging为true时，增加分页工具条
     * @params pageSize{Number} 分页的个数 默认为10
     */
    initPagingBar: function(pageSize) {
        if(this.isPaging) {
            this.bbar = new Ext.PagingToolbar({
                pageSize:(pageSize || 10),
                store: this.store,
                displayInfo:true, 
                dsiplayMsg:'本页显示 {0} - {1},共{2}条记录',
                emptyMsg:"没有可显示的记录",
                items: [
                  "每页显示:",Starit.createMemoryCombo([{"id":1, "name":"name1"},{"id":2, "name":"name2"}])
                ]
            });
        }
    },
    /**
     * private
     * 配置选择模式
     * 配置选择模式是否为checkbox,是否为单选模式
     */
    initSm: function() {
        if(!this.isCheckBoxSelectionModel) {
            this.sm = new Ext.grid.RowSelectionModel({singleSelect: this.isSingleSelect});
        }
        this.sm = new Ext.grid.CheckboxSelectionModel({singleSelect: this.isSingleSelect});
    },
     /**
     * private
     * 配置store中的reader,分为分页和不分页两种实现方式
     * @params:dataField {Array}   如：["userID","userName"]
     * @retrun{Ext.data.JsonReader} 
     */
    initReader: function(dataField) {
        return new Ext.data.JsonReader(this.isPaging ? {totalProperty: 'totalProperty', root:'root'}: {},this.initDataField(dataField));     
    },
    /**
     * private
     * 配置store中的对应的属性字段
     * @params:dataField{Array}   如：["userID","userName"]
     * @return{Array}返回属性字段组成后的对象数组如：[{name:'userID'},{name:'userName'}]
     */
    initDataField: function(dataField) {
        if(!Ext.isArray(dataField)) {
            throw new Error("dataField is not a Array, is required a Array.");
            return;
        }
        var dfs = [];
        for(var i = 0, len = dataField.length; i < len; i++) {
            var o = {};
            o.name = dataField[i];
            dfs[dfs.length] = o; 
        }
        return dfs;
    },
    /**
     * private 打印当前grid的当前页
     * @params{Ext.grid.GridPanel} grid
     */
    printPage: function(grid) {
        var tableStr = '<table width="100%" border=1>';
        var cm = grid.getColumnModel();
        var colCount = cm.getColumnCount();
        var temp_obj = new Array();
        // 只下载没有隐藏的列(isHidden()为true表示隐藏,其他都为显示)
        // 临时数组,存放所有当前显示列的下标
        for (var i = 2; i < colCount; i++) {
            if (cm.isHidden(i) == true) {
            } else {
                temp_obj.push(i);
            }
        }
        tableStr = tableStr + '<tr><td>序号</td>';
        for (var i = 0; i < temp_obj.length; i++) {
            // 显示列的列标题
            // xlSheet.Cells(1, i).Value = cm.getColumnHeader(temp_obj[i - 1]);
            tableStr = tableStr + '<td>' + cm.getColumnHeader(temp_obj[i])
                    + '</td>';
        }
        tableStr = tableStr + '</tr>';
        var store = grid.getStore();
        var recordCount = store.getCount();
        for (var i = 0; i < recordCount; i++) {
            var r = store.getAt(i);
            tableStr = tableStr + '<tr><td>' + (i + 1) + '</td>';
            for (var j = 0; j < temp_obj.length; j++) {
                var dataIndex = cm.getDataIndex(temp_obj[j]);
                var tdValue = r.get(dataIndex);
                var rendererFunc = cm.getRenderer(temp_obj[j]);
                if (rendererFunc != null) {
                    tdValue = rendererFunc(tdValue);
                }
                if (tdValue == null) {
                    tdValue = '';
                }
                tableStr = tableStr + '<td>' + tdValue + '</td>';
            }
            tableStr = tableStr + '</tr>';
        }
        tableStr = tableStr + '</table>';
        var titleHTML = tableStr;// document.getElementById("printGridfff").innerHTML;
        var newwin = window.open('printer.jsp', '', '');
    
        newwin.document.write(titleHTML);
        newwin.document.location.reload();
        newwin.print();
        newwin.close();
    }
});

/**
 * @description: 用户信息管理Grid
 * @author: pbqi
 * @created on 2009年12月23日10:34:02
 * @modified on 2009年12月24日10:34:46
 */

Starit.CommonTree = Ext.extend(Ext.tree.TreePanel, {

    constructor : function(cfg) {

        // 把一个对象中的属性拷贝到当前对象中
        cfg = cfg || {};
        Ext.apply(this, cfg);
        
        this.initCfgParams();
        
        Starit.CommonTree.superclass.constructor.call(this, {
            autoScroll : true,
            enableDD : false,// 是否支持拖拽效果
            containerScroll : true,// 是否支持滚动条
            split : true,
            border : true,
            frame : false,
            animCollapse : false,
            animate : false,
            collapseFirst : false,
            rootVisible : true,
            collapsible : true,
            margins : '0 0 0 0',
            tbar: ['名称：',this.trigger,
                '-',{iconCls:'refresh', handler: this.doRefresh,scope:this}
            ]
        });
    },
    /**
     * 这里可以看做一个抽象方法，具体的根据具体业务查询
     * 查询
     */
    doQuery: function() {
        
    },
    /**
     * 刷新
     */
    doRefresh: function() {
        var that = this;
        this.getLoader().load(this.getRootNode(),function() {
             that.getRootNode().expand();
        });
    },
    /**
     * 初始化树的配置参数
     */
    initCfgParams: function() {
        this.loader = new Ext.tree.TreeLoader({dataUrl : this.url});
        this.root =  new Ext.tree.AsyncTreeNode({
            id : this.rootId,
            text : this.rootText,
            draggable : false,
            expanded : true
        });
        this.initQueryField();
    },
    initQueryField: function() {
        var that = this;
        this.trigger = new Ext.form.TriggerField({
            width:150,
            triggerClass:'x-form-search-trigger',
            listeners:{
                'render': function() {
                    Ext.select(".x-form-search-trigger").on('click',that.doQuery);
                }
            }
        });
    }
});

/**
 * @description:通用viewPort布局
 * @author: pbqi
 * @created on 2010年1月6日15:24:54
 * @modified on 2010年1月6日15:24:59
 */

Starit.CommonViewport = Ext.extend(Ext.Viewport, {
    
    constructor: function() {
        
        this.initCfgParams();
        
        Starit.CommonViewport.superclass.constructor.call(this, {
            layout:'border'
        });
    },
    
    /**
     * 可以看做一个抽象方法，
     * 需要在其子类中实现此方法。
     */
    initCfgParams: function() {},
    
    /**
     * 配置viewport中的各个组件
     * @param {Object} o
     * example: var o = {
     *      tree: tree,                 //可选
     *      upper: [grid],              //必选
     *      under: [grid, form, tree]   //必选
     * }
     * 
     */
    initConfig: function(o) {
        
        this.items = [];
        var upperTab, underTab;
        
        if(o && o.tree) {
            this.items.push(o.tree); 
        }
         if(o && o.upper) {
            upperTab = this.createTab(o.upper, "center");
        }
        if(o && o.under) {
           underTab = this.createTab(o.under, "south");
        }
        this.items.push(
            new Ext.Panel({
                autoScroll: true,
                border: true,
                frame: true,
                region: 'center',
                layout: 'border',
                split: true,
                buttons: [
                    {text: '确定'}, {text: '取消'}
                ],
                buttonAlign: 'center',
                items: [upperTab, 
                    new Ext.Panel({
                         collapsible: true,
                         title: '涛涛',
                         border: true,
                         frame: true,
                         layout: 'fit',
                         region: 'south',
                         height: 300,
                         split: true,
                         items: [underTab]
                    })
               ]
            })
        );
       
    },
    /**
     * private 生成一个tab
     * @param {} items
     */
    createTab: function(items, region) {
        var tab = new Ext.TabPanel({
            region: region,
            frame: false,
            height: 250,
            border: false,
            layoutOnTabChange:true,
            activeTab: 0,
            items: items
        });
        return tab;
    }
});

