/**
 * @description: 用户信息管理Grid
 * @author: pbqi
 * @created on 2009年12月23日10:34:02
 * @modified on 2009年12月24日10:34:46
 */

Starit.security.UserGrid = Ext.extend(Ext.grid.GridPanel, {
    
    userStore:null,         //配置的数据源store
    
    constructor: function(cfg) {
        
        //把一个对象中的属性拷贝到当前对象中
        cfg = cfg || {};
        Ext.apply(this, cfg);
        
        this.init();    //初始化需要配置的参数
        
        Starit.security.UserGrid.superclass.constructor.call(this, {
            //renderTo: 'UserGrid',
            //title: '用户信息 管理',  
            isPaging: true,         //是否分页,默认为 true.
            isRowNumberer:true,     //是否有行号,默认为true. 
            isCheckBoxSelectionModel: false,//选择模式是否为checkBox默认为false
            isSingleSelect: false,          //选择模式是否为单选
            url: '',
            dataField: [],
            columnParmas:[],
            //frame: true,
            //width: Ext.getBody().getViewSize().width - 2,
            //height: Ext.getBody().getViewSize().height - 2,
            //pageSize: 10,
            viewConfig: {
                forceFit: true
            },
            loadMask: {
                msg : '正在载入数据,请稍候...'
            },
            //sm: new Ext.grid.RowSelectionModel({}),
            //cm: this.cm,
            tbar: new Ext.Toolbar({
                items:['-',
                    {text:'添加',iconCls: 'new', handler:this.doAdd,scope:this},'-',
                    {text:'修改',iconCls: 'update',handler:this.doModify,scope:this},'-',
                    {text:'删除',iconCls: 'delete',handler:this.doDelete,scope:this},'-',
                    {text:'刷新',iconCls: 'refresh',handler:this.doRefresh,scope:this},
                    {text:'查询',iconCls: 'find',handler:this.doQuery,scope:this},'->',
                    {text:'导入',iconCls: '',handler:this.doQuery,scope:this},'-',
                    {text:'',iconCls: 'print',handler:this.doQuery,scope:this},'-',
                    {text:'',iconCls: 'excel',handler:this.doQuery,scope:this},'-',
                    {text:'',iconCls: 'find',handler:this.doQuery,scope:this},'-',
                    {text:'',iconCls: 'find',handler:this.doQuery,scope:this},'-',
                    {text:'',iconCls: 'find',handler:this.doQuery,scope:this},'-'
                ]
            })
        });
    }, 
    /**
     * 增加
     */
    doAdd: function() {
        
    },
    /**
     * 修改
     */
    doModify: function() {
        
    },
    /**
     * 删除
     */
    doDelete: function() {
        
    },
    /**
     * 刷新
     */
    doRefresh: function() {
        
    },
    /**
     * 查询
     */
    doQuery: function() {
        
    },
    init: function() {
        //var o = {};
        this.initConfig(o || {});
    },
    /**
     * public 初始化grid中需要配置的参数
     */
    initConfig: function(o) {
        this.store = this.initStore(o.url, o.dataField);
        this.initColumn(o.columnParams);
        this.initSm();
        this.initPagingBar();
    },
    /**
     * 配置Grid中的数据源store
     */
    initStore: function(url, dataField) {
        var s = new Ext.data.Store({          
            proxy: new Ext.data.HttpProxy({url: url, method: 'POST'}),
            reader: this.initReader(dataField)
        });
        return s;
    },
    /**
     * 配置grid中的列
     * @params:columnParams {Array}列的参数数组
     * 
     */
    initColumn: function(columnParams) {
        var cm;
        if(isRowNumberer) {    //如果带行号
            columnParams = columnParams.unshift(new Ext.grid.RowNumberer());
        } 
        return new Ext.grid.ColumnModel(columnParams);
    },
    /**
     * 如果配置isPaging为true时，增加分页工具条
     * @params pageSize{Number} 分页的个数 默认为10
     */
    initPagingBar: function(pageSize) {
        if(isPaging) {
            this.bbar = new Ext.PagingToolbar({
                pageSize:(pageSize || 10),
                store: this.store,
                displayInfo:false, 
                dsiplayMsg:'本页显示 {0} - {1},共{2}条记录',
                emptyMsg:"没有可显示的记录"
            });
        }
    },
    /**
     * 配置选择模式
     * 配置选择模式是否为checkbox,是否为单选模式
     */
    initSm: function() {
        if(!isCheckBoxSelectionModel) {
            this.sm = new Ext.grid.RowSelectionModel({singleSelect: this.isSingleSelect});
        }
        this.sm = new Ext.grid.CheckBoxSelectionModel({singleSelect: this.isSingleSelect});
    },
     /**
     * private
     * 配置store中的reader,分为分页和不分页两种实现方式
     * @params:dataField {Array}   如：["userID","userName"]
     * @retrun{Ext.data.JsonReader} 
     */
    initReader: function(dataField) {
        var reader;
        if(!this.isPaging) {
            reader = new Ext.data.JsonReader({},this.initDataField(dataField)); 
        } else {
            reader = new Ext.data.JsonReader({totalProperty: 'totalProperty', root:'root'},this.initDataField(dataField)); 
        }
        return reader;
    },
    /**
     * private
     * 配置store中的对应的属性字段
     * @params:dataField{Array}   如：["userID","userName"]
     * @return{Array}返回属性字段组成后的对象数组如：[{name:'userID'},{name:'userName'}]
     */
    initDataField: function(dataField) {
        if(!Ext.isArray(params)) {
            throw new Error("配置的属性字段时，传递的参数不是数组");
            return;
        }
        var dfs = [];
        for(var i = 0, len = params.length; i < len; i++) {
            var o = {};
            o.name = params[i];
            dfs[dfs.length] = o; 
        }
        return dfs;
    }
});