/**
 * @description: 用户信息管理Tree
 * @author: pbqi
 * @created on 2009年12月23日10:34:02
 * @modified on 2009年12月24日10:34:46
 */
/**
 * 参数介绍：
 * leftCmp : 对象类型。有，则为整体布局的左侧。通常是一棵树
 * rightCmp: 数组类型。有，则为整体布局的center。对于rightCmp[i]来说，包含有如下属性：title ,upper ,under. 
 * rightCmp[i].title:字符串类型。(不必配置，是upper的title)。为rightCmp的title。
 * rightCmp[i].upper:对象类型。有，则为rightCmp的center。通常是grid. 属性：parentCmp ->指的是当前的rightCmp[i]
 * rightCmp[i].under:对象类型。有，则为rightCmp的south。包含如下属性 :cfgCmps , relCmps.
 * rightCmp[i].under.cfgCmps:数组类型。rightCmp[i].upper 的配置相关的组件。
 * rightCmp[i].under.relCmps:数组类型。rightCmp[i].upper 的配置无关，但是有关联关系的组件。 
 *    
 * 特别说明：
 * rightCmp[i].underPanel 包含rightCmp[i].underTabs。
 * rightCmp[i].underTabs  包含cfgCmps,(也可能包含)relCmps。
 * @class Starit.CommonViewport
 * @extends Ext.Viewport
 */
Starit.CommonViewport = Ext.extend(Ext.Viewport, {
	
    leftCmp:null,
    rightCmp:null,//一个数组,每一个rightCmp[i]都是一个Tab ，这个Tab包含有upper
	constructor : function() {

		this.initCfgParams();

		Starit.CommonViewport.superclass.constructor.call(this, {
					layout : 'border'
				});
	},

	/**
	 * 可以看做一个抽象方法， 需要在其子类中实现此方法。
	 */
	initCfgParams : function() {
	},

	/**
	 * 配置viewport中的各个组件
	 * 
	 * @param {}
	 *            o
	 */
	initConfig : function(o) {

		this.items = [];

		if (o && o.leftCmp) {
			this.leftCmp = o.leftCmp;
			this.leftCmp.region = 'west';
			this.items.push(this.leftCmp);
		}

		if (o && (this.rightCmp = o.rightCmp) && this.rightCmp.length) {
			var rightTabs = [];

			for (var i = 0, len = this.rightCmp.length; i < len; i++) {
				var rItems = [], c = this.rightCmp[i], title = c.title, underPanel;
				if (c.upper) {
					c.parentCmp=this.rightCmp[i];
					c.upper.region = 'center';
					rItems.push(c.upper);
				}
				if (c.under) {
				    var cfgTab,relTab;
					if (c.under.cfgCmps && c.under.cfgCmps.length) {
						for (var m = 0, l = c.under.cfgCmps.length; m < l; m++) {
							c.under.cfgCmps[m].iconCls = 'config';
						}
						 cfgTab = this.createTabs(c.under.cfgCmps,'south');
					}
					if (c.under.relCmps && c.under.relCmps.length) {
						for (var m = 0, l = c.under.relCmps.length; m < l; m++) {
							c.under.relCmps[m].iconCls = 'close';
						}
						 relTab = this.createTabs(c.under.relCmps,'south');
					}
                    this.rightCmp[i].underTabs = cfgTab;
                    
				    this.rightCmp[i].underPanel = new Ext.Panel({
						title : '相关信息',
						border : false,
						frame : false,
						layout : 'fit',
                        width: (Ext.getBody().getViewSize().width)*0.6,
						region : 'south',
						height : (Ext.getBody().getViewSize().height)*0.6,
						split : true,
						items : [cfgTab]
					});
					rItems.push(this.rightCmp[i].underPanel);
				}

				var p = new Ext.Panel({
					border : false,
                    bodyBorder:false,
					frame : true,
					region : 'center',
					layout : 'border',
					title : title,
					split : true,
					items : rItems
				});

				rightTabs.push(p);

			}
			this.items.push(this.createTabs(rightTabs, "center"));
		}
	},
	/**
	 * private 生成一个tab
	 * 
	 * @param {}
	 *            items
	 */
	createTabs : function(items, region) {
		var tab = new Ext.TabPanel({
			region : region,
			frame : false,
			border : false,
			layoutOnTabChange : true,
			activeTab : 0,
			items : items
		});
		return tab;
	}
});
