/**
 * @description: 构建一个通用的tree,        
 *    通过继承此类，可以方便的配置属性，并提供一些通用方法的访问接口
 * @author: pbqi
 * @created on 2009年12月23日10:34:02
 * @modified on 2010年1月28日10:52:04
 */

Starit.CommonTree = Ext.extend(Ext.tree.TreePanel, {
    autoScroll : true,
    enableDD : false,// 是否支持拖拽效果
    containerScroll : true,// 是否支持滚动条
    split : true,
    border : true,
    frame : false,
    animCollapse : false,
    animate : false,
    collapseFirst : false,
    rootVisible : true,
    collapsible : true,
    margins : '0 0 0 0',
    
    initComponent : function(){
        this.initParams();
        Starit.CommonTree.superclass.initComponent.call(this);
        this.on("click", this.onTreeClick, this);
        
        //add selfDefine events.
        //this.addEvents("loadError",.......);
    },
    /**
     * 抽象方法
     * @description 树点击执行的方法
     * @param {Node} node 树节点
     * @param {Ext.EventObject} e
     */
    onTreeClick: function(node,e) {
        
    },
    /**
     * 刷新树，如果此功能不能满足需要，可以覆盖此方法
     */
    doRefresh : function() {
        var that = this;
        this.getLoader().load(this.getRootNode(), function() {
            that.getRootNode().expand();
        });
    },
    /**
     * 抽象方法，
     * 具体的根据具体业务查询 查询
     */
    doQuery : function(v) {},
    /**
     * 初始化节点名称查询文本框
     */
    initQueryField : function() {
        var that = this;
        this.trigger = new Ext.ux.SearchField({
            width : 120,
            onSearchClick: function(v) {
                that.doQuery(v);
            }
        });
    },
    /**
     * 初始化的一些配置参数
     */
    initParams: function() {
        
        this.loader = new Ext.tree.TreeLoader({
            dataUrl : this.url
        });
        
        this.root = new Ext.tree.AsyncTreeNode({
            id : this.rootId,
            text : this.rootText,
            draggable : false,
            expanded : true
        });
        
        this.initQueryField();
        
        this.tbar = ['名称：', this.trigger, '-', {
            iconCls : 'refresh',
            handler : this.doRefresh,
            scope : this
        }];
    }
});
