/**
 * @description: 用户信息管理Grid
 * @author: pbqi
 * @created on 2009年12月23日10:34:02
 * @modified on 2009年12月24日10:34:46
 */

Starit.CommonTree = Ext.extend(Ext.tree.TreePanel, {

	iconCls : null,
	viewport : null,
	constructor : function(cfg) {

		// 把一个对象中的属性拷贝到当前对象中
		cfg = cfg || {};
		Ext.apply(this, cfg);

		this.initCfgParams();

		Starit.CommonTree.superclass.constructor.call(this, {
			autoScroll : true,
			enableDD : false,// 是否支持拖拽效果
			containerScroll : true,// 是否支持滚动条
			split : true,
			border : true,
			frame : false,
			animCollapse : false,
			animate : false,
			collapseFirst : false,
			rootVisible : true,
			collapsible : true,
			margins : '0 0 0 0',
			tbar : ['名称：', this.trigger, '-', {
				iconCls : 'refresh',
				handler : this.doRefresh,
				scope : this
			}]
			});
       this.on("click", this.onTreeClick, this);
	},
	onTreeClick : function(node, e) {
		this.doTreeClickCascading(node);
	},
	/**
	 * 这里可以看做一个抽象方法，具体的根据具体业务 节点点击级联操作
	 */
	doTreeClickCascading : function(node) {

		if (this.viewport) {
			this.doViewportLoad(this.viewport, node);
		}
	},
	/**
	 * 这里可以看做一个抽象方法 当viewport存在的时候，点击数节点，对viewport进行load
	 */
	doViewportLoad : function(viewport, node) {
		
	},

	/**
	 * 这里可以看做一个抽象方法，具体的根据具体业务查询 查询
	 */
	doQuery : function(v) {
	},
	/**
	 * 刷新
	 */
	doRefresh : function() {
		var that = this;
		this.getLoader().load(this.getRootNode(), function() {
					that.getRootNode().expand();
				});
	},
	/**
	 * 初始化树的配置参数
	 */
	initCfgParams : function() {
		this.loader = new Ext.tree.TreeLoader({
					dataUrl : this.url
				});
		this.root = new Ext.tree.AsyncTreeNode({
					id : this.rootId,
					text : this.rootText,
					draggable : false,
					expanded : true
				});
		this.initQueryField();
	},
	initQueryField : function() {
		var that = this;
		this.trigger = new Ext.ux.SearchField({
			width : 120,
            onSearchClick: function(v){
                that.doQuery(v);
            }
		});
	}
});