/**
 * @description: 通用的Grid
 * @author: chen.bo
 */

var resultData;// json装换成XMl后的结果
var charts;// 存放饼图需要的xml数据

Starit.CommonQueryGrid = Ext.extend(Ext.grid.GridPanel, {

	isPaging : true, // 是否分页,默认为 true.
	isRowNumberer : true, // 是否有行号,默认为true.
	isCheckBoxSelectionModel : false,// 选择模式是否为checkBox默认为false
	isSingleSelect : false, // 选择模式是否为单选

	// 图形报表参数
	caption : null,// 标题
	seriesNames : null,// 系列
	cateColumnKey : null,// 代表种类的关键字
	setColumn : null,// 数值列
	chartFalg : 1,// 初始化图形报表参数标记

	constructor : function(cfg) {

		// 把一个对象中的属性拷贝到当前对象中
		cfg = cfg || {};
		Ext.apply(this, cfg);

		this.initCfgParams(); // 初始化需要配置的参数

		this.rightMenu = new Ext.menu.Menu({
			items : [
                {text : '打印',       iconCls : 'print',  handler : this.doPrint,     scope : this}, 
                {text : 'excel导出',  iconCls : 'excel',  handler : this.doExcel,     scope : this}, 
                {text : '条形图',     iconCls : 'bar',    handler : this.doBarChart,  scope : this}, 
                {text : '线图',       iconCls : 'line',   handler : this.doLineChart, scope : this},
                {text : '饼图',       iconCls : 'pie',    handler : this.doPieChart,  scope : this}
           ]
		});

		Starit.CommonQueryGrid.superclass.constructor.call(this, {
			frame : true,
			height : 400,
			width : 900,
			viewConfig : {
				forceFit : true
			},
			loadMask : {
				msg : '正在载入数据,请稍候...'
			},
			tbar : new Ext.Toolbar({
				items : ['-', {
					text : '打印',
					iconCls : 'print',
					handler : this.doPrint,
					scope : this
				}, '-', {
					text : '导出Excel',
					iconCls : 'excel',
					handler : this.doExcel,
					scope : this
				}, '-', {
					text : '柱状图',
					iconCls : 'bar',
					handler : this.doBarChart,
					scope : this
				}, '-', {
					text : '线状图',
					iconCls : 'line',
					handler : this.doLineChart,
					scope : this
				}, '-', {
					text : '饼状图',
					iconCls : 'pie',
					handler : this.doPieChart,
					scope : this
				}]
			})
		});
	},

	/**
	 * 这里可以看做一个抽象方法，需要实现 excel导出
	 */
	doExcel : function() {
		var filename = this.title;
		var vExportContent = this.getExcelXml();
		if (Ext.isIE6 || Ext.isIE7 || Ext.isIE8 || Ext.isSafari
				|| Ext.isSafari2 || Ext.isSafari3) {
			var fd = Ext.get('frmDummy');
			if (!fd) {
				fd = Ext.DomHelper.append(Ext.getBody(), {
					tag : 'form',
					method : 'post',
					id : 'frmDummy',
					action : '../exportexcel.jsp',
					target : '_blank',
					name : 'frmDummy',
					cls : 'x-hidden',
					cn : [{
                        tag : 'input',
                        name : 'fileName',
                        id : 'fileName',
                        type : 'hidden'
                    },{
						tag : 'input',
						name : 'exportContent',
						id : 'exportContent',
						type : 'hidden'
					}]
				}, true);
			}
            fd.child('#fileName').set({
                value : filename
            });
			fd.child('#exportContent').set({
				value : vExportContent
			});
			fd.dom.submit();
		} else {
			document.location = 'data:application/vnd.ms-excel;base64,'
					+ Base64.encode(vExportContent);
		}
	},

	/**
	 * 本地分页下，柱状图(bar) 查看查询结果，如果需要后台查看查询结果，可以重写此方法。
	 */
	doBarChart : function() {
		var dataArray = this.getColumnAndValue();
		resultData = this.getChartsXmlData(this.caption, this.seriesNames, dataArray);
		var pageWidth = window.screen.availWidth;
		var pageHeight = window.screen.availHeight - 20;
		window.open("../charts/BarChart.jsp", "_blank",
				"top=0,left=0,menubar=0,toolbar=0,width=" + pageWidth
						+ ",height=" + pageHeight);
	},

	/**
	 * 本地分页下，线图(line) 查看查询结果，如果需要后台查看查询结果，可以重写此方法。
	 */
	doLineChart : function() {
		var dataArray = this.getColumnAndValue();
		resultData = this.getChartsXmlData(this.caption, this.seriesNames, dataArray);
		var pageWidth = window.screen.availWidth;
		var pageHeight = window.screen.availHeight - 20;
		window.open("../charts/LineChart.jsp", "_blank",
				"top=0,left=0,menubar=0,toolbar=0,width=" + pageWidth
						+ ",height=" + pageHeight);
	},

	/**
	 * 本地分页下，饼图(pie) 查看查询结果，如果需要后台查看查询结果，可以重写此方法。
	 */
	doPieChart : function() {
		var dataArray = this.getColumnAndValue();
		resultData = this.getPieChartXmlData(this.caption, this.seriesNames,
				dataArray);
		charts = resultData.split('+');
		var pageWidth = window.screen.availWidth;
		var pageHeight = window.screen.availHeight - 20;

		for (var i = 0; i < charts.length - 1; i++) {
			window.open("../charts/PieChart.jsp?chartIndex=" + i, "_blank",
					"top=0,left=0,menubar=0,toolbar=0,width=" + pageWidth
							+ ",height=" + pageHeight);
		}
	},

	/**
	 * 
	 * 图形报表配置参数(默认配置) 默认情况下第一列为种类关键字 
	 * 
	 * 如果需要手动配置，可重写此方法
	 */
	initChartsConfig : function() {
		this.caption = this.title;
		this.seriesNames = new Array();
		this.cateColumnKey = new Array();
		this.setColumn = new Array();

		var cm = this.getColumnModel();
		var falg = 1;
		for (var i = 1, colCount = cm.getColumnCount(); i < colCount; i++) {
			var dataindex = cm.getDataIndex(i);
			if (!cm.isHidden(i) && falg === 1) {
				this.cateColumnKey.push(dataindex);
				falg = 2;
			} else if (!cm.isHidden(i) && falg === 2) {
				var columnName = cm.getColumnHeader(i);
				var fld = this.store.recordType.prototype.fields.get(dataindex);

				if ((fld.type == "int" || fld.type == "float")
						&& columnName != "") {
					this.seriesNames.push(columnName);
					this.setColumn.push(dataindex);
				}
			}
		}
	},

	/**
	 * private 获得当前grid的列标题和对应的数据 返回二维数组
	 */
	getColumnAndValue : function() {
		if (this.chartFalg === 1) {
			this.initChartsConfig();// 初始化图形报表配置,织初始化一次
			this.chartFalg = 2;
		}

		var allDataArray = new Array();// 二维数组，存放数据
		var cm = this.getColumnModel();
		var colCount = cm.getColumnCount();

		// 标记需要取值的字段
		var cateColumnKeyLen = this.cateColumnKey.length;
		var columnFalg = new Array();
		for (var i = 0; i < cateColumnKeyLen; i++) {
			columnFalg.push(this.cateColumnKey[i]);
		}
		for (var i = 0, setColumnLen = this.setColumn.length; i < setColumnLen; i++) {
			columnFalg.push(this.setColumn[i]);
		}

		// 遍历grid
		for (var i = 0, it = this.store.allData.items, l = it.length; i < l; i++) {
			var r = it[i].data;
			var k = 0;
			allDataArray[i] = new Array();

			for (var j = 0; j < colCount; j++) {
				var dataIndex = cm.getDataIndex(j);
				if ((dataIndex != '') && !cm.isHidden(j)
						&& this.isDataInArray(dataIndex, columnFalg)) {

					var v = r[dataIndex];
					var rendererFunc = cm.getRenderer(j);
					if (rendererFunc != null) {
						v = rendererFunc(v);
					}
					if (v == null) {
						v = '';
					}
					allDataArray[i].push(v);
				}
			}
		}
		return allDataArray;
	},

	/**
	 * 判断dataArray(数组)是否存在item(元素)
	 */
	isDataInArray : function(item, dataArray) {
		var falg = false;
		for (var i = 0, len = dataArray.length; i < len; i++) {
			if (item === dataArray[i]) {
				falg = true;
				break;
			}
		}
		return falg;
	},

	/**
	 * private 已实现，一般情况下，子类grid不要再次实现此方法 打印当前grid的当前页
	 */
	doPrint : function() {
		var that = this;
		this.printPage(that);
	},

	/**
	 * 初始化配置信息 这里可以看做一个抽象方法，需要实现 例如: this.isCheckBoxSelectionModel = true;
	 * this.isPaging = false; this.initConfig({ url: 'test.json', dataField:
	 * ["name", "age"], columnParams:[ {header: '用户名称', dataIndex: 'name',
	 * width: 90}, {header: '年龄', dataIndex: 'age', width: 90} ] });
	 */
	initCfgParams : function() {
	},

	/**
	 * public 初始化grid中需要配置的参数
	 */
	initConfig : function(o) {
		this.initSm();
		// 本地分页
		this.store = this.localPagingStore(o.url, o.dataField);
		this.initColumn(o.columnParams);
		this.initPagingBar(o.pageSize);
	},

	/**
	 * private 配置Grid中的数据源store
	 */
	initStore : function(url, dataField) {
		var s = new Ext.data.Store({
			proxy : new Ext.data.HttpProxy({
				url : url,
				method : 'POST'
			}),
			reader : this.initReader(dataField)
		});
		return s;
	},

	/**
	 * 本地分页
	 * 
	 * @params records{Ext.data.Record} 查询结果
	 */
	localPagingStore : function(url, dataField) {
		var store = new Ext.ux.data.PagingStore({
			proxy : new Ext.data.HttpProxy({
				url : url,
				method : 'POST'
			}),
			reader : this.initReader(dataField)
		});
		return store;
	},
	/**
	 * private 配置grid中的列
	 * 
	 * @params:columnParams {Array}列的参数数组
	 * 
	 */
	initColumn : function(columnParams) {
		if (this.isCheckBoxSelectionModel) {
			columnParams.unshift(this.sm);
		}
		if (this.isRowNumberer) {
			columnParams.unshift(new Ext.grid.RowNumberer());
		}
		this.cm = new Ext.grid.ColumnModel(columnParams);
	},
	/**
	 * private 如果配置isPaging为true时，增加分页工具条
	 * 
	 * @params pageSize{Number} 分页的个数 默认为10
	 */
	initPagingBar : function(pageSize) {

		if (this.isPaging) {
			this.bbar = new Ext.PagingToolbar({
				plugins : new Ext.ux.data.PageSizePlugin(),
				pageSize : (pageSize || 10),
				store : this.store,
				displayInfo : true,
				dsiplayMsg : '本页显示 {0} - {1},共{2}条记录',
				emptyMsg : "没有可显示的记录"
			});
		}
	},

	/**
	 * private 配置选择模式 配置选择模式是否为checkbox,是否为单选模式
	 */
	initSm : function() {
		if (!this.isCheckBoxSelectionModel) {
			this.sm = new Ext.grid.RowSelectionModel({
				singleSelect : this.isSingleSelect
			});
		}
		this.sm = new Ext.grid.CheckboxSelectionModel({
			singleSelect : this.isSingleSelect
		});
	},
	/**
	 * private 配置store中的reader,分为分页和不分页两种实现方式
	 * 
	 * @params:dataField {Array} 如：["userID","userName"]
	 * @retrun{Ext.data.JsonReader}
	 */
	initReader : function(dataField) {
		return new Ext.data.JsonReader(this.isPaging ? {
			totalProperty : 'totalProperty',
			root : 'root'
		} : {}, this.initDataField(dataField));
	},

	/**
	 * private 配置store中的对应的属性字段
	 * 
	 * @params:dataField{Array} 如：[["userID","int"],["userName",""]]
	 * @return{Array}返回属性字段组成后的对象数组如：[{name:'userID',type:'int'},{name:'userName',type:''}]
	 */
	initDataField : function(dataField) {
		if (!Ext.isArray(dataField)) {
			throw new Error("dataField is not a Array, is required a Array.");
			return;
		}
		var dfs = [];
		for (var i = 0, len = dataField.length; i < len; i++) {
			var o = {};
			o.name = dataField[i][0];
			o.type = dataField[i][1]
			dfs[dfs.length] = o;
		}
		return dfs;
	},

	/**
	 * private 获得当前grid的全部数据
	 */
	getAllData : function() {
		var d = this.store.allData;
		return d;
	},
    
    /**
	 * @description: 生成图形报表(线图、条形图)需要的XML数据(讲json数据转换为xml数据)
	 * @params caption 标题
	 * @params seriesNames{Array} 系列
	 * @params dataArray{Array} 数值
	 * @author: chen.bo
	 */

    getChartsXmlData: function(caption, seriesNames, dataArray) {
	    var xmlData = "<graph caption='" + caption + "'>";
	    var len = dataArray.length;
	    // 种类(查询结果记录数)
	    xmlData += "<categories>";
	    for (var i = 0; i < len; i++) {
	        xmlData += "<category name='" + dataArray[i][0] + "' />";
	    }
	    xmlData += "</categories>";
	
	    // 为各个系列的每个种类设值(各个参数每条记录对应的值)
	    var seriesNamesLen = seriesNames.length;
	    if (seriesNamesLen === 0 || seriesNamesLen === 1) {
	        var seriesName = '';
	        xmlData += "<dataset seriesName='" + seriesName + "'>";
	        for (var j = 0; j < len; j++) {
	            colorNumber = Math.round(maxNumber * Math.random());
	            xmlData += "<set value='" + dataArray[j][1] + "' color='"
	                    + this.getRandomColor() + "'/>";
	        }
	        xmlData += "</dataset>";
	    } else {
	        for (var i = 0; i < seriesNamesLen; i++) {
	            
	            xmlData += "<dataset seriesName='" + seriesNames[i] + "' color='"
	                    + this.getRandomColor() + "'>";
	
	            for (var j = 0; j < len; j++) {
	                xmlData += "<set value='" + dataArray[j][i + 1] + "'/>";
	            }
	            xmlData += "</dataset>";
	        }
	    }
	    xmlData += "</graph>";
	
	    return xmlData;
    },

	/**
	 * @description: 生成图形报表(饼图)需要的XML数据(讲json数据转换为xml数据)
	 * @param {}
	 *            caption
	 * @param {}
	 *            seriesNames
	 * @param {}
	 *            dataArray
	 * @author: chen.bo
	 */
    getPieChartXmlData: function (caption, seriesNames, dataArray) {
	    var seriesNamesLen = seriesNames.length;
	    var len = dataArray.length
	    var xmlData = "";
	    if (seriesNamesLen === 0 || seriesNamesLen === 1) {
	        var seriesName = '';
	        xmlData += "<graph caption='"
	                + caption
	                + "' showNames='1' showPercentageValues='0' showPercentageInLabel='1' decimalPrecision='2'>";
	
	        for (var i = 0; i < len; i++) {
	            
	            xmlData += "<set name='" + dataArray[i][0] + "' value='"
	                    + dataArray[i][1] + "' color='" + this.getRandomColor() + "'/>"
	        }
	        xmlData += "</graph>+";
	
	    } else {
	        for (var i = 0; i < seriesNamesLen; i++) {
	            xmlData += "<graph caption='"
	                    + caption
	                    + "-"
	                    + seriesNames[i]
	                    + "' showNames='1' showPercentageValues='0' showPercentageInLabel='1' decimalPrecision='2'>";
	
	            for (var j = 0; j < len; j++) {
	                
	                xmlData += "<set name='" + dataArray[j][0] + "' value='"
	                        + dataArray[j][i + 1] + "' color='" + this.getRandomColor()
	                        + "'/>"
	            }
	
	            xmlData += "</graph>+";
	        }
	    }
	    return xmlData;
    },

	/**
	 * 随机生成颜色
	 * 
	 * @return {}
	 */
    getRandomColor: function() {
	    return '#' + (Math.random() * 0xffffff << 0).toString(16);
	},
    
	/**
	 * private 打印当前grid的当前页
	 * 
	 * @params{Ext.grid.GridPanel} grid
	 */
	printPage : function(grid) {
		var tableStr = '<table width="100%" border=1>';
		var cm = grid.getColumnModel();
		var colCount = cm.getColumnCount();
		var temp_obj = new Array();
		// 只下载没有隐藏的列(isHidden()为true表示隐藏,其他都为显示)
		// 临时数组,存放所有当前显示列的下标
		for (var i = 1; i < colCount; i++) {
			if (cm.isHidden(i) == true) {
			} else {
				temp_obj.push(i);
			}
		}
		tableStr = tableStr + '<tr><td>序号</td>';
		for (var i = 0; i < temp_obj.length; i++) {
			// 显示列的列标题
			// xlSheet.Cells(1, i).Value = cm.getColumnHeader(temp_obj[i - 1]);
			tableStr = tableStr + '<td>' + cm.getColumnHeader(temp_obj[i])
					+ '</td>';
		}
		tableStr = tableStr + '</tr>';
		var store = this.getAllData();// 得到全部数据
		var recordCount = store.length;
		for (var i = 0; i < recordCount; i++) {
			var r = store.items[i];// 得到一行
			tableStr = tableStr + '<tr><td>' + (i + 1) + '</td>';
			for (var j = 0; j < temp_obj.length; j++) {
				var dataIndex = cm.getDataIndex(temp_obj[j]);
				var tdValue = r.get(dataIndex);// 得到一列
				var rendererFunc = cm.getRenderer(temp_obj[j]);
				if (rendererFunc != null) {
					tdValue = rendererFunc(tdValue);
				}
				if (tdValue == null) {
					tdValue = '';
				}
				tableStr = tableStr + '<td>' + tdValue + '</td>';
			}
			tableStr = tableStr + '</tr>';
		}
		tableStr = tableStr + '</table>';
		var titleHTML = tableStr;// document.getElementById("printGridfff").innerHTML;
		var newwin = window.open('printer.jsp', '', '');

		newwin.document.write(titleHTML);
		newwin.document.location.reload();
		newwin.print();
		newwin.close();
	}
});

