/**
 * @description: 通用的Grid
 * @author: pbqi
 * @created on 2009年12月23日10:34:02
 * @modified on 2009年12月24日10:34:46
 */
var resultData;

Starit.CommonGrid = Ext.extend(Ext.grid.GridPanel, {
	iconCls : null,
	viewport : null,// 外界的布局。
	showDataIndex : null,// 关联的tabPanel显示的title对应的列模型中的dataIndex

	isPaging : true, // 是否分页,默认为 true.
	isRowNumberer : true, // 是否有行号,默认为true.
	isCheckBoxSelectionModel : false,// 选择模式是否为checkBox默认为false
	isSingleSelect : false, // 选择模式是否为单选
	isAdvancedQuery:true,// tbar上是否显示高级查询
	isOperation : true, // tbar上是否显示操作(增删查改刷新)
	isExport : true, // tbar上是否支持（导入导出打印功能）
	isCharts : true, // tbar上是否显示图表操作（bar, line, pie）
	

	// 图形报表参数
	caption : null,// 标题
	seriesNames : null,// 系列
	cateColumnKey : null,// 代表种类的关键字
	setColumn : null,// 数值列
	chartFalg : 1,// 初始化图形报表参数标记

	constructor : function(cfg) {

		// 把一个对象中的属性拷贝到当前对象中
		cfg = cfg || {};
		Ext.apply(this, cfg);

		this.initQueryField(); // 初始化查询条件组件
		this.initCfgParams(); // 初始化需要配置的参数

		Starit.CommonGrid.superclass.constructor.call(this, {
					// frame : false,
                    border: false,
                    bodyStyle: "padding: 0 0 0 0",
					// height : 300,
					// width : 800,
					height : (Ext.getBody().getViewSize().height) * 0.33,
					width : 800,

					viewConfig : {
						forceFit : true
					},
					loadMask : {
						msg : '正在载入数据,请稍候...'
					}
				});

		this.addListener("rowcontextmenu", this.onRowContextmenu, this);
		this.addListener("rowclick", this.onRowClick, this);
	},
    /**
	 * 这是一个抽象方法，需要实现 点击的级联操作 recod 是获取的记录 viewport是布局 relatedTabs是相关联的Tab页。按顺序排列
	 * 此方法同时也是修改记录接口方法。
	 */
    onRowClickBiz : function(viewport, record, relatedTabs) {},
    /**
	 * 这里可以看做一个抽象方法，需要实现, 增加操作时，具体的业务实现
	 */
    doAddBiz : function(viewport, firstTab) {},
    /**
	 * 这里可以看做一个抽象方法，需要实现, 删除记录操作，具体的业务实现
	 * 
	 * @param {Array}
	 *            records : 记录数组
	 */
    doDeleteBiz : function(records) {},
	/**
	 * 右键菜单
	 */
	onRowContextmenu : function(grid, rowIndex, e) {
		this.getSelectionModel().selectRow(rowIndex);
		e.preventDefault();
		this.rightMenu.showAt(e.getXY());
	},
	/**
	 * 行点击时触发事件操作， 具体实现为2步： １.调用此方法，
	 * ２.提供一个通用的接口方法onRowClickBiz，和具体业务相关的操作，需要实现onRowClickBiz
	 */
	onRowClick : function(grid, rowIndex, e) {
		
		/*
		 * 
		 * if (this.viewport && this.showDataIndex) {
		 * 
		 * var record = this.store.getAt(rowIndex); var showSign =
		 * record.get(this.showDataIndex);
		 * this.viewport.underPanel.setTitle(showSign);
		 * 
		 * var underItems = this.viewport.underItems; if (underItems.length > 1) {
		 * if (!this.viewport.underComponents.getComponent(1)) { for (var i = 1;
		 * i < underItems.length; i++) {
		 * this.viewport.underComponents.add(underItems[i]);
		 * this.viewport.underComponents.doLayout(); } } }
		 * this.onRowClickBiz(this.viewport, record, underItems);
		 *  }
		 */
	},
	/**
	 * grid中增加一条记录时的共通操作，具体实现分为2步： 1.调用此方法，
	 * 2.提供一个通用的接口方法doAddBiz，和具体业务相关的操作，需要实现doAddBiz
	 */
	doAdd : function() {
		if (this.viewport && this.showDataIndex) {

			var showSign = "配置";
			this.viewport.underPanel.setTitle(showSign);

			var underItems = this.viewport.underItems;
			if (underItems.length > 1) {
				if (this.viewport.underComponents.getComponent(1)) {
					for (var i = 1; i < underItems.length; i++) {
						this.viewport.underComponents.remove(underItems[i],
								false);
						this.viewport.underComponents.doLayout();
					}
				}
			}
			this.doAddBiz(this.viewport, underItems[0]);

		}
	},
    /**
	 * grid中修改一条记录时的共通操作，具体实现分为2步： 1.调用此方法，
	 * 2.提供一个通用的接口方法doUpdateBiz，和具体业务相关的操作，需要实现doUpdateBiz
	 */
    doModify : function() {
    	/*
		 * 
		 * var selections = this.getSelectionModel().getSelections(); if
		 * (selections.length != 1) { Ext.Msg.alert('提示', Starit.padBlank +
		 * '选择且必须只选择一条记录进行修改！' + Starit.padBlank); return; } var record =
		 * this.getSelectionModel().getSelected();
		 * 
		 * if (this.viewport && this.showDataIndex) {
		 * 
		 * var showSign = record.get(this.showDataIndex);
		 * this.viewport.underPanel.setTitle(showSign);
		 * 
		 * var underItems = this.viewport.underItems; if (underItems.length > 1) {
		 * if (!this.viewport.underComponents.getComponent(1)) { for (var i = 1;
		 * i < underItems.length; i++) {
		 * this.viewport.underComponents.add(underItems[i]);
		 * this.viewport.underComponents.doLayout(); } } }
		 * this.onRowClickBiz(this.viewport, record, underItems); }
		 */
    },
    /**
	 * 这里可以看做一个抽象方法，可以重写 删除
	 */
    doDelete : function() {

        this.doAdd();

        var records = this.getSelectionModel().getSelections();

        if (records.length == 0) {
            Ext.Msg.alert('提示', '没有记录被选择！' + Starit.padBlank + Starit.padBlank);
            return;
        }

        if (this.isSingleSelect) {

            if (records.length >= 0) {
                Ext.Msg.alert('提示', '只能删除一条记录！' + Starit.padBlank +Starit.padBlank);
                return;
            }
        }
        if (records.length == 0) {
            Ext.Msg.alert('提示', '没有记录被选择！' + Starit.padBlank + Starit.padBlank);
            return;
        }

        Ext.MessageBox.confirm('提示', '确认要删除选择的信息' + Starit.padBlank + Starit.padBlank,
            function() {
                this.doDeleteBiz(records);
            }, this);
    },
	/**
	 * 刷新，需要在store.load时传递参数传到可以覆盖此方法
	 */
	doRefresh : function() {
		this.store.load();
	},
	/**
	 * 这里可以看做一个抽象方法，需要实现 查询
	 */
	doQuery : function(v) {},
	/**
	 * 这里可以看做一个抽象方法，需要实现 excel导出
	 */
	doExcel : function() {
		var fileName = this.title;
		var vExportContent = this.getExcelXml();
		if (Ext.isIE6 || Ext.isIE7 || Ext.isIE8 || Ext.isSafari
				|| Ext.isSafari2 || Ext.isSafari3) {
			var fd = Ext.get('frmDummy');
			if (!fd) {
				fd = Ext.DomHelper.append(Ext.getBody(), {
					tag : 'form',
					method : 'post',
					id : 'frmDummy',
					action : '../exportexcel.jsp',
					target : '_blank',
					name : 'frmDummy',
					cls : 'x-hidden',
					cn : [{
						tag : 'input',
						name : 'fileName',
						id : 'fileName',
						type : 'hidden'
					}, {
						tag : 'input',
						name : 'exportContent',
						id : 'exportContent',
						type : 'hidden'
					}]
				}, true);
			}
			fd.child('#fileName').set({
				value : fileName
			});
			fd.child('#exportContent').set({
				value : vExportContent
			});
			fd.dom.submit();
		} else {
			document.location = 'data:application/vnd.ms-excel;base64,'
					+ Base64.encode(vExportContent);
		}
	},
	/**
	 * 这里可以看做一个抽象方法，需要实现 导入
	 */
	doImport : function() {},
	/**
	 * 这里可以看做一个抽象方法，需要实现 柱状图查看
	 */
	doBarChart : function() {

		var dataArray = this.getColumnAndValue();
		resultData = Starit.getChartsXmlData(this.caption, this.seriesNames, dataArray);
		var pageWidth = window.screen.availWidth;
		var pageHeight = window.screen.availHeight - 20;
		window.open("../charts/BarChart.jsp", "_blank",
				"top=0,left=0,menubar=0,toolbar=0,width=" + pageWidth
						+ ",height=" + pageHeight);

	},
	/**
	 * 这里可以看做一个抽象方法，需要实现 线图查看
	 */
	doLineChart : function() {
		var dataArray = this.getColumnAndValue();
		resultData = Starit.getChartsXmlData(this.caption, this.seriesNames, dataArray);
		var pageWidth = window.screen.availWidth;
		var pageHeight = window.screen.availHeight - 20;
		window.open("../charts/LineChart.jsp", "_blank",
				"top=0,left=0,menubar=0,toolbar=0,width=" + pageWidth
						+ ",height=" + pageHeight);
	},
	/**
	 * 这里可以看做一个抽象方法，需要实现 饼图查看
	 */
	doPieChart : function() {
		
		var dataArray = this.getColumnAndValue();
		resultData = Starit.getPieChartXmlData(this.caption, this.seriesNames,
				dataArray);
		charts = resultData.split('+');
		var pageWidth = window.screen.availWidth;
		var pageHeight = window.screen.availHeight - 20;

		for (var i = 0; i < charts.length - 1; i++) {
			window.open("../charts/PieChart.jsp?chartIndex=" + i, "_blank",
					"top=0,left=0,menubar=0,toolbar=0,width=" + pageWidth
							+ ",height=" + pageHeight);
		}
	},
	/**
	 * private 已实现，一般情况下，子类grid不要再次实现此方法 打印当前grid的当前页
	 */
	doPrint : function() {
		var that = this;
		this.printPage(that);
	},
	doRightAdd : function() {
		this.doAdd();
	},
	doRightModify : function() {
		this.doModify();
	},
	doRightDelete : function() {
		this.doDelete();
	},
	doRightExcel : function() {
		this.doExcel();
	},
	doRightImport : function() {
		this.doImport();
	},
	doRightBarChart : function() {
		this.doBarChart();
	},
	doRightLineChart : function() {
		this.doLineChart();
	},
	doRightPieChart : function() {
		this.doPieChart();
	},
	doRightPrint : function() {
		this.doPrint();
	},
	/**
	 * 初始化配置信息 这里可以看做一个抽象方法，需要实现 例如: this.isCheckBoxSelectionModel = true;
	 * this.isPaging = false; this.initConfig({ url: 'test.json', dataField:
	 * ["name", "age"], columnParams:[ {header: '用户名称', dataIndex: 'name',
	 * width: 90}, {header: '年龄', dataIndex: 'age', width: 90} ] });
	 */
	initCfgParams : function() {
	},
	/**
	 * 初始化查询一般条件组件
	 */
	initQueryField : function() {

		var that = this;
        
		this.trigger = new Ext.ux.SearchField({
			width : 120,
            onSearchClick: function(v){
                that.doQuery(v);
            }
		});
	},
	/**
	 * public 初始化grid中需要配置的参数
	 */
	initConfig : function(o) {
		this.initSm();
		this.store = this.initStore(o.url, o.dataField);
		this.initColumn(o.columnParams);
		this.initPagingBar(o.pageSize);
		this.initTbar();
		this.initRightMenu();
	},
	/**
	 * 初始化右键菜单的操作，主要根据tbar上操作来确定，右键菜单的操作
	 */
	initRightMenu : function() {
		var menuItems = [];
		if (this.isOperation) {
			menuItems.push({
						text : '添加',
						iconCls : 'new',
						handler : this.doRightAdd,
						scope : this
					}, {
						text : '修改',
						iconCls : 'update',
						handler : this.doRightModify,
						scope : this
					}, {
						text : '删除',
						iconCls : 'delete',
						handler : this.doRightDelete,
						scope : this
					}, '-');
		}
		if (this.isExport) {
			menuItems.push({
						text : '导入',
						iconCls : 'import',
						handler : this.doRightImport,
						scope : this
					}, {
						text : '打印',
						iconCls : 'print',
						handler : this.doRightPrint,
						scope : this
					}, {
						text : 'excel导出',
						iconCls : 'excel',
						handler : this.doRightExcel,
						scope : this
					}, '-');
		}
		if (this.isCharts) {
			menuItems.push({
						text : '条形图',
						iconCls : 'bar',
						handler : this.doRightBarChart,
						scope : this
					}, {
						text : '线图',
						iconCls : 'line',
						handler : this.doRightLineChart,
						scope : this
					}, {
						text : '饼图',
						iconCls : 'pie',
						handler : this.doRightPieChart,
						scope : this
					});
		}
		this.rightMenu = new Ext.menu.Menu({
					items : menuItems
				});
	},
	/**
	 * 初始化tbar 分为3种配置设置 1.isOperation配置操作,包括(add, update delete query,
	 * advantageQuery) defaut: true 2.isExport配置导入导出打印,包括(import, print, export)
	 * defaut: true 3.isCharts配置图表显示,包括(bar, line, pie) defaut: true
	 */
	initTbar : function() {
		var that = this; // 获得当前对象的一个引用
		var tbarItems = [];

		// this.tbar.addItem({text:'',iconCls:
		// 'refresh',handler:that.doRefresh,scope:that});
		// 是否显示操作
		if (this.isOperation) {
			
			tbarItems.push({
						text : '',
						iconCls : 'refresh',
						handler : that.doRefresh,
						scope : that
					}, '-', {
						text : '添加',
						iconCls : 'new',
						handler : that.doAdd,
						scope : that
					}, '-', {
						text : '修改',
						iconCls : 'update',
						handler : that.doModify,
						scope : that
					}, '-', {
						text : '删除',
						iconCls : 'delete',
						handler : that.doDelete,
						scope : that
					}, '-', '名称：', that.trigger);
			if (this.isAdvancedQuery){
				tbarItems.push({
						text : '高级查询',
						iconCls : 'find',
						handler : that.doQuery,
						scope : that
					},"->");
			
			}else{
				tbarItems.push("->");
			}
		}
		// 是否显示导入导出和打印
		if (this.isExport) {
			tbarItems.push({
						text : '',
						iconCls : 'import',
						handler : that.doImport,
						scope : that
					}, '-', {
						text : '',
						iconCls : 'print',
						handler : that.doPrint,
						scope : that
					}, '-', {
						text : '',
						iconCls : 'excel',
						handler : that.doExcel,
						scope : that
					}, '-');
		}
		// 是否显示图表
		if (this.isCharts) {
			tbarItems.push({
						text : '',
						iconCls : 'bar',
						handler : that.doBarChart,
						scope : that
					}, '-', {
						text : '',
						iconCls : 'line',
						handler : that.doLineChart,
						scope : that
					}, '-', {
						text : '',
						iconCls : 'pie',
						handler : that.doPieChart,
						scope : that
					});
		}

		this.tbar = new Ext.Toolbar({
					items : tbarItems
				});
	},
	/**
	 * private 配置Grid中的数据源store
	 */
	initStore : function(url, dataField) {
		var s = new Ext.data.Store({
					proxy : new Ext.data.HttpProxy({
								url : url,
								method : 'POST'
							}),
					reader : this.initReader(dataField)
				});
		return s;
	},
	/**
	 * private 配置grid中的列
	 * 
	 * @params:columnParams {Array}列的参数数组
	 * 
	 */
	initColumn : function(columnParams) {
		if (this.isCheckBoxSelectionModel) {
			columnParams.unshift(this.sm);
		}
		if (this.isRowNumberer) {
			columnParams.unshift(new Ext.grid.RowNumberer());
		}
		this.cm = new Ext.grid.ColumnModel(columnParams);
	},
	/**
	 * private 如果配置isPaging为true时，增加分页工具条
	 * 
	 * @params pageSize{Number} 分页的个数 默认为10
	 */
	initPagingBar : function(pageSize) {
		
		if (this.isPaging) {
			this.bbar = new Ext.PagingToolbar({
				plugins : new Ext.ux.data.PageSizePlugin(),
				pageSize : (pageSize || 10),
				store : this.store,
				displayInfo : true,
				dsiplayMsg : '本页显示 {0} - {1},共{2}条记录',
				emptyMsg : "没有可显示的记录"
			});
		}
		/*
		 * if (this.isPaging) { this.pagingCombox = new
		 * Starit.createMemoryCombo([{ "id" : 10, "name" : "10行" }, { "id" : 20,
		 * "name" : "20行" }, { "id" : 30, "name" : "30行" }, { "id" : 50, "name" :
		 * "50行" }, { "id" : 100, "name" : "100行" }]);
		 * this.pagingCombox.store.load();
		 * 
		 * this.pagingCombox.on('select', this.onPagingSelect, this);
		 * this.pagingCombox.on('render', function() { var pageSize = pageSize ||
		 * 10; this.pagingCombox.setValue(pageSize); }, this);
		 * 
		 * this.bbar = new Ext.PagingToolbar({ pageSize : (pageSize || 10),
		 * store : this.store, displayInfo : true, dsiplayMsg : '本页显示 {0} -
		 * {1},共{2}条记录', emptyMsg : "没有可显示的记录", items : ["每页显示:",
		 * this.pagingCombox] }); }
		 */},
	/**
	 * 监听分页
	 * 
	 * @param {}combo
	 * @param {}record
	 * @param {}index
	 */
	onPagingSelect : function(combo, record, index) {
		var pageSize = combo.getValue();
		this.store.load({
					params : {
						start : 0,
						limit : pageSize
					}
				});
	},
	/**
	 * private 配置选择模式 配置选择模式是否为checkbox,是否为单选模式
	 */
	initSm : function() {
		if (!this.isCheckBoxSelectionModel) {
			this.sm = new Ext.grid.RowSelectionModel({
						singleSelect : this.isSingleSelect
					});
		}
		this.sm = new Ext.grid.CheckboxSelectionModel({
					singleSelect : this.isSingleSelect
				});
	},
	/**
	 * private 配置store中的reader,分为分页和不分页两种实现方式
	 * 
	 * @params:dataField {Array} 如：["userID","userName"]
	 * @retrun{Ext.data.JsonReader}
	 */
	initReader : function(dataField) {
		return new Ext.data.JsonReader(this.isPaging ? {
					totalProperty : 'totalProperty',
					root : 'root'
				} : {}, this.initDataField(dataField));
	},
	/**
	 * private 配置store中的对应的属性字段
	 * 
	 * @params:dataField{Array} 如：["userID","userName"]
	 * @return{Array}返回属性字段组成后的对象数组如：[{name:'userID'},{name:'userName'}]
	 */
	initDataField : function(dataField) {
		if (!Ext.isArray(dataField)) {
			throw new Error("dataField is not a Array, is required a Array.");
			return;
		}
		var dfs = [];
		for (var i = 0, len = dataField.length; i < len; i++) {
			var o = {};
			o.name = dataField[i];
			dfs[dfs.length] = o;
		}
		return dfs;
	},
	/**
	 * private 打印当前grid的当前页
	 * 
	 * @params{Ext.grid.GridPanel} grid
	 */
	printPage : function(grid) {
		var tableStr = '<table width="100%" border=1>';
		var cm = grid.getColumnModel();
		var colCount = cm.getColumnCount();
		var temp_obj = new Array();
		// 只下载没有隐藏的列(isHidden()为true表示隐藏,其他都为显示)
		// 临时数组,存放所有当前显示列的下标
		for (var i = 1; i < colCount; i++) {
			if (cm.isHidden(i) == true) {
			} else {
				temp_obj.push(i);
			}
		}
		tableStr = tableStr + '<tr><td>序号</td>';
		for (var i = 0; i < temp_obj.length; i++) {
			// 显示列的列标题
			// xlSheet.Cells(1, i).Value = cm.getColumnHeader(temp_obj[i
			// - 1]);
			tableStr = tableStr + '<td>' + cm.getColumnHeader(temp_obj[i])
					+ '</td>';
		}
		tableStr = tableStr + '</tr>';
		var store = grid.getStore();
		var recordCount = store.getCount();
		for (var i = 0; i < recordCount; i++) {
			var r = store.getAt(i);
			tableStr = tableStr + '<tr><td>' + (i + 1) + '</td>';
			for (var j = 0; j < temp_obj.length; j++) {
				var dataIndex = cm.getDataIndex(temp_obj[j]);
				var tdValue = r.get(dataIndex);
				var rendererFunc = cm.getRenderer(temp_obj[j]);
				if (rendererFunc != null) {
					tdValue = rendererFunc(tdValue);
				}
				if (tdValue == null) {
					tdValue = '';
				}
				tableStr = tableStr + '<td>' + tdValue + '</td>';
			}
			tableStr = tableStr + '</tr>';
		}
		tableStr = tableStr + '</table>';
		var titleHTML = tableStr;// document.getElementById("printGridfff").innerHTML;
		var newwin = window.open('printer.jsp', '', '');

		newwin.document.write(titleHTML);
		newwin.document.location.reload();
		newwin.print();
		newwin.close();
	},
	/**
	 * private 获得当前grid的列标题和对应的数据 返回二维数组
	 */
	getColumnAndValue : function() {
		if (this.chartFalg === 1) {
			this.initChartsConfig();// 初始化图形报表配置,织初始化一次
			this.chartFalg = 2;
		}

		var allDataArray = new Array();// 二维数组，存放数据
		var cm = this.getColumnModel();
		var colCount = cm.getColumnCount();

		// 标记需要取值的字段
		var cateColumnKeyLen = this.cateColumnKey.length;
		var columnFalg = new Array();
		for (var i = 0; i < cateColumnKeyLen; i++) {
			columnFalg.push(this.cateColumnKey[i]);
		}
		for (var i = 0, setColumnLen = this.setColumn.length; i < setColumnLen; i++) {
			columnFalg.push(this.setColumn[i]);
		}

		// 遍历grid
		for (var i = 0, it = this.store.data.items, l = it.length; i < l; i++) {
			var r = it[i].data;
			var k = 0;
			allDataArray[i] = new Array();

			for (var j = 0; j < colCount; j++) {
				var dataIndex = cm.getDataIndex(j);
				if ((dataIndex != '') && !cm.isHidden(j)
						&& this.isDataInArray(dataIndex, columnFalg)) {

					var v = r[dataIndex];
					var rendererFunc = cm.getRenderer(j);
					if (rendererFunc != null) {
						v = rendererFunc(v);
					}
					if (v == null) {
						v = '';
					}
					allDataArray[i].push(v);
				}
			}
		}
		return allDataArray;
	},
	/**
	 * 
	 * 图形报表配置参数(默认配置) 默认情况下第一列为种类关键字
	 * 
	 * 如果需要手动配置，可重写此方法
	 */
	initChartsConfig : function() {
		this.caption = this.title;
		this.seriesNames = new Array();
		this.cateColumnKey = new Array();
		this.setColumn = new Array();

		var cm = this.getColumnModel();
		var falg = 1;
		for (var i = 1, colCount = cm.getColumnCount(); i < colCount; i++) {
			var dataindex = cm.getDataIndex(i);
			if (!cm.isHidden(i) && falg === 1) {
				this.cateColumnKey.push(dataindex);
				falg = 2;
			} else if (!cm.isHidden(i) && falg === 2) {
				var columnName = cm.getColumnHeader(i);
				var fld = this.store.recordType.prototype.fields.get(dataindex);

				if ((fld.type == "int" || fld.type == "float")
						&& columnName != "") {
					this.seriesNames.push(columnName);
					this.setColumn.push(dataindex);
				}
			}
		}
	},
	/**
	 * 判断dataArray(数组)是否存在item(元素)
	 */
	isDataInArray : function(item, dataArray) {
		var falg = false;
		for (var i = 0, len = dataArray.length; i < len; i++) {
			if (item === dataArray[i]) {
				falg = true;
				break;
			}
		}
		return falg;
	}
});

/** *****对象的复制********* */
function cloneObj(fromObj, toObj) {
	for (var i in fromObj) {
		if (typeof fromObj[i] == 'object') {
			toObj[i] = {};
			cloneObj(fromObj[i], toObj[i]);
			continue;
		}
		toObj[i] = fromObj[i];
	}
}