/**
 * @description: 通用的form表单
 * @author: pbqi
 * @created on 2009年12月23日10:34:02
 * @modified on 2010年1月25日9:53:07
 */

Starit.CommonForm = Ext.extend(Ext.form.FormPanel, {
    frame : false,
    border: false,
    bodyStyle : "padding: 10px 0 0 20px",
    labelWidth : this.labelWidth || 100, // 默认为100
    labelAlign : 'left',
    layout : 'form',
    autoScroll: true,
    
    /**
     * 初始化系统组件
     */
    initComponent : function(){
        if(this.layout == 'form') {
            this.items = this.fields;
	    }
	    if(this.layout == 'column') {
           this.layout = 'form';
	       this.items = this.assembleItems(this.fields, this.columnNum, this.others);
	    }
        Starit.CommonForm.superclass.initComponent.call(this);
        
        //add selfDefine events.
        //this.addEvents("loadError",.......);
    },

    /**
     * private 列布局下组合items
     */
    assembleItems: function(fields, columnNum, others) {
        var colItems = [];          
        
        if(fields && fields.length) {
            var columnItems = [], itemLen = fields.length;
            
            var columnNum = columnNum || 2;
            if (columnNum > itemLen) {
                throw new Error("列的配置列数columnNum>fields的长度,应该小于或者等于.");
            }
            var columnW = 0.9 / columnNum;
            var avg = Math.floor(itemLen / columnNum);
            var remainder = itemLen % columnNum;

            var j = 0;
            var bakAvg = avg;
            for (var i = 0; i < columnNum; i++) {
                var fs = [];
                for (; j < avg; j++) {
                    fs.push(fields[j]);
                }
                if (remainder > 0) {
                    fs.push(fields[j++]);
                    remainder--;
                }
                columnItems.push({
                    xtype : 'panel',
                    columnWidth : columnW,
                    layout : 'form',
                    items : fs
                });

                avg = bakAvg + j;
            }
           colItems = [{
               xtype : 'panel',
               layout : 'column',
               items : columnItems
           }]; 
           
           if(others){
               colItems.push({
                   xtype : 'panel',
	               layout : 'form',
	               items : others
               });
           }
        }
        return colItems;
    }
});