/**
 * @description: 用户信息管理
 * @author: pbqi
 * @created on 2009年12月23日10:34:02
 * @modified on 2009年12月24日10:34:46
 */

Starit.CommonForm = Ext.extend(Ext.form.FormPanel, {

	        iconCls:null,
	        loadRecordId:null,//载入From数据，对应的Record的Id,例如:"userID"
	        viewport:null,//布局 父对象
			constructor : function(cfg) {

				// 把一个对象中的属性拷贝到当前对象中
				cfg = cfg || {};
				Ext.apply(this, cfg);

				this.initCfgParams();

				Starit.CommonForm.superclass.constructor.call(this, {
					frame : false,
                    //baseCls: '',
                    border: false,
					bodyStyle : "padding: 10px 0 0 20px",
					labelWidth : this.labelWidth || 100, // 默认为100
					labelAlign : 'left',
					layout : 'form'
				});
			},
			/**
			 * 可以看做一个抽象方法需要实现 初始化配置参数
			 */
			initCfgParams : function() {
			},

			/**
			 * private
			 * 
			 * @param {String}
			 *            html 要输入的用户提示信息
			 * @param {Object}
			 *            o 初始化参数配置 默认布局为'form' 若是'column' 布局, 需要配置 配置项 fields:
			 *            [fields, field2, .........], 列号 columnNum : 2 表明为2列
			 */
			initConfig : function(/* html, */o) {
				this.items = [];

				var layoutx = o.layout || "form";
				var itemLen = o.fields.length;

				if (layoutx == "form") { // form布局
					this.items = o.fields;
				}
				if (layoutx == "column") { // column布局
					var columnItems = [];

					var columnNum = o.columnNum || 2;
					if (columnNum > itemLen) {
						throw new Error("列的配置列数columnNum>fields的长度,应该小于或者等于.");
					}

					var columnW = 0.9 / columnNum;
					var avg = Math.floor(itemLen / columnNum);
					var remainder = itemLen % columnNum;

					var j = 0;

					var bakAvg = avg;
					for (var i = 0; i < columnNum; i++) {
						var fs = [];
						for (; j < avg; j++) {
							fs.push(o.fields[j]);
						}
						if (remainder > 0) {
							fs.push(o.fields[j++]);
							remainder--;
						}
						columnItems.push({
									xtype : 'panel',
									columnWidth : columnW,
									layout : 'form',
									items : fs
								});

						avg = bakAvg + j;
					}
					this.items = [{
								xtype : 'panel',
								layout : 'column',
								items : columnItems
							}];
				}
				/*
				 * this.items.unshift({ xtype:'panel', html:html, width:358,
				 * border:false, style:'border-bottom:1px solid
				 * #3674A7;margin:5px 0px 20px
				 * 17px;font-size:12px;font-weight:bold;' });
				 */
			},
			doSave : function() {
			},
			doClose : function() {
			},
			/**
			 * 清空Form中的数据
			 */
			doAllClear : function() {
				this.getForm().reset();
				this.doOtherClear();

			},
			/**
			 * 需要特殊清除的
			 * 可以看做一个抽象方法需要实现 初始化配置参数
			 */
			doOtherClear : function() {

			},
			/**
			 * 重置Form中的基本数据
			 */
			doReset : function() {
				this.getForm().reset();
				// 特殊的reset需要额外做
				this.doOtherReset();
			},
			/**
			 * 重置Form中的非基本数据
			 * 可以看做一个抽象方法需要实现 初始化配置参数
			 */
			doOtherReset : function() {

			},
			/**
			 * 从记录中根据name属性，载入Form的数据 
			 * 说明：通常record是从Grid中获得的一条记录
			 * @param {} record
			 */
			loadAllData : function(record) {
				// load Form的基本数据。
				this.getForm().loadRecord(record);
				
				this.loadFormatData(record);

				// 根据这条记录的ID ,载入其他具体信息
				if(this.loadRecordId){
				   var id=record.get(this.loadRecordId);
				   this.loadOtherData(id);
				}
			},
			/**
			 * 可以看做一个抽象方法需要实现 初始化配置参数
			 * 需要做特殊格式处理的数据的load
			 * @param {} record
			 */
			loadFormatData:function(record){
			
			},
			/**
			 * 可以看做一个抽象方法需要实现 初始化配置参数
			 * 对一些非基本数据，根据ID进行加载
			 * 例如 grid , tree等的数据需要额外加载的
			 * @param {} id
			 */
			loadOtherData : function(id) {

			}
		});