/**
 * 提供一些通用的field的配置
 */
/**
 * 生成一个通用的TextField.
 * @param {} fieldLabel
 * @param {} name
 * @param {} anchor
 * @param {} allowBlank  
 * @param {} helpText  帮助文本
 * @param {} vtype
 * @param {} blankText 错误提示文本
 * @param {} maxLength
 * @param {} maxLengthText
 * @return {}
 */
Starit.createTextField = function(fieldLabel, name, anchor,allowBlank,helpText,vtype, blankText, maxLength, maxLengthText) {   
	var itemCls=(allowBlank?'':'required-field');
    var tf = new Ext.form.TextField({
        fieldLabel: fieldLabel,
        name: name,
        xtype: 'textfield',
        readOnly: false,
        allowBlank: allowBlank,
        itemCls:itemCls,
        helpText:helpText,
        anchor: anchor,
        blankText: '该选项为必填项,请输入内容...',
        vtype: vtype,
        maxLength: maxLength,
        maxLengthText: maxLengthText
    });
    return tf;
};

/**
 * 生成一个通用的远程的combo
 * @param {} fieldLabel
 * @param {} url
 * @param {} anchor
 * @param {} allowBlank
 * @param {} helpText   帮助文本
 * @param {} id    不仅仅是本combo的name,也是valueField
 * @param {} name   本combo的displayField
 * @param {} extra1
 * @param {} extra2
 * @return {}
 */
Starit.createCombo = function(fieldLabel,url,id,name,anchor,allowBlank,helpText,extra1,extra2) {   
	    var itemCls=(allowBlank?'':'required-field');
        var combo = new Ext.form.ComboBox({
            autoLoad: true,
            fieldLabel: fieldLabel,
            emptyText: '请选择...',
            isFormField: true,
            anchor: anchor,
            mode: 'local',
            name:id,
            itemCls:itemCls,
            helpText:helpText,
            allowBlank: allowBlank,
            blankText:'请选择...',
            lastQuery: '',
            triggerAction: 'all',
            displayField:name,
            valueField:id,
            store: new Ext.data.Store({
                proxy: new Ext.data.HttpProxy({url: url, method: 'POST'}),
                reader: new Ext.data.JsonReader({},new Ext.data.Record.create([{name:id},{name:name},{name:extra1},{name:extra2}]))
            }),
            readOnly: true
        });
        return combo;
};

/**
 * 生成一个通用的本地combo
 * @param {} jsonData 格式必须是：[{id:456,name:'er'},{id:123,name:'123'},{id:12,name:'11'}]
 * @param {} anchor
 * @param {} allowBlank 
 * @param {} helpText  帮助文本
 * @return {}
 */
Starit.createMemoryCombo = function(fieldLabel,jsonData,anchor,allowBlank,helpText) {
     	 var itemCls=(allowBlank?'':'required-field');
         var combo = new Ext.form.ComboBox({
         	fieldLabel:fieldLabel,
            emptyText: '请选择...',
            isFormField: true,
            mode: 'local',
            name: "id",
            blankText:'请选择...',
            anchor: anchor,
            itemCls:itemCls,
            allowBlank:allowBlank,
            helpText:helpText,
            triggerAction: 'all',
            displayField:"name",
            valueField:"id",
            store: new Ext.data.Store({
                proxy: new Ext.data.MemoryProxy(jsonData),
                reader: new Ext.data.JsonReader({},new Ext.data.Record.create([{name:"id"},{name:"name"}]))
            }),
            readOnly: true
        });
        return combo;
    }

/**
 * 生成一个通用的Button
 * @param {} text       按钮名称
 * @param {} fn        点击的处理函数
 * @param {} scope     按钮的所在域
 * @param {} iconCls 
 * @return {}
 */
Starit.createButton = function(text,fn,scope,iconCls) {
    var btn = new Ext.Button({
        text: text,
        handler: fn,
        scope: scope,
        iconCls: iconCls
    });
    return btn;
};
/**
 * 生成一个通用的datefield
 * @param {} fieldLabel
 * @param {} name
 * @param {} format
 * @param {} anchor
 * @param {} allowBlank
 * @param {} helpText
 * @param {} value
 * @return {}
 */
Starit.createDateField = function(fieldLabel, name, format, anchor,allowBlank,helpText,value) {
	    var itemCls=(allowBlank?'':'required-field');
        var df =  new Ext.form.DateField({
            fieldLabel: fieldLabel,
            name: name,
            itemCls:itemCls,
            helpText:helpText,
            allowBlank:allowBlank,
            value : value,
            anchor: anchor,
            format: format
        });
        return df;
    }
/**
 * 创建一个隐藏的域
 * @param {} name
 * @param {} value
 * @return {}
 */
Starit.createHidden = function(name,value) {
    var hn = new Ext.form.Hidden({
        name: name,
        value:value
    });
    return hn;
};
/**
 * 创建一个通用的textarea
 * @param {} fieldLabel
 * @param {} name
 * @param {} height
 * @param {} anchor
 * @param {} allowBlank
 * @param {} helpText
 * @param {} blankText
 * @return {}
 */
Starit.createTextArea = function(fieldLabel,name,height,anchor,allowBlank,helpText,blankText) {
	 var itemCls=(allowBlank?'':'required-field');
    var ta = new Ext.form.TextArea({
        fieldLabel:fieldLabel,
        name:name,
        height:height,
        itemCls:itemCls,
        allowBlank:allowBlank,
        helpText:helpText,
        anchor:anchor,
        blankText:blankText
    });
    return ta;
};

/**
 * 创建一个通用的多选下拉框,两个多选框
 * @param {} valueField
 * @param {} displayField
 * @param {} fromStore
 * @param {} toStore
 * @return {}
 */    
Starit.createSelector = function(valueField, displayField, fromStore, toStore) {
    var selector = new Ext.ux.ItemSelector({ 
           isFormField: false,
           hideLabel: true,
           msWidth: 265,
           autoScroll:true,
           msHeight: 300,
           valueField: 'instanceId',
           displayField: 'userLabel',
           imagePath: '../resources/images/query',
           fromStore: fromStore,
           toStore: toStore
       });
       return selector;
};

/**
 * 创建一个通用的多选下拉框,一个多选框
 * @param {} valueField
 * @param {} displayField
 * @param {} fromStore
 * @param {} toStore
 * @return {}
 */    
Starit.createSingleSelector = function(id, name, data, legend, width, height) {
    var selector = new Ext.ux.Multiselect({ 
        isFormField: false,
        hideLabel: true,
        msWidth: 265,
        autoScroll:true,
        msHeight: 300,
        valueField: id,
        displayField: name,
        legend: legend,
        data: data,
        width: width,
        height: height,
        dataFields:[id, name]
    });
    return selector;
};