/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsinms.web;

import cn.com.starit.tsinms.web.FormatConvertor;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import jxl.Workbook;
import jxl.biff.FontRecord;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.struts2.ServletActionContext;

public class ExcelAction
extends ActionSupport {
    protected String filenamedisplay;
    protected List dataList;
    protected String[][] fieldArr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel() {
        String sheetName = this.filenamedisplay;
        OutputStream os = null;
        try {
            ActionContext.getContext().getActionInvocation().getProxy().setExecuteResult(false);
            HttpServletResponse response = ServletActionContext.getResponse();
            response.setContentType("application/vnd.ms-excel;charset=UTF-8");
            this.filenamedisplay = URLEncoder.encode(this.filenamedisplay, "UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + this.filenamedisplay + ".xls");
            os = response.getOutputStream();
            WritableWorkbook wwb = Workbook.createWorkbook((OutputStream)os);
            int num = 0;
            WritableSheet ws = wwb.createSheet(sheetName, num);
            int datalen = this.dataList.size();
            int fieldLen = this.fieldArr.length;
            this.createHeader(fieldLen, ws);
            this.setColumnFormat(fieldLen, ws);
            this.createValue(datalen, fieldLen, ws);
            wwb.write();
            wwb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
    }

    public WritableFont getFont(String fontName) {
        WritableFont font = new WritableFont(WritableFont.createFont((String)fontName));
        return font;
    }

    public WritableCellFormat getFormat(WritableFont font, int pointSize, Alignment horizAlignment) throws Exception {
        WritableCellFormat format = new WritableCellFormat();
        font.setPointSize(pointSize);
        format.setFont((FontRecord)font);
        format.setAlignment(horizAlignment);
        return format;
    }

    public void createHeader(int fieldLen, WritableSheet ws) throws Exception {
        WritableFont font = this.getFont("\u65b0\u5b8b\u4f53");
        WritableCellFormat format = this.getFormat(font, 14, Alignment.CENTRE);
        int i = 0;
        for (int len = 0; len < fieldLen; ++len) {
            Label label = new Label(i, 0, this.fieldArr[len][1], (CellFormat)format);
            ws.addCell((WritableCell)label);
            ++i;
        }
    }

    public void createValue(int datalen, int fieldLen, WritableSheet ws) throws Exception {
        WritableFont font = this.getFont("\u5b8b\u4f53");
        WritableCellFormat format = this.getFormat(font, 12, Alignment.CENTRE);
        for (int i = 1; i < 1 + datalen; ++i) {
            Object temp = this.dataList.get(i - 1);
            int j = 0;
            for (int len = 0; len < fieldLen; ++len) {
                Object object = FormatConvertor.getValue(temp, (String)this.fieldArr[len][0]);
                Label label = null;
                if (object != null) {
                    String str = object.toString().trim().replace(",", ";");
                    label = new Label(j, i, str, (CellFormat)format);
                    ws.addCell((WritableCell)label);
                } else {
                    ws.addCell((WritableCell)new Label(j, i, " ", (CellFormat)format));
                }
                ++j;
            }
        }
        this.mergeCell(ws, 0, 0, 0, 0);
    }

    public void setColumnFormat(int fieldLen, WritableSheet ws) {
        for (int j = 0; j < fieldLen; ++j) {
            ws.setColumnView(j, 15);
        }
    }

    public void mergeCell(WritableSheet ws, int m, int n, int q, int p) throws Exception {
        ws.mergeCells(m, n, q, p);
    }

    public void addOneLabel(int col, int row, String val, WritableSheet ws) throws Exception {
        Label label = new Label(col, row, val);
        ws.addCell((WritableCell)label);
    }

    public void addOneNumber(int col, int row, double val, WritableSheet ws) throws Exception {
        Number num = new Number(col, row, val);
        ws.addCell((WritableCell)num);
    }

    public WritableCellFormat formatCell(WritableSheet ws, String fontName, int pointSize, Alignment horizAlignment, VerticalAlignment vertAlignment, Colour bgColour, Border border, BorderLineStyle borderLineStyle, Colour borderColour) throws Exception {
        WritableFont font = new WritableFont(WritableFont.createFont((String)fontName));
        WritableCellFormat cellFormat = new WritableCellFormat();
        font.setPointSize(pointSize);
        cellFormat.setFont((FontRecord)font);
        cellFormat.setAlignment(horizAlignment);
        cellFormat.setVerticalAlignment(vertAlignment);
        cellFormat.setBackground(bgColour);
        cellFormat.setBorder(border, borderLineStyle, borderColour);
        cellFormat.setWrap(true);
        return cellFormat;
    }
}

