/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.register.web.dwr;

import cn.com.starit.inas.biz.log.LogServiceProvider;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationResult;
import cn.com.starit.inas.biz.log.SysLogManager.util.OperationType;
import cn.com.starit.inas.biz.tree.TreeServiceProvider;
import cn.com.starit.inas.biz.tree.node.Node;
import cn.com.starit.inas.persistence.po.security.UserInfo;
import cn.com.starit.tsaip.register.biz.IServAffordManRegService;
import cn.com.starit.tsaip.register.biz.IServDirectoryService;
import cn.com.starit.tsaip.register.biz.IServSubscribeConfService;
import cn.com.starit.tsaip.register.biz.IServVisitLimitService;
import cn.com.starit.tsaip.register.biz.tree.node.impl.ServCompositeNode;
import cn.com.starit.tsaip.register.dto.ServDto;
import cn.com.starit.tsaip.register.dto.ServManDto;
import cn.com.starit.tsaip.register.persistence.entity.ServAffordManConfig;
import cn.com.starit.tsaip.register.persistence.entity.ServAffordManReg;
import cn.com.starit.tsaip.register.persistence.entity.ServDirectoryLevel;
import cn.com.starit.tsaip.register.persistence.entity.ServSubscribeConf;
import cn.com.starit.tsaip.register.persistence.entity.ServVisitLimit;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServManServRegDwr {
    private Log log = LogFactory.getLog(ServManServRegDwr.class);
    private IServAffordManRegService servAffordManRegService;
    private IServVisitLimitService servVisitLimitService;
    private IServDirectoryService servDirectoryLevelService;
    private IServSubscribeConfService subscribeConfService;

    public String findServInfoById(Long servId) {
        String str = "";
        try {
            List list = this.servAffordManRegService.getServInfoById(servId);
            str = list == null || list.size() == 0 ? "" : JSONObject.fromObject(list.get(0)).toString();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        return str;
    }

    public List<ServDto> getServVisitLimitById(long servManId) {
        List list = this.servVisitLimitService.getServVisitById(servManId);
        ArrayList servIdList = new ArrayList();
        return list;
    }

    public List<ServDto> getSubscribeConfById(long servDefineId) {
        List list = this.subscribeConfService.getSubscribeConfById(servDefineId);
        return list;
    }

    public IServSubscribeConfService getServSubsribeConfService() {
        return this.subscribeConfService;
    }

    public void setServSubsribeConfService(IServSubscribeConfService subscribeConfService) {
        this.subscribeConfService = subscribeConfService;
    }

    public List<Long> getServManVisitLimitById(long servId) {
        List list = this.servVisitLimitService.getServManVisitById(servId);
        ArrayList<Long> servManIdList = new ArrayList<Long>();
        for (ServManDto dto : list) {
            servManIdList.add(dto.getServManId());
        }
        return servManIdList;
    }

    public boolean saveServVisitLimit(long servManId, long servId, double versionNo, long isConfirm) {
        try {
            ServVisitLimit servVisitLimit = new ServVisitLimit();
            ServAffordManConfig man = new ServAffordManConfig();
            man.setServManId(servManId);
            ServAffordManReg reg = new ServAffordManReg();
            reg.setServId(servId);
            servVisitLimit.setServAffordManConfig(man);
            servVisitLimit.setServAffordManReg(reg);
            servVisitLimit.setVersionNo(versionNo);
            servVisitLimit.setIsConfirm(isConfirm);
            this.servVisitLimitService.saveServVisitLimit(servVisitLimit);
            return true;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateServVisitLimit(long servLimitId, long servManId, long servId, double versionNo, long isConfirm) {
        try {
            ServVisitLimit servVisitLimit = new ServVisitLimit();
            if (servLimitId != 0L) {
                servVisitLimit.setServLimitId(servLimitId);
            }
            ServAffordManConfig man = new ServAffordManConfig();
            man.setServManId(servManId);
            ServAffordManReg reg = new ServAffordManReg();
            reg.setServId(servId);
            servVisitLimit.setServAffordManConfig(man);
            servVisitLimit.setServAffordManReg(reg);
            servVisitLimit.setVersionNo(versionNo);
            servVisitLimit.setIsConfirm(isConfirm);
            this.servVisitLimitService.updateServVisitLimit(servVisitLimit);
            return true;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateServVisitLimita(long isConfirm, long servLimitId, long servManId, long servId, double versionNo, String flux, String frequency) {
        try {
            ServVisitLimit servVisitLimit = new ServVisitLimit();
            if (servLimitId != 0L) {
                servVisitLimit.setServLimitId(servLimitId);
            }
            ServAffordManConfig man = new ServAffordManConfig();
            man.setServManId(servManId);
            ServAffordManReg reg = new ServAffordManReg();
            reg.setServId(servId);
            servVisitLimit.setFlux(flux);
            servVisitLimit.setIsConfirm(isConfirm);
            servVisitLimit.setFrequency(frequency);
            servVisitLimit.setServAffordManConfig(man);
            servVisitLimit.setServAffordManReg(reg);
            servVisitLimit.setVersionNo(versionNo);
            this.servVisitLimitService.updateServVisitLimit(servVisitLimit);
            return true;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean insertServVisitLimit(long servManId, long servId, double versionNo, String flux, String frequency) {
        try {
            ServVisitLimit servVisitLimit = new ServVisitLimit();
            ServAffordManConfig man = new ServAffordManConfig();
            man.setServManId(servManId);
            ServAffordManReg reg = new ServAffordManReg();
            reg.setServId(servId);
            servVisitLimit.setFlux(flux);
            servVisitLimit.setFrequency(frequency);
            servVisitLimit.setServAffordManConfig(man);
            servVisitLimit.setServAffordManReg(reg);
            servVisitLimit.setVersionNo(versionNo);
            this.servVisitLimitService.saveServVisitLimit(servVisitLimit);
            return true;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean check(long servManId, long servId, double versionNo) {
        return this.servVisitLimitService.check(servManId, servId, versionNo);
    }

    public boolean delServVisitLimit(long servManId, long servId) {
        try {
            this.servVisitLimitService.deleteServVisitLimit(servManId, servId);
            return true;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean findServByCode(Long servId, String servCode) {
        List list = this.servAffordManRegService.findServByCode(servId, servCode);
        return list == null || list.size() <= 0;
    }

    public Long saveServ(ServAffordManReg entity, String pNodeId, String servManName, String servManNodeId, ServDirectoryLevel servLevel, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u6dfb\u52a0\u670d\u52a1\uff0c\u670d\u52a1\u5546[" + servManName + "]\u65b0\u589e\u670d\u52a1[" + entity.getServName() + "],\u670d\u52a1\u7f16\u7801:[" + entity.getServCode() + "],\u670d\u52a1\u540d\u79f0:[" + entity.getServName() + "]";
        try {
            ServAffordManConfig man = new ServAffordManConfig();
            int end = pNodeId.lastIndexOf(95);
            String pNodeType = pNodeId.substring(0, end);
            if (pNodeType.equals("type")) {
                man.setServManId(Long.parseLong(servManNodeId.substring(9)));
            } else {
                man.setServManId(Long.parseLong(pNodeId.substring(9)));
            }
            entity.setServAffordManConfig(man);
            Long servId = this.servAffordManRegService.save(entity);
            servLevel.setBusiId(servId.longValue());
            if (pNodeType.equals("type")) {
                this.servDirectoryLevelService.save(servLevel);
            }
            Node pNode = TreeServiceProvider.getNodeStorage().getNode(pNodeId);
            Node node = TreeServiceProvider.getNodeFactory().createServNode(servId.toString(), entity.getServName(), null);
            pNode.addChildNode(node);
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Add, OperationResult.SUCC, content);
            return servId;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Add, OperationResult.FAIL, content);
            return null;
        }
    }

    public boolean updateServ(ServAffordManReg entity, String servManName, long oldStat, String oldServName, String oldServCode, HttpSession session) {
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u4fee\u6539\u670d\u52a1\uff0c\u4fee\u6539\u670d\u52a1\u5546[" + servManName + "]\u4e0b\u670d\u52a1[" + entity.getServName() + "],\u4fee\u6539\u524d\u670d\u52a1\u540d\u79f0:[" + oldServName + "],\u4fee\u6539\u524d\u670d\u52a1\u7f16\u7801:[" + oldServCode + "],\u4fee\u6539\u540e\u670d\u52a1\u7f16\u7801:[" + entity.getServCode() + "]";
        try {
            this.servAffordManRegService.update(entity);
            ServCompositeNode node = (ServCompositeNode)TreeServiceProvider.getNodeStorage().getNode("serv_" + entity.getServId());
            node.setNodeName(entity.getServName());
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Update, OperationResult.SUCC, content);
            if (entity.getServStat() != oldStat) {
                String contentStat = "\u4fee\u6539\u670d\u52a1\u72b6\u6001\uff0c\u4fee\u6539\u670d\u52a1\u5546[" + servManName + "]\u4e0b\u670d\u52a1[" + entity.getServName() + "]\u72b6\u6001\u4ece" + this.convertServState((int)oldStat) + "\u6539\u4e3a" + this.convertServState((int)entity.getServStat());
                LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Update, OperationResult.SUCC, contentStat);
            }
            return true;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Update, OperationResult.FAIL, content);
            return false;
        }
    }

    private String convertServState(int state) {
        String stateName = "";
        switch (state) {
            case 1: {
                stateName = "[\u5df2\u6ce8\u518c]";
                break;
            }
            case 2: {
                stateName = "[\u5df2\u53d1\u5e03]";
                break;
            }
            case 3: {
                stateName = "[\u5df2\u6ce8\u9500]";
                break;
            }
        }
        return stateName;
    }

    public boolean deleteServ(String nodeId, String pNodeId, String servName, String servManName, HttpSession session) {
        Long servId = Long.parseLong(nodeId.substring(5));
        UserInfo userInfo = (UserInfo)session.getAttribute("USER_INFO");
        String content = "\u5220\u9664\u670d\u52a1\uff0c\u5220\u9664\u670d\u52a1\u5546[" + servManName + "]\u4e0b\u670d\u52a1[" + servName + "],\u670d\u52a1\u540d\u79f0:[" + servName + "]";
        try {
            this.servAffordManRegService.delete(servId);
            Node pNode = TreeServiceProvider.getNodeStorage().getNode(pNodeId);
            Node node = TreeServiceProvider.getNodeStorage().getNode(nodeId);
            pNode.removeChildNode(node);
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Remove, OperationResult.SUCC, content);
            return true;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            LogServiceProvider.getSysLogHandler().handle(userInfo, OperationType.Remove, OperationResult.FAIL, content);
            return false;
        }
    }

    public List<String> filterServByName(String filterName) {
        List servIdList = null;
        try {
            servIdList = this.servAffordManRegService.getAllFilterServ(filterName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return servIdList;
    }

    public void setServAffordManRegService(IServAffordManRegService servAffordManRegService) {
        this.servAffordManRegService = servAffordManRegService;
    }

    public void setServVisitLimitService(IServVisitLimitService servVisitLimitService) {
        this.servVisitLimitService = servVisitLimitService;
    }

    public boolean saveOrUpdateSubscribeConf(long subscribeConfId, long servManId, long servDefineId, long servId, double versionNo) {
        try {
            ServSubscribeConf ssc = new ServSubscribeConf();
            ssc.setServSubscribeConfId(subscribeConfId);
            ssc.setServDefineId(servDefineId);
            ServAffordManConfig servAffordManConfig = new ServAffordManConfig();
            servAffordManConfig.setServManId(servManId);
            ssc.setServAffordManConfig(servAffordManConfig);
            ServAffordManReg samr = new ServAffordManReg();
            samr.setServId(servId);
            ssc.setServAffordManReg(samr);
            ssc.setSubscribeServVersion(versionNo);
            this.subscribeConfService.saveOrUpdate(ssc);
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public boolean deleteSubscribeConf(long subsribeConfId, long servDefineId) {
        try {
            ServSubscribeConf scc = new ServSubscribeConf();
            scc.setServDefineId(servDefineId);
            scc.setServSubscribeConfId(subsribeConfId);
            this.subscribeConfService.deleteConf(scc);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public void setServDirectoryLevelService(IServDirectoryService servDirectoryLevelService) {
        this.servDirectoryLevelService = servDirectoryLevelService;
    }
}

