/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.register.persistence.dao;

import cn.com.starit.common.persistence.GenericHibernateDao;
import cn.com.starit.common.persistence.Page;
import cn.com.starit.common.util.StringUtil;
import cn.com.starit.oip.Srp.pesistence.entity.ConnSrpReg;
import cn.com.starit.tsaip.audit.dto.AipMessageDto;
import cn.com.starit.tsaip.register.dto.ServResendDto;
import cn.com.starit.tsaip.register.dto.ServVersionDto;
import cn.com.starit.tsaip.register.persistence.entity.MsgResendRuleConf;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;

public class ServVersionDao
extends GenericHibernateDao<MsgResendRuleConf, Long> {
    public Page<ServVersionDto> findPage(ServVersionDto servVersionDto, Page<ServVersionDto> page) {
        String hql = " select new cn.com.starit.tsaip.register.dto.ServVersionDto(mr.recordsn, s.servName, s.servAffordManConfig.servManName,mr.resendTimes,mr.resendInterval,mr.sendTime ,mr.servCode,s.servId,s.servAffordManConfig.servManId,mr.resendRule,b.businname)  from MsgResendRuleConf mr,ServAffordManReg s,BndictTDictionary b where b.id.busintypeid='MSG_RESEND_RULE' and b.id.businid=mr.resendRule and mr.servCode= to_char(s.servId) ";
        if (servVersionDto != null) {
            hql = hql + (servVersionDto.getServManId() == 0L ? "" : " and s.servAffordManConfig.servManId = " + servVersionDto.getServManId());
            hql = hql + (servVersionDto.getServId() == 0L ? "" : " and s.servId = " + servVersionDto.getServId());
        }
        hql = hql + " order by s.servAffordManConfig.servManId,s.servId";
        Page resultPage = this.findPage(page, hql, new Object[0]);
        return resultPage;
    }

    public long getQueryCount(MsgResendRuleConf entity) {
        String hql = "select count(*) from MsgResendRuleConf mr where ";
        hql = hql + (entity.getServCode() != null || !"".equals(entity.getServCode()) ? " mr.servCode = '" + entity.getServCode() + "' " : " ");
        return this.countHqlResult(hql, new Object[0]);
    }

    private String getDateFromStconfig(String key) {
        return ConfigControl.getStConfigCache().getConfigValue((Object)key) == null ? "" : (String)ConfigControl.getStConfigCache().getConfigValue((Object)key);
    }

    public List<ServResendDto> getResendMsg() {
        long currtMillTime = new Date().getTime() / 1000L - 172800L;
        Date beforeDate = new Date();
        beforeDate.setTime(currtMillTime * 1000L);
        return this.getResendMsg(beforeDate);
    }

    public List<ServResendDto> getResendMsg(Date beforeDate) {
        ArrayList<ServResendDto> res = new ArrayList<ServResendDto>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (beforeDate == null) {
            return res;
        }
        String sql = "select t1.send_system,t1.receive_system,t1.serv_code,t1.store_key,t1.id,t1.csb_id,m.resend_interval,m.fixed_time,m.resend_rule,t1.resendCount,m.resend_times,t1.receiveTime from (select s.serv_id as servId, t.id,t.csb_id,t.send_system,t.receive_system,t.serv_code,t.store_key,t.resend_count as resendCount,t.receive_time as receiveTime  from aip_message_persistence t, serv_afford_man_reg s where (t.resend_flag!=1 or t.resend_flag is null) and  t.service_state in (1, 7, 8,296,297,298,299)  and t.serv_code = s.serv_code and s.serv_invoke_mode=1 and t.receive_time >= to_date('" + sdf.format(beforeDate) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "') ) t1,msg_resend_rule_conf m where to_char(t1.servId) = m.serv_code and t1.resendCount < m.resend_times";
        List list = this.findBySQL(sql, new Object[0]);
        for (Object[] objs : list) {
            try {
                res.add(new ServResendDto(StringUtil.getStringFrom((Object)objs[0]), StringUtil.getStringFrom((Object)objs[1]), StringUtil.getStringFrom((Object)objs[2]), StringUtil.getStringFrom((Object)objs[3]), StringUtil.getLongFrom((Object)objs[4]), StringUtil.getStringFrom((Object)objs[5]), StringUtil.getLongFrom((Object)objs[6]), StringUtil.getStringFrom((Object)objs[7]), StringUtil.getStringFrom((Object)objs[8]), StringUtil.getLongFrom((Object)objs[9]), StringUtil.getLongFrom((Object)objs[10]), StringUtil.getDateFrom((Object)objs[11])));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public List<ServResendDto> getServResendByIds(String ids, boolean withoutServiceStat) {
        String sql = "select t.send_system,t.receive_system,t.serv_code,t.store_key,t.id,t.csb_id,t.resend_count resendCount , t.receive_time receive_time from aip_message_persistence t where t.id in (" + ids + ") ";
        if (!withoutServiceStat) {
            sql = sql + " and t.service_state in (1, 7, 8,296,297,298,299) ";
        }
        List list = this.findBySQL(sql, new Object[0]);
        ArrayList<ServResendDto> res = new ArrayList<ServResendDto>();
        for (Object[] objs : list) {
            try {
                res.add(new ServResendDto(StringUtil.getStringFrom((Object)objs[0]), StringUtil.getStringFrom((Object)objs[1]), StringUtil.getStringFrom((Object)objs[2]), StringUtil.getStringFrom((Object)objs[3]), StringUtil.getLongFrom((Object)objs[4]), StringUtil.getStringFrom((Object)objs[5]), Long.valueOf(0L), "", "", StringUtil.getLongFrom((Object)objs[6]), Long.valueOf(0L), StringUtil.getDateFrom((Object)objs[7])));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public boolean checkResend4Subscribe(String servManCode, String csbId) {
        String hql = " from AipMessageConfirm a where a.esbId=? and a.cfmManCode=? and a.cfmStatus=1";
        List list = this.find(hql, new Object[]{csbId, servManCode});
        return list != null;
    }

    public AipMessageDto getServResend(String msgId, String sender) {
        String sql = "select t.id,t.csb_id,t.send_system,t.receive_system,t.serv_code,t.store_key,t.resend_count resendCount , t.receive_time receive_time,t.service_state  from aip_message_persistence t where t.msg_id =? and t.send_system=?";
        List list = this.findBySQL(sql, new Object[]{msgId, sender});
        ArrayList res = new ArrayList();
        for (Object[] objs : list) {
            try {
                AipMessageDto dto = new AipMessageDto();
                dto.setId(StringUtil.getLongFrom((Object)objs[0]).longValue());
                dto.setCsbId(StringUtil.getStringFrom((Object)objs[1]));
                dto.setSendSystem(StringUtil.getStringFrom((Object)objs[2]));
                dto.setReceiveSystem(StringUtil.getStringFrom((Object)objs[3]));
                dto.setServCode(StringUtil.getStringFrom((Object)objs[4]));
                dto.setStoreKey(StringUtil.getStringFrom((Object)objs[5]));
                dto.setResendCount(StringUtil.getLongFrom((Object)objs[6]).longValue());
                dto.setReceiveTime(StringUtil.getDateFrom((Object)objs[7]));
                dto.setServiceState(StringUtil.getLongFrom((Object)objs[8]).longValue());
                return dto;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ServResendDto getServResendById(Long id, boolean withoutServiceStat) {
        String sql = "select t.send_system,t.receive_system,t.serv_code,t.store_key,t.id,t.csb_id,t.resend_count resendCount , t.receive_time receive_time from aip_message_persistence t where t.id =? ";
        if (!withoutServiceStat) {
            sql = sql + " and t.service_state in (1, 7, 8,296,297,298,299) ";
        }
        List list = this.findBySQL(sql, new Object[]{id});
        for (Object[] objs : list) {
            try {
                return new ServResendDto(StringUtil.getStringFrom((Object)objs[0]), StringUtil.getStringFrom((Object)objs[1]), StringUtil.getStringFrom((Object)objs[2]), StringUtil.getStringFrom((Object)objs[3]), StringUtil.getLongFrom((Object)objs[4]), StringUtil.getStringFrom((Object)objs[5]), Long.valueOf(0L), "", "", StringUtil.getLongFrom((Object)objs[6]), Long.valueOf(0L), StringUtil.getDateFrom((Object)objs[7]));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ConnSrpReg getConnSrpRegByPlainCode(String plainCode) {
        DetachedCriteria dc = DetachedCriteria.forClass(ConnSrpReg.class);
        dc.add((Criterion)Restrictions.eq((String)"connRoutePlatCode", (Object)plainCode));
        Object obj = this.getHibernateTemplate().execute((HibernateCallback)new /* Unavailable Anonymous Inner Class!! */);
        return obj == null ? null : (ConnSrpReg)obj;
    }

    public Page<ServVersionDto> findConnResendConfPage(ServVersionDto servVersionDto, Page<ServVersionDto> page) {
        String hql = "select t.recordsn,t.serv_code,t.resend_times,t.resend_interval,t.resend_rule,c.conn_serv_name, c.conn_route_plat_code,d.businname,t.fixed_time from msg_resend_rule_conf t, conn_serv_reg c, bndict_t_dictionary d where t.resend_rule = d.businid and d.busintypeid = 'MSG_RESEND_RULE' and t.serv_code = c.conn_serv_code";
        if (servVersionDto != null) {
            if (servVersionDto.getConnServCode() != null && !"0".equals(servVersionDto.getConnServCode())) {
                hql = hql + " and t.serv_code ='" + servVersionDto.getConnServCode() + "'";
            }
            if (servVersionDto.getConnPlatCode() != null && !"0".equals(servVersionDto.getConnPlatCode())) {
                hql = hql + " and c.conn_route_plat_code='" + servVersionDto.getConnPlatCode() + "'";
            }
        }
        hql = hql + " order by t.recordsn desc";
        SQLQuery query = (SQLQuery)this.createSQLQuery(hql, null);
        query.setFirstResult(page.getStart());
        query.setMaxResults(page.getPageSize());
        List list = query.list();
        ArrayList<ServVersionDto> res = new ArrayList<ServVersionDto>();
        for (Object[] obj : list) {
            ServVersionDto dto = new ServVersionDto();
            dto.setServName(StringUtil.getStringFrom((Object)obj[5]));
            dto.setResendRule(StringUtil.getStringFrom((Object)obj[4]));
            dto.setResendInterval(StringUtil.getLongFrom((Object)obj[3]).longValue());
            dto.setId(StringUtil.getLongFrom((Object)obj[0]).longValue());
            dto.setResendRuleName(StringUtil.getStringFrom((Object)obj[7]));
            dto.setResendTimes(StringUtil.getLongFrom((Object)obj[2]).longValue());
            dto.setSendTime(StringUtil.getStringFrom((Object)obj[8]));
            dto.setConnPlatCode(StringUtil.getStringFrom((Object)obj[6]));
            dto.setConnServCode(StringUtil.getStringFrom((Object)obj[1]));
            res.add(dto);
        }
        page.setResult(res);
        Integer maxCount = ConfigControl.getStConfigCache().getConfigValue((Object)"MAX_MSG_SEARCH_NUM") == null ? Integer.valueOf(10000) : (String)ConfigControl.getStConfigCache().getConfigValue((Object)"MAX_MSG_SEARCH_NUM");
        String countSql = "select count(*) from msg_resend_rule_conf t ";
        if (servVersionDto != null && servVersionDto.getConnServCode() != null && !"0".equals(servVersionDto.getConnServCode())) {
            countSql = countSql + " where t.serv_code ='" + servVersionDto.getConnServCode() + "'";
        }
        List countRes = this.findBySQL(countSql, new Object[0]);
        page.setTotalCount(StringUtil.getLongFrom(countRes.get(0)).longValue());
        return page;
    }

    public List<ServResendDto> getConnResendMsg() {
        long currtMillTime = new Date().getTime() / 1000L - 172800L;
        Date beforeDate = new Date();
        beforeDate.setTime(currtMillTime * 1000L);
        return this.getConnResendMsg(beforeDate);
    }

    public List<ServResendDto> getConnResendMsg(Date beforeDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sql = "select t1.send_system,t1.receive_system,t1.serv_code,t1.store_key,t1.id,t1.csb_id,m.resend_interval,m.fixed_time,m.resend_rule,t1.resendCount,m.resend_times,t1.receiveTime from (select s.conn_serv_code as servId, t.id,t.csb_id,t.send_system,t.receive_system,t.serv_code,t.store_key,t.resend_count as resendCount,t.receive_time as receiveTime  from aip_message_persistence t, conn_serv_reg s where  (t.resend_flag!=1 or t.resend_flag is null) and t.conn_flag=2 and t.service_state in (1, 7, 8,296,297,298,299)  and t.serv_code = s.conn_serv_code  and t.receive_time >= to_date('" + sdf.format(beforeDate) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "') ) t1,msg_resend_rule_conf m where to_char(t1.servId) = m.serv_code and t1.resendCount < m.resend_times";
        List list = this.findBySQL(sql, new Object[0]);
        ArrayList<ServResendDto> res = new ArrayList<ServResendDto>();
        for (Object[] objs : list) {
            try {
                res.add(new ServResendDto(StringUtil.getStringFrom((Object)objs[0]), StringUtil.getStringFrom((Object)objs[1]), StringUtil.getStringFrom((Object)objs[2]), StringUtil.getStringFrom((Object)objs[3]), StringUtil.getLongFrom((Object)objs[4]), StringUtil.getStringFrom((Object)objs[5]), StringUtil.getLongFrom((Object)objs[6]), StringUtil.getStringFrom((Object)objs[7]), StringUtil.getStringFrom((Object)objs[8]), StringUtil.getLongFrom((Object)objs[9]), StringUtil.getLongFrom((Object)objs[10]), StringUtil.getDateFrom((Object)objs[11])));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    public boolean checkResendStatus(String esbId) {
        String sql = "select count(*) from resend_instance t,aip_message_persistence p where t.resend_esb_id=p.csb_id and t.esb_id=? and p.service_state=0 ";
        List list = this.findBySQL(sql, new Object[]{esbId});
        if (list.size() > 0) {
            int status = StringUtil.getIntegerFrom(list.get(0));
            return status != 0;
        }
        return false;
    }
}

