/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.register.persistence.dao;

import cn.com.starit.common.persistence.GenericHibernateDao;
import cn.com.starit.common.util.StringUtil;
import cn.com.starit.inas.persistence.service.PagingOption;
import cn.com.starit.tsaip.register.dto.JobConfigDto;
import cn.com.starit.tsaip.register.dto.ServDefineDto;
import cn.com.starit.tsaip.register.dto.ServDefineProbeDto;
import cn.com.starit.tsaip.register.dto.ServManDto;
import cn.com.starit.tsaip.register.dto.StaticDataDto;
import cn.com.starit.tsaip.register.persistence.entity.DataFormatConvert;
import cn.com.starit.tsaip.register.persistence.entity.ServDefine;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ServDefineDaoImpl
extends GenericHibernateDao<ServDefine, Long> {
    public String oracleClobToStr(Clob clob) {
        try {
            return clob != null ? clob.getSubString(1L, (int)clob.length()) : null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<ServDefineDto> getServDefineById(long servManId, long servId, PagingOption pagingOption) {
        String querySql = "";
        String countSql = "select count(sd.serv_define_id) ";
        String sql = " select %s sd.serv_id,reg.serv_code,config.serv_Man_Code,reg.serv_Name,sd.serv_define_id,sd.serv_type,dic.businname servTypeName,wf.busi_serv_addr,wf.proxy_serv_addr,sd.message_Type,sd.operation_Name,sd.param_Name,sd.res_Operation_Name,sd.res_Param_Name,sd.ns, wf.busi_Wsdl_Text,wf.proxy_wsdl_text,pro.file_Path,wo.wsdl_Oper_Id,config.serv_Man_Id,nvl(sd.version_No,0) version_No,sd.version_State version_State,wo.oper_Name,pro.protocol_Name,nvl(wf.wsdl_Id,0) wsdl_Id,nvl(pro.protocol_Id,0) protocol_Id,dc.businname verStateName,nvl(sd.serv_Probe_Flag,2) serv_Probe_Flag, queue.queue_name,subscribe_Flag,protocol_Convert_Flag,dct.businname protocolConvertFlagName,reg.serv_type  isAtomServ,sd.route_flag,sd.route_role,reg.serv_invoke_mode servInvokeMode ";
        String prefix = " from Serv_Define sd  left join Bndict_T_Dictionary dic on  sd.SERV_TYPE = dic.BUSINID and (dic.BUSINTYPEID = 'SERV_TYPE' or dic.BUSINTYPEID is null) left join wsdl_conf wf on   sd.wsdl_id = wf.wsdl_id left join  protocol_info pro on  sd.protocol_id = pro.protocol_id left join wsdl_oper wo on  sd.wsdl_oper_id = wo.wsdl_oper_id left join Bndict_T_Dictionary dc on  sd.VERSION_STATE = dc.BUSINID and (dc.BUSINTYPEID = 'VERSION_STATE' or dc.BUSINTYPEID is null) left join serv_Afford_Man_Reg reg on sd.serv_id = reg.serv_id left join Bndict_T_Dictionary dct on  sd.PROTOCOL_CONVERT_FLAG = dct.BUSINID and (dct.BUSINTYPEID = 'PROTOCOL_CONVERT_FLAG' or dct.BUSINTYPEID is null) left join serv_Afford_Man_Config config on  reg.ser_serv_man_id = config.serv_man_id left join queue_Conf queue  on sd.serv_id = reg.serv_id and reg.ser_serv_man_id = config.serv_man_id and config.receive_queue_id = queue.queue_id where  1 = 1  ";
        prefix = prefix + (servId == -1L || servId == 0L ? " " : " and sd.serv_Id=" + servId);
        prefix = prefix + (servManId != 0L ? " and config.serv_Man_Id =" + servManId : " ");
        if (this.isOracle()) {
            sql = String.format(sql, " ");
            querySql = "select *  from (select row_.*, rownum rownum_ from (" + sql + prefix + ")  row_  where rownum <= " + (pagingOption.getPerPageRecordCount() + pagingOption.getFirstResult()) + ") where rownum_ > " + pagingOption.getFirstResult();
        } else {
            sql = String.format(sql, "skip " + pagingOption.getFirstResult() + " first " + pagingOption.getPerPageRecordCount());
            querySql = sql + prefix;
        }
        List list = this.getJdbcTemplate().queryForList(querySql);
        Long total = this.getJdbcTemplate().queryForLong(countSql + prefix);
        pagingOption.setRecordCount(total.intValue());
        return this.encapServDefineDto(list);
    }

    public List<ServDefineDto> getServDefineByAtomId(long atomServId, PagingOption pagingOption) {
        String querySql = "";
        String countSql = "select count(sd.serv_define_id) ";
        String sql = " select  %s sd.serv_id,reg.serv_code,config.serv_Man_Code,reg.serv_Name,sd.serv_define_id,sd.serv_type,dic.businname servTypeName,wf.busi_serv_addr,wf.proxy_serv_addr,sd.message_Type,sd.operation_Name,sd.param_Name,sd.res_Operation_Name,sd.res_Param_Name,sd.ns, wf.busi_Wsdl_Text,wf.proxy_wsdl_text,pro.file_Path,wo.wsdl_Oper_Id,config.serv_Man_Id,nvl(sd.version_No,0) version_No,nvl(sd.version_State,0) version_State,wo.oper_Name,pro.protocol_Name,nvl(wf.wsdl_Id,0) wsdl_Id,nvl(pro.protocol_Id,0) protocol_Id,dc.businname verStateName,nvl(sd.serv_Probe_Flag,2) serv_Probe_Flag, queue.queue_name,subscribe_Flag,protocol_Convert_Flag,dct.businname protocolConvertFlagName ";
        String prefix = " from Serv_Define sd  left join Bndict_T_Dictionary dic on  sd.SERV_TYPE = dic.BUSINID and (dic.BUSINTYPEID = 'SERV_TYPE' or dic.businid is null) left join wsdl_conf wf on   sd.wsdl_id = wf.wsdl_id left join  protocol_info pro on  sd.protocol_id = pro.protocol_id left join wsdl_oper wo on  sd.wsdl_oper_id = wo.wsdl_oper_id left join Bndict_T_Dictionary dc on  sd.VERSION_STATE = dc.BUSINID and (dc.BUSINTYPEID = 'VERSION_STATE' or dc.BUSINTYPEID is null) left join serv_Afford_Man_Reg reg on sd.serv_id = reg.serv_id left join Bndict_T_Dictionary dct on  sd.PROTOCOL_CONVERT_FLAG = dct.BUSINID and (dct.BUSINTYPEID = 'PROTOCOL_CONVERT_FLAG' or dct.BUSINTYPEID is null) left join serv_Afford_Man_Config config on  reg.ser_serv_man_id = config.serv_man_id left join queue_Conf queue  on sd.serv_id = reg.serv_id and reg.ser_serv_man_id = config.serv_man_id and config.receive_queue_id = queue.queue_id where  1 = 1  ";
        prefix = prefix + (atomServId == -1L || atomServId == 0L ? " " : " and sd.serv_Define_Id in(select serv_define_id from stdservver_busiserv_rela rela  where rela.BUSISERV_TYPE =0  and rela.BUSISERV_ID = " + atomServId + ")");
        if (this.isOracle()) {
            sql = String.format(sql, " ");
            querySql = "select *  from (select row_.*, rownum rownum_ from (" + sql + prefix + ")  row_  where rownum <= " + (pagingOption.getPerPageRecordCount() + pagingOption.getFirstResult()) + ") where rownum_ > " + pagingOption.getFirstResult();
        } else {
            sql = String.format(sql, "skip " + pagingOption.getFirstResult() + " first " + pagingOption.getPerPageRecordCount());
            querySql = sql + prefix;
        }
        List list = this.getJdbcTemplate().queryForList(querySql);
        Long total = this.getJdbcTemplate().queryForLong(countSql + prefix);
        pagingOption.setRecordCount(total.intValue());
        return this.encapServDefineDto(list);
    }

    public List<ServDefineDto> findUrlByServDefine(long servDefineId) {
        String hqlStr = "select new cn.com.starit.tsaip.register.dto.ServDefineDto(sd.servDefineId,wf.busiServAddr) from ServDefine sd,WsdlConf wf where sd.wsdlConf.wsdlId = wf.wsdlId and sd.servDefineId=?";
        return this.find(hqlStr, new Object[]{servDefineId});
    }

    private List<ServDefineDto> encapServDefineDto(List list) {
        ArrayList<ServDefineDto> servlist = new ArrayList<ServDefineDto>();
        for (int i = 0; i < list.size(); ++i) {
            ServDefineDto servDto = new ServDefineDto();
            Map obj = (Map)list.get(i);
            servDto.setServId(StringUtil.getLongFrom(obj.get("serv_id")).longValue());
            servDto.setServCode(StringUtil.getStringFrom(obj.get("serv_code")));
            servDto.setServManCode(StringUtil.getStringFrom(obj.get("serv_Man_Code")));
            servDto.setServName(StringUtil.getStringFrom(obj.get("serv_Name")));
            servDto.setServDefineId(StringUtil.getLongFrom(obj.get("serv_define_id")).longValue());
            servDto.setServType(StringUtil.getLongFrom(obj.get("serv_type")).longValue());
            servDto.setServTypeName(StringUtil.getStringFrom(obj.get("servTypeName")));
            servDto.setServPrivateUrl(StringUtil.getStringFrom(obj.get("busi_serv_addr")));
            servDto.setServPubUrl(StringUtil.getStringFrom(obj.get("proxy_serv_addr")));
            servDto.setMessageType(StringUtil.getLongFrom(obj.get("message_Type")).longValue());
            servDto.setOperationName(StringUtil.getStringFrom(obj.get("operation_Name")));
            servDto.setParamName(StringUtil.getStringFrom(obj.get("param_Name")));
            servDto.setResOperationName(StringUtil.getStringFrom(obj.get("res_Operation_Name")));
            servDto.setResParamName(StringUtil.getStringFrom(obj.get("res_Param_Name")));
            servDto.setNs(StringUtil.getStringFrom(obj.get("ns")));
            servDto.setRequestWsdl(StringUtil.getStringFrom(obj.get("busi_Wsdl_Text")));
            servDto.setResponseWsdl(StringUtil.getStringFrom(obj.get("proxy_wsdl_text")));
            servDto.setProtocolDoc(StringUtil.getStringFrom(obj.get("file_Path")));
            servDto.setWsdlOperId(StringUtil.getLongFrom(obj.get("wsdl_Oper_Id")).longValue());
            servDto.setServManId(StringUtil.getLongFrom(obj.get("serv_Man_Id")).longValue());
            servDto.setVersionNo(StringUtil.getDoubleFrom(obj.get("version_No")).doubleValue());
            servDto.setVersionState(StringUtil.getLongFrom(obj.get("version_State")).longValue());
            servDto.setOperName(StringUtil.getStringFrom(obj.get("oper_Name")));
            servDto.setProtocolName(StringUtil.getStringFrom(obj.get("protocol_Name")));
            servDto.setWsdlId(StringUtil.getLongFrom(obj.get("wsdl_Id")).longValue());
            servDto.setProtocolId(StringUtil.getLongFrom(obj.get("protocol_Id")).longValue());
            servDto.setVerStateName(StringUtil.getStringFrom(obj.get("verStateName")));
            servDto.setServProbeFlag(StringUtil.getLongFrom(obj.get("serv_Probe_Flag")).longValue());
            servDto.setQueueName(StringUtil.getStringFrom(obj.get("queue_name")));
            servDto.setSubscribeFlag(StringUtil.getLongFrom(obj.get("subscribe_Flag")).longValue());
            servDto.setProtocolConvertFlag(StringUtil.getLongFrom(obj.get("protocol_Convert_Flag")).longValue());
            servDto.setProtocolConvertFlagName(StringUtil.getStringFrom(obj.get("protocolConvertFlagName")));
            servDto.setServInvokeMode(StringUtil.getLongFrom(obj.get("servInvokeMode")).longValue());
            servlist.add(servDto);
        }
        return servlist;
    }

    public List<ServDefineDto> getServDefine(long servManId, long servId, long servType, PagingOption pagingOption) {
        String sql = " select sd.serv_id,reg.serv_code,config.serv_Man_Code,reg.serv_Name,sd.serv_define_id,sd.serv_type,dic.businname servTypeName,config.serv_Man_Id,nvl(sd.version_No,0) version_No,nvl(sd.version_State,0) version_State,nvl(wf.wsdl_Id,0) wsdl_Id,nvl(pro.protocol_Id,0) protocol_Id,dc.businname, reg.serv_invoke_mode, reg.serv_desc from Serv_Define sd  left join Bndict_T_Dictionary dic on  sd.SERV_TYPE = dic.BUSINID and (dic.BUSINTYPEID = 'SERV_TYPE' or dic.businid is null) left join wsdl_conf wf on   sd.wsdl_id = wf.wsdl_id left join  protocol_info pro on  sd.protocol_id = pro.protocol_id left join Bndict_T_Dictionary dc on  sd.VERSION_STATE = dc.BUSINID and (dc.BUSINTYPEID = 'VERSION_STATE' or dc.BUSINTYPEID is null) left join serv_Afford_Man_Reg reg on sd.serv_id = reg.serv_id left join serv_Afford_Man_Config config on  reg.ser_serv_man_id = config.serv_man_id where  1 = 1  and sd.serv_define_id not in (select conn.serv_define_id from conn_serv_reg conn where 1=1)";
        sql = sql + (servId == -1L || servId == 0L ? " " : " and sd.serv_Id=" + servId);
        sql = sql + (servManId != 0L ? " and config.serv_Man_Id =" + servManId : " ");
        sql = sql + (servType == 0L ? " " : " and sd.serv_type = " + servType);
        List list = this.pagingFindBySQL(sql, pagingOption);
        ArrayList<ServDefineDto> servlist = new ArrayList<ServDefineDto>();
        for (int i = 0; i < list.size(); ++i) {
            ServDefineDto servDto = new ServDefineDto();
            Object[] obj = (Object[])list.get(i);
            if (obj[0] != null && obj[0] != "") {
                servDto.setServId(Long.parseLong(obj[0].toString()));
            }
            if (obj[1] != null && obj[1] != "") {
                servDto.setServCode(obj[1].toString());
            }
            if (obj[2] != null && obj[2] != "") {
                servDto.setServManCode(obj[2].toString());
            }
            if (obj[3] != null && obj[3] != "") {
                servDto.setServName(obj[3].toString());
            }
            if (obj[4] != null && obj[4] != "") {
                servDto.setServDefineId(Long.parseLong(obj[4].toString()));
            }
            if (obj[5] != null && obj[5] != "") {
                servDto.setServType(Long.parseLong(obj[5].toString()));
            }
            if (obj[6] != null && obj[6] != "") {
                servDto.setServTypeName(obj[6].toString());
            }
            if (obj[7] != null && obj[7] != "") {
                servDto.setServManId(Long.parseLong(obj[7].toString()));
            }
            if (obj[8] != null && obj[8] != "") {
                servDto.setVersionNo(Double.parseDouble(obj[8].toString()));
            }
            if (obj[9] != null && obj[9] != "") {
                servDto.setVersionState(Long.parseLong(obj[9].toString()));
            }
            if (obj[10] != null && obj[10] != "") {
                servDto.setWsdlId(Long.parseLong(obj[10].toString()));
            }
            if (obj[11] != null && obj[11] != "") {
                servDto.setProtocolId(Long.parseLong(obj[11].toString()));
            }
            if (obj[12] != null && obj[12] != "") {
                servDto.setVerStateName(obj[12].toString());
            }
            if (obj[13] != null && obj[13] != "") {
                servDto.setServInvokeMode(Long.parseLong(obj[13].toString()));
            }
            if (obj[14] != null && obj[14] != "") {
                servDto.setServDesc(obj[14].toString());
            }
            servlist.add(servDto);
        }
        return servlist;
    }

    public List<ServDefineDto> getServDefineSc(long servManId, long servId, long servType, PagingOption pagingOption) {
        String sql = " select sd.serv_id,reg.serv_code,config.serv_Man_Code,reg.serv_Name,sd.serv_define_id,sd.serv_type,dic.businname servTypeName,config.serv_Man_Id,nvl(sd.version_No,0) version_No,nvl(sd.version_State,0) version_State,nvl(wf.wsdl_Id,0) wsdl_Id,nvl(pro.protocol_Id,0) protocol_Id,dc.businname, reg.serv_invoke_mode, reg.serv_desc from Serv_Define sd  left join Bndict_T_Dictionary dic on  sd.SERV_TYPE = dic.BUSINID and (dic.BUSINTYPEID = 'SERV_TYPE' or dic.businid is null) left join wsdl_conf wf on   sd.wsdl_id = wf.wsdl_id left join  protocol_info pro on  sd.protocol_id = pro.protocol_id left join Bndict_T_Dictionary dc on  sd.VERSION_STATE = dc.BUSINID and (dc.BUSINTYPEID = 'VERSION_STATE' or dc.BUSINTYPEID is null) left join serv_Afford_Man_Reg reg on sd.serv_id = reg.serv_id left join serv_Afford_Man_Config config on  reg.ser_serv_man_id = config.serv_man_id where  1 = 1  and sd.serv_define_id not in (select conn.serv_define_id from conn_serv_reg_SC conn where 1=1)";
        sql = sql + (servId == -1L || servId == 0L ? " " : " and sd.serv_Id=" + servId);
        sql = sql + (servManId != 0L ? " and config.serv_Man_Id =" + servManId : " ");
        sql = sql + (servType == 0L ? " " : " and sd.serv_type = " + servType);
        List list = this.pagingFindBySQL(sql, pagingOption);
        ArrayList<ServDefineDto> servlist = new ArrayList<ServDefineDto>();
        for (int i = 0; i < list.size(); ++i) {
            ServDefineDto servDto = new ServDefineDto();
            Object[] obj = (Object[])list.get(i);
            if (obj[0] != null && obj[0] != "") {
                servDto.setServId(Long.parseLong(obj[0].toString()));
            }
            if (obj[1] != null && obj[1] != "") {
                servDto.setServCode(obj[1].toString());
            }
            if (obj[2] != null && obj[2] != "") {
                servDto.setServManCode(obj[2].toString());
            }
            if (obj[3] != null && obj[3] != "") {
                servDto.setServName(obj[3].toString());
            }
            if (obj[4] != null && obj[4] != "") {
                servDto.setServDefineId(Long.parseLong(obj[4].toString()));
            }
            if (obj[5] != null && obj[5] != "") {
                servDto.setServType(Long.parseLong(obj[5].toString()));
            }
            if (obj[6] != null && obj[6] != "") {
                servDto.setServTypeName(obj[6].toString());
            }
            if (obj[7] != null && obj[7] != "") {
                servDto.setServManId(Long.parseLong(obj[7].toString()));
            }
            if (obj[8] != null && obj[8] != "") {
                servDto.setVersionNo(Double.parseDouble(obj[8].toString()));
            }
            if (obj[9] != null && obj[9] != "") {
                servDto.setVersionState(Long.parseLong(obj[9].toString()));
            }
            if (obj[10] != null && obj[10] != "") {
                servDto.setWsdlId(Long.parseLong(obj[10].toString()));
            }
            if (obj[11] != null && obj[11] != "") {
                servDto.setProtocolId(Long.parseLong(obj[11].toString()));
            }
            if (obj[12] != null && obj[12] != "") {
                servDto.setVerStateName(obj[12].toString());
            }
            if (obj[13] != null && obj[13] != "") {
                servDto.setServInvokeMode(Long.parseLong(obj[13].toString()));
            }
            if (obj[14] != null && obj[14] != "") {
                servDto.setServDesc(obj[14].toString());
            }
            servlist.add(servDto);
        }
        return servlist;
    }

    public List<StaticDataDto> queryServType() {
        String hql = "SELECT new cn.com.starit.tsaip.register.dto.StaticDataDto(dic.id.businid,dic.businname) From BndictTDictionary dic WHERE dic.id.busintypeid = 'SERV_TYPE'";
        return this.find(hql, new Object[0]);
    }

    public List<StaticDataDto> queryProConvertFlag() {
        String hql = "SELECT new cn.com.starit.tsaip.register.dto.StaticDataDto(dic.id.businid,dic.businname) From BndictTDictionary dic WHERE dic.id.busintypeid = 'PROTOCOL_CONVERT_FLAG'";
        return this.find(hql, new Object[0]);
    }

    public List<StaticDataDto> querySubscribeFlag() {
        String hql = "SELECT new cn.com.starit.tsaip.register.dto.StaticDataDto(dic.id.businid,dic.businname) From BndictTDictionary dic WHERE dic.id.busintypeid = 'SUBSCRIBE_FLAG'";
        return this.find(hql, new Object[0]);
    }

    public List<StaticDataDto> queryVersionState() {
        String hql = "SELECT new cn.com.starit.tsaip.register.dto.StaticDataDto(dic.id.businid,dic.businname) From BndictTDictionary dic WHERE dic.id.busintypeid = 'VERSION_STATE'";
        return this.find(hql, new Object[0]);
    }

    public List<ServDefineProbeDto> getAllServiceDefine() {
        String hqlStr = "SELECT new cn.com.starit.tsaip.register.dto.ServDefineProbeDto(sd.servDefineId,sd.wsdlConf.wsdlId,sd.wsdlOper.wsdlOperId,sd.servAffordManReg.servId,sd.servAffordManReg.servCode) From ServDefine sd inner join sd.servAffordManReg inner join sd.wsdlConf inner join sd.wsdlOper";
        return this.find(hqlStr, new Object[0]);
    }

    public List<ServDefineProbeDto> getAllServiceDefineProbe() {
        String hqlStr = "SELECT new cn.com.starit.tsaip.register.dto.ServDefineProbeDto(sd.servDefineId,sd.wsdlConf.wsdlId,sd.wsdlOper.wsdlOperId,sd.servAffordManReg.servId,sd.servAffordManReg.servCode,sd.servAffordManReg.servName,sd.servAffordManReg.servAffordManConfig.servManName) From ServDefine sd inner join sd.servAffordManReg inner join sd.wsdlConf inner join sd.wsdlOper inner join sd.servAffordManReg.servAffordManConfig WHERE sd.servProbeFlag=1";
        return this.find(hqlStr, new Object[0]);
    }

    public List<ServDefineProbeDto> findServProbe() {
        String hql1 = "SELECT new cn.com.starit.tsaip.register.dto.ServDefineProbeDto(sd.servDefineId,sd.wsdlConf.wsdlId,sd.wsdlOper.wsdlOperId,sd.servAffordManReg.servId,sd.servAffordManReg.servCode,sd.servAffordManReg.servName,sd.servAffordManReg.servAffordManConfig.servManName,sd.servProbeFlag) From ServDefine sd inner join sd.servAffordManReg inner join sd.wsdlConf inner join sd.wsdlOper inner join sd.servAffordManReg.servAffordManConfig where sd.servProbeFlag = 1";
        ArrayList<ServDefineProbeDto> list = this.find(hql1, new Object[0]);
        String sql = "select sd.serv_probe_flag, conf.busi_serv_addr,config.serv_man_name from serv_define sd left join wsdl_conf conf on sd.wsdl_id = conf.wsdl_id  left join serv_afford_man_reg reg on sd.serv_id = reg.serv_id  left join serv_afford_man_config config on reg.ser_serv_man_id = config.serv_man_id where sd.serv_probe_flag = 2 or sd.serv_probe_flag = 3  group by sd.serv_probe_flag, conf.busi_serv_addr,config.serv_man_name";
        List list1 = this.findBySQL(sql, new Object[0]);
        if (list == null) {
            list = new ArrayList<ServDefineProbeDto>();
        }
        if (list1 != null && list1.size() > 0) {
            for (int i = 0; i < list1.size(); ++i) {
                Object[] obj = (Object[])list1.get(i);
                ServDefineProbeDto dto = new ServDefineProbeDto();
                if (obj[0] != null) {
                    dto.setServProbeFlag(Long.parseLong(obj[0].toString()));
                }
                if (obj[1] != null) {
                    dto.setServPrivateUrl(obj[1].toString());
                }
                if (obj[2] != null) {
                    dto.setServManName(obj[2].toString());
                }
                list.add(dto);
            }
        }
        return list;
    }

    public List<ServDefineProbeDto> findAtomServProbe() {
        String sql = "select ad.CONNDETECT_FLAG, conf.busi_serv_addr,ad.ATOMSERV_NAME,man.serv_man_name from serv_atomserv_define ad left join WSDL_OPER oper on ad.WSDL_OPER_ID = oper.WSDL_OPER_ID left join wsdl_conf conf on oper.wsdl_id = conf.wsdl_id  left join serv_afford_man_config man on man.serv_man_id = ad.serv_man_id where ad.CONNDETECT_FLAG = 1 ";
        List list = this.findBySQL(sql, new Object[0]);
        ArrayList<ServDefineProbeDto> res = new ArrayList<ServDefineProbeDto>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Object[] obj = (Object[])list.get(i);
                ServDefineProbeDto dto = new ServDefineProbeDto();
                dto.setServProbeFlag(StringUtil.getLongFrom((Object)obj[0]).longValue());
                dto.setServPrivateUrl(StringUtil.getStringFrom((Object)obj[1]));
                dto.setServName(StringUtil.getStringFrom((Object)obj[2]));
                dto.setServManName(StringUtil.getStringFrom((Object)obj[3]));
                res.add(dto);
            }
        }
        return res;
    }

    public List<ServDefineDto> queryServDefineVersion(ServDefineDto dto) {
        String hqlStr = "SELECT new cn.com.starit.tsaip.register.dto.ServDefineDto(sd.wsdlOper.wsdlOperId,sd.servDefineId,sd.versionNo) From ServDefine sd left join sd.servAffordManReg left join sd.wsdlConf left join sd.wsdlOper left join sd.servAffordManReg.servAffordManConfig WHERE 1 = 1";
        if (dto != null && dto.getServCode() != null && !dto.getServCode().equals("")) {
            String hql = "select servId from ServAffordManReg  where servCode = '" + dto.getServCode() + "'";
            List list = this.find(hql, new Object[0]);
            hqlStr = hqlStr + (list != null && list.size() != 0 ? " and sd.servAffordManReg.servId = " + list.get(0) : " and sd.servAffordManReg.servId = -1");
        }
        hqlStr = hqlStr + (dto != null && dto.getServId() != -1L && dto.getServId() != 0L ? " and sd.servAffordManReg.servId =" + dto.getServId() : " ");
        hqlStr = hqlStr + " order by sd.versionNo";
        return this.find(hqlStr, new Object[0]);
    }

    public List<ServDefineProbeDto> findwsdlProbe() {
        String sql = "select conf.busi_serv_addr,man.serv_man_name from wsdl_conf conf left join serv_afford_man_config man on man.serv_man_id = conf.serv_man_id";
        List list1 = this.findBySQL(sql, new Object[0]);
        ArrayList<ServDefineProbeDto> list = new ArrayList<ServDefineProbeDto>();
        if (list1 != null && list1.size() > 0) {
            for (int i = 0; i < list1.size(); ++i) {
                Object[] obj = (Object[])list1.get(i);
                ServDefineProbeDto dto = new ServDefineProbeDto();
                if (obj[0] != null) {
                    dto.setServPrivateUrl(obj[0].toString());
                }
                if (obj[1] != null) {
                    dto.setServManName(obj[1].toString());
                }
                list.add(dto);
            }
        }
        return list;
    }

    public List<JobConfigDto> findJobStartStrategy(JobConfigDto dto) {
        String hql = "select new cn.com.starit.tsaip.register.dto.JobConfigDto(jobId,jobName,jobCode,jobStartStrategy) from JobConfig config where config.jobCode = '" + dto.getJobCode() + "'";
        hql = hql + " and config.jobStatus = 1";
        List list = this.find(hql, new Object[0]);
        return list;
    }

    public ServDefine findById(long servDefineId) {
        String hqlStr = "from ServDefine servDefine where ";
        hqlStr = hqlStr + "servDefine.servDefineId =?";
        List list = this.find(hqlStr, new Object[]{servDefineId});
        ServDefine servDefine = null;
        if (list.size() > 0) {
            servDefine = (ServDefine)list.get(0);
        }
        return servDefine;
    }

    public List queryById(long servId) {
        String hql = " select max(versionNo) From ServDefine sd where 1 = 1";
        if (servId != 0L && servId != -1L) {
            hql = hql + " and sd.servAffordManReg.servId =  " + servId;
        }
        List list = this.find(hql, new Object[0]);
        return list;
    }

    public DataFormatConvert getDataFormatConvert(long servDefineId) {
        String hql = "from DataFormatConvert t where t.servDefineId=" + servDefineId;
        List list = this.find(hql, new Object[0]);
        if (list != null && list.size() > 0) {
            return (DataFormatConvert)list.get(0);
        }
        return null;
    }

    public DataFormatConvert getDataFormatConvert(long servDefineId, String servManCode) {
        String hql = "from DataFormatConvert t where t.servDefineId=? and t.servManCode=?";
        List list = this.find(hql, new Object[]{servDefineId, servManCode});
        if (list != null && list.size() > 0) {
            return (DataFormatConvert)list.get(0);
        }
        return null;
    }

    public Long getServType(long servId) {
        String hql = "select sd.servType from ServDefine sd where sd.servAffordManReg.servId = " + servId;
        List list = this.find(hql, new Object[0]);
        if (list != null && list.size() > 0) {
            return (Long)list.get(0);
        }
        return 0L;
    }

    public List<ServDefineDto> getVersionNo(long servId) {
        String hql = "select new cn.com.starit.tsaip.register.dto.ServDefineDto(sd.servDefineId,sd.versionNo) from ServDefine sd where sd.servAffordManReg.servId = " + servId + " order by sd.versionNo asc";
        List list = this.find(hql, new Object[0]);
        return list;
    }

    public void updateDataFormatConvert(DataFormatConvert dfc) {
        this.getHibernateTemplate().update((Object)dfc);
    }

    public long saveDataFormatConvert(DataFormatConvert dfc) {
        return (Long)this.getHibernateTemplate().save((Object)dfc);
    }

    public List getCanVisitServmanByServDefineId(long servDefineId) {
        String hql = "select new cn.com.starit.tsaip.register.dto.ServManDto(sv.servAffordManConfig.servManId,sv.servAffordManConfig.servManCode,sv.servAffordManConfig.servManName)  from ServVisitLimit sv,ServDefine sd where sd.servDefineId=? and sv.servAffordManReg.servId=sd.servAffordManReg.servId";
        List list = this.find(hql, new Object[]{servDefineId});
        return list;
    }

    public List getConnCanVisitServmanByServDefineId(long servDefineId) {
        String sql = "select t2.conn_serv_man_code from conn_serv_reg t1, conn_visit_limit t2 where t1.serv_define_id = ? and  t1.conn_serv_code = t2.conn_serv_code";
        List list = this.findBySQL(sql, new Object[]{servDefineId});
        ArrayList<ServManDto> res = new ArrayList<ServManDto>();
        for (Object[] obj : list) {
            res.add(new ServManDto(0L, (String)obj, (String)obj));
        }
        return res;
    }

    public List<ServDefineDto> getServInfoByServDefineId(long servDefineId) {
        String hql = "select new cn.com.starit.tsaip.register.dto.ServDefineDto(sd.servAffordManReg.servId, sd.servAffordManReg.servName, sd.servAffordManReg.servCode, sd.servAffordManReg.servInvokeMode, sd.versionNo, sd.servAffordManReg.servDesc, sd.servAffordManReg.servAffordManConfig.servManName) from ServDefine sd where sd.servDefineId = " + servDefineId;
        List list = this.find(hql, new Object[0]);
        return list;
    }
}

