/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.register.persistence.dao;

import cn.com.starit.common.persistence.GenericHibernateDao;
import cn.com.starit.common.persistence.Page;
import cn.com.starit.tsaip.register.dto.JobConfigDto;
import cn.com.starit.tsaip.register.persistence.entity.JobConfig;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class JobConfigDao
extends GenericHibernateDao<JobConfig, Long> {
    public Page<JobConfigDto> findJob(Page<JobConfigDto> page, JobConfigDto dto) {
        String hql = "select new cn.com.starit.tsaip.register.dto.JobConfigDto(j.jobId, j.jobName, j.jobCode,j.jobType,j.jobStartStrategy,j.jobStatus,b.businname, j.jobParamType, j.jobParam,j.jobLasttimeStartup)  from JobConfig j, BndictTDictionary b where b.id.busintypeid='JOB_TYPE' and j.jobType=b.id.businid";
        if (dto != null) {
            hql = hql + (dto.getJobType().trim().equals("") ? " " : " and j.jobType = '" + dto.getJobType() + "'");
            hql = hql + (dto.getJobName().trim().equals("") ? " " : " and j.jobName LIKE'%" + dto.getJobName() + "%'");
            hql = hql + (dto.getJobStatus() == null ? " " : " and j.jobStatus = " + dto.getJobStatus());
            hql = hql + (dto.getJobId() == 0L ? " " : " and j.jobId = " + dto.getJobId());
        }
        Page resultPage = this.findPage(page, hql, new Object[0]);
        System.out.println(resultPage.getResult());
        return resultPage;
    }

    public List<JobConfigDto> getAllJob() {
        String hql = "select new cn.com.starit.tsaip.register.dto.JobConfigDto(j.jobId, j.jobName, j.jobCode,j.jobType,j.jobStartStrategy,j.jobStatus,b.businname, j.jobParamType, j.jobParam,j.jobLasttimeStartup) from JobConfig j, BndictTDictionary b where b.id.busintypeid='JOB_TYPE' and j.jobType=b.id.businid";
        return this.find(hql, new Object[0]);
    }

    public void updateLastStartTime(long jobId) {
        JobConfig config = (JobConfig)this.findUnique("from JobConfig t where t.jobId=?", new Object[]{jobId});
        config.setJobLasttimeStartup(new Date());
        config.setJobStatus(1L);
        this.update((Object)config);
    }

    public List<JobConfig> getJobsByJobCode(String jobCode) {
        DetachedCriteria dc = DetachedCriteria.forClass(JobConfig.class);
        dc.add((Criterion)Restrictions.eq((String)"jobCode", (Object)jobCode));
        return this.findByCriteria(dc);
    }

    public JobConfigDto getJobConfigDto(Long id) {
        String hql = "select new cn.com.starit.tsaip.register.dto.JobConfigDto(j.jobId, j.jobName, j.jobCode,j.jobType,j.jobStartStrategy,j.jobStatus,b.businname, j.jobParamType, j.jobParam,j.jobLasttimeStartup)  from JobConfig j, BndictTDictionary b where b.id.busintypeid='JOB_TYPE' and j.jobType=b.id.businid and j.jobId=?";
        JobConfigDto dto = (JobConfigDto)this.findUnique(hql, new Object[]{id});
        return dto;
    }
}

