/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.register.dto;

import cn.com.starit.common.util.StringUtil;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Date;

public class ServQualityAnalysisDto
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String successRate;
    private double successRatedouble;
    private long servId;
    private long responsetimes;
    private String servName;
    private String servManName;
    private Date startTime;
    private Date endTime;
    private double responseAvgTimedouble;
    private long responseAvgTime;
    private long responseMaxTime;
    private long responseMinTime;
    private double averageMessageLength;
    private Date analysisEndTime;
    private String analysisTime;

    public ServQualityAnalysisDto() {
    }

    public ServQualityAnalysisDto(long servId) {
        this.servId = servId;
    }

    public ServQualityAnalysisDto(Object responseAvgTimedouble, double successRate, String analysisTime) {
        this.responseAvgTimedouble = responseAvgTimedouble == null ? 0.0 : StringUtil.getDoubleFrom((Object)responseAvgTimedouble);
        this.successRatedouble = successRate;
        this.analysisTime = analysisTime;
    }

    public ServQualityAnalysisDto(double responseAvgTimedouble, double successRate, Date analysisEndTime) {
        DecimalFormat format = new DecimalFormat("0.##%");
        this.responseAvgTimedouble = responseAvgTimedouble;
        this.successRate = format.format(successRate);
    }

    public ServQualityAnalysisDto(long servId, long responsetimes, double successRate, Long responseAvgTime, Long responseMinTime, Long responseMaxTime, String analysisTime) {
        this.servId = servId;
        this.responsetimes = responsetimes;
        this.successRatedouble = successRate;
        this.responseAvgTime = responseAvgTime == null ? 0L : responseAvgTime;
        this.responseMinTime = responseMinTime == null ? 0L : responseMinTime;
        this.responseMaxTime = responseMaxTime == null ? 0L : responseMaxTime;
        this.analysisTime = analysisTime;
    }

    public ServQualityAnalysisDto(long servId, String servName, long responsetimes, Object successRate, Object responseAvgTimedouble, Long responseMinTime, Long responseMaxTime) {
        this.servId = servId;
        DecimalFormat format = new DecimalFormat("0.##%");
        this.servName = servName;
        this.responsetimes = responsetimes;
        this.successRate = format.format(StringUtil.getDoubleFrom((Object)successRate));
        this.responseMinTime = responseMinTime == null ? 0L : responseMinTime;
        this.responseMaxTime = responseMaxTime == null ? 0L : responseMaxTime;
        this.responseAvgTimedouble = responseAvgTimedouble == null ? 0.0 : StringUtil.getDoubleFrom((Object)responseAvgTimedouble);
    }

    public ServQualityAnalysisDto(Object servId, Object servName, Object servManName, long responsetimes, double successRate, Object responseAvgTimedouble) {
        DecimalFormat format = new DecimalFormat("0.##%");
        this.servId = servId == null ? 0L : StringUtil.getLongFrom((Object)servId);
        this.servName = servName == null ? "\u672a\u77e5" : StringUtil.getStringFrom((Object)servName);
        this.responsetimes = responsetimes;
        this.successRate = format.format(successRate);
        this.servManName = servManName == null ? "\u672a\u77e5" : StringUtil.getStringFrom((Object)servManName);
        this.responseAvgTimedouble = StringUtil.getDoubleFrom((Object)responseAvgTimedouble);
    }

    public long getServId() {
        return this.servId;
    }

    public long getResponsetimes() {
        return this.responsetimes;
    }

    public String getServName() {
        return this.servName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public double getResponseAvgTime() {
        return this.responseAvgTime;
    }

    public double getResponseMaxTime() {
        return this.responseMaxTime;
    }

    public double getResponseMinTime() {
        return this.responseMinTime;
    }

    public double getAverageMessageLength() {
        return this.averageMessageLength;
    }

    public void setSuccessRate(String successRate) {
        this.successRate = successRate;
    }

    public void setServId(long servId) {
        this.servId = servId;
    }

    public void setResponsetimes(long responsetimes) {
        this.responsetimes = responsetimes;
    }

    public void setServName(String servName) {
        this.servName = servName;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setResponseAvgTime(long responseAvgTime) {
        this.responseAvgTime = responseAvgTime;
    }

    public void setResponseMaxTime(long responseMaxTime) {
        this.responseMaxTime = responseMaxTime;
    }

    public void setResponseMinTime(long responseMinTime) {
        this.responseMinTime = responseMinTime;
    }

    public void setAverageMessageLength(double averageMessageLength) {
        this.averageMessageLength = averageMessageLength;
    }

    public double getResponseAvgTimedouble() {
        return this.responseAvgTimedouble;
    }

    public void setResponseAvgTimedouble(double responseAvgTimedouble) {
        this.responseAvgTimedouble = responseAvgTimedouble;
    }

    public Date getAnalysisEndTime() {
        return this.analysisEndTime;
    }

    public void setAnalysisEndTime(Date analysisEndTime) {
        this.analysisEndTime = analysisEndTime;
    }

    public String getServManName() {
        return this.servManName;
    }

    public void setServManName(String servManName) {
        this.servManName = servManName;
    }

    public String getAnalysisTime() {
        return this.analysisTime;
    }

    public void setAnalysisTime(String analysisTime) {
        this.analysisTime = analysisTime;
    }

    public String getSuccessRate() {
        return this.successRate;
    }

    public double getSuccessRatedouble() {
        return this.successRatedouble;
    }

    public void setSuccessRatedouble(double successRatedouble) {
        this.successRatedouble = successRatedouble;
    }
}

