/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.register.biz.impl;

import cn.com.starit.common.persistence.Page;
import cn.com.starit.tsaip.register.biz.IStConfigService;
import cn.com.starit.tsaip.register.dto.StConfigDto;
import cn.com.starit.tsaip.register.persistence.dao.StConfigDao;
import cn.com.starit.tsaip.register.persistence.entity.StConfig;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSONArray;

public class StConfigServiceImpl
implements IStConfigService {
    private StConfigDao stConfigDao;

    public List<StConfig> loadAllStConfig() {
        return this.stConfigDao.loadAll();
    }

    public Page<StConfigDto> findStConfig(Page<StConfigDto> page) {
        return this.stConfigDao.findStConfig(page);
    }

    public void deleteConfig(Long id) {
        StConfig config = this.loadStConfig(id);
        this.stConfigDao.delete((Object)config);
        ConfigControl.getStConfigCache().removeStConfig((Object)config.getConfigKey());
    }

    public Long insertStConfig(StConfig stConfig) {
        Long id = (Long)this.stConfigDao.save((Object)stConfig);
        ConfigControl.getStConfigCache().pushStConfig((Object)stConfig);
        return id;
    }

    public String queryStConfigs() {
        List list = this.stConfigDao.loadAll();
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll((Collection)list);
        return jsonArray.toString();
    }

    public void updateStConfig(StConfig stConfig) {
        ConfigControl.getStConfigCache().refreshStConfig((Object)stConfig);
        this.stConfigDao.update((Object)stConfig);
    }

    public String queryStConfigValue(String configKey) {
        return this.stConfigDao.queryStconfigValue(configKey);
    }

    public StConfig loadStConfig(Long id) {
        return (StConfig)this.stConfigDao.get((Serializable)id);
    }

    public boolean checkRepeat(String cfgKey) {
        return ConfigControl.getStConfigCache().hadStConfig((Object)cfgKey);
    }

    public boolean refreshStConfig() {
        try {
            ConfigControl.getStConfigCache().refreshAll();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public StConfigDao getStConfigDao() {
        return this.stConfigDao;
    }

    public void setStConfigDao(StConfigDao stConfigDao) {
        this.stConfigDao = stConfigDao;
    }
}

