/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.register.biz.impl;

import cn.com.starit.common.persistence.Page;
import cn.com.starit.inas.biz.scheduler.SchedulerTaskUtil;
import cn.com.starit.tsaip.register.biz.IJobConfigService;
import cn.com.starit.tsaip.register.dto.JobConfigDto;
import cn.com.starit.tsaip.register.persistence.dao.JobConfigDao;
import cn.com.starit.tsaip.register.persistence.entity.JobConfig;
import java.text.ParseException;
import java.util.List;
import org.quartz.CronExpression;

public class JobConfigServiceImpl
implements IJobConfigService {
    public JobConfigDao jobConfigDao;

    public List<JobConfigDto> getAllJob() {
        return this.jobConfigDao.getAllJob();
    }

    public void updateLastStartTime(long jobId) {
        this.jobConfigDao.updateLastStartTime(jobId);
    }

    public Page<JobConfigDto> findJob(Page<JobConfigDto> page, JobConfigDto dto) {
        return this.jobConfigDao.findJob(page, dto);
    }

    public long addJobConfig(JobConfig jobConfig) {
        long id = (Long)this.jobConfigDao.save((Object)jobConfig);
        return id;
    }

    public void updateJobConfig(JobConfig jobConfig) {
        this.jobConfigDao.update((Object)jobConfig);
    }

    public void deleteJobConfig(JobConfig jobConfig) {
        this.jobConfigDao.delete((Object)jobConfig);
        this.stopJob(jobConfig.getJobCode());
    }

    public JobConfigDao getJobConfigDao() {
        return this.jobConfigDao;
    }

    public void setJobConfigDao(JobConfigDao jobConfigDao) {
        this.jobConfigDao = jobConfigDao;
    }

    public boolean checkExpression(String cronExp) {
        try {
            CronExpression exp = new CronExpression(cronExp);
            exp = null;
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public boolean checkJobCode(String jobCode) {
        List list = this.jobConfigDao.getJobsByJobCode(jobCode);
        return list.size() > 0;
    }

    public String triggerJob(Long id) {
        JobConfigDto dto = this.getJobConfigDao().getJobConfigDto(id);
        boolean flag = SchedulerTaskUtil.restartJobs((JobConfigDto)dto);
        if (flag) {
            this.updateLastStartTime(id.longValue());
            return "\u91cd\u542f\u6210\u529f";
        }
        return "\u91cd\u542f\u5931\u8d25";
    }

    public String stopJob(String jobCode) {
        boolean flag = SchedulerTaskUtil.stopJob((String)jobCode);
        if (flag) {
            List list = this.jobConfigDao.getJobsByJobCode(jobCode);
            if (list.size() > 0) {
                JobConfig jobConfig = (JobConfig)list.get(0);
                jobConfig.setJobStatus(0L);
                this.updateJobConfig(jobConfig);
            }
            return "\u505c\u6b62\u4efb\u52a1\u6210\u529f";
        }
        return "\u505c\u6b62\u4efb\u52a1\u5931\u8d25";
    }

    public JobConfigDto getJobConfigDto(Long id) {
        return this.jobConfigDao.getJobConfigDto(id);
    }
}

