/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.register.biz.build;

import cn.com.starit.tsaip.register.persistence.dao.WsdlOperDao;
import cn.com.starit.tsaip.register.persistence.entity.WsdlConf;
import cn.com.starit.tsaip.register.persistence.entity.WsdlOper;
import cn.com.starit.tsaip.register.persistence.entity.WsdlPara;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.encoding.Deserializer;
import javax.xml.rpc.encoding.DeserializerFactory;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.symbolTable.BaseType;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DynamicInvokerService {
    private Parser wsdlParser = null;
    private Map services = null;
    private Element header = null;
    private WsdlOperDao wsdlOperDao;

    public DynamicInvokerService(String wsdlURL) throws Exception {
        this.wsdlParser = new Parser();
        this.wsdlParser.run(wsdlURL);
        this.services = this.getEnumSymTabEntry(ServiceEntry.class);
    }

    public DynamicInvokerService() {
    }

    public void initWsdl(String wsdlURL) {
        this.wsdlParser = new Parser();
        try {
            this.wsdlParser.run(wsdlURL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.services = this.getEnumSymTabEntry(ServiceEntry.class);
    }

    public void initWsdl(String context, Document doc) {
        this.wsdlParser = new Parser();
        try {
            this.wsdlParser.run(null, doc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (WSDLException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.services = this.getEnumSymTabEntry(ServiceEntry.class);
    }

    public Vector getEnumServiceNames() {
        Vector<String> v = new Vector<String>();
        for (String s : this.services.keySet()) {
            v.addElement(s);
        }
        return v;
    }

    public Vector getEnumPortNames(String serviceName) {
        Vector<String> v = new Vector<String>();
        ServiceEntry serviceEntry = (ServiceEntry)this.services.get(serviceName);
        Map ports = serviceEntry.getService().getPorts();
        for (String s : ports.keySet()) {
            v.addElement(s);
        }
        return v;
    }

    public Vector getEnumOperationNames(String serviceName, String portName) {
        Vector<WsdlOper> v = new Vector<WsdlOper>();
        BindingEntry entry = this.getBindingEntry(serviceName, portName);
        String operNs = entry.getQName().getNamespaceURI();
        Set operations = entry.getOperations();
        Iterator i = operations.iterator();
        while (i.hasNext()) {
            WsdlOper wsdlOper = new WsdlOper();
            Operation oper = (Operation)i.next();
            wsdlOper.setOperNs(operNs);
            wsdlOper.setOperName(oper.getName());
            wsdlOper.setPortName(portName);
            wsdlOper.setServiceName(serviceName);
            v.addElement(wsdlOper);
        }
        return v;
    }

    public Vector getEnumOperationsList(String serviceName, String portName, long wsdlConfigId) {
        Vector<WsdlOper> v = new Vector<WsdlOper>();
        BindingEntry entry = this.getBindingEntry(serviceName, portName);
        String operNs = entry.getQName().getNamespaceURI();
        Set operations = entry.getOperations();
        Iterator i = operations.iterator();
        while (i.hasNext()) {
            WsdlConf wsdlConf = new WsdlConf();
            wsdlConf.setWsdlId(wsdlConfigId);
            WsdlOper wsdlOper = new WsdlOper();
            Operation oper = (Operation)i.next();
            wsdlOper.setOperNs(operNs);
            wsdlOper.setOperName(oper.getName());
            wsdlOper.setPortName(portName);
            wsdlOper.setServiceName(serviceName);
            wsdlOper.setWsdlConf(wsdlConf);
            v.addElement(wsdlOper);
        }
        return v;
    }

    public Parameters getEnumParameters(String serviceName, String portName, String operationName) {
        WsdlOper wsdlOper = null;
        List list = this.wsdlOperDao.findByName(operationName);
        if (list.size() == 0 || list.size() > 1) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            wsdlOper = (WsdlOper)list.get(i);
        }
        BindingEntry entry = this.getBindingEntry(serviceName, portName);
        Operation o = this.getOperation(entry, operationName);
        Parameters parameters = entry.getParameters(o);
        return parameters;
    }

    public List getEnumParameterList(String serviceName, String portName, String operationName) {
        WsdlOper wsdlOper = null;
        ArrayList<WsdlPara> parameterList = new ArrayList<WsdlPara>();
        List list = this.wsdlOperDao.findByName(operationName);
        wsdlOper = (WsdlOper)list.get(0);
        BindingEntry entry = this.getBindingEntry(serviceName, portName);
        Operation o = this.getOperation(entry, operationName);
        Parameters parameters = entry.getParameters(o);
        Vector paraList = parameters.list;
        for (int i = 0; i < paraList.size(); ++i) {
            WsdlPara wsdlPara = new WsdlPara();
            Parameter parameter = (Parameter)paraList.get(i);
            wsdlPara.setParaName(parameter.getName());
            wsdlPara.setWsdlOper(wsdlOper);
            wsdlPara.setParaNs(parameter.getQName().getNamespaceURI());
            wsdlPara.setParaDataType(parameter.getType().getQName().getLocalPart());
            wsdlPara.setParaType((long)parameter.getMode());
            parameterList.add(wsdlPara);
        }
        return parameterList;
    }

    public List getEnumParameterList(String serviceName, String portName, WsdlOper wsdlOper) {
        ArrayList<WsdlPara> parameterList = new ArrayList<WsdlPara>();
        BindingEntry entry = this.getBindingEntry(serviceName, portName);
        Operation o = this.getOperation(entry, wsdlOper.getOperName());
        Parameters parameters = entry.getParameters(o);
        Vector paraList = null;
        Parameter outParameter = null;
        if (parameters != null) {
            paraList = parameters.list;
            outParameter = parameters.returnParam;
        }
        if (outParameter != null) {
            paraList.add(outParameter);
        }
        if (paraList != null) {
            for (int i = 0; i < paraList.size(); ++i) {
                WsdlPara wsdlPara = new WsdlPara();
                Parameter parameter = (Parameter)paraList.get(i);
                wsdlPara.setParaName(parameter.getName());
                wsdlPara.setWsdlOper(wsdlOper);
                wsdlPara.setParaNs(parameter.getQName().getNamespaceURI());
                wsdlPara.setParaDataType(parameter.getType().getQName().getLocalPart());
                wsdlPara.setParaType((long)parameter.getMode());
                parameterList.add(wsdlPara);
            }
        }
        return parameterList;
    }

    public String getParameterModeString(Parameter p) {
        String ret = null;
        switch (p.getMode()) {
            case 1: {
                ret = "[IN]";
                break;
            }
            case 3: {
                ret = "[IN, OUT]";
                break;
            }
            case 2: {
                ret = "[OUT]";
            }
        }
        return ret;
    }

    private BindingEntry getBindingEntry(String serviceName, String portName) {
        ServiceEntry serviceEntry = (ServiceEntry)this.services.get(serviceName);
        Port port = serviceEntry.getService().getPort(portName);
        Binding binding = port.getBinding();
        SymbolTable table = this.wsdlParser.getSymbolTable();
        return table.getBindingEntry(binding.getQName());
    }

    private Operation getOperation(BindingEntry entry, String operationName) {
        Set operations = entry.getOperations();
        for (Operation o : operations) {
            if (!operationName.equals(o.getName())) continue;
            return o;
        }
        return null;
    }

    private Map getEnumSymTabEntry(Class cls) {
        HashMap<String, SymTabEntry> ret = new HashMap<String, SymTabEntry>();
        HashMap map = this.wsdlParser.getSymbolTable().getHashMap();
        for (Map.Entry entry : map.entrySet()) {
            QName key = (QName)entry.getKey();
            Vector v = (Vector)entry.getValue();
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)v.elementAt(i);
                if (!cls.isInstance(symTabEntry)) continue;
                ret.put(key.getLocalPart(), symTabEntry);
            }
        }
        return ret;
    }

    private Object getParamData(Call c, Parameter p, String arg) throws Exception {
        DeserializerFactory factory;
        Deserializer deserializer;
        QName paramType = Utils.getXSIType((Parameter)p);
        TypeEntry type = p.getType();
        if (type instanceof BaseType && ((BaseType)type).isBaseType() && (deserializer = (factory = c.getTypeMapping().getDeserializer(paramType)).getDeserializerAs("Axis SAX Mechanism")) instanceof SimpleDeserializer) {
            return ((SimpleDeserializer)deserializer).makeValue(arg);
        }
        throw new RuntimeException("not know how to convert '" + arg + "' into " + c);
    }

    public void setWsdlOperDao(WsdlOperDao wsdlOperDao) {
        this.wsdlOperDao = wsdlOperDao;
    }

    public void setWsdlParser(Parser wsdlParser) {
        this.wsdlParser = wsdlParser;
    }
}

