/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.orchestration.persistence.dao;

import cn.com.starit.common.persistence.GenericHibernateDao;
import cn.com.starit.tsaip.orchestration.persistence.entity.ServDefineOrche;
import cn.com.starit.tsaip.orchestration.persistence.entity.WfProcessdefine;
import cn.com.starit.tsaip.register.persistence.entity.ServAffordManConfig;
import cn.com.starit.tsaip.register.persistence.entity.ServAffordManReg;
import cn.com.starit.tsaip.register.persistence.entity.ServDefine;
import cn.com.starit.tsaip.register.persistence.entity.WsdlConf;
import cn.com.starit.tsaip.register.persistence.entity.WsdlOper;
import cn.com.starit.tsaip.register.persistence.entity.WsdlPara;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;

public class WfProcessDefineDao
extends GenericHibernateDao {
    public List<WfProcessdefine> getPorcessDefineByProcessID(long processsID) {
        DetachedCriteria criteria = DetachedCriteria.forClass(WfProcessdefine.class);
        criteria.add((Criterion)Restrictions.like((String)"processdefname", (String)("flow." + processsID + ".%"), (MatchMode)MatchMode.START));
        criteria.addOrder(Order.asc((String)"versionsign"));
        List list = this.findByCriteria(criteria);
        return list;
    }

    public boolean processDefineIsUnique(String chname, String defname) {
        DetachedCriteria criteria = DetachedCriteria.forClass(WfProcessdefine.class);
        criteria.add((Criterion)Restrictions.eq((String)"processdefname", (Object)defname));
        criteria.add((Criterion)Restrictions.eq((String)"processchname", (Object)chname));
        List r = this.findByCriteria(criteria);
        return r != null && r.size() > 0;
    }

    public WfProcessdefine findProcessDefine(long id) {
        DetachedCriteria criteria = DetachedCriteria.forClass(WfProcessdefine.class);
        criteria.add((Criterion)Restrictions.eq((String)"processdefid", (Object)id));
        List r = this.findByCriteria(criteria);
        if (r != null && r.size() > 0) {
            return (WfProcessdefine)r.get(0);
        }
        return null;
    }

    public ServAffordManConfig getServAffordManConfigByCode(String code) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ServAffordManConfig.class);
        criteria.add((Criterion)Restrictions.like((String)"servManCode", (Object)code));
        List r = this.findByCriteria(criteria);
        if (r != null && r.size() > 0) {
            return (ServAffordManConfig)r.get(0);
        }
        return null;
    }

    public List<WsdlOper> getWsdlOperByWsdlCfgId(long wsdlCfgId) {
        DetachedCriteria criteria = DetachedCriteria.forClass(WsdlOper.class);
        criteria.add((Criterion)Restrictions.eq((String)"wsdlConf.wsdlId", (Object)wsdlCfgId));
        List r = this.findByCriteria(criteria);
        return r;
    }

    public void updateBysql(long wfProcessDefineId, int stat, String processDefname) {
        String str = "update wf_processdefine t set t.currentstate =" + stat + " where t.processdefname='" + processDefname + "'";
        if (wfProcessDefineId != 0L) {
            str = str + " and t.processdefid= " + wfProcessDefineId;
        }
        String sql = str;
        this.getHibernateTemplate().execute((HibernateCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getProcessDefineXML(long wfProcessDefineId) {
        String hql = "select t.processdefcontent from WfProcessdefine t where t.processdefid= ?";
        List list = this.find(hql, new Object[]{wfProcessDefineId});
        if (list != null && list.size() > 0) {
            return (String)list.get(0);
        }
        return "";
    }

    public String[] getNewServiceParameter(long wfProcessDefineId) {
        String hql = "select s.servAffordManReg.servCode,s.servAffordManReg.servName,s.wsdlOper.operName from ServDefineOrche o,ServDefine s where o.wfProcDefId=? and o.newServDefId=s.servDefineId";
        List list = this.find(hql, new Object[]{wfProcessDefineId});
        if (list != null && list.size() > 0) {
            Object[] obj = (Object[])list.get(0);
            String[] res = new String[]{(String)obj[0], (String)obj[1], (String)obj[2]};
            return res;
        }
        return null;
    }

    public ServDefineOrche getServDefineOrche(long wfProcessDefineId) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ServDefineOrche.class);
        criteria.add((Criterion)Restrictions.eq((String)"wfProcDefId", (Object)wfProcessDefineId));
        List list = this.findByCriteria(criteria);
        if (list != null && list.size() > 0) {
            return (ServDefineOrche)list.get(0);
        }
        return null;
    }

    public ServAffordManReg getServAffordManReg(long wfProcessDefineId) {
        String hql = "select s.servAffordManReg from ServDefineOrche o,ServDefine s where o.wfProcDefId=? and o.newServDefId=s.servDefineId";
        List list = this.find(hql, new Object[]{wfProcessDefineId});
        if (list != null && list.size() > 0) {
            Object obj = list.get(0);
            return (ServAffordManReg)obj;
        }
        return null;
    }

    public ServDefine getServDefine(long wfProcessDefineId) {
        String hql = "select s from ServDefineOrche o,ServDefine s where o.wfProcDefId=? and o.newServDefId=s.servDefineId";
        List list = this.find(hql, new Object[]{wfProcessDefineId});
        if (list != null && list.size() > 0) {
            Object obj = list.get(0);
            return (ServDefine)obj;
        }
        return null;
    }

    public WsdlConf getWsdlConf(long servDefineId) {
        String hql = "select s.wsdlConf from ServDefine s where s.servDefineId=?";
        List list = this.find(hql, new Object[]{servDefineId});
        if (list != null && list.size() > 0) {
            Object obj = list.get(0);
            return (WsdlConf)obj;
        }
        return null;
    }

    public List<WsdlOper> getWsdlOpers(long wsdlId) {
        String hql = "select s from WsdlOper s where s.wsdlConf.wsdlId=?";
        List list = this.find(hql, new Object[]{wsdlId});
        if (list != null && list.size() > 0) {
            return list;
        }
        return null;
    }

    public List<WsdlPara> getWsdlParas(long wsdlOperId) {
        String hql = "select s from WsdlPara s where s.wsdlOper.wsdlOperId=?";
        List list = this.find(hql, new Object[]{wsdlOperId});
        if (list != null && list.size() > 0) {
            return list;
        }
        return null;
    }

    public boolean checkServCode(String servCode) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ServAffordManReg.class);
        criteria.add((Criterion)Restrictions.like((String)"servCode", (String)("%." + servCode + ".%"), (MatchMode)MatchMode.ANYWHERE));
        List list = this.findByCriteria(criteria);
        return list != null && list.size() != 0;
    }
}

