/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.orchestration.biz.impl;

import cn.com.starit.inas.biz.tree.TreeServiceProvider;
import cn.com.starit.inas.biz.tree.node.Node;
import cn.com.starit.tsaip.orchestration.biz.CreateWSDL;
import cn.com.starit.tsaip.orchestration.biz.IWfProcessDefineService;
import cn.com.starit.tsaip.orchestration.dto.NewServiceParameter;
import cn.com.starit.tsaip.orchestration.persistence.dao.WfProcessDefineDao;
import cn.com.starit.tsaip.orchestration.persistence.entity.ServDefineOrche;
import cn.com.starit.tsaip.orchestration.persistence.entity.WfProcessdefine;
import cn.com.starit.tsaip.register.biz.IServAffordManRegService;
import cn.com.starit.tsaip.register.biz.IServDefineService;
import cn.com.starit.tsaip.register.biz.IServVersionService;
import cn.com.starit.tsaip.register.biz.IWsdlConfService;
import cn.com.starit.tsaip.register.biz.tree.node.impl.ServCompositeNode;
import cn.com.starit.tsaip.register.persistence.entity.ServAffordManConfig;
import cn.com.starit.tsaip.register.persistence.entity.ServAffordManReg;
import cn.com.starit.tsaip.register.persistence.entity.ServDefine;
import cn.com.starit.tsaip.register.persistence.entity.StdservverBusiservRela;
import cn.com.starit.tsaip.register.persistence.entity.WsdlConf;
import cn.com.starit.tsaip.register.persistence.entity.WsdlOper;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class WfPorcessDefineServiceImpl
implements IWfProcessDefineService {
    private WfProcessDefineDao wfProcessDefineDao;
    private IWsdlConfService wsdlConfService;
    private IServDefineService servDefineService;
    private IServAffordManRegService servAffordManRegService;
    private double versionNo;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_hh\u65f6mmM\u5206ss\u79d2");
    private IServVersionService servVersionService;

    public String getPorcessDefineByProcessID(long processId) {
        List list = this.wfProcessDefineDao.getPorcessDefineByProcessID(processId);
        StringBuffer jsonString = new StringBuffer("[");
        for (WfProcessdefine wf : list) {
            jsonString.append("{");
            jsonString.append("\"processdefid\":").append(wf.getProcessdefid());
            jsonString.append(",\"processchname\":\"").append(wf.getProcesschname()).append("\"");
            jsonString.append(",\"processdefname\":\"").append(wf.getProcessdefname()).append("\"");
            jsonString.append(",\"versionsign\":\"").append(wf.getVersionsign()).append("\"");
            jsonString.append(",\"currentstate\":\"").append(wf.getCurrentstate()).append("\"");
            jsonString.append("}");
            jsonString.append(",");
        }
        String str = "";
        str = jsonString.length() > 1 ? jsonString.substring(0, jsonString.length() - 1) : jsonString.toString();
        str = str + "]";
        return str;
    }

    public int countProcessDefineByPorcessID(long processId) {
        List list = this.wfProcessDefineDao.getPorcessDefineByProcessID(processId);
        return list.size();
    }

    public long saveWfProcessDefine(WfProcessdefine processDefine) {
        if (processDefine.getProcessdefid() == 0L) {
            processDefine.setCreatetime(new Date());
            processDefine.setCurrentstate(1L);
            this.wfProcessDefineDao.save((Object)processDefine);
        } else {
            boolean isUnique = this.wfProcessDefineDao.processDefineIsUnique(processDefine.getProcesschname(), processDefine.getProcessdefname());
            if (isUnique) {
                WfProcessdefine pd = this.wfProcessDefineDao.findProcessDefine(processDefine.getProcessdefid());
                pd.setDescription(processDefine.getDescription());
                pd.setLimittime(processDefine.getLimittime());
                pd.setProcessdefcontent(processDefine.getProcessdefcontent());
                pd.setUpdatetime(new Date());
                this.wfProcessDefineDao.update((Object)pd);
            } else {
                processDefine.setProcessdefid(0L);
                processDefine.setCurrentstate(1L);
                processDefine.setCreatetime(new Date());
                this.wfProcessDefineDao.save((Object)processDefine);
            }
        }
        return processDefine.getProcessdefid();
    }

    public String formatWsdl(NewServiceParameter newServiceParameter) throws IOException {
        String text;
        String path = this.getClass().getResource("/").getPath() + "orch-template.xml";
        BufferedReader input = new BufferedReader(new FileReader(path));
        StringBuffer buffer = new StringBuffer();
        while ((text = input.readLine()) != null) {
            buffer.append(text);
        }
        String output = buffer.toString();
        output = output.replaceAll("#OPERATION_NAME#", newServiceParameter.getName());
        output = output.replaceAll("#PARAM_IN_NAME#", newServiceParameter.getParamInName());
        output = output.replaceAll("#PARAM_OUT_NAME#", newServiceParameter.getParamOutName());
        output = output.replaceAll("#ESB_URL#", ConfigControl.getStConfigCache().getConfigValue((Object)"SPEC_ESB_ROUTE_PATH") == null ? "" : (String)ConfigControl.getStConfigCache().getConfigValue((Object)"SPEC_ESB_ROUTE_PATH"));
        return output;
    }

    public void saveNewService(long wfProcessDefineId, String servDefines, NewServiceParameter newServiceParameter) {
        String wsdl = "";
        try {
            wsdl = this.formatWsdl(newServiceParameter);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ServAffordManConfig servManCfg = this.wfProcessDefineDao.getServAffordManConfigByCode("esb");
        if (servManCfg == null) {
            servManCfg = this.wfProcessDefineDao.getServAffordManConfigByCode("1111");
        }
        if (servManCfg != null) {
            WsdlConf entity = new WsdlConf();
            entity.setServAffordManConfig(servManCfg);
            entity.setWsdlName("CompositeService" + this.sdf.format(new Date()));
            entity.setBusiWsdlText(wsdl);
            this.wsdlConfService.BuilderWsdlConf(entity);
            this.wsdlConfService.save(entity);
            this.wsdlConfService.componentBuilder("", entity);
            String content = "\u6dfb\u52a0\u670d\u52a1\uff0c\u670d\u52a1\u5546[" + servManCfg.getServManName() + "]\u65b0\u589e\u670d\u52a1[" + newServiceParameter.getServName() + "]";
            ServAffordManReg servAffordManReg = new ServAffordManReg();
            try {
                servAffordManReg.setServAffordManConfig(servManCfg);
                servAffordManReg.setServCode(servManCfg.getServManCode() + "." + newServiceParameter.getCode() + "." + "SynReq");
                servAffordManReg.setServName(newServiceParameter.getServName());
                servAffordManReg.setServInvokeMode(0L);
                servAffordManReg.setCallTimeOut(0L);
                servAffordManReg.setServType(2L);
                servAffordManReg.setServStat(2L);
                this.servAffordManRegService.save(servAffordManReg);
                Node pNode = TreeServiceProvider.getNodeStorage().getNode("serv_man_" + servManCfg.getServManId());
                Node node = TreeServiceProvider.getNodeFactory().createServNode(servAffordManReg.getServId() + "", servAffordManReg.getServName(), null);
                pNode.addChildNode(node);
                TreeServiceProvider.getNodeStorage().refreshNode(pNode);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            ServDefine servDefine = new ServDefine();
            WsdlOper wsdlOper = new WsdlOper();
            Iterator it = this.wfProcessDefineDao.getWsdlOperByWsdlCfgId(entity.getWsdlId()).iterator();
            if (it.hasNext()) {
                wsdlOper = (WsdlOper)it.next();
            }
            servDefine.setWsdlConf(entity);
            servDefine.setWsdlOper(wsdlOper);
            servDefine.setServAffordManReg(servAffordManReg);
            servDefine.setServType(3L);
            servDefine.setServPrivateUrl("");
            servDefine.setServPubUrl("");
            servDefine.setVersionState(1L);
            servDefine.setServProbeFlag(2L);
            servDefine.setProtocolConvertFlag(0L);
            this.versionNo = this.getVersionNo(servAffordManReg.getServId());
            servDefine.setVersionNo(this.versionNo);
            try {
                this.servDefineService.save(servDefine);
                ServDefineOrche servDefineOrche = new ServDefineOrche();
                servDefineOrche.setNewServDefId(servDefine.getServDefineId());
                servDefineOrche.setServDefineIds(servDefines);
                servDefineOrche.setWfProcDefId(wfProcessDefineId);
                this.wfProcessDefineDao.save((Object)servDefineOrche);
                StdservverBusiservRela rela = new StdservverBusiservRela();
                rela.setBusiservId(servDefine.getServDefineId());
                rela.setBusiservType(1L);
                rela.setServDefineId(servDefine.getServDefineId());
                this.wfProcessDefineDao.save((Object)rela);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    public double getVersionNo(long servId) {
        double vNoMax = 0.0;
        double versionNO = 0.1;
        List list = this.servDefineService.queryById(servId);
        if (list != null && list.size() > 0) {
            Object object = list.get(0);
            if (object != null) {
                vNoMax = Double.parseDouble(object.toString());
            }
            this.versionNo = vNoMax + 0.1;
        }
        return this.versionNo;
    }

    public String delProcessDefine(long processDefineId) {
        WfProcessdefine entity = this.wfProcessDefineDao.findProcessDefine(processDefineId);
        ServDefineOrche servDefineOrche = this.wfProcessDefineDao.getServDefineOrche(processDefineId);
        try {
            this.wfProcessDefineDao.delete((Object)entity);
            this.wfProcessDefineDao.delete((Object)servDefineOrche);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
        return "success";
    }

    public WfProcessdefine getWfProcessDefine(long processId) {
        return this.wfProcessDefineDao.findProcessDefine(processId);
    }

    public WfProcessDefineDao getWfProcessDefineDao() {
        return this.wfProcessDefineDao;
    }

    public String release(long processDefineId, String processDefname, int type) {
        try {
            this.wfProcessDefineDao.updateBysql(processDefineId, type, processDefname);
            ServAffordManReg servAffordManReg = this.wfProcessDefineDao.getServAffordManReg(processDefineId);
            servAffordManReg.setServStat(type == 1 ? 1L : (long)(type - 1));
            this.servAffordManRegService.update(servAffordManReg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return "success";
    }

    public String getProcessDefineXML(long wfProcessDefineId) {
        return this.wfProcessDefineDao.getProcessDefineXML(wfProcessDefineId);
    }

    public String[] getNewServiceParameter(long wfProcessDefineId) {
        return this.wfProcessDefineDao.getNewServiceParameter(wfProcessDefineId);
    }

    public void updateServDefine(long wfProcessDefineId, String servDefines, NewServiceParameter newServiceParameter) {
        ServAffordManReg servAffordManReg = this.wfProcessDefineDao.getServAffordManReg(wfProcessDefineId);
        ServAffordManConfig servManCfg = servAffordManReg.getServAffordManConfig();
        if (servAffordManReg == null) {
            return;
        }
        String servCode = "";
        if (!newServiceParameter.getCode().startsWith(servManCfg.getServManCode() + ".")) {
            servCode = servCode + servManCfg.getServManCode() + ".";
        }
        if (!(servCode = servCode + newServiceParameter.getCode()).endsWith(".SynReq")) {
            servCode = servCode + ".SynReg";
        }
        servAffordManReg.setServInvokeMode(0L);
        servAffordManReg.setServCode(servCode);
        servAffordManReg.setServName(newServiceParameter.getServName());
        this.servAffordManRegService.update(servAffordManReg);
        ServCompositeNode node = (ServCompositeNode)TreeServiceProvider.getNodeStorage().getNode("serv_" + servAffordManReg.getServId());
        node.setNodeName(servAffordManReg.getServName());
        ServDefine servDefine = this.wfProcessDefineDao.getServDefine(wfProcessDefineId);
        WsdlConf wsdlConf = servDefine.getWsdlConf();
        CreateWSDL createWsdl = new CreateWSDL();
        String wsdl = createWsdl.crateWsdl(newServiceParameter);
        if (wsdlConf.getBusiWsdlText().equals(wsdl)) {
            return;
        }
        WsdlConf entity = new WsdlConf();
        entity.setServAffordManConfig(servManCfg);
        entity.setWsdlName("ServiceOrchestration" + this.sdf.format(new Date()));
        entity.setBusiWsdlText(wsdl);
        this.wsdlConfService.BuilderWsdlConf(entity);
        this.wsdlConfService.save(entity);
        this.wsdlConfService.componentBuilder("", entity);
        WsdlOper wsdlOper = new WsdlOper();
        Iterator it = this.wfProcessDefineDao.getWsdlOperByWsdlCfgId(entity.getWsdlId()).iterator();
        if (it.hasNext()) {
            wsdlOper = (WsdlOper)it.next();
        }
        servDefine.setWsdlConf(entity);
        servDefine.setWsdlOper(wsdlOper);
        this.servDefineService.update(servDefine);
        ServDefineOrche servDefineOrche = this.wfProcessDefineDao.getServDefineOrche(wfProcessDefineId);
        servDefineOrche.setServDefineIds(servDefines);
        this.wfProcessDefineDao.update((Object)servDefineOrche);
    }

    public boolean checkServCode(String servCode) {
        if (servCode == null || "".equals(servCode.trim())) {
            return false;
        }
        if (servCode.startsWith("esb.")) {
            servCode = servCode.replace("esb.", "");
        }
        if (servCode.lastIndexOf(".") > -1) {
            servCode = servCode.substring(0, servCode.lastIndexOf("."));
        }
        return this.wfProcessDefineDao.checkServCode(servCode);
    }

    public void setWfProcessDefineDao(WfProcessDefineDao wfProcessDefineDao) {
        this.wfProcessDefineDao = wfProcessDefineDao;
    }

    public IWsdlConfService getWsdlConfService() {
        return this.wsdlConfService;
    }

    public void setWsdlConfService(IWsdlConfService wsdlConfService) {
        this.wsdlConfService = wsdlConfService;
    }

    public IServDefineService getServDefineService() {
        return this.servDefineService;
    }

    public void setServDefineService(IServDefineService servDefineService) {
        this.servDefineService = servDefineService;
    }

    public IServAffordManRegService getServAffordManRegService() {
        return this.servAffordManRegService;
    }

    public void setServAffordManRegService(IServAffordManRegService servAffordManRegService) {
        this.servAffordManRegService = servAffordManRegService;
    }

    public void setServVersionService(IServVersionService servVersionService) {
        this.servVersionService = servVersionService;
    }
}

