/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.orchestration.biz.impl;

import cn.com.starit.tsaip.orchestration.biz.IBusiProcessService;
import cn.com.starit.tsaip.orchestration.dto.BusiTypeTree;
import cn.com.starit.tsaip.orchestration.persistence.dao.WfBusiProcessDao;
import cn.com.starit.tsaip.orchestration.persistence.entity.StFlowBusiprocess;
import cn.com.starit.tsaip.orchestration.persistence.entity.StFlowBusitype;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;

public class WfBusiProcessServiceImpl
implements IBusiProcessService {
    private WfBusiProcessDao wfBusiDao;

    public String getBusitypeTree() {
        List topList = this.wfBusiDao.getAllBusitype(0L);
        ArrayList result = new ArrayList();
        this.encapTreeNode(topList, result);
        JSONArray jsonObject = JSONArray.fromObject(result);
        String menuString = "";
        try {
            menuString = jsonObject.toString();
        }
        catch (Exception e) {
            menuString = "";
        }
        System.out.println(menuString);
        return menuString;
    }

    private void encapTreeNode(List<StFlowBusitype> topList, List<BusiTypeTree> result) {
        for (StFlowBusitype s : topList) {
            List r;
            List t = this.wfBusiDao.getAllBusitype(s.getBusitypeid());
            BusiTypeTree tree = new BusiTypeTree();
            tree.setCls(s.getIsleaf().equals("1") ? "file" : "folder");
            tree.setId("TYPE_" + s.getBusitypeid());
            tree.setLeaf(s.getIsleaf().equals("1"));
            tree.setText(s.getName());
            if (t.size() > 0) {
                r = new ArrayList();
                this.encapTreeNode(t, r);
                tree.setChildren(r);
            } else {
                r = this.encapBusiprocess(s.getBusitypeid());
                if (r.size() > 0) {
                    tree.setChildren(r);
                    tree.setLeaf(false);
                }
            }
            result.add(tree);
        }
    }

    private List<BusiTypeTree> encapBusiprocess(long busiTypeId) {
        ArrayList<BusiTypeTree> result = new ArrayList<BusiTypeTree>();
        List list = this.wfBusiDao.getBusiProcesses(busiTypeId);
        for (StFlowBusiprocess s : list) {
            BusiTypeTree tree = new BusiTypeTree();
            tree.setCls("file");
            tree.setId("PROC_" + s.getBusiprocessid());
            tree.setLeaf(true);
            tree.setText(s.getFlowname());
            result.add(tree);
        }
        return result;
    }

    public String getBusitype(long id) {
        StFlowBusitype s = this.wfBusiDao.getBusitypeById(id);
        JSONArray array = JSONArray.fromObject((Object)s);
        return array.toString();
    }

    public void saveBusitype(StFlowBusitype s) {
        this.wfBusiDao.save((Object)s);
    }

    public void updateBusitype(StFlowBusitype s) {
        this.wfBusiDao.update((Object)s);
    }

    public String delBusitypeById(long id) {
        try {
            StFlowBusitype s = this.wfBusiDao.getBusitypeById(id);
            this.wfBusiDao.delete((Object)s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
        return "success";
    }

    public String delBusiprocessById(long id) {
        try {
            StFlowBusiprocess s = this.wfBusiDao.getBusiprocessById(id);
            this.wfBusiDao.delete((Object)s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
        return "success";
    }

    public String getBusiProcess(long id) {
        StFlowBusiprocess s = this.wfBusiDao.getBusiprocessById(id);
        String json = "[{";
        if (s != null) {
            json = json + "\"busiprocessid\":\"" + s.getBusiprocessid() + "\",\"flowname\":\"" + s.getFlowname() + "\",\"descn\":\"" + s.getDescn() + "\",\"busitypeid\":\"" + s.getStFlowBusitype().getBusitypeid() + "\"";
        }
        json = json + "}]";
        return json;
    }

    public void saveBusiprocess(StFlowBusiprocess s, long busitypeId) {
        s.setType("flow");
        s.setStFlowBusitype(this.wfBusiDao.getBusitypeById(busitypeId));
        this.wfBusiDao.save((Object)s);
    }

    public void updateBusiprocess(StFlowBusiprocess s, long busitypeId) {
        StFlowBusiprocess temp = this.wfBusiDao.getBusiprocessById(s.getBusiprocessid());
        temp.setFlowname(s.getFlowname());
        temp.setDescn(s.getDescn());
        this.wfBusiDao.update((Object)temp);
    }

    public WfBusiProcessDao getWfBusiDao() {
        return this.wfBusiDao;
    }

    public void setWfBusiDao(WfBusiProcessDao wfBusiDao) {
        this.wfBusiDao = wfBusiDao;
    }
}

