/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.orchestration.biz;

import cn.com.starit.tsaip.orchestration.dto.NewServiceParameter;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class CreateWSDL {
    private final String tns = "http://test.org/Hello";
    private final String xsd = "http://www.w3.org/2001/XMLSchema";
    private Message inMessage = null;
    private Message outMessage = null;

    public String crateWsdl(NewServiceParameter newServiceParameter) {
        try {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            Definition definition = this.createDefinition(wsdlFactory);
            this.inMessage = definition.createMessage();
            this.outMessage = definition.createMessage();
            this.createPart(newServiceParameter, definition);
            PortType portType = this.createPortType(newServiceParameter.getName(), definition);
            definition.addPortType(portType);
            Binding binding = this.createBind(definition, portType, newServiceParameter.getName());
            definition.addBinding(binding);
            Service service = this.createService(definition, binding);
            definition.addService(service);
            WSDLWriter wirter = wsdlFactory.newWSDLWriter();
            wirter.writeWSDL(definition, (OutputStream)System.out);
            return this.xmlToString(wirter.getDocument(definition));
        }
        catch (WSDLException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String xmlToString(Document doc) {
        StringWriter writer = null;
        DOMSource source = new DOMSource(doc.getFirstChild());
        System.out.println(doc.getDocumentElement());
        writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = tFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        StringBuffer strBuf = writer.getBuffer();
        return strBuf.toString();
    }

    private Definition createDefinition(WSDLFactory wsdlFactory) throws WSDLException {
        Definition definition = wsdlFactory.newDefinition();
        definition.setTargetNamespace("http://test.org/Hello");
        definition.setQName(new QName("http://test.org/Hello", "CombinationService"));
        definition.addNamespace("tns", "http://test.org/Hello");
        definition.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        definition.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        definition.addNamespace("soapenc11", "http://schemas.xmlsoap.org/soap/encoding/");
        definition.addNamespace("soap11", "http://schemas.xmlsoap.org/soap/envelope/");
        return definition;
    }

    private void createPart(NewServiceParameter newServiceParameter, Definition definition) {
        Part part = definition.createPart();
        part.setName(newServiceParameter.getParamInName());
        part.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        this.inMessage.setQName(new QName("http://test.org/Hello", "serviceRequest"));
        this.inMessage.addPart(part);
        this.inMessage.setUndefined(false);
        definition.addMessage(this.inMessage);
        part = definition.createPart();
        part.setName(newServiceParameter.getParamOutName());
        part.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        this.outMessage.setQName(new QName("http://test.org/Hello", "serviceResponse"));
        this.outMessage.addPart(part);
        this.outMessage.setUndefined(false);
        definition.addMessage(this.outMessage);
    }

    private PortType createPortType(String opName, Definition definition) {
        PortType portType = definition.createPortType();
        portType.setQName(new QName("http://test.org/Hello", "servicePortType"));
        Operation operation = definition.createOperation();
        operation.setName(opName);
        Input input = definition.createInput();
        input.setName("serviceRequest");
        input.setMessage(this.inMessage);
        Output output = definition.createOutput();
        output.setName("serviceResponse");
        output.setMessage(this.outMessage);
        operation.setInput(input);
        operation.setOutput(output);
        operation.setStyle(OperationType.REQUEST_RESPONSE);
        operation.setUndefined(false);
        portType.addOperation(operation);
        portType.setUndefined(false);
        return portType;
    }

    private Binding createBind(Definition definition, PortType portType, String opName) {
        Binding binding = definition.createBinding();
        binding.setQName(new QName("http://test.org/Hello", "serviceHttpBinding"));
        SOAPBindingImpl soapBinding = new SOAPBindingImpl();
        soapBinding.setStyle("document");
        soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
        binding.setPortType(portType);
        BindingOperation bindingOperation = definition.createBindingOperation();
        BindingInput bindingInput = definition.createBindingInput();
        bindingInput.setName("serviceRequest");
        SOAPBodyImpl soapBody1 = new SOAPBodyImpl();
        soapBody1.setUse("literal");
        bindingInput.addExtensibilityElement((ExtensibilityElement)soapBody1);
        BindingOutput bindingOutput = definition.createBindingOutput();
        bindingOutput.setName("serviceResponse");
        SOAPBodyImpl soapBody2 = new SOAPBodyImpl();
        soapBody2.setUse("literal");
        bindingOutput.addExtensibilityElement((ExtensibilityElement)soapBody2);
        bindingOperation.setName(opName);
        bindingOperation.setBindingInput(bindingInput);
        bindingOperation.setBindingOutput(bindingOutput);
        binding.addBindingOperation(bindingOperation);
        binding.setUndefined(false);
        return binding;
    }

    private Service createService(Definition definition, Binding binding) {
        Service service = definition.createService();
        service.setQName(new QName("http://test.org/Hello", "serviceService"));
        Port port = definition.createPort();
        port.setBinding(binding);
        port.setName("serviceHttpPort");
        SOAPAddressImpl soapAddress = new SOAPAddressImpl();
        soapAddress.setLocationURI("http://starit.com/services");
        port.addExtensibilityElement((ExtensibilityElement)soapAddress);
        service.addPort(port);
        return service;
    }

    public static void main(String[] args) throws WSDLException {
        CreateWSDL wsdl = new CreateWSDL();
    }
}

