/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.msgresend.biz.impl;

import cn.com.starit.common.util.AlarmSendUtil;
import cn.com.starit.common.util.StringUtil;
import cn.com.starit.inas.service.ApplicationContextProvider;
import cn.com.starit.oip.Srp.biz.impl.ServRegServiceImpl;
import cn.com.starit.oip.Srp.pesistence.entity.ConnServReg;
import cn.com.starit.tsaip.esb.plugin.cache.bean.ServDefineBean;
import cn.com.starit.tsaip.esb.plugin.serviceDefine.facade.ESBServDefineInfoFinder;
import cn.com.starit.tsaip.register.biz.IServVersionService;
import cn.com.starit.tsaip.register.dto.ServResendDto;
import cn.com.starit.tsaip.register.util.ConfigControl;

public class ResendResultCheckThread
implements Runnable {
    private IServVersionService servVersionService;
    private ServResendDto servResendDto;
    private boolean needUpdateAipMessageState101;
    private boolean isConnServResend;

    public ResendResultCheckThread(IServVersionService servVersionService, ServResendDto servResendDto, boolean needUpdateAipMessageState101, boolean isConnServResend) {
        this.servResendDto = servResendDto;
        this.servVersionService = servVersionService;
        this.needUpdateAipMessageState101 = needUpdateAipMessageState101;
        this.isConnServResend = isConnServResend;
    }

    @Override
    public void run() {
        Object obj = ConfigControl.getStConfigCache().getConfigValue((Object)"RESEND_CHECK_INTEVAL_TIME");
        int intevalTime = obj == null ? 4 : StringUtil.getIntegerFrom((Object)obj);
        try {
            Thread.sleep(intevalTime * 1000 * 60);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        boolean resendSuccess = this.servVersionService.checkResendStatus(this.servResendDto.getCsbId());
        if (!resendSuccess) {
            if (this.needUpdateAipMessageState101 && this.servResendDto.getResendCount() + 1L > this.servResendDto.getResendTiems()) {
                this.servVersionService.upateMsgPersist(this.servResendDto.getId(), 101);
                if (!this.isConnServResend) {
                    ServDefineBean servDefine = ESBServDefineInfoFinder.findServDefineBean((String)this.servResendDto.getServCode(), (String)this.servResendDto.getReceiveSystem());
                    AlarmSendUtil.sendResendAlarm((ServDefineBean)servDefine, (ServResendDto)this.servResendDto);
                } else {
                    ConnServReg servDefine = ((ServRegServiceImpl)ApplicationContextProvider.getBean((String)"servRegService")).getConnServRegDto(this.servResendDto.getServCode());
                    AlarmSendUtil.sendConnResndAlarm((ConnServReg)servDefine, (ServResendDto)this.servResendDto);
                }
            }
        } else {
            this.servVersionService.upateMsgPersist(this.servResendDto.getId(), 1);
        }
    }
}

