/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.msgresend.biz.impl;

import cn.com.starit.common.util.RemoteRPCHandler;
import cn.com.starit.tsaip.esb.plugin.pkg.facade.PkgStore;
import cn.com.starit.tsaip.msgresend.biz.IMsgResendService;
import cn.com.starit.tsaip.msgresend.biz.impl.ResendResultCheckThread;
import cn.com.starit.tsaip.msgresend.persistence.entity.ResendInstance;
import cn.com.starit.tsaip.register.biz.IServVersionService;
import cn.com.starit.tsaip.register.dto.ServResendDto;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.httpclient.HttpException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgResendServiceImpl
implements IMsgResendService {
    private Logger log = LoggerFactory.getLogger(MsgResendServiceImpl.class);
    private static String ESB_ROUTE_URL = null;
    private String errorReason = "";
    private String result = "";
    private boolean isConnServResend = false;
    private IServVersionService servVersionService;

    public void setServVersionService(IServVersionService servVersionService) {
        this.servVersionService = servVersionService;
    }

    public boolean resend4Webservice(ServResendDto servResendDto) {
        boolean res = this.resend(servResendDto);
        this.saveResendInstance(res ? 1 : 0, servResendDto.getCsbId(), "1", servResendDto);
        return res;
    }

    public boolean resend4Page(ServResendDto servResendDto) {
        boolean res = this.resend(servResendDto);
        this.saveResendInstance(res ? 1 : 0, servResendDto.getCsbId(), "2", servResendDto);
        return res;
    }

    public boolean resend4Auto(ServResendDto servResendDto) {
        boolean res = this.resend(servResendDto);
        this.saveResendInstance(res ? 1 : 0, servResendDto.getCsbId(), "3", servResendDto);
        return res;
    }

    private boolean resend(ServResendDto servResendDto) {
        String soap;
        ESB_ROUTE_URL = (String)ConfigControl.getStConfigCache().getConfigValue((Object)"SPEC_ESB_ROUTE_PATH");
        if (ESB_ROUTE_URL == null || "".equals(ESB_ROUTE_URL)) {
            this.log.error("webservice\u63a5\u53e3\u91cd\u6295\u9519\u8bef\uff1a\u3010\u539f\u56e0\uff1a\u6ca1\u6709\u914d\u7f6eESB_ROUTE_URL\uff0c\u6216\u8005\u6ca1\u6709\u5728\u7f13\u5b58\u4e2d\u67e5\u627e\u5230\u6b64\u914d\u7f6e\u3011");
        }
        if ((soap = PkgStore.getPkg((String)servResendDto.getCsbId(), (String)"Receive")) == null) {
            return false;
        }
        if ((soap = this.formatChange(soap)) != null) {
            try {
                soap = this.addResendFlag(soap);
                byte[] b = RemoteRPCHandler.invoke((String)ESB_ROUTE_URL, (String)soap, (int)120000);
                if (b != null) {
                    this.result = new String(b);
                    return true;
                }
                this.errorReason = "\u8fd4\u56de\u7ed3\u679c\u4e3anull";
            }
            catch (HttpException e) {
                this.errorReason = e.getMessage();
                e.printStackTrace();
            }
            catch (IOException e) {
                this.errorReason = e.getMessage();
                e.printStackTrace();
            }
        }
        return false;
    }

    private void saveResendInstance(int resendStatus, String csbId, String resendMethod, ServResendDto servResendDto) {
        ResendInstance ri = new ResendInstance();
        ri.setErrorReason(this.errorReason);
        ri.setEsbId(csbId);
        ri.setResender((String)ConfigControl.getStConfigCache().getConfigValue((Object)"SRP_CODE"));
        ri.setResendEsbId(this.getEsbId(this.result));
        ri.setResendMethod(resendMethod);
        ri.setResendTime(new Date());
        ri.setResult("" + resendStatus);
        this.servVersionService.saveResendInstance(ri);
        ResendResultCheckThread t = new ResendResultCheckThread(this.servVersionService, servResendDto, "3".equals(resendMethod), this.isConnServResend);
        Thread thread = new Thread((Runnable)t);
        thread.start();
    }

    private String formatChange(String msg) {
        if (msg.contains("&lt;") && msg.contains("&gt;")) {
            msg = msg.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        }
        return msg;
    }

    private String addResendFlag(String soap) {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)soap);
            Element singleNode = (Element)document.selectSingleNode("//Esb/Route");
            Element newElement = singleNode.addElement("ResendFlag");
            newElement.setText("1");
            newElement = singleNode.addElement("Resender");
            newElement.setText((String)ConfigControl.getStConfigCache().getConfigValue((Object)"SRP_CODE"));
            return document.asXML();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getEsbId(String responseStrXML) {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)responseStrXML);
            Element feedbackEl = (Element)document.selectSingleNode("//Esb/Route/EsbId");
            return feedbackEl.getText();
        }
        catch (DocumentException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setIsConnServResend(boolean isConnServResend) {
        this.isConnServResend = isConnServResend;
    }
}

