/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.monitor.flex.impl;

import cn.com.starit.tsaip.monitor.dto.ServArdManCfgDto;
import cn.com.starit.tsaip.monitor.dto.ServArdManRegDto;
import cn.com.starit.tsaip.monitor.dto.ServInkTrendExpDto;
import cn.com.starit.tsaip.monitor.dto.ServInvokeTrendDto;
import cn.com.starit.tsaip.monitor.dto.ServMonSearchDto;
import cn.com.starit.tsaip.monitor.dto.ToServManDto;
import cn.com.starit.tsaip.monitor.dto.ToServiceAnalyseDto;
import cn.com.starit.tsaip.monitor.dto.ToServiceDto;
import cn.com.starit.tsaip.monitor.flex.ConditionParam;
import cn.com.starit.tsaip.monitor.flex.IServFlexMonitor;
import cn.com.starit.tsaip.monitor.flex.impl.ServFlexMonDBUtil;
import cn.com.starit.tsaip.monitor.persistence.dao.ServInvokeTrendsDao;
import java.util.List;

public class ServFlexMonitorDB
implements IServFlexMonitor {
    private ServInvokeTrendsDao servInkTreDao;

    public ServInvokeTrendsDao getServInkTreDao() {
        return this.servInkTreDao;
    }

    public void setServInkTreDao(ServInvokeTrendsDao servInkTreDao) {
        this.servInkTreDao = servInkTreDao;
    }

    public List<ServInkTrendExpDto> servInkTrentExpQuery(ConditionParam conditionParam) {
        String date = conditionParam.getDate();
        String begin = "";
        String end = "";
        int timeLength = date.trim().length();
        if (timeLength > 0 && timeLength <= 10) {
            begin = date + " 00:00:00";
            end = date + " 23:59:59";
        } else if (timeLength > 10 && timeLength <= 16) {
            begin = date + ":00";
            end = date + ":59";
        }
        List servExpList = this.servInkTreDao.findExp(begin, end);
        this.update2(servExpList, conditionParam.getExptotal());
        return servExpList;
    }

    public List<ServInvokeTrendDto> servIvkTrentQuery(ConditionParam conditionParam) {
        if (conditionParam.getGranularity().equals(1L)) {
            String begin = conditionParam.getBeginDate() + " 00:00:00";
            String end = conditionParam.getEndDate() + " 23:59:59";
            List servTreList = new ServFlexMonDBUtil().compServByDate(this.servInkTreDao.findByDate(begin, end));
            this.update(servTreList);
            return servTreList;
        }
        String begin = conditionParam.getBeginDate() + ":00";
        String end = conditionParam.getEndDate() + ":59";
        List servTreList = new ServFlexMonDBUtil().compServByDate(this.servInkTreDao.findByTime(begin, end));
        this.update(servTreList);
        return servTreList;
    }

    private void update(List<ServInvokeTrendDto> list) {
        for (ServInvokeTrendDto temp : list) {
            temp.setPercent(this.countPrecent(temp.getAbnm(), temp.getTotal()));
        }
    }

    private void update2(List<ServInkTrendExpDto> list, Long total) {
        for (ServInkTrendExpDto temp : list) {
            temp.setPercent(this.countPrecent(temp.getValue(), total));
        }
    }

    private Double countPrecent(Long num1, Long total) {
        double d = (double)num1.longValue() * 1.0 / (double)total.longValue();
        double value = Math.floor(d * 1000.0 + 0.5) / 10.0;
        return value;
    }

    public List<ServArdManCfgDto> getServManCfgs() {
        List servCfgList = this.servInkTreDao.findServManCfgDto();
        ServArdManCfgDto element = new ServArdManCfgDto();
        element.setServManId(-1L);
        element.setServManCode("CSB");
        element.setServManName("\u5168\u90e8");
        servCfgList.add(0, element);
        return servCfgList;
    }

    public List<ServArdManRegDto> getServManRegs(Long servManid) {
        List servRegList = this.servInkTreDao.findServRegDto(servManid);
        ServArdManRegDto element = new ServArdManRegDto();
        if (servManid == null || servManid == -1L) {
            element.setServId(-1L);
            element.setServCode("CSB");
            element.setServName("\u5168\u90e8");
            servRegList.add(0, element);
        }
        return servRegList;
    }

    public List<ToServManDto> getServManDtos() {
        List servCfgList = this.servInkTreDao.findServManDtos();
        return servCfgList;
    }

    public List<ToServiceDto> getServicesDtos(Long servManid) {
        List list = this.servInkTreDao.findServicesDtos(servManid);
        return list;
    }

    public List<ToServiceAnalyseDto> findServiceAnalyseDtosMon() {
        return this.servInkTreDao.findServiceAnalyseDtosMon();
    }

    public List<ToServiceAnalyseDto> findServiceAnalyseDtos() {
        return this.servInkTreDao.findServiceAnalyseDtos();
    }

    public List findCanOfferServman(Long serviceId) {
        return this.servInkTreDao.findCanOfferServman(serviceId);
    }

    public List<ToServiceDto> findAllServicesDtosByServmanId(Long servManId) {
        return this.servInkTreDao.findAllServicesDtosByServmanId(servManId);
    }

    public List<ServMonSearchDto> findServMonSearchData(String fwxff, String fwtgf, long servId, ConditionParam conditionParam, String dataField) {
        String end;
        String begin;
        if (conditionParam.getGranularity().equals(1L)) {
            begin = conditionParam.getBeginDate() + " 00:00:00";
            end = conditionParam.getEndDate() + " 23:59:59";
        } else {
            begin = conditionParam.getBeginDate() + ":00";
            end = conditionParam.getEndDate() + ":59";
        }
        List servTreList = this.servInkTreDao.findServMonSearchData(fwxff, fwtgf, servId, begin, end, dataField, conditionParam.getGranularity());
        return servTreList;
    }

    public List<ServArdManRegDto> getServices(Long servManid) {
        List servRegList = this.servInkTreDao.findServRegDto(servManid);
        ServArdManRegDto element = new ServArdManRegDto();
        element.setServId(-1L);
        element.setServCode("CSB");
        element.setServName("\u5168\u90e8");
        servRegList.add(0, element);
        return servRegList;
    }

    public List<ServMonSearchDto> findServTopData(ConditionParam conditionParam, String dataField, int topN, int type) {
        String end;
        String begin;
        if (conditionParam.getGranularity().equals(1L)) {
            begin = conditionParam.getBeginDate() + " 00:00:00";
            end = conditionParam.getEndDate() + " 23:59:59";
        } else {
            begin = conditionParam.getBeginDate() + ":00";
            end = conditionParam.getEndDate() + ":59";
        }
        List servTreList = this.servInkTreDao.findServTopData(begin, end, dataField, topN, type);
        return servTreList;
    }

    public List<ServMonSearchDto> findServMonpData(ConditionParam conditionParam, String code, long servId, String dataField, int type) {
        String end;
        String begin;
        if (conditionParam.getGranularity().equals(1L)) {
            begin = conditionParam.getBeginDate() + " 00:00:00";
            end = conditionParam.getEndDate() + " 23:59:59";
        } else {
            begin = conditionParam.getBeginDate() + ":00";
            end = conditionParam.getEndDate() + ":59";
        }
        List servTreList = this.servInkTreDao.findServMonpData(begin, end, code, servId, dataField, type, conditionParam.getGranularity());
        return servTreList;
    }

    public ToServiceAnalyseDto queryServiceAnalyseMon(String servCode) {
        return this.servInkTreDao.findServiceAnalyseMonDto(servCode);
    }

    public ToServiceAnalyseDto queryServiceAnalyse(String servCode) {
        return this.servInkTreDao.findServiceAnalyseDto(servCode);
    }

    public List findAtomSer(Long servId) {
        return this.servInkTreDao.findAtomSer(servId);
    }
}

