/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.monitor.flex;

import cn.com.starit.tsaip.monitor.dto.AlarmsTopoDto;
import cn.com.starit.tsaip.monitor.dto.ToServManDto;
import cn.com.starit.tsaip.monitor.dto.ToServiceAnalyseDto;
import cn.com.starit.tsaip.monitor.dto.ToServiceDto;
import cn.com.starit.tsaip.monitor.flex.IServFlexMonitor;
import cn.com.starit.tsaip.register.biz.IServAffordManService;
import java.util.Date;
import java.util.List;

public class ServFlexTopologyManager {
    private IServFlexMonitor servFlexMonitor;
    private IServAffordManService servAffordManService;
    private AlarmsTopoDto alarmsTopoDto;

    public ServFlexTopologyManager(IServFlexMonitor servFlexMonitor) {
        this.servFlexMonitor = servFlexMonitor;
    }

    public ServFlexTopologyManager() {
    }

    public List<ToServManDto> queryServManCfg() {
        return this.servFlexMonitor.getServManDtos();
    }

    public List<ToServiceDto> queryServManReg(long servCode) {
        return this.servFlexMonitor.getServicesDtos(Long.valueOf(servCode));
    }

    public ToServiceAnalyseDto queryServiceAnalyseMon(String servCode) {
        return this.servFlexMonitor.queryServiceAnalyseMon(servCode);
    }

    public ToServiceAnalyseDto queryServiceAnalyse(String servCode) {
        return this.servFlexMonitor.queryServiceAnalyse(servCode);
    }

    public ToServiceAnalyseDto queryServceAnalyseCSBMon() {
        List lists = this.servFlexMonitor.findServiceAnalyseDtosMon();
        long busiMoSum = 0L;
        long busiMoAvg = 0L;
        long requestTimes = 0L;
        long responseTimes = 0L;
        for (ToServiceAnalyseDto dto : lists) {
            busiMoSum += dto.getBusiMoSum();
            busiMoAvg += dto.getBusiMoAvg();
            requestTimes += dto.getRequestTimes();
            responseTimes += dto.getResponseTimes();
        }
        ToServiceAnalyseDto analyseDto = new ToServiceAnalyseDto(busiMoSum, busiMoAvg, requestTimes, responseTimes, new Date());
        return analyseDto;
    }

    public ToServiceAnalyseDto queryServceAnalyseCSB() {
        List lists = this.servFlexMonitor.findServiceAnalyseDtos();
        long csbAchieveMaxTime = 0L;
        long csbAchieveMinTime = 0L;
        long busiServMaxTime = 0L;
        long busiServMinTime = 0L;
        long busiServAvgTime = 0L;
        double failureRate = 0.0;
        double count = lists == null ? 0.0 : (double)lists.size();
        Date updateTime = null;
        for (ToServiceAnalyseDto dto : lists) {
            csbAchieveMaxTime += dto.getCsbAchieveMaxTime();
            csbAchieveMinTime += dto.getCsbAchieveMinTime();
            busiServMaxTime += dto.getBusiServMaxTime();
            busiServMinTime += dto.getBusiServMinTime();
            busiServAvgTime += dto.getBusiServAvgTime();
            failureRate += dto.getFailureRate();
            updateTime = dto.getUpdateTime();
        }
        ToServiceAnalyseDto analyseDto = new ToServiceAnalyseDto(Double.valueOf(failureRate), Long.valueOf(csbAchieveMaxTime), Long.valueOf(csbAchieveMinTime), Long.valueOf(busiServMaxTime), Long.valueOf(busiServMinTime), Long.valueOf(busiServAvgTime), updateTime);
        return analyseDto;
    }

    public List queryCanOfferServMan(Long serviceId) {
        return this.servFlexMonitor.findCanOfferServman(serviceId);
    }

    public List<ToServiceDto> queryAllServiceDtosByServmanId(Long servManId) {
        return this.servFlexMonitor.findAllServicesDtosByServmanId(servManId);
    }

    public IServFlexMonitor getServFlexMonitor() {
        return this.servFlexMonitor;
    }

    public void setServFlexMonitor(IServFlexMonitor servFlexMonitor) {
        this.servFlexMonitor = servFlexMonitor;
    }

    public List<AlarmsTopoDto> queryAlarms(List<Integer> servList, List<Integer> servManList) {
        return null;
    }

    public List findAtomSer(Long servId) {
        return this.servFlexMonitor.findAtomSer(servId);
    }

    public IServAffordManService getServAffordManService() {
        return this.servAffordManService;
    }

    public void setServAffordManService(IServAffordManService servAffordManService) {
        this.servAffordManService = servAffordManService;
    }
}

