/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.monitor.biz;

import cn.com.starit.tsaip.common.biz.IAlarmService;
import cn.com.starit.tsaip.monitor.dto.RequestTimeoutDto;
import cn.com.starit.tsaip.monitor.persistence.dao.RequestTimeoutDao;
import cn.com.starit.tsinms.persistence.po.alarm.Alarms;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestTimeoutService {
    private Logger log = LoggerFactory.getLogger(RequestTimeoutService.class);
    private RequestTimeoutDao requestTimeoutDao;
    private IAlarmService alarmService;
    private HashMap<String, RequestTimeoutDto> needMonMap = new HashMap();
    private Date currentTime;
    private Long interval;

    public void run() {
        this.log.info("\u8bf7\u6c42\u8d85\u65f6\u5224\u65ad\u5f00\u59cb");
        this.getData();
        if (this.needMonMap != null && this.needMonMap.size() > 0) {
            this.checkNeedMap();
        }
        this.log.info("\u8bf7\u6c42\u8d85\u65f6\u5224\u65ad\u7ed3\u675f");
    }

    public void checkServ(RequestTimeoutDto dto) {
        if (dto.getResponseTime() == null && dto.getRequestTime() == null) {
            this.needMonMap.put(dto.getCsbId(), dto);
        } else if (dto.getRequestTime() != null && dto.getResponseTime() == null) {
            if (this.currentTime.getTime() - dto.getRequestTime().getTime() > dto.getCallTimeOut() * 1000L) {
                Alarms alarmInfo = new Alarms();
                alarmInfo.setDetail("[\u6d88\u8d39\u65b9]" + dto.getSendSystem() + " [\u63d0\u4f9b\u65b9] " + dto.getReceiveSystem() + " [\u670d\u52a1] " + dto.getServName() + " [\u5f02\u5e38]\u8bf7\u6c42\u65f6\u957f\u8d85\u8fc7" + dto.getCallTimeOut() + "\u79d2");
                alarmInfo.setFatherinstanceid(dto.getId());
                alarmInfo.setInstanceid(dto.getId());
                alarmInfo.setAlarmlevelkey("1");
                alarmInfo.setGategorykey("2");
                alarmInfo.setRestypeid(Long.valueOf(0L));
                alarmInfo.setCauseid(Long.valueOf(0L));
                alarmInfo.setAlarmtypekey("1");
                alarmInfo.setOrgintime(new Date());
                alarmInfo.setRepeattimes(Long.valueOf(1L));
                alarmInfo.setState(Long.valueOf(1L));
                alarmInfo.setNettypeid(Long.valueOf(1L));
                alarmInfo.setAlarmid(dto.getId());
                this.alarmService.handle(alarmInfo);
            } else {
                this.needMonMap.put(dto.getCsbId(), dto);
            }
        } else if (dto.getRequestTime() != null && dto.getResponseTime() != null && dto.getResponseTime().getTime() - dto.getRequestTime().getTime() > dto.getCallTimeOut() * 1000L) {
            Alarms alarmInfo = new Alarms();
            alarmInfo.setDetail("[\u6d88\u8d39\u65b9]" + dto.getSendSystem() + " [\u63d0\u4f9b\u65b9] " + dto.getReceiveSystem() + " [\u670d\u52a1] " + dto.getServName() + " [\u5f02\u5e38]\u8bf7\u6c42\u65f6\u957f\u8d85\u8fc7" + dto.getCallTimeOut() + "\u79d2");
            alarmInfo.setFatherinstanceid(dto.getId());
            alarmInfo.setInstanceid(dto.getId());
            alarmInfo.setAlarmlevelkey("1");
            alarmInfo.setGategorykey("2");
            alarmInfo.setRestypeid(Long.valueOf(0L));
            alarmInfo.setCauseid(Long.valueOf(0L));
            alarmInfo.setAlarmtypekey("1");
            alarmInfo.setOrgintime(new Date());
            alarmInfo.setRepeattimes(Long.valueOf(1L));
            alarmInfo.setState(Long.valueOf(1L));
            alarmInfo.setNettypeid(Long.valueOf(1L));
            alarmInfo.setAlarmid(dto.getId());
            this.alarmService.handle(alarmInfo);
        }
    }

    public void getData() {
        this.currentTime = new Date();
        List list = this.requestTimeoutDao.getCsbMessage(this.getFrontTime(this.currentTime), this.currentTime);
        for (RequestTimeoutDto dto : list) {
            if (this.needMonMap.get(dto.getCsbId()) != null) continue;
            this.checkServ(dto);
        }
    }

    private Date getFrontTime(Date curTime) {
        Date date = new Date();
        date.setTime(curTime.getTime() - this.interval);
        return date;
    }

    public void checkNeedMap() {
        Map cloneNeedMap = (Map)this.needMonMap.clone();
        for (Map.Entry m : cloneNeedMap.entrySet()) {
            String csbId = (String)m.getKey();
            RequestTimeoutDto dto = this.requestTimeoutDao.getRequestTimeoutDto(csbId);
            this.checkServ(dto);
        }
    }

    public RequestTimeoutDao getRequestTimeoutDao() {
        return this.requestTimeoutDao;
    }

    public void setRequestTimeoutDao(RequestTimeoutDao requestTimeoutDao) {
        this.requestTimeoutDao = requestTimeoutDao;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public void setAlarmService(IAlarmService alarmService) {
        this.alarmService = alarmService;
    }
}

