/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.globalLog.persistence.dao;

import cn.com.starit.common.persistence.GenericHibernateDao;
import cn.com.starit.common.persistence.Page;
import cn.com.starit.tsaip.globalLog.persistence.entity.PlatformLog;
import cn.com.starit.tsaip.globalLog.persistence.entity.PlatformLogDto;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class GlobalLogDao
extends GenericHibernateDao<PlatformLog, Long> {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private String getDateFromStconfig(String key) {
        return ConfigControl.getStConfigCache().getConfigValue((Object)key) == null ? "" : (String)ConfigControl.getStConfigCache().getConfigValue((Object)key);
    }

    public Page<PlatformLogDto> findLog(Page<PlatformLogDto> page, PlatformLogDto dto) throws ParseException {
        String hql = "select new cn.com.starit.tsaip.globalLog.persistence.entity.PlatformLogDto(j.platformLog,j.platformCode,j.platformLogContent, j.platformLogTime,j.platformLogFlag,b.businname,j.flag) from PlatformLog j, BndictTDictionary b where j.platformLogFlag=b.id.businid and b.id.busintypeid='PLATFORM_LOG_FLAG' ";
        if (dto != null) {
            hql = hql + (dto.getPlatformLogFlag() != null && dto.getPlatformLogFlag() > 0L ? " and j.platformLogFlag =" + dto.getPlatformLogFlag() : " ");
            if (dto.getBeginTime() != null && dto.getEndTime() != null) {
                hql = hql + " and j.platformLogTime >= to_date('" + this.sdf.format(dto.getBeginTime()) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "') ";
                hql = hql + " and j.platformLogTime < to_date('" + this.sdf.format(dto.getEndTime()) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "') ";
            }
        }
        Page resultPage = this.findPage(page, hql, new Object[0]);
        return resultPage;
    }

    public PlatformLog getPlatformLog(Long id) {
        String hql = "from PlatformLog j where j.platformLog=?";
        PlatformLog dto = (PlatformLog)this.findUnique(hql, new Object[]{id});
        return dto;
    }
}

