/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.common.biz;

import cn.com.starit.common.exception.ExceptionHandler;
import cn.com.starit.tsaip.esb.plugin.common.exception.dao.DataAccessException;
import cn.com.starit.tsaip.esb.plugin.common.exception.dao.DataRetrievalFailureException;
import cn.com.starit.tsaip.esb.plugin.db.AbstractDBDao;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.rowset.CachedRowSet;

public class DBUtils
extends AbstractDBDao {
    private static final String FIND_SERV_ID_FROM_SERV_DEFINE_ID = "SELECT SERV_ID FROM SERV_DEFINE WHERE SERV_DEFINE_ID=?";
    private static final String FIND_SERV_ID_FROM_FLUX_CTRL_ID = "SELECT SERV_ID FROM SERV_FLUX_CTL WHERE SERV_CTRL_ID=?";
    private static final String FIND_SERV_ID_FROM_ALARM_ID = "SELECT SERV_ID FROM ALARM_THRESHOLD_CONF WHERE ALARM_THRES_CONF_ID =?";
    private static final String FIND_SERV_MAN_IP_CONFIG_ID = "SELECT SERV_MAN_IP_ID FROM SERV_MAN_IP_CONF";
    private static final String FIND_SERV_VISIT_LIMIT_ID = "SELECT SERV_LIMIT_ID  FROM SERV_VISIT_LIMIT";
    private static final String FIND_ALARM_CONFIG_ID = "SELECT  ALARM_THRES_CONF_ID FROM ALARM_THRESHOLD_CONF";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getServIdByServDefineId(long servDefineId) throws DataAccessException {
        this.log.debug((Object)("\u4ece\u6570\u636e\u5e93\u8bfb\u53d6\u6570\u636e\u5f00\u59cb:" + this));
        Connection conn = null;
        CachedRowSet crs = null;
        long servId = 0L;
        try {
            conn = this.getConnection();
            crs = this.executeQuery(conn, FIND_SERV_ID_FROM_SERV_DEFINE_ID, new Object[]{servDefineId});
            while (crs.next()) {
                servId = crs.getLong("SERV_ID");
            }
            this.log.info((Object)("\u8bfb\u53d6\u6570\u636e\u7ed3\u675f:servDefineId/" + servDefineId));
        }
        catch (SQLException e) {
            try {
                ExceptionHandler.handle((Object)this, (Exception)e, DataRetrievalFailureException.class, (String)("\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38:servDefineId/" + servDefineId));
            }
            catch (Throwable throwable) {
                this.close(crs);
                this.close(conn);
                throw throwable;
            }
            this.close((ResultSet)crs);
            this.close(conn);
        }
        this.close((ResultSet)crs);
        this.close(conn);
        return servId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getServIdByFluxCtlId(long fluxCtlId) throws DataAccessException {
        this.log.debug((Object)("\u4ece\u6570\u636e\u5e93\u8bfb\u53d6\u6570\u636e\u5f00\u59cb:" + this));
        Connection conn = null;
        CachedRowSet crs = null;
        long servId = 0L;
        try {
            conn = this.getConnection();
            crs = this.executeQuery(conn, FIND_SERV_ID_FROM_FLUX_CTRL_ID, new Object[]{fluxCtlId});
            while (crs.next()) {
                servId = crs.getLong("SERV_ID");
            }
            this.log.info((Object)("\u8bfb\u53d6\u6570\u636e\u7ed3\u675f:fluxCtlId/" + fluxCtlId));
        }
        catch (SQLException e) {
            try {
                ExceptionHandler.handle((Object)this, (Exception)e, DataRetrievalFailureException.class, (String)("\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38:fluxCtlId/" + fluxCtlId));
            }
            catch (Throwable throwable) {
                this.close(crs);
                this.close(conn);
                throw throwable;
            }
            this.close((ResultSet)crs);
            this.close(conn);
        }
        this.close((ResultSet)crs);
        this.close(conn);
        return servId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getServIdByAlarmConfId(long alarmConfId) throws DataAccessException {
        this.log.debug((Object)("\u4ece\u6570\u636e\u5e93\u8bfb\u53d6\u6570\u636e\u5f00\u59cb:" + this));
        Connection conn = null;
        CachedRowSet crs = null;
        long servId = 0L;
        try {
            conn = this.getConnection();
            crs = this.executeQuery(conn, FIND_SERV_ID_FROM_ALARM_ID, new Object[]{alarmConfId});
            while (crs.next()) {
                servId = crs.getLong("SERV_ID");
            }
            this.log.info((Object)("\u8bfb\u53d6\u6570\u636e\u7ed3\u675f:alarmConfId/" + alarmConfId));
        }
        catch (SQLException e) {
            try {
                ExceptionHandler.handle((Object)this, (Exception)e, DataRetrievalFailureException.class, (String)("\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38:alarmConfId/" + alarmConfId));
            }
            catch (Throwable throwable) {
                this.close(crs);
                this.close(conn);
                throw throwable;
            }
            this.close((ResultSet)crs);
            this.close(conn);
        }
        this.close((ResultSet)crs);
        this.close(conn);
        return servId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getServManIpConfIdsByServManId(long servManId) throws DataRetrievalFailureException {
        this.log.debug((Object)("\u4ece\u6570\u636e\u5e93\u8bfb\u53d6\u6570\u636e\u5f00\u59cb:" + this));
        String sql = "SELECT SERV_MAN_IP_ID FROM SERV_MAN_IP_CONF WHERE SERV_MAN_ID = ?";
        Connection conn = null;
        CachedRowSet crs = null;
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            conn = this.getConnection();
            crs = this.executeQuery(conn, sql, new Object[]{servManId});
            while (crs.next()) {
                list.add(crs.getLong("SERV_MAN_IP_ID"));
            }
            this.log.info((Object)("\u8bfb\u53d6\u6570\u636e\u7ed3\u675f:servManId/" + servManId));
        }
        catch (Exception e) {
            try {
                ExceptionHandler.handle((Object)this, (Exception)e, DataRetrievalFailureException.class, (String)("\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38:servManId/" + servManId));
            }
            catch (Throwable throwable) {
                this.close(crs);
                this.close(conn);
                throw throwable;
            }
            this.close((ResultSet)crs);
            this.close(conn);
        }
        this.close((ResultSet)crs);
        this.close(conn);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getServLimitVisitIdByServManIdAndServId(long servManId, long servId) throws DataRetrievalFailureException {
        this.log.debug((Object)("\u4ece\u6570\u636e\u5e93\u8bfb\u53d6\u6570\u636e\u5f00\u59cb:" + this));
        String sql = "SELECT SERV_LIMIT_ID  FROM SERV_VISIT_LIMIT WHERE SERV_MAN_ID = ? AND SERV_ID =?";
        Connection conn = null;
        CachedRowSet crs = null;
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            conn = this.getConnection();
            crs = this.executeQuery(conn, sql, new Object[]{servManId, servId});
            while (crs.next()) {
                list.add(crs.getLong("SERV_LIMIT_ID"));
            }
            this.log.info((Object)("\u8bfb\u53d6\u6570\u636e\u7ed3\u675f:servManId/" + servManId + "/servId=" + servId));
        }
        catch (Exception e) {
            try {
                ExceptionHandler.handle((Object)this, (Exception)e, DataRetrievalFailureException.class, (String)("\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38:servManId/" + servManId + "/servId=" + servId));
            }
            catch (Throwable throwable) {
                this.close(crs);
                this.close(conn);
                throw throwable;
            }
            this.close((ResultSet)crs);
            this.close(conn);
        }
        this.close((ResultSet)crs);
        this.close(conn);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getAlarmConfIdByServId(long servId) throws DataRetrievalFailureException {
        this.log.debug((Object)("\u4ece\u6570\u636e\u5e93\u8bfb\u53d6\u6570\u636e\u5f00\u59cb:" + this));
        String sql = "SELECT  ALARM_THRES_CONF_ID FROM ALARM_THRESHOLD_CONF WHERE  SERV_ID =?";
        Connection conn = null;
        CachedRowSet crs = null;
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            conn = this.getConnection();
            crs = this.executeQuery(conn, sql, new Object[]{servId});
            while (crs.next()) {
                list.add(crs.getLong("ALARM_THRES_CONF_ID"));
            }
            this.log.info((Object)("\u8bfb\u53d6\u6570\u636e\u7ed3\u675f:servId/" + servId));
        }
        catch (Exception e) {
            try {
                ExceptionHandler.handle((Object)this, (Exception)e, DataRetrievalFailureException.class, (String)("\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38:servId/" + servId));
            }
            catch (Throwable throwable) {
                this.close(crs);
                this.close(conn);
                throw throwable;
            }
            this.close((ResultSet)crs);
            this.close(conn);
        }
        this.close((ResultSet)crs);
        this.close(conn);
        return list;
    }
}

