/*
 * Decompiled with CFR 0.152.
 */
package cn.com.starit.tsaip.audit.persistence.dao;

import cn.com.starit.common.persistence.GenericHibernateDao;
import cn.com.starit.tsaip.audit.dto.ServManCfgDto;
import cn.com.starit.tsaip.audit.dto.ServRunDto;
import cn.com.starit.tsaip.audit.dto.ServStatDto;
import cn.com.starit.tsaip.register.util.ConfigControl;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.orm.hibernate3.HibernateCallback;

public class StartPageDao
extends GenericHibernateDao {
    private Long servManId;
    private Long serServManId;
    private Long servId;
    private Long servDefineId;

    private String getDateFromStconfig(String key) {
        return ConfigControl.getStConfigCache().getConfigValue((Object)key) == null ? "" : (String)ConfigControl.getStConfigCache().getConfigValue((Object)key);
    }

    public List<ServRunDto> getAllInfo(Date startTime, Date endTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String hql = "select new cn.com.starit.tsaip.audit.dto.ServRunDto(sum(bean.busiMoSum) as busiMoSum,sum(bean.busiMoAvg * bean.requestTimes)/sum(bean.requestTimes) as busiMoAvg,sum(bean.requestTimes) as requestTimes,sum(bean.responseTimes) as responseTimes,sum(bean.requestTimes * bean.failureRate)/sum(bean.requestTimes) as failureRate,sum(bean.csbAchieveAvgTime * bean.requestTimes)/sum(bean.requestTimes) as csbAchieveAvgTime,sum(bean.busiServAvgTime *  bean.requestTimes)/sum(bean.requestTimes) as busiServAvgTime) from ServMon  bean  where (bean.connFlag = 1 or bean.connFlag is null) and bean.analysisEndTime>=to_date('" + sdf.format(startTime) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "') and bean.analysisEndTime<=to_date('" + sdf.format(endTime) + "','" + this.getDateFromStconfig("SYS_DATA_YMD_HMS") + "') ";
        return this.find(hql, new Object[0]);
    }

    public ServManCfgDto getCount() {
        ServManCfgDto servManCfgDto = new ServManCfgDto();
        String sql1 = "select count(serv_man_id) from serv_afford_man_config";
        String sql2 = "select count( distinct c.ser_serv_man_id) from serv_afford_man_config config, serv_afford_man_reg c  where config.serv_Man_Id = c.ser_serv_man_id";
        String sql3 = "select count(c.serv_id) from serv_afford_man_reg c";
        String sql4 = "select count(distinct c2.serv_id) from serv_afford_man_reg c1, serv_define c2 where c1.serv_id = c2.serv_id";
        servManCfgDto.setServManId(Long.valueOf(this.getCount(sql1)));
        servManCfgDto.setSerServManId(Long.valueOf(this.getCount(sql2)));
        servManCfgDto.setServId(Long.valueOf(this.getCount(sql3)));
        servManCfgDto.setServDefineId(Long.valueOf(this.getCount(sql4)));
        return servManCfgDto;
    }

    private long getCount(String sql) {
        Object obj = this.getHibernateTemplate().execute((HibernateCallback)new /* Unavailable Anonymous Inner Class!! */);
        return obj == null ? 0L : ((BigDecimal)obj).longValue();
    }

    public List<Object[]> getRunAuditInfo(int flag) {
        String sql = "select t1.check_result_value, t1.check_host from (select a.check_result_value as check_result_value, a.check_host as check_host, t.service_run_audit_typeb as service_run_audit_typeb from serv_run_audit_count a, serv_run_audit_config t where a.service_run_audit_id = t.service_run_audit_id and a.analysis_end_time in (select max(analysis_end_time) from serv_run_audit_count b)) t1, BNDICT_T_DICTIONARY t2 where t1.service_run_audit_typeb = t2.businname and t2.busintypeid = 'SERVICE_RUN_AUDIT_TYPEB' and t2.businid = " + flag;
        List list = this.findBySQL(sql, new Object[0]);
        return list;
    }

    public List<ServStatDto> getServStat() {
        String sql = "select bean.msgCount,bean.serv_Man_Name,bean.serv_Name,nvl(s.abMsgCount, 0) from (select a.receive_System,count(*) as msgCount,b.serv_Man_Name as serv_Man_Name,c.serv_Name,a.serv_Id from Aip_Message a left join serv_Afford_Man_Reg c on a.serv_Id = c.serv_Id left join Serv_Afford_Man_Config b on a.receive_System =b.serv_Man_code group by a.receive_System, b.serv_Man_Name, c.serv_Name, a.serv_Id) bean left join (select d.receive_System,count(*) as abMsgCount,e.serv_Name,d.serv_Id from Aip_Message d left join serv_Afford_Man_Reg e  on d.serv_Id = e.serv_Id left join Serv_Afford_Man_Config f on d.receive_System = f.Serv_Man_Code where d.service_State <> 0  group by d.receive_System, e.serv_Name, d.serv_Id) s on s.receive_System = bean.receive_System and s.serv_Id = bean.serv_Id order by bean.msgCount desc";
        List temp = this.findBySQL(sql, new Object[0]);
        ArrayList<ServStatDto> list = new ArrayList<ServStatDto>();
        DecimalFormat formt = new DecimalFormat("0.##%");
        for (int i = 0; i < temp.size(); ++i) {
            Object[] obj = (Object[])temp.get(i);
            ServStatDto servStatDto = new ServStatDto();
            if (obj[0] != null) {
                servStatDto.setMsgCount(Long.valueOf(Long.parseLong(obj[0].toString())));
            }
            if (obj[1] != null) {
                servStatDto.setReceiveSystemName(obj[1].toString());
            }
            if (obj[2] != null) {
                servStatDto.setServName(obj[2].toString());
            }
            if (obj[3] != null) {
                servStatDto.setAbMsgCount(Long.valueOf(Long.parseLong(obj[3].toString())));
            }
            if (obj[0] != null && Long.parseLong(obj[0].toString()) != 0L) {
                servStatDto.setFailureRate(formt.format(Float.parseFloat(obj[3].toString()) / Float.parseFloat(obj[0].toString())));
            }
            list.add(i, servStatDto);
        }
        return list;
    }

    public Long getSerServManId() {
        return this.serServManId;
    }

    public void setSerServManId(Long serServManId) {
        this.serServManId = serServManId;
    }

    public Long getServId() {
        return this.servId;
    }

    public void setServId(Long servId) {
        this.servId = servId;
    }

    public Long getServDefineId() {
        return this.servDefineId;
    }

    public void setServDefineId(Long servDefineId) {
        this.servDefineId = servDefineId;
    }

    public Long getServManId() {
        return this.servManId;
    }

    public void setServManId(Long servManId) {
        this.servManId = servManId;
    }
}

